/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.security;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedDeque;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xipki.security.KeypairGenerator;
import org.xipki.security.KeypairGeneratorFactory;
import org.xipki.security.KeypairGeneratorFactoryRegister;
import org.xipki.security.SecurityFactory;
import org.xipki.util.Args;
import org.xipki.util.exception.ObjectCreationException;

public class KeypairGeneratorFactoryRegisterImpl
implements KeypairGeneratorFactoryRegister {
    private static final Logger LOG = LoggerFactory.getLogger(KeypairGeneratorFactoryRegisterImpl.class);
    private final ConcurrentLinkedDeque<KeypairGeneratorFactory> factories = new ConcurrentLinkedDeque();

    @Override
    public Set<String> getSupportedGeneratorTypes() {
        HashSet<String> types = new HashSet<String>();
        for (KeypairGeneratorFactory service : this.factories) {
            types.addAll(service.getSupportedKeypairTypes());
        }
        return Collections.unmodifiableSet(types);
    }

    public void registFactory(KeypairGeneratorFactory factory) {
        if (factory == null) {
            LOG.info("registFactory invoked with null.");
            return;
        }
        boolean replaced = this.factories.remove(factory);
        this.factories.add(factory);
        String action = replaced ? "replaced" : "added";
        LOG.info("{} KeypairGeneratorFactory binding for {}", (Object)action, (Object)factory);
    }

    public void unregistFactory(KeypairGeneratorFactory factory) {
        if (factory == null) {
            LOG.info("unregistFactory invoked with null.");
            return;
        }
        if (this.factories.remove(factory)) {
            LOG.info("removed KeypairGeneratorFactory binding for {}", (Object)factory);
        } else {
            LOG.info("no KeypairGeneratorFactory binding found to remove for '{}'", (Object)factory);
        }
    }

    @Override
    public KeypairGenerator newKeypairGenerator(SecurityFactory securityFactory, String type, String conf) throws ObjectCreationException {
        Args.notBlank((String)type, (String)"type");
        for (KeypairGeneratorFactory service : this.factories) {
            if (!service.canCreateKeypairGenerator(type)) continue;
            return service.newKeypairGenerator(type, conf, securityFactory);
        }
        throw new ObjectCreationException("could not find Factory to create keypair generator of type " + type);
    }
}

