/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.security.pkcs11;

import org.xipki.pkcs11.wrapper.TokenException;
import org.xipki.security.pkcs11.NativeP11Slot;
import org.xipki.security.pkcs11.P11Identity;
import org.xipki.security.pkcs11.P11IdentityId;
import org.xipki.security.pkcs11.P11Params;

class NativeP11Identity
extends P11Identity {
    NativeP11Identity(NativeP11Slot slot, P11IdentityId identityId) {
        super(slot, identityId);
    }

    @Override
    protected byte[] digestSecretKey0(long mechanism) throws TokenException {
        return ((NativeP11Slot)this.slot).digestSecretKey(mechanism, this);
    }

    @Override
    public void destroy() throws TokenException {
        if (this.id.getPublicKeyHandle() == null) {
            this.slot.destroyObjectsByHandle(this.id.getKeyId().getHandle());
        } else {
            this.slot.destroyObjectsByHandle(this.id.getKeyId().getHandle(), this.id.getPublicKeyHandle());
        }
    }

    @Override
    protected byte[] sign0(long mechanism, P11Params parameters, byte[] content) throws TokenException {
        return ((NativeP11Slot)this.slot).sign(mechanism, parameters, content, this);
    }
}

