/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.security.pkcs11;

import java.io.IOException;
import java.io.OutputStream;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.interfaces.DSAPublicKey;
import java.security.interfaces.ECPublicKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.DSAPublicKeySpec;
import java.security.spec.InvalidKeySpecException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.bouncycastle.asn1.ASN1BitString;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.DERBitString;
import org.bouncycastle.asn1.DERNull;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.gm.GMObjectIdentifiers;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import org.bouncycastle.asn1.pkcs.RSAPrivateKey;
import org.bouncycastle.asn1.sec.ECPrivateKey;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.DSAParameter;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.asn1.x9.X9ObjectIdentifiers;
import org.bouncycastle.util.encoders.Hex;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xipki.pkcs11.wrapper.AttributeVector;
import org.xipki.pkcs11.wrapper.KeyPairTemplate;
import org.xipki.pkcs11.wrapper.Mechanism;
import org.xipki.pkcs11.wrapper.ModuleInfo;
import org.xipki.pkcs11.wrapper.PKCS11Constants;
import org.xipki.pkcs11.wrapper.PKCS11Exception;
import org.xipki.pkcs11.wrapper.PKCS11KeyPair;
import org.xipki.pkcs11.wrapper.Session;
import org.xipki.pkcs11.wrapper.Slot;
import org.xipki.pkcs11.wrapper.Token;
import org.xipki.pkcs11.wrapper.TokenException;
import org.xipki.security.EdECConstants;
import org.xipki.security.pkcs11.NativeP11Identity;
import org.xipki.security.pkcs11.NativeP11SlotUtil;
import org.xipki.security.pkcs11.P11Identity;
import org.xipki.security.pkcs11.P11IdentityId;
import org.xipki.security.pkcs11.P11ModuleConf;
import org.xipki.security.pkcs11.P11ObjectId;
import org.xipki.security.pkcs11.P11Params;
import org.xipki.security.pkcs11.P11Slot;
import org.xipki.security.pkcs11.P11SlotId;
import org.xipki.security.util.AlgorithmUtil;
import org.xipki.security.util.KeyUtil;
import org.xipki.util.Args;
import org.xipki.util.CollectionUtil;
import org.xipki.util.LogUtil;
import org.xipki.util.StringUtil;
import org.xipki.util.concurrent.ConcurrentBag;
import org.xipki.util.concurrent.ConcurrentBagEntry;

class NativeP11Slot
extends P11Slot {
    public static final AlgorithmIdentifier ALGID_RSA = new AlgorithmIdentifier(PKCSObjectIdentifiers.rsaEncryption, (ASN1Encodable)DERNull.INSTANCE);
    private static final Logger LOG = LoggerFactory.getLogger(NativeP11Slot.class);
    private static final long DEFAULT_MAX_COUNT_SESSION = 32L;
    private final int maxMessageSize;
    private Slot slot;
    private final long userType;
    private List<char[]> password;
    private final int maxSessionCount;
    private final long timeOutWaitNewSession = 10000L;
    private final AtomicLong countSessions = new AtomicLong(0L);
    private final SecureRandom random = new SecureRandom();
    private final ConcurrentBag<ConcurrentBagEntry<Session>> sessions = new ConcurrentBag();
    private final long rsaKeyPairGenMech;
    private String libDesc;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    NativeP11Slot(String moduleName, P11SlotId slotId, Slot slot, boolean readOnly, long userType, List<char[]> password, int maxMessageSize, P11ModuleConf.P11MechanismFilter mechanismFilter, P11ModuleConf.P11NewObjectConf newObjectConf, Integer numSessions, List<Long> secretKeyTypes, List<Long> keyPairTypes) throws TokenException {
        super(moduleName, slotId, readOnly, secretKeyTypes, keyPairTypes, newObjectConf);
        this.slot = (Slot)Args.notNull((Object)slot, (String)"slot");
        this.maxMessageSize = Args.positive((int)maxMessageSize, (String)"maxMessageSize");
        this.userType = userType;
        this.password = password;
        boolean successful = false;
        ModuleInfo moduleInfo = slot.getModule().getInfo();
        this.libDesc = moduleInfo.getLibraryDescription();
        if (this.libDesc == null) {
            this.libDesc = "";
        }
        this.initMechanisms(this.getSupportedMechanisms(), mechanismFilter);
        try {
            Session session = this.openSession();
            this.firstLogin(session, password);
            Token token = this.slot.getToken();
            long maxSessionCount2 = token.getTokenInfo().getMaxSessionCount();
            long l = maxSessionCount2 <= 0L ? 32L : (maxSessionCount2 = maxSessionCount2 < 3L ? 1L : maxSessionCount2 - 2L);
            if (numSessions != null) {
                maxSessionCount2 = Math.min((long)numSessions.intValue(), maxSessionCount2);
            }
            this.maxSessionCount = (int)maxSessionCount2;
            LOG.info("maxSessionCount: {}", (Object)this.maxSessionCount);
            this.sessions.add(new ConcurrentBagEntry((Object)session));
            this.rsaKeyPairGenMech = this.supportsMechanism(10L) ? 10L : 0L;
            successful = true;
        }
        finally {
            if (!successful) {
                this.close();
            }
        }
    }

    private long[] getSupportedMechanisms() throws TokenException {
        long[] mechanisms = this.slot.getToken().getMechanismList();
        ArrayList<Long> newList = new ArrayList<Long>(mechanisms.length);
        StringBuilder ignoreMechs = new StringBuilder();
        boolean smartcard = this.libDesc.toLowerCase().contains("smartcard");
        for (long code : mechanisms) {
            if (smartcard) {
                if (code == 4162L || code == 4163L || code == 4164L || code == 4165L || code == 4166L || code == 4167L || code == 4168L || code == 4169L || code == 4170L) {
                    ignoreMechs.append(PKCS11Constants.ckmCodeToName((long)code)).append(", ");
                    continue;
                }
                newList.add(code);
                continue;
            }
            newList.add(code);
        }
        if (ignoreMechs.length() > 0) {
            LOG.info("Ignore mechanisms in smartcard-based HSM: {}", (Object)ignoreMechs.substring(0, ignoreMechs.length() - 2));
        }
        if (ignoreMechs.length() == 0) {
            return mechanisms;
        }
        long[] ret = new long[newList.size()];
        int i = 0;
        for (Long mech : newList) {
            ret[i++] = mech;
        }
        return ret;
    }

    @Override
    public final void close() {
        if (this.slot != null) {
            try {
                LOG.info("close all sessions on token: {}", (Object)this.slot.getSlotID());
                for (ConcurrentBagEntry session : this.sessions.values()) {
                    ((Session)session.value()).closeSession();
                }
            }
            catch (Throwable th) {
                LogUtil.error((Logger)LOG, (Throwable)th, (String)"could not slot.getToken().closeAllSessions()");
            }
            this.slot = null;
        }
        this.sessions.close();
        this.countSessions.lazySet(0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    byte[] digestSecretKey(long mech, NativeP11Identity identity) throws TokenException {
        int digestLen;
        if (!identity.isSecretKey()) {
            throw new TokenException("digestSecretKey could not be applied to non-SecretKey");
        }
        long keyHandle = ((NativeP11Identity)Args.notNull((Object)identity, (String)"identity")).getId().getKeyId().getHandle();
        this.assertMechanismSupported(mech);
        if (LOG.isTraceEnabled()) {
            LOG.debug("digest (init, digestKey, then finish) secret key {}", (Object)identity.getId());
        }
        int n = 544L == mech ? 20 : (597L == mech || 693L == mech ? 28 : (592L == mech || 688L == mech ? 32 : (608L == mech || 704L == mech ? 48 : (digestLen = 624L == mech || 720L == mech ? 64 : -1))));
        if (digestLen == -1) {
            throw new TokenException("unsupported mechanism " + mech);
        }
        ConcurrentBagEntry<Session> session0 = this.borrowSession();
        Mechanism mechanismObj = new Mechanism(mech);
        try {
            Session session = (Session)session0.value();
            try {
                byte[] byArray = NativeP11SlotUtil.digestKey(session, digestLen, mechanismObj, keyHandle);
                return byArray;
            }
            catch (PKCS11Exception ex) {
                if (ex.getErrorCode() != 257L) {
                    throw ex;
                }
                LOG.info("digestKey ended with ERROR CKR_USER_NOT_LOGGED_IN, login and then retry it");
                this.forceLogin(session);
                byte[] byArray = NativeP11SlotUtil.digestKey(session, digestLen, mechanismObj, keyHandle);
                this.sessions.requite(session0);
                return byArray;
            }
        }
        finally {
            this.sessions.requite(session0);
        }
    }

    byte[] sign(long mech, P11Params parameters, byte[] content, NativeP11Identity identity) throws TokenException {
        Args.notNull((Object)content, (String)"content");
        this.assertMechanismSupported(mech);
        Mechanism mechanismObj = NativeP11SlotUtil.getMechanism(mech, parameters);
        long signingKeyHandle = identity.getId().getKeyId().getHandle();
        ConcurrentBagEntry<Session> session0 = this.borrowSession();
        Session session = (Session)session0.value();
        try {
            byte[] byArray = this.sign0(session, mechanismObj, content, signingKeyHandle);
            return byArray;
        }
        catch (PKCS11Exception ex) {
            if (ex.getErrorCode() == 257L) {
                LOG.info("sign ended with ERROR CKR_USER_NOT_LOGGED_IN, login and then retry it");
                this.forceLogin(session);
                byte[] byArray = this.sign0(session, mechanismObj, content, signingKeyHandle);
                return byArray;
            }
            throw ex;
        }
        finally {
            this.sessions.requite(session0);
        }
    }

    private byte[] sign0(Session session, Mechanism mechanism, byte[] content, long signingKeyHandle) throws PKCS11Exception {
        byte[] sigvalue;
        int len = content.length;
        if (len <= this.maxMessageSize) {
            sigvalue = this.singleSign(session, mechanism, content, signingKeyHandle);
        } else {
            LOG.debug("sign (init, update, then finish)");
            session.signInit(mechanism, signingKeyHandle);
            for (int i = 0; i < len; i += this.maxMessageSize) {
                int blockLen = Math.min(this.maxMessageSize, len - i);
                session.signUpdate(content, i, blockLen);
            }
            sigvalue = session.signFinal();
        }
        return sigvalue;
    }

    private byte[] singleSign(Session session, Mechanism mechanism, byte[] content, long signingKeyHandle) throws PKCS11Exception {
        LOG.debug("single sign");
        session.signInit(mechanism, signingKeyHandle);
        return session.sign(content);
    }

    private Session openSession() throws TokenException {
        Session session = this.slot.getToken().openSession(!this.isReadOnly());
        this.countSessions.incrementAndGet();
        return session;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ConcurrentBagEntry<Session> borrowSession() throws TokenException {
        ConcurrentBagEntry session = null;
        ConcurrentBag<ConcurrentBagEntry<Session>> concurrentBag = this.sessions;
        synchronized (concurrentBag) {
            if (this.countSessions.get() < (long)this.maxSessionCount) {
                try {
                    session = this.sessions.borrow(1L, TimeUnit.NANOSECONDS);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (session == null) {
                    this.sessions.add(new ConcurrentBagEntry((Object)this.openSession()));
                }
            }
        }
        if (session == null) {
            try {
                session = this.sessions.borrow(10000L, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        if (session == null) {
            throw new TokenException("no idle session");
        }
        this.login((Session)session.value());
        return session;
    }

    private void firstLogin(Session session, List<char[]> password) throws TokenException {
        block5: {
            try {
                boolean isProtectedAuthenticationPath = session.getToken().getTokenInfo().isProtectedAuthenticationPath();
                if (isProtectedAuthenticationPath || CollectionUtil.isEmpty(password)) {
                    LOG.info("verify on PKCS11Module with PROTECTED_AUTHENTICATION_PATH");
                    NativeP11SlotUtil.singleLogin(session, this.userType, null);
                } else {
                    LOG.info("verify on PKCS11Module with PIN");
                    for (char[] singlePwd : password) {
                        NativeP11SlotUtil.singleLogin(session, this.userType, singlePwd);
                    }
                    this.password = password;
                }
            }
            catch (PKCS11Exception ex) {
                if (ex.getErrorCode() == 256L) break block5;
                throw ex;
            }
        }
    }

    private void login(Session session) throws TokenException {
        boolean loginRequired;
        boolean isSessionLoggedIn = NativeP11SlotUtil.checkSessionLoggedIn(session, this.userType);
        if (isSessionLoggedIn) {
            return;
        }
        try {
            loginRequired = session.getToken().getTokenInfo().isLoginRequired();
        }
        catch (PKCS11Exception ex) {
            LogUtil.error((Logger)LOG, (Throwable)ex, (String)"could not check isLoginRequired of token");
            loginRequired = true;
        }
        LOG.debug("loginRequired: {}", (Object)loginRequired);
        if (!loginRequired) {
            return;
        }
        if (CollectionUtil.isEmpty(this.password)) {
            NativeP11SlotUtil.singleLogin(session, this.userType, null);
        } else {
            for (char[] singlePwd : this.password) {
                NativeP11SlotUtil.singleLogin(session, this.userType, singlePwd);
            }
        }
    }

    private void forceLogin(Session session) throws TokenException {
        if (CollectionUtil.isEmpty(this.password)) {
            LOG.info("verify on PKCS11Module with NULL PIN");
            NativeP11SlotUtil.singleLogin(session, this.userType, null);
        } else {
            LOG.info("verify on PKCS11Module with PIN");
            for (char[] singlePwd : this.password) {
                NativeP11SlotUtil.singleLogin(session, this.userType, singlePwd);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public P11Identity getIdentity(P11IdentityId identityId) throws TokenException {
        ConcurrentBagEntry<Session> bagEntry = this.borrowSession();
        try {
            Session session = (Session)bagEntry.value();
            long handle = identityId.getKeyId().getHandle();
            AttributeVector attrs = session.getAttrValues(handle, new long[]{0L, 256L});
            long keyType = attrs.keyType();
            long objClass = attrs.class_();
            NativeP11Identity p11Identity = new NativeP11Identity(this, identityId);
            if (objClass != 3L) throw new IllegalStateException("unknown object class " + PKCS11Constants.ckoCodeToName((long)objClass));
            if (keyType == 0L) {
                attrs = session.getAttrValues(handle, new long[]{288L, 290L});
                p11Identity.setRsaMParameters(attrs.modulus(), attrs.publicExponent());
            } else if (keyType == 1L) {
                p11Identity.setDsaQ(session.getBigIntAttrValue(handle, 305L));
            } else {
                if (keyType != 3L && keyType != 0xFFFFF001L && keyType != 64L && keyType != 65L) throw new IllegalStateException("unknown key type " + PKCS11Constants.ckkCodeToName((long)keyType));
                byte[] ecParams = session.getByteArrayAttrValue(handle, 384L);
                ASN1ObjectIdentifier curveId = NativeP11Slot.detectCurveOid(ecParams);
                if (curveId == null && identityId.getPublicKeyHandle() != null) {
                    ecParams = session.getByteArrayAttrValue(identityId.getPublicKeyHandle().longValue(), 384L);
                    curveId = NativeP11Slot.detectCurveOid(ecParams);
                }
                if (curveId != null) {
                    p11Identity.setEcParams(curveId);
                }
            }
            NativeP11Identity nativeP11Identity = p11Identity;
            return nativeP11Identity;
        }
        finally {
            this.sessions.requite(bagEntry);
        }
    }

    @Override
    protected PublicKey getPublicKey(P11Identity identity) throws TokenException {
        long keyType;
        ConcurrentBagEntry<Session> bagEntry;
        block21: {
            Long publicKeyHandle = identity.getId().getPublicKeyHandle();
            if (publicKeyHandle == null) {
                return null;
            }
            bagEntry = this.borrowSession();
            keyType = identity.getKeyType();
            Session session = (Session)bagEntry.value();
            if (keyType == 0L) {
                RSAPublicKey rSAPublicKey = NativeP11SlotUtil.buildRSAKey(identity.getRsaModulus(), identity.getRsaPublicExponent());
                return rSAPublicKey;
            }
            if (keyType == 1L) {
                BigInteger q = identity.getDsaQ();
                AttributeVector attrs = session.getAttrValues(publicKeyHandle.longValue(), new long[]{304L, 17L, 306L});
                DSAPublicKeySpec keySpec = new DSAPublicKeySpec(new BigInteger(1, attrs.value()), attrs.prime(), q, attrs.base());
                try {
                    DSAPublicKey dSAPublicKey = KeyUtil.generateDSAPublicKey(keySpec);
                    return dSAPublicKey;
                }
                catch (InvalidKeySpecException ex) {
                    throw new TokenException(ex.getMessage(), (Exception)ex);
                }
            }
            if (keyType != 3L && keyType != 0xFFFFF001L && keyType != 64L && keyType != 65L) break block21;
            byte[] ecPoint = session.getByteArrayAttrValue(publicKeyHandle.longValue(), 385L);
            ASN1ObjectIdentifier curveOid = identity.getEcParams();
            byte[] encodedPoint = DEROctetString.getInstance((Object)ecPoint).getOctets();
            if (keyType == 64L || keyType == 65L) {
                if (keyType == 64L) {
                    if (!EdECConstants.isEdwardsCurve(curveOid)) {
                        throw new TokenException("unknown Edwards curve OID " + curveOid);
                    }
                } else if (!EdECConstants.isMontgomeryCurve(curveOid)) {
                    throw new TokenException("unknown Montgomery curve OID " + curveOid);
                }
                SubjectPublicKeyInfo pkInfo = new SubjectPublicKeyInfo(new AlgorithmIdentifier(curveOid), encodedPoint);
                try {
                    PublicKey publicKey = KeyUtil.generatePublicKey(pkInfo);
                    return publicKey;
                }
                catch (InvalidKeySpecException ex) {
                    throw new TokenException(ex.getMessage(), (Exception)ex);
                }
            }
            try {
                ECPublicKey pkInfo = KeyUtil.createECPublicKey(curveOid, encodedPoint);
                return pkInfo;
            }
            catch (InvalidKeySpecException ex) {
                throw new TokenException(ex.getMessage(), (Exception)ex);
            }
        }
        throw new TokenException("unknown key type " + PKCS11Constants.ckkCodeToName((long)keyType));
        finally {
            this.sessions.requite(bagEntry);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean objectExistsByIdLabel(byte[] id, String label) throws TokenException {
        if ((id == null || id.length == 0) && StringUtil.isBlank((String)label)) {
            return false;
        }
        AttributeVector template = new AttributeVector();
        if (id != null && id.length > 0) {
            template.id(id);
        }
        if (!StringUtil.isBlank((String)label)) {
            template.label(label);
        }
        ConcurrentBagEntry<Session> bagEntry = this.borrowSession();
        try {
            Session session = (Session)bagEntry.value();
            boolean bl = !NativeP11SlotUtil.getObjects(session, template, 1).isEmpty();
            return bl;
        }
        finally {
            this.sessions.requite(bagEntry);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int destroyAllObjects() {
        int num = 0;
        ConcurrentBagEntry<Session> bagEntry = null;
        try {
            bagEntry = this.borrowSession();
            Session session = (Session)bagEntry.value();
            List<Long> allHandles = NativeP11SlotUtil.getObjects(session, null, 9999);
            for (long handle : allHandles) {
                try {
                    session.destroyObject(handle);
                    ++num;
                }
                catch (PKCS11Exception e) {
                    LOG.warn("error destroying object with handle " + handle + ": " + e.getMessage());
                }
            }
        }
        catch (TokenException e) {
            LogUtil.warn((Logger)LOG, (Throwable)e, (String)"error destroyAllObjects()");
        }
        finally {
            if (bagEntry != null) {
                this.sessions.requite(bagEntry);
            }
        }
        return num;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long[] destroyObjectsByHandle(long[] handles) {
        ConcurrentBagEntry<Session> bagEntry = null;
        ArrayList<Long> destroyedHandles = new ArrayList<Long>(handles.length);
        try {
            bagEntry = this.borrowSession();
            for (long handle : handles) {
                try {
                    ((Session)bagEntry.value()).destroyObject(handle);
                    destroyedHandles.add(handle);
                }
                catch (PKCS11Exception e) {
                    LOG.warn("error destroying object with handle " + handle + ": " + e.getMessage());
                }
            }
        }
        catch (TokenException e) {
            LogUtil.warn((Logger)LOG, (Throwable)e, (String)"error borrowSession()");
        }
        finally {
            if (bagEntry != null) {
                this.sessions.requite(bagEntry);
            }
        }
        if (handles.length == destroyedHandles.size()) {
            return new long[0];
        }
        long[] failedHandles = new long[handles.length - destroyedHandles.size()];
        int index = 0;
        for (long handle : handles) {
            if (destroyedHandles.contains(handle)) continue;
            failedHandles[index++] = handle;
        }
        return failedHandles;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int destroyObjectsByIdLabel(byte[] id, String label) throws TokenException {
        if ((id == null || id.length == 0) && StringUtil.isBlank((String)label)) {
            throw new IllegalArgumentException("at least one of id and label may not be null");
        }
        AttributeVector template = new AttributeVector();
        if (id != null && id.length > 0) {
            template.id(id);
        }
        if (label != null && !label.isEmpty()) {
            template.label(label);
        }
        ConcurrentBagEntry<Session> bagEntry = this.borrowSession();
        try {
            String objIdDesc = NativeP11Slot.getDescription(id, label);
            int n = NativeP11SlotUtil.removeObjects0((Session)bagEntry.value(), template, "objects " + objIdDesc);
            return n;
        }
        finally {
            this.sessions.requite(bagEntry);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected P11IdentityId doGenerateSecretKey(long keyType, Integer keysize, P11Slot.P11NewKeyControl control) throws TokenException {
        String label;
        long mech;
        if (keysize != null && keysize % 8 != 0) {
            throw new IllegalArgumentException("keysize is not multiple of 8: " + keysize);
        }
        boolean hasValueLen = true;
        if (31L == keyType) {
            mech = 4224L;
        } else if (21L == keyType) {
            mech = 305L;
            hasValueLen = false;
        } else if (16L == keyType) {
            mech = 848L;
        } else if (40L == keyType || 46L == keyType || 43L == keyType || 44L == keyType || 45L == keyType || 54L == keyType || 55L == keyType || 56L == keyType || 57L == keyType) {
            mech = 848L;
        } else {
            throw new IllegalArgumentException("unsupported key type 0x" + PKCS11Constants.codeToName((PKCS11Constants.Category)PKCS11Constants.Category.CKK, (long)keyType));
        }
        this.assertMechanismSupported(mech);
        if (this.newObjectConf.isIgnoreLabel()) {
            if (control.getLabel() != null) {
                LOG.warn("label is set, but ignored: '{}'", (Object)control.getLabel());
            }
            label = null;
        } else {
            label = control.getLabel();
        }
        byte[] id = control.getId();
        AttributeVector template = AttributeVector.newSecretKey((long)keyType);
        NativeP11SlotUtil.setKeyAttributes(control, template, label);
        if (hasValueLen) {
            if (keysize == null) {
                throw new IllegalArgumentException("keysize must not be null");
            }
            template.valueLen(Integer.valueOf(keysize / 8));
        }
        Mechanism mechanism = new Mechanism(mech);
        ConcurrentBagEntry<Session> bagEntry = this.borrowSession();
        try {
            Session session = (Session)bagEntry.value();
            if (label != null && this.labelExists(session, label)) {
                throw new IllegalArgumentException("label " + control.getLabel() + " exists, please specify another one");
            }
            if (id == null) {
                id = this.generateId(session);
            }
            template.id(id);
            long keyHandle = session.generateKey(mechanism, template);
            label = session.getCkaLabel(keyHandle);
            P11IdentityId p11IdentityId = new P11IdentityId(this.slotId, new P11ObjectId(keyHandle, 4L, keyType, id, label), null);
            return p11IdentityId;
        }
        finally {
            this.sessions.requite(bagEntry);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected P11IdentityId doImportSecretKey(long keyType, byte[] keyValue, P11Slot.P11NewKeyControl control) throws TokenException {
        String label;
        AttributeVector template = AttributeVector.newSecretKey((long)keyType);
        if (this.newObjectConf.isIgnoreLabel()) {
            if (control.getLabel() != null) {
                LOG.warn("label is set, but ignored: '{}'", (Object)control.getLabel());
            }
            label = null;
        } else {
            label = control.getLabel();
        }
        NativeP11SlotUtil.setKeyAttributes(control, template, label);
        template.value(keyValue);
        ConcurrentBagEntry<Session> bagEntry = this.borrowSession();
        try {
            Session session = (Session)bagEntry.value();
            if (label != null && this.labelExists(session, label)) {
                throw new IllegalArgumentException("label " + control.getLabel() + " exists, please specify another one");
            }
            byte[] id = control.getId();
            if (id == null) {
                id = this.generateId(session);
            }
            template.id(id);
            long keyHandle = session.createObject(template);
            try {
                label = session.getCkaLabel(keyHandle);
            }
            catch (PKCS11Exception pKCS11Exception) {
                // empty catch block
            }
            P11IdentityId p11IdentityId = new P11IdentityId(this.slotId, new P11ObjectId(keyHandle, 4L, keyType, id, label), null);
            return p11IdentityId;
        }
        finally {
            this.sessions.requite(bagEntry);
        }
    }

    @Override
    protected P11IdentityId doGenerateRSAKeypair(int keysize, BigInteger publicExponent, P11Slot.P11NewKeyControl control) throws TokenException {
        KeyPairTemplate template = new KeyPairTemplate(0L);
        template.publicKey().modulusBits(Integer.valueOf(keysize));
        if (publicExponent != null) {
            template.publicKey().publicExponent(publicExponent);
        }
        NativeP11SlotUtil.setKeyPairAttributes(control, template, this.newObjectConf);
        return this.doGenerateKeyPair(this.rsaKeyPairGenMech, control.getId(), template);
    }

    @Override
    protected PrivateKeyInfo doGenerateRSAKeypairOtf(int keysize, BigInteger publicExponent) throws TokenException {
        KeyPairTemplate template = new KeyPairTemplate(0L);
        template.publicKey().modulusBits(Integer.valueOf(keysize));
        if (publicExponent != null) {
            template.publicKey().publicExponent(publicExponent);
        }
        NativeP11Slot.setPrivateKeyAttrsOtf(template.privateKey());
        long mech = this.rsaKeyPairGenMech;
        ConcurrentBagEntry<Session> bagEntry = this.borrowSession();
        try {
            PrivateKeyInfo privateKeyInfo;
            Session session = (Session)bagEntry.value();
            PKCS11KeyPair keypair = null;
            try {
                keypair = session.generateKeyPair(new Mechanism(mech), template);
                AttributeVector attrs = session.getAttrValues(keypair.getPrivateKey(), new long[]{288L, 290L, 291L, 292L, 293L, 294L, 295L, 296L});
                privateKeyInfo = new PrivateKeyInfo(ALGID_RSA, (ASN1Encodable)new RSAPrivateKey(attrs.modulus(), attrs.publicExponent(), attrs.privateExponent(), attrs.prime1(), attrs.prime2(), attrs.exponent1(), attrs.exponent2(), attrs.coefficient()));
            }
            catch (IOException | PKCS11Exception ex) {
                try {
                    throw new TokenException("could not generate keypair " + PKCS11Constants.ckmCodeToName((long)mech), (Exception)ex);
                }
                catch (Throwable throwable) {
                    NativeP11Slot.destroyKeyPairQuietly(session, keypair);
                    throw throwable;
                }
            }
            NativeP11Slot.destroyKeyPairQuietly(session, keypair);
            return privateKeyInfo;
        }
        finally {
            this.sessions.requite(bagEntry);
        }
    }

    @Override
    protected P11IdentityId doGenerateDSAKeypair(BigInteger p, BigInteger q, BigInteger g, P11Slot.P11NewKeyControl control) throws TokenException {
        KeyPairTemplate template = new KeyPairTemplate(1L);
        template.publicKey().prime(p).subprime(q).base(g);
        NativeP11SlotUtil.setKeyPairAttributes(control, template, this.newObjectConf);
        return this.doGenerateKeyPair(16L, control.getId(), template);
    }

    @Override
    protected PrivateKeyInfo generateDSAKeypairOtf0(BigInteger p, BigInteger q, BigInteger g) throws TokenException {
        KeyPairTemplate template = new KeyPairTemplate(1L);
        NativeP11Slot.setPrivateKeyAttrsOtf(template.privateKey());
        template.publicKey().prime(p).subprime(q).base(g);
        long mech = 16L;
        ConcurrentBagEntry<Session> bagEntry = this.borrowSession();
        try {
            PrivateKeyInfo privateKeyInfo;
            Session session = (Session)bagEntry.value();
            PKCS11KeyPair keypair = null;
            try {
                DSAParameter parameter = new DSAParameter(p, q, g);
                AlgorithmIdentifier algId = new AlgorithmIdentifier(X9ObjectIdentifiers.id_dsa, (ASN1Encodable)parameter);
                keypair = session.generateKeyPair(new Mechanism(mech), template);
                long skHandle = keypair.getPrivateKey();
                long pkHandle = keypair.getPublicKey();
                BigInteger p11PublicKeyValue = session.getBigIntAttrValue(pkHandle, 17L);
                BigInteger p11PrivateKeyValue = session.getBigIntAttrValue(skHandle, 17L);
                byte[] publicKey = new ASN1Integer(p11PublicKeyValue).getEncoded();
                privateKeyInfo = new PrivateKeyInfo(algId, (ASN1Encodable)new ASN1Integer(p11PrivateKeyValue), null, publicKey);
            }
            catch (IOException | PKCS11Exception ex) {
                try {
                    throw new TokenException("could not generate keypair " + PKCS11Constants.ckmCodeToName((long)mech), (Exception)ex);
                }
                catch (Throwable throwable) {
                    NativeP11Slot.destroyKeyPairQuietly(session, keypair);
                    throw throwable;
                }
            }
            NativeP11Slot.destroyKeyPairQuietly(session, keypair);
            return privateKeyInfo;
        }
        finally {
            this.sessions.requite(bagEntry);
        }
    }

    @Override
    protected P11IdentityId doGenerateECEdwardsKeypair(ASN1ObjectIdentifier curveId, P11Slot.P11NewKeyControl control) throws TokenException {
        byte[] encodedCurveId;
        KeyPairTemplate template = new KeyPairTemplate(64L);
        NativeP11SlotUtil.setKeyPairAttributes(control, template, this.newObjectConf);
        try {
            encodedCurveId = curveId.getEncoded();
        }
        catch (IOException ex) {
            throw new TokenException(ex.getMessage(), (Exception)ex);
        }
        template.publicKey().ecParams(encodedCurveId);
        return this.doGenerateKeyPair(4181L, control.getId(), template);
    }

    @Override
    protected PrivateKeyInfo doGenerateECEdwardsKeypairOtf(ASN1ObjectIdentifier curveId) throws TokenException {
        return this.doGenerateECKeypairOtf(64L, 4181L, curveId);
    }

    @Override
    protected P11IdentityId doGenerateECMontgomeryKeypair(ASN1ObjectIdentifier curveId, P11Slot.P11NewKeyControl control) throws TokenException {
        KeyPairTemplate template = new KeyPairTemplate(65L);
        NativeP11SlotUtil.setKeyPairAttributes(control, template, this.newObjectConf);
        try {
            template.publicKey().ecParams(curveId.getEncoded());
        }
        catch (IOException ex) {
            throw new TokenException(ex.getMessage(), (Exception)ex);
        }
        return this.doGenerateKeyPair(4182L, control.getId(), template);
    }

    @Override
    protected PrivateKeyInfo doGenerateECMontgomeryKeypairOtf(ASN1ObjectIdentifier curveId) throws TokenException {
        return this.doGenerateECKeypairOtf(65L, 4182L, curveId);
    }

    @Override
    protected P11IdentityId doGenerateECKeypair(ASN1ObjectIdentifier curveId, P11Slot.P11NewKeyControl control) throws TokenException {
        byte[] encodedCurveId;
        KeyPairTemplate template = new KeyPairTemplate(3L);
        NativeP11SlotUtil.setKeyPairAttributes(control, template, this.newObjectConf);
        try {
            encodedCurveId = curveId.getEncoded();
        }
        catch (IOException ex) {
            throw new TokenException(ex.getMessage(), (Exception)ex);
        }
        template.publicKey().ecParams(encodedCurveId);
        return this.doGenerateKeyPair(4160L, control.getId(), template);
    }

    @Override
    protected PrivateKeyInfo doGenerateECKeypairOtf(ASN1ObjectIdentifier curveId) throws TokenException {
        return this.doGenerateECKeypairOtf(3L, 4160L, curveId);
    }

    private PrivateKeyInfo doGenerateECKeypairOtf(long keyType, long mech, ASN1ObjectIdentifier curveId) throws TokenException {
        if (keyType == 0xFFFFF001L && !GMObjectIdentifiers.sm2p256v1.equals((ASN1Primitive)curveId)) {
            throw new TokenException("keyType and curveId do not match.");
        }
        KeyPairTemplate template = new KeyPairTemplate(keyType);
        NativeP11Slot.setPrivateKeyAttrsOtf(template.privateKey());
        try {
            template.publicKey().ecParams(curveId.getEncoded());
        }
        catch (IOException ex) {
            throw new TokenException(ex.getMessage(), (Exception)ex);
        }
        ConcurrentBagEntry<Session> bagEntry = this.borrowSession();
        try {
            PrivateKeyInfo privateKeyInfo;
            byte[] privValue;
            byte[] encodedPublicPoint;
            PKCS11KeyPair keypair;
            Session session;
            block14: {
                session = (Session)bagEntry.value();
                keypair = null;
                keypair = session.generateKeyPair(new Mechanism(mech), template);
                byte[] ecPoint = session.getByteArrayAttrValue(keypair.getPublicKey(), 385L);
                encodedPublicPoint = DEROctetString.getInstance((Object)ecPoint).getOctets();
                privValue = session.getByteArrayAttrValue(keypair.getPrivateKey(), 17L);
                if (64L != keyType && 65L != keyType) break block14;
                AlgorithmIdentifier algId = new AlgorithmIdentifier(curveId);
                PrivateKeyInfo privateKeyInfo2 = new PrivateKeyInfo(algId, (ASN1Encodable)new DEROctetString(privValue), null, encodedPublicPoint);
                NativeP11Slot.destroyKeyPairQuietly(session, keypair);
                return privateKeyInfo2;
            }
            try {
                AlgorithmIdentifier algId = new AlgorithmIdentifier(X9ObjectIdentifiers.id_ecPublicKey, (ASN1Encodable)curveId);
                if (encodedPublicPoint[0] != 4) {
                    throw new TokenException("EcPoint does not start with 0x04");
                }
                int orderBigLen = (encodedPublicPoint.length - 1) / 2 * 8;
                privateKeyInfo = new PrivateKeyInfo(algId, (ASN1Encodable)new ECPrivateKey(orderBigLen, new BigInteger(1, privValue), (ASN1BitString)new DERBitString(encodedPublicPoint), null));
            }
            catch (IOException | PKCS11Exception ex) {
                try {
                    throw new TokenException("could not generate keypair " + PKCS11Constants.ckmCodeToName((long)mech), (Exception)ex);
                }
                catch (Throwable throwable) {
                    NativeP11Slot.destroyKeyPairQuietly(session, keypair);
                    throw throwable;
                }
            }
            NativeP11Slot.destroyKeyPairQuietly(session, keypair);
            return privateKeyInfo;
        }
        finally {
            this.sessions.requite(bagEntry);
        }
    }

    @Override
    protected P11IdentityId doGenerateSM2Keypair(P11Slot.P11NewKeyControl control) throws TokenException {
        long ckm = 0xFFFFF001L;
        if (this.supportsMechanism(ckm)) {
            KeyPairTemplate template = new KeyPairTemplate(0xFFFFF001L);
            template.publicKey().ecParams(Hex.decode((String)"06082A811CCF5501822D"));
            NativeP11SlotUtil.setKeyPairAttributes(control, template, this.newObjectConf);
            return this.doGenerateKeyPair(ckm, control.getId(), template);
        }
        return this.doGenerateECKeypair(GMObjectIdentifiers.sm2p256v1, control);
    }

    @Override
    protected PrivateKeyInfo doGenerateSM2KeypairOtf() throws TokenException {
        long ckm = 0xFFFFF001L;
        return this.supportsMechanism(ckm) ? this.doGenerateECKeypairOtf(0xFFFFF001L, ckm, GMObjectIdentifiers.sm2p256v1) : this.doGenerateECKeypairOtf(GMObjectIdentifiers.sm2p256v1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private P11IdentityId doGenerateKeyPair(long mech, byte[] id, KeyPairTemplate template) throws TokenException {
        long keyType = template.privateKey().keyType();
        String label = template.privateKey().label();
        boolean succ = false;
        try {
            P11IdentityId p11IdentityId;
            ConcurrentBagEntry<Session> bagEntry = this.borrowSession();
            try {
                PKCS11KeyPair keypair;
                Session session = (Session)bagEntry.value();
                if (label != null && this.labelExists(session, label)) {
                    throw new IllegalArgumentException("label " + label + " exists, please specify another one");
                }
                if (id == null) {
                    id = this.generateId(session);
                }
                template.id(id);
                try {
                    keypair = session.generateKeyPair(new Mechanism(mech), template);
                }
                catch (PKCS11Exception ex) {
                    throw new TokenException("could not generate keypair " + PKCS11Constants.ckmCodeToName((long)mech), (Exception)((Object)ex));
                }
                P11IdentityId ret = new P11IdentityId(this.slotId, new P11ObjectId(keypair.getPrivateKey(), 3L, keyType, id, label), keypair.getPublicKey());
                succ = true;
                p11IdentityId = ret;
            }
            catch (Throwable throwable) {
                this.sessions.requite(bagEntry);
                throw throwable;
            }
            this.sessions.requite(bagEntry);
            return p11IdentityId;
        }
        finally {
            if (!succ && id != null) {
                try {
                    this.destroyObjectsByIdLabel(id, label);
                }
                catch (Throwable th) {
                    LogUtil.error((Logger)LOG, (Throwable)th, (String)"could not remove objects");
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public P11IdentityId getIdentityId(byte[] keyId, String keyLabel) throws TokenException {
        if ((keyId == null || keyId.length == 0) && StringUtil.isBlank((String)keyLabel)) {
            return null;
        }
        ConcurrentBagEntry<Session> bagEntry = this.borrowSession();
        try {
            AttributeVector attrs;
            long objClass;
            List<Long> objHandles;
            Session session = (Session)bagEntry.value();
            if (keyId == null) {
                long objClass2;
                AttributeVector template = new AttributeVector().label(keyLabel);
                List<Long> objHandles2 = NativeP11SlotUtil.getObjects(session, template.class_(Long.valueOf(objClass2 = 3L)), 2);
                if (objHandles2.isEmpty()) {
                    objClass2 = 4L;
                    objHandles2 = NativeP11SlotUtil.getObjects(session, template.class_(Long.valueOf(objClass2)), 2);
                }
                if (objHandles2.isEmpty()) {
                    P11IdentityId p11IdentityId = null;
                    return p11IdentityId;
                }
                if (objHandles2.size() > 1) {
                    throw new TokenException("found more than 1 " + PKCS11Constants.ckkCodeToName((long)objClass2).substring(4) + " with label=" + keyLabel);
                }
                long keyHandle = objHandles2.get(0);
                AttributeVector attrs2 = session.getAttrValues(keyHandle, new long[]{258L, 256L});
                long keyType = attrs2.keyType();
                keyId = attrs2.id();
                P11ObjectId secretOrPrivKeyId = new P11ObjectId(keyHandle, objClass2, keyType, keyId, keyLabel);
                Long publicKeyHandle = null;
                if (objClass2 == 3L) {
                    List<Long> handles;
                    if (keyId == null) {
                        handles = NativeP11SlotUtil.getObjects(session, AttributeVector.newPublicKey().label(keyLabel), 2);
                        if (handles.size() > 1) {
                            LOG.warn("found more than 1 public key with label={}, ignore them", (Object)keyLabel);
                        } else if (handles.size() == 1) {
                            publicKeyHandle = handles.get(0);
                        }
                    } else {
                        handles = NativeP11SlotUtil.getObjects(session, AttributeVector.newPublicKey().id(keyId), 2);
                        if (handles.size() > 1) {
                            LOG.warn("found more than 1 public key with id={}, ignore them", (Object)Hex.encode((byte[])keyId));
                        } else if (handles.size() == 1) {
                            publicKeyHandle = handles.get(0);
                        }
                    }
                }
                P11IdentityId p11IdentityId = new P11IdentityId(this.slotId, secretOrPrivKeyId, publicKeyHandle);
                return p11IdentityId;
            }
            AttributeVector template = new AttributeVector().id(keyId);
            if (keyLabel != null) {
                template.label(keyLabel);
            }
            if ((objHandles = NativeP11SlotUtil.getObjects(session, template.class_(Long.valueOf(objClass = 3L)), 2)).isEmpty()) {
                objClass = 4L;
                objHandles = NativeP11SlotUtil.getObjects(session, template.class_(Long.valueOf(objClass)), 2);
            }
            if (objHandles.isEmpty()) {
                P11IdentityId keyHandle = null;
                return keyHandle;
            }
            if (objHandles.size() > 1) {
                throw new TokenException("found more than 1 " + PKCS11Constants.ckoCodeToName((long)objClass).substring(4) + " with " + NativeP11Slot.getDescription(keyId, keyLabel));
            }
            long keyHandle = objHandles.get(0);
            if (keyLabel == null) {
                attrs = session.getAttrValues(keyHandle, new long[]{256L, 3L});
                keyLabel = attrs.label();
            } else {
                attrs = session.getAttrValues(keyHandle, new long[]{256L});
            }
            P11ObjectId secretOrPrivKeyId = new P11ObjectId(keyHandle, objClass, attrs.keyType(), keyId, keyLabel);
            Long publicKeyHandle = null;
            if (objClass == 3L) {
                objHandles = NativeP11SlotUtil.getObjects(session, AttributeVector.newPublicKey().id(keyId), 2);
                if (objHandles.isEmpty()) {
                    LOG.warn("found no public key with ID {}.", (Object)NativeP11Slot.hex(keyId));
                } else if (objHandles.size() > 1) {
                    LOG.warn("found more than 1 public key with ID {}, ignore them", (Object)NativeP11Slot.hex(keyId));
                } else {
                    publicKeyHandle = objHandles.get(0);
                }
            }
            P11IdentityId p11IdentityId = new P11IdentityId(this.slotId, secretOrPrivKeyId, publicKeyHandle);
            return p11IdentityId;
        }
        finally {
            this.sessions.requite(bagEntry);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void showDetails(OutputStream stream, boolean verbose) throws IOException {
        ConcurrentBagEntry<Session> session0;
        String slotInfo;
        String tokenInfo;
        try {
            tokenInfo = this.slot.getToken().getTokenInfo().toString("  ");
        }
        catch (PKCS11Exception ex) {
            tokenInfo = "  ERROR";
        }
        try {
            slotInfo = this.slot.getSlotInfo().toString("  ");
        }
        catch (PKCS11Exception ex) {
            slotInfo = "  ERROR";
        }
        stream.write(("\nToken information:\n" + tokenInfo).getBytes(StandardCharsets.UTF_8));
        stream.write(("\n\nSlot information:\n" + slotInfo).getBytes(StandardCharsets.UTF_8));
        stream.write(10);
        if (verbose) {
            this.printSupportedMechanism(stream);
        }
        stream.write("\nList of objects:\n".getBytes(StandardCharsets.UTF_8));
        try {
            session0 = this.borrowSession();
        }
        catch (TokenException e) {
            throw new RuntimeException(e);
        }
        try {
            Session session = (Session)session0.value();
            session.findObjectsInit(null);
            LinkedList<Long> allHandles = new LinkedList<Long>();
            try {
                long[] handles;
                do {
                    for (long handle : handles = session.findObjects(10)) {
                        allHandles.add(handle);
                    }
                } while (handles.length >= 10);
            }
            finally {
                session.findObjectsFinal();
            }
            int no = 0;
            Iterator iterator = allHandles.iterator();
            while (iterator.hasNext()) {
                String text;
                long handle = (Long)iterator.next();
                String objectText = this.objectToString(session, handle);
                try {
                    text = NativeP11Slot.formatNumber(++no, 3) + ". " + objectText;
                }
                catch (Exception ex) {
                    text = NativeP11Slot.formatNumber(no, 3) + ". Error reading object with handle " + handle;
                    LOG.debug(text, (Throwable)ex);
                }
                stream.write(("  " + text + "\n").getBytes(StandardCharsets.UTF_8));
                if (no % 10 != 0) continue;
                stream.flush();
            }
        }
        catch (PKCS11Exception e) {
            String message = "error finding objects: " + e.getMessage();
            stream.write(message.getBytes(StandardCharsets.UTF_8));
            LogUtil.warn((Logger)LOG, (Throwable)e, (String)message);
        }
        finally {
            this.sessions.requite(session0);
        }
        stream.flush();
    }

    private String objectToString(Session session, long handle) throws PKCS11Exception {
        AttributeVector attrs = session.getAttrValues(handle, new long[]{258L, 3L, 0L});
        long objClass = attrs.class_();
        byte[] id = attrs.id();
        String label = attrs.label();
        String keySpec = null;
        if (objClass == 3L || objClass == 2L || objClass == 4L) {
            long keyType = session.getCkaKeyType(handle);
            if (objClass == 4L) {
                Integer len;
                int valueLen = keyType == 21L ? 24 : ((len = session.getIntAttrValue(handle, 353L)) == null ? 0 : len);
                keySpec = PKCS11Constants.ckkCodeToName((long)keyType).substring(4) + "/" + valueLen * 8;
            } else if (keyType == 0L) {
                BigInteger modulus = session.getBigIntAttrValue(handle, 288L);
                keySpec = "RSA/" + (modulus == null ? "<N/A>" : Integer.valueOf(modulus.bitLength()));
            } else if (keyType == 3L || keyType == 64L || keyType == 65L) {
                byte[] ecParams = session.getByteArrayAttrValue(handle, 384L);
                String curveName = null;
                if (ecParams == null) {
                    curveName = "<N/A>";
                } else {
                    ASN1ObjectIdentifier curveOid = NativeP11Slot.detectCurveOid(ecParams);
                    if (curveOid != null && (curveName = AlgorithmUtil.getCurveName(curveOid)) == null) {
                        curveName = curveOid.getId();
                    }
                    if (curveName == null) {
                        curveName = "0x" + NativeP11Slot.hex(ecParams);
                    }
                }
                keySpec = PKCS11Constants.ckkCodeToName((long)keyType).substring(4) + "/" + curveName;
            } else if (keyType == 0xFFFFF001L) {
                keySpec = "SM2";
            } else if (keyType == 1L) {
                BigInteger prime = session.getBigIntAttrValue(handle, 304L);
                keySpec = "DSA/" + (prime == null ? 0 : prime.bitLength());
            } else {
                keySpec = PKCS11Constants.ckkCodeToName((long)keyType).substring(4);
            }
        }
        String text = "handle=" + handle + ", id=" + (id == null ? "<N/A>" : NativeP11Slot.hex(id)) + ", label=" + (label == null ? "<N/A>" : label) + ", " + PKCS11Constants.ckoCodeToName((long)objClass).substring(4);
        if (keySpec != null) {
            text = text + ": " + keySpec;
        }
        return text;
    }

    private byte[] generateId(Session session) throws TokenException {
        byte[] keyId;
        AttributeVector template;
        do {
            keyId = new byte[this.newObjectConf.getIdLength()];
            this.random.nextBytes(keyId);
        } while (!CollectionUtil.isEmpty(NativeP11SlotUtil.getObjects(session, template = new AttributeVector().id(keyId), 1)));
        return keyId;
    }

    private boolean labelExists(Session session, String keyLabel) throws TokenException {
        Args.notNull((Object)keyLabel, (String)"keyLabel");
        AttributeVector template = new AttributeVector().label(keyLabel);
        return !CollectionUtil.isEmpty(NativeP11SlotUtil.getObjects(session, template, 1));
    }

    private static void setPrivateKeyAttrsOtf(AttributeVector privateKeyTemplate) {
        privateKeyTemplate.sensitive(Boolean.valueOf(false)).extractable(Boolean.valueOf(true)).token(Boolean.valueOf(false));
    }

    private static void destroyKeyPairQuietly(Session session, PKCS11KeyPair keypair) {
        if (keypair != null) {
            try {
                session.destroyObject(keypair.getPrivateKey());
            }
            catch (PKCS11Exception ex) {
                LogUtil.warn((Logger)LOG, (Throwable)ex, (String)("error destroying private key " + keypair.getPrivateKey()));
            }
            try {
                session.destroyObject(keypair.getPublicKey());
            }
            catch (PKCS11Exception ex) {
                LogUtil.warn((Logger)LOG, (Throwable)ex, (String)("error destroying public key " + keypair.getPublicKey()));
            }
        }
    }

    private static ASN1ObjectIdentifier detectCurveOid(byte[] ecParams) {
        if (ecParams[0] == 6 && (0xFF & ecParams[1]) == ecParams.length - 2) {
            try {
                return ASN1ObjectIdentifier.getInstance((Object)ecParams);
            }
            catch (Exception e) {
                return null;
            }
        }
        return null;
    }
}

