/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.security.pkcs11;

import java.math.BigInteger;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.RSAPublicKeySpec;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xipki.pkcs11.wrapper.AttributeVector;
import org.xipki.pkcs11.wrapper.KeyPairTemplate;
import org.xipki.pkcs11.wrapper.Mechanism;
import org.xipki.pkcs11.wrapper.PKCS11Constants;
import org.xipki.pkcs11.wrapper.PKCS11Exception;
import org.xipki.pkcs11.wrapper.Session;
import org.xipki.pkcs11.wrapper.SessionInfo;
import org.xipki.pkcs11.wrapper.TokenException;
import org.xipki.pkcs11.wrapper.params.ByteArrayParams;
import org.xipki.pkcs11.wrapper.params.CkParams;
import org.xipki.pkcs11.wrapper.params.RSA_PKCS_PSS_PARAMS;
import org.xipki.security.pkcs11.P11ModuleConf;
import org.xipki.security.pkcs11.P11Params;
import org.xipki.security.pkcs11.P11Slot;
import org.xipki.security.util.KeyUtil;
import org.xipki.util.CollectionUtil;
import org.xipki.util.LogUtil;

class NativeP11SlotUtil {
    private static final Logger LOG = LoggerFactory.getLogger(NativeP11SlotUtil.class);

    NativeP11SlotUtil() {
    }

    static void singleLogin(Session session, long userType, char[] pin) throws TokenException {
        char[] tmpPin = pin;
        if (pin == null) {
            tmpPin = new char[]{};
        }
        String userTypeText = PKCS11Constants.codeToName((PKCS11Constants.Category)PKCS11Constants.Category.CKU, (long)userType);
        try {
            session.login(userType, tmpPin);
            LOG.info("login successful as user " + userTypeText);
        }
        catch (PKCS11Exception ex) {
            if (ex.getErrorCode() == 256L) {
                LOG.info("user already logged in");
            }
            LOG.info("login failed as user " + userTypeText);
            throw new TokenException("login failed as user " + userTypeText + ": " + ex.getMessage(), (Exception)((Object)ex));
        }
    }

    static byte[] digestKey(Session session, int digestLen, Mechanism mechanism, long hKey) throws PKCS11Exception {
        session.digestInit(mechanism);
        session.digestKey(hKey);
        byte[] digest = new byte[digestLen];
        int len = session.digestFinal(digest, 0, digestLen);
        if (len != digestLen) {
            LOG.warn("Token returns digest with unexpected length {}, expected {}", (Object)len, (Object)digestLen);
            throw new PKCS11Exception(6L);
        }
        return digest;
    }

    static Mechanism getMechanism(long mechanism, P11Params parameters) throws TokenException {
        ByteArrayParams paramObj;
        if (parameters == null) {
            return new Mechanism(mechanism);
        }
        if (parameters instanceof P11Params.P11RSAPkcsPssParams) {
            P11Params.P11RSAPkcsPssParams param = (P11Params.P11RSAPkcsPssParams)parameters;
            paramObj = new RSA_PKCS_PSS_PARAMS(param.getHashAlgorithm(), param.getMaskGenerationFunction(), param.getSaltLength());
        } else if (parameters instanceof P11Params.P11ByteArrayParams) {
            paramObj = new ByteArrayParams(((P11Params.P11ByteArrayParams)parameters).getBytes());
        } else {
            throw new TokenException("unknown P11Parameters " + parameters.getClass().getName());
        }
        return new Mechanism(mechanism, (CkParams)paramObj);
    }

    static boolean checkSessionLoggedIn(Session session, long userType) throws TokenException {
        SessionInfo info = session.getSessionInfo();
        if (LOG.isTraceEnabled()) {
            LOG.debug("SessionInfo: {}", (Object)info);
        }
        long state = info.getState();
        long deviceError = info.getDeviceError();
        LOG.debug("to be verified PKCS11Module: state = {}, deviceError: {}", (Object)PKCS11Constants.codeToName((PKCS11Constants.Category)PKCS11Constants.Category.CKS, (long)state), (Object)deviceError);
        if (deviceError != 0L) {
            LOG.error("deviceError {}", (Object)deviceError);
            return false;
        }
        boolean sessionLoggedIn = userType == 0L ? state == 4L : state == 3L || state == 1L;
        LOG.debug("sessionLoggedIn: {}", (Object)sessionLoggedIn);
        return sessionLoggedIn;
    }

    static List<Long> getObjects(Session session, AttributeVector template) throws TokenException {
        return NativeP11SlotUtil.getObjects(session, template, 9999);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static List<Long> getObjects(Session session, AttributeVector template, int maxNo) throws TokenException {
        LinkedList<Long> objList = new LinkedList<Long>();
        boolean initialized = false;
        try {
            int maxObjectCount;
            long[] foundObjectHandles;
            session.findObjectsInit(template);
            initialized = true;
            while (objList.size() < maxNo && (foundObjectHandles = session.findObjects(maxObjectCount = Math.min(maxNo - objList.size(), 100))) != null) {
                if (foundObjectHandles.length == 0) {
                    break;
                }
                for (long hObject : foundObjectHandles) {
                    objList.add(hObject);
                }
            }
        }
        finally {
            if (initialized) {
                try {
                    session.findObjectsFinal();
                }
                catch (Exception ex) {
                    LogUtil.error((Logger)LOG, (Throwable)ex, (String)"session.findObjectsFinal() failed");
                }
            }
        }
        return objList;
    }

    static RSAPublicKey buildRSAKey(BigInteger mod, BigInteger exp) throws TokenException {
        try {
            return KeyUtil.generateRSAPublicKey(new RSAPublicKeySpec(mod, exp));
        }
        catch (InvalidKeySpecException ex) {
            throw new TokenException(ex.getMessage(), (Exception)ex);
        }
    }

    static int removeObjects0(Session session, AttributeVector template, String desc) throws TokenException {
        try {
            List<Long> objects = NativeP11SlotUtil.getObjects(session, template);
            for (Long obj : objects) {
                session.destroyObject(obj.longValue());
            }
            return objects.size();
        }
        catch (TokenException ex) {
            LogUtil.error((Logger)LOG, (Throwable)ex, (String)("could not remove " + desc));
            throw new TokenException(ex.getMessage(), (Exception)((Object)ex));
        }
    }

    static void setKeyPairAttributes(P11Slot.P11NewKeyControl control, KeyPairTemplate template, P11ModuleConf.P11NewObjectConf newObjectConf) {
        Set<P11Slot.P11KeyUsage> usages;
        template.token(Boolean.valueOf(true));
        template.privateKey().private_(Boolean.valueOf(true));
        if (newObjectConf.isIgnoreLabel()) {
            if (control.getLabel() != null) {
                LOG.warn("label is set, but ignored: '{}'", (Object)control.getLabel());
            }
        } else {
            template.label(control.getLabel());
        }
        if (control.getExtractable() != null) {
            template.privateKey().extractable(control.getExtractable());
        }
        if (control.getSensitive() != null) {
            template.privateKey().sensitive(control.getSensitive());
        }
        if (CollectionUtil.isNotEmpty(usages = control.getUsages())) {
            block7: for (P11Slot.P11KeyUsage usage : usages) {
                switch (usage) {
                    case DECRYPT: {
                        template.decryptEncrypt(Boolean.valueOf(true));
                        continue block7;
                    }
                    case DERIVE: {
                        template.derive(Boolean.valueOf(true));
                        continue block7;
                    }
                    case SIGN: {
                        template.signVerify(Boolean.valueOf(true));
                        continue block7;
                    }
                    case SIGN_RECOVER: {
                        template.signVerifyRecover(Boolean.valueOf(true));
                        continue block7;
                    }
                    case UNWRAP: {
                        template.unwrapWrap(Boolean.valueOf(true));
                        continue block7;
                    }
                }
                throw new IllegalStateException("unknown P11KeyUsage");
            }
        } else {
            long keyType = template.privateKey().keyType();
            if (keyType == 3L || keyType == 0L || keyType == 1L || keyType == 0xFFFFF001L) {
                template.signVerify(Boolean.valueOf(true));
            }
            if (keyType == 0L) {
                template.unwrapWrap(Boolean.valueOf(true)).decryptEncrypt(Boolean.valueOf(true));
            }
        }
    }

    static void setKeyAttributes(P11Slot.P11NewKeyControl control, AttributeVector template, String label) {
        Set<P11Slot.P11KeyUsage> usages;
        template.token(Boolean.valueOf(true));
        if (label != null) {
            template.label(label);
        }
        if (control.getExtractable() != null) {
            template.extractable(control.getExtractable());
        }
        if (control.getSensitive() != null) {
            template.sensitive(control.getSensitive());
        }
        if (CollectionUtil.isNotEmpty(usages = control.getUsages())) {
            block7: for (P11Slot.P11KeyUsage usage : usages) {
                switch (usage) {
                    case DECRYPT: {
                        template.decrypt(Boolean.valueOf(true)).encrypt(Boolean.valueOf(true));
                        continue block7;
                    }
                    case DERIVE: {
                        template.derive(Boolean.valueOf(true));
                        continue block7;
                    }
                    case SIGN: {
                        template.sign(Boolean.valueOf(true)).verify(Boolean.valueOf(true));
                        continue block7;
                    }
                    case SIGN_RECOVER: {
                        template.signRecover(Boolean.valueOf(true)).verifyRecover(Boolean.valueOf(true));
                        continue block7;
                    }
                    case UNWRAP: {
                        template.unwrap(Boolean.valueOf(true)).wrap(Boolean.valueOf(true));
                        continue block7;
                    }
                }
                throw new IllegalStateException("unknown P11KeyUsage");
            }
        }
    }
}

