/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.security.pkcs11;

import java.math.BigInteger;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.cert.CertPathBuilderException;
import java.security.interfaces.ECPublicKey;
import java.security.spec.ECPoint;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.gm.GMObjectIdentifiers;
import org.xipki.pkcs11.wrapper.PKCS11Constants;
import org.xipki.pkcs11.wrapper.TokenException;
import org.xipki.security.ConcurrentContentSigner;
import org.xipki.security.DfltConcurrentContentSigner;
import org.xipki.security.SecurityFactory;
import org.xipki.security.SignAlgo;
import org.xipki.security.X509Cert;
import org.xipki.security.XiContentSigner;
import org.xipki.security.XiSecurityException;
import org.xipki.security.pkcs11.P11ContentSigner;
import org.xipki.security.pkcs11.P11Identity;
import org.xipki.security.util.X509Util;
import org.xipki.util.Args;

public class P11ContentSignerBuilder {
    private final X509Cert[] certificateChain;
    private final SecurityFactory securityFactory;
    private final P11Identity identity;

    public P11ContentSignerBuilder(SecurityFactory securityFactory, P11Identity identity, X509Cert[] certificateChain) throws XiSecurityException, TokenException {
        X509Cert cert;
        this.securityFactory = (SecurityFactory)Args.notNull((Object)securityFactory, (String)"securityFactory");
        this.identity = (P11Identity)Args.notNull((Object)identity, (String)"identity");
        HashSet<X509Cert> caCerts = new HashSet<X509Cert>();
        if (certificateChain != null && certificateChain.length > 0) {
            int n = certificateChain.length;
            cert = certificateChain[0];
            if (n > 1) {
                caCerts.addAll(Arrays.asList(certificateChain).subList(1, n));
            }
        } else {
            cert = null;
        }
        if (cert != null) {
            try {
                this.certificateChain = X509Util.buildCertPath(cert, caCerts);
            }
            catch (CertPathBuilderException ex) {
                throw new XiSecurityException(ex);
            }
        } else {
            this.certificateChain = null;
        }
    }

    public ConcurrentContentSigner createSigner(SignAlgo signAlgo, int parallelism) throws XiSecurityException, TokenException {
        DfltConcurrentContentSigner concurrentSigner;
        Args.positive((int)parallelism, (String)"parallelism");
        ArrayList<XiContentSigner> signers = new ArrayList<XiContentSigner>(parallelism);
        long keyType = this.identity.getKeyType();
        Boolean isSm2p256v1 = null;
        BigInteger wx = null;
        BigInteger wy = null;
        for (int i = 0; i < parallelism; ++i) {
            XiContentSigner signer;
            if (keyType == 0L) {
                signer = this.createRSAContentSigner(signAlgo);
            } else if (keyType == 3L || keyType == 0xFFFFF001L) {
                if (i == 0 && (isSm2p256v1 = Boolean.valueOf(keyType == 0xFFFFF001L || GMObjectIdentifiers.sm2p256v1.equals((ASN1Primitive)this.identity.getEcParams()))).booleanValue()) {
                    PublicKey publicKey = this.certificateChain != null ? this.certificateChain[0].getPublicKey() : this.identity.getPublicKey();
                    ECPoint w = ((ECPublicKey)publicKey).getW();
                    wx = w.getAffineX();
                    wy = w.getAffineY();
                }
                signer = isSm2p256v1 != false ? this.createSM2ContentSigner(signAlgo, GMObjectIdentifiers.sm2p256v1, wx, wy) : this.createECContentSigner(signAlgo);
            } else if (keyType == 1L) {
                signer = this.createDSAContentSigner(signAlgo);
            } else if (keyType == 64L) {
                signer = this.createEdDSAContentSigner(signAlgo);
            } else {
                throw new XiSecurityException("unsupported key type " + PKCS11Constants.ckkCodeToName((long)keyType));
            }
            signers.add(signer);
        }
        boolean mac = false;
        try {
            concurrentSigner = new DfltConcurrentContentSigner(false, signers);
        }
        catch (NoSuchAlgorithmException ex) {
            throw new XiSecurityException(ex.getMessage(), ex);
        }
        if (this.certificateChain != null) {
            concurrentSigner.setCertificateChain(this.certificateChain);
        } else {
            concurrentSigner.setPublicKey(this.identity.getPublicKey());
        }
        return concurrentSigner;
    }

    private XiContentSigner createRSAContentSigner(SignAlgo signAlgo) throws XiSecurityException {
        return signAlgo.isRSAPSSSigAlgo() ? new P11ContentSigner.RSAPSS(this.identity, signAlgo, this.securityFactory.getRandom4Sign()) : new P11ContentSigner.RSA(this.identity, signAlgo);
    }

    private XiContentSigner createECContentSigner(SignAlgo signAlgo) throws XiSecurityException {
        return new P11ContentSigner.ECDSA(this.identity, signAlgo);
    }

    private XiContentSigner createSM2ContentSigner(SignAlgo signAlgo, ASN1ObjectIdentifier curveOid, BigInteger pubPointX, BigInteger pubPointy) throws XiSecurityException {
        return new P11ContentSigner.SM2(this.identity, signAlgo, curveOid, pubPointX, pubPointy);
    }

    private XiContentSigner createDSAContentSigner(SignAlgo signAlgo) throws XiSecurityException {
        return new P11ContentSigner.DSA(this.identity, signAlgo);
    }

    private XiContentSigner createEdDSAContentSigner(SignAlgo signAlgo) throws XiSecurityException {
        return new P11ContentSigner.EdDSA(this.identity, signAlgo);
    }
}

