/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.security.pkcs11;

import java.math.BigInteger;
import java.security.PublicKey;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xipki.pkcs11.wrapper.PKCS11Constants;
import org.xipki.pkcs11.wrapper.TokenException;
import org.xipki.security.XiSecurityException;
import org.xipki.security.pkcs11.P11IdentityId;
import org.xipki.security.pkcs11.P11Params;
import org.xipki.security.pkcs11.P11Slot;
import org.xipki.util.Args;
import org.xipki.util.LogUtil;

public abstract class P11Identity {
    private static final Logger LOG = LoggerFactory.getLogger(P11Identity.class);
    protected final P11Slot slot;
    protected final P11IdentityId id;
    private ASN1ObjectIdentifier ecParams;
    private BigInteger rsaModulus;
    private BigInteger rsaPublicExponent;
    private BigInteger dsaQ;
    private boolean publicKeyInitialized;
    private PublicKey publicKey;

    protected P11Identity(P11Slot slot, P11IdentityId id) {
        this.slot = (P11Slot)Args.notNull((Object)slot, (String)"slot");
        this.id = (P11IdentityId)Args.notNull((Object)id, (String)"id");
    }

    public abstract void destroy() throws TokenException;

    public ASN1ObjectIdentifier getEcParams() {
        return this.ecParams;
    }

    public void setEcParams(ASN1ObjectIdentifier ecParams) {
        this.ecParams = ecParams;
    }

    public BigInteger getRsaModulus() {
        return this.rsaModulus;
    }

    public BigInteger getRsaPublicExponent() {
        return this.rsaPublicExponent;
    }

    public void setRsaMParameters(BigInteger modulus, BigInteger publicExponent) {
        this.rsaModulus = modulus;
        this.rsaPublicExponent = publicExponent;
    }

    public BigInteger getDsaQ() {
        return this.dsaQ;
    }

    public void setDsaQ(BigInteger q) {
        this.dsaQ = q;
    }

    public byte[] sign(long mechanism, P11Params parameters, byte[] content) throws TokenException {
        if (this.id.getKeyId().getKeyType() == 65L) {
            throw new TokenException("this identity is not suitable for sign");
        }
        Args.notNull((Object)content, (String)"content");
        this.slot.assertMechanismSupported(mechanism);
        if (!this.supportsMechanism(mechanism, parameters)) {
            throw new TokenException("unsupported mechanism " + PKCS11Constants.ckmCodeToName((long)mechanism));
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("sign with mechanism {}", (Object)PKCS11Constants.ckmCodeToName((long)mechanism));
        }
        return this.sign0(mechanism, parameters, content);
    }

    protected abstract byte[] sign0(long var1, P11Params var3, byte[] var4) throws TokenException;

    public byte[] digestSecretKey(long mechanism) throws TokenException, XiSecurityException {
        this.slot.assertMechanismSupported(mechanism);
        if (LOG.isDebugEnabled()) {
            LOG.debug("digest secret with mechanism {}", (Object)PKCS11Constants.ckmCodeToName((long)mechanism));
        }
        return this.digestSecretKey0(mechanism);
    }

    protected abstract byte[] digestSecretKey0(long var1) throws TokenException;

    public P11IdentityId getId() {
        return this.id;
    }

    public long getKeyType() {
        return this.id.getKeyId().getKeyType();
    }

    public boolean isSecretKey() {
        return this.id.getKeyId().getObjectCLass() == 4L;
    }

    public final synchronized PublicKey getPublicKey() {
        if (this.isSecretKey()) {
            return null;
        }
        if (this.publicKeyInitialized) {
            return this.publicKey;
        }
        try {
            this.publicKey = this.slot.getPublicKey(this);
        }
        catch (Exception e) {
            LogUtil.error((Logger)LOG, (Throwable)e, (String)("could not initialize public key for (private) key " + this.id));
        }
        finally {
            this.publicKeyInitialized = true;
        }
        return this.publicKey;
    }

    public boolean supportsMechanism(long mechanism) {
        return this.slot.supportsMechanism(mechanism);
    }

    public boolean supportsMechanism(long mechanism, P11Params parameters) {
        if (!this.supportsMechanism(mechanism)) {
            return false;
        }
        if (this.isSecretKey() && (545L == mechanism || 598L == mechanism || 593L == mechanism || 609L == mechanism || 625L == mechanism || 694L == mechanism || 689L == mechanism || 705L == mechanism || 721L == mechanism)) {
            return parameters == null;
        }
        long keyType = this.getKeyType();
        if (keyType == 0L) {
            if (2L == mechanism || 1L == mechanism || 6L == mechanism || 70L == mechanism || 64L == mechanism || 65L == mechanism || 66L == mechanism) {
                return parameters == null;
            }
            if (13L == mechanism || 14L == mechanism || 71L == mechanism || 67L == mechanism || 68L == mechanism || 69L == mechanism) {
                return parameters instanceof P11Params.P11RSAPkcsPssParams;
            }
            if (3L == mechanism) {
                return parameters == null;
            }
        } else {
            if (keyType == 1L) {
                if (parameters != null) {
                    return false;
                }
                return 17L == mechanism || 18L == mechanism || 19L == mechanism || 20L == mechanism || 21L == mechanism || 22L == mechanism;
            }
            if (keyType == 3L || keyType == 0xFFFFF001L) {
                if (4161L == mechanism || 4162L == mechanism || 4163L == mechanism || 4164L == mechanism || 4165L == mechanism || 4166L == mechanism || 0xFFFFF002L == mechanism) {
                    return parameters == null;
                }
                if (0xFFFFF003L == mechanism) {
                    return parameters instanceof P11Params.P11ByteArrayParams;
                }
            } else if (keyType == 64L) {
                return 4183L == mechanism;
            }
        }
        return false;
    }
}

