/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.security.pkcs11;

import org.xipki.security.pkcs11.P11ObjectId;
import org.xipki.security.pkcs11.P11SlotId;
import org.xipki.util.Args;

public class P11IdentityId {
    private final P11SlotId slotId;
    private final P11ObjectId keyId;
    private final Long publicKeyHandle;

    public P11IdentityId(P11SlotId slotId, P11ObjectId keyId, Long publicKeyHandle) {
        this.slotId = (P11SlotId)Args.notNull((Object)slotId, (String)"slotId");
        this.keyId = (P11ObjectId)Args.notNull((Object)keyId, (String)"keyId");
        this.publicKeyHandle = keyId.getObjectCLass() == 4L ? null : publicKeyHandle;
    }

    public Long getPublicKeyHandle() {
        return this.publicKeyHandle;
    }

    public P11SlotId getSlotId() {
        return this.slotId;
    }

    public P11ObjectId getKeyId() {
        return this.keyId;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof P11IdentityId)) {
            return false;
        }
        P11IdentityId ei = (P11IdentityId)obj;
        return this.slotId.equals(ei.slotId) && this.keyId.equals(ei.keyId);
    }

    public String toString() {
        return "slot " + this.slotId + ", key " + this.keyId;
    }

    public int hashCode() {
        return this.slotId.hashCode() + 31 * this.keyId.hashCode();
    }
}

