/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.security.pkcs11;

import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xipki.pkcs11.wrapper.TokenException;
import org.xipki.security.ConcurrentContentSigner;
import org.xipki.security.DfltConcurrentContentSigner;
import org.xipki.security.SignAlgo;
import org.xipki.security.XiContentSigner;
import org.xipki.security.XiSecurityException;
import org.xipki.security.pkcs11.P11ContentSigner;
import org.xipki.security.pkcs11.P11Identity;
import org.xipki.util.Args;
import org.xipki.util.LogUtil;

public class P11MacContentSignerBuilder {
    private static final Logger LOG = LoggerFactory.getLogger(P11MacContentSignerBuilder.class);
    private final P11Identity identity;

    public P11MacContentSignerBuilder(P11Identity identity) {
        this.identity = (P11Identity)Args.notNull((Object)identity, (String)"identity");
    }

    public ConcurrentContentSigner createSigner(SignAlgo signAlgo, int parallelism) throws XiSecurityException, TokenException {
        DfltConcurrentContentSigner concurrentSigner;
        Args.positive((int)parallelism, (String)"parallelism");
        ArrayList<XiContentSigner> signers = new ArrayList<XiContentSigner>(parallelism);
        for (int i = 0; i < parallelism; ++i) {
            signers.add(new P11ContentSigner.Mac(this.identity, signAlgo));
        }
        boolean mac = true;
        try {
            concurrentSigner = new DfltConcurrentContentSigner(true, signers);
        }
        catch (NoSuchAlgorithmException ex) {
            throw new XiSecurityException(ex.getMessage(), ex);
        }
        try {
            byte[] sha1HashOfKey = this.identity.digestSecretKey(544L);
            concurrentSigner.setSha1DigestOfMacKey(sha1HashOfKey);
        }
        catch (TokenException | XiSecurityException ex) {
            LogUtil.warn((Logger)LOG, (Throwable)ex, (String)("could not compute the digest of secret key " + this.identity.getId()));
        }
        return concurrentSigner;
    }
}

