/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.security.pkcs11;

import java.util.Arrays;
import org.xipki.util.Args;
import org.xipki.util.CompareUtil;
import org.xipki.util.Hex;

public class P11ObjectId {
    private final long handle;
    private final long keyType;
    private final long objectCLass;
    private final byte[] id;
    private final String idHex;
    private final String label;

    public P11ObjectId(long handle, long objectClass, long keyType, byte[] id, String label) {
        this.handle = handle;
        this.objectCLass = objectClass;
        this.keyType = keyType;
        if (id == null || id.length == 0) {
            this.id = null;
            this.idHex = null;
            this.label = Args.notBlank((String)label, (String)"label");
        } else {
            this.id = id;
            this.idHex = Hex.encode((byte[])id);
            this.label = label;
        }
    }

    public long getKeyType() {
        return this.keyType;
    }

    public long getObjectCLass() {
        return this.objectCLass;
    }

    public long getHandle() {
        return this.handle;
    }

    public byte[] getId() {
        return this.id;
    }

    public String getIdHex() {
        return this.idHex;
    }

    public String getLabel() {
        return this.label;
    }

    public String toString() {
        return String.format("(handle = %d, id = %s, label = %s)", this.handle, this.idHex, this.label);
    }

    public int hashCode() {
        return (int)this.handle;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof P11ObjectId)) {
            return false;
        }
        P11ObjectId other = (P11ObjectId)obj;
        return this.handle == other.handle && Arrays.equals(this.id, other.id) && CompareUtil.equalsObject((Object)this.label, (Object)other.label);
    }
}

