/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.security.pkcs11;

import java.security.NoSuchAlgorithmException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xipki.pkcs11.wrapper.TokenException;
import org.xipki.security.ConcurrentContentSigner;
import org.xipki.security.SecurityFactory;
import org.xipki.security.SignAlgo;
import org.xipki.security.SignerConf;
import org.xipki.security.SignerFactory;
import org.xipki.security.X509Cert;
import org.xipki.security.XiSecurityException;
import org.xipki.security.pkcs11.P11ContentSignerBuilder;
import org.xipki.security.pkcs11.P11CryptService;
import org.xipki.security.pkcs11.P11CryptServiceFactory;
import org.xipki.security.pkcs11.P11Identity;
import org.xipki.security.pkcs11.P11MacContentSignerBuilder;
import org.xipki.security.pkcs11.P11Module;
import org.xipki.security.pkcs11.P11Slot;
import org.xipki.security.pkcs11.P11SlotId;
import org.xipki.util.Hex;
import org.xipki.util.exception.ObjectCreationException;

public class P11SignerFactory
implements SignerFactory {
    private static final Logger LOG = LoggerFactory.getLogger(P11SignerFactory.class);
    private static final String TYPE = "pkcs11";
    private static final Set<String> types = Collections.unmodifiableSet(new HashSet<String>(Collections.singletonList("pkcs11")));
    private P11CryptServiceFactory p11CryptServiceFactory;
    private SecurityFactory securityFactory;

    public void setP11CryptServiceFactory(P11CryptServiceFactory p11CryptServiceFactory) {
        this.p11CryptServiceFactory = p11CryptServiceFactory;
    }

    public void setSecurityFactory(SecurityFactory securityFactory) {
        this.securityFactory = securityFactory;
    }

    @Override
    public Set<String> getSupportedSignerTypes() {
        return types;
    }

    @Override
    public boolean canCreateSigner(String type) {
        return types.contains(type.toLowerCase());
    }

    @Override
    public ConcurrentContentSigner newSigner(String type, SignerConf conf, X509Cert[] certificateChain) throws ObjectCreationException {
        P11Slot slot;
        Long slotId;
        if (!TYPE.equalsIgnoreCase(type)) {
            throw new ObjectCreationException("unknown signer type " + type);
        }
        if (this.p11CryptServiceFactory == null) {
            throw new ObjectCreationException("p11CryptServiceFactory is not set");
        }
        if (this.securityFactory == null) {
            throw new ObjectCreationException("securityFactory is not set");
        }
        String str = conf.getConfValue("parallelism");
        int parallelism = this.securityFactory.getDfltSignerParallelism();
        if (str != null) {
            try {
                parallelism = Integer.parseInt(str);
            }
            catch (NumberFormatException ex) {
                throw new ObjectCreationException("invalid parallelism " + str);
            }
            if (parallelism < 1) {
                throw new ObjectCreationException("invalid parallelism " + str);
            }
        }
        String moduleName = conf.getConfValue("module");
        str = conf.getConfValue("slot");
        Integer slotIndex = str == null ? null : Integer.valueOf(Integer.parseInt(str));
        str = conf.getConfValue("slot-id");
        Long l = slotId = str == null ? null : Long.valueOf(Long.parseLong(str));
        if (slotIndex == null && slotId == null || slotIndex != null && slotId != null) {
            throw new ObjectCreationException("exactly one of slot (index) and slot-id must be specified");
        }
        String keyLabel = conf.getConfValue("key-label");
        str = conf.getConfValue("key-id");
        byte[] keyId = null;
        if (str != null) {
            keyId = Hex.decode((String)str);
        }
        if (keyId == null && keyLabel == null || keyId != null && keyLabel != null) {
            throw new ObjectCreationException("exactly one of key-id and key-label must be specified");
        }
        try {
            P11CryptService p11Service = this.p11CryptServiceFactory.getP11CryptService(moduleName);
            P11Module module = p11Service.getModule();
            P11SlotId p11SlotId = slotId != null ? module.getSlotIdForId(slotId) : module.getSlotIdForIndex(slotIndex);
            slot = module.getSlot(p11SlotId);
        }
        catch (TokenException | XiSecurityException ex) {
            throw new ObjectCreationException(ex.getMessage(), ex);
        }
        String str2 = keyId != null ? "id " + Hex.encode((byte[])keyId) : "label " + keyLabel;
        P11Identity identity = null;
        try {
            identity = slot.getIdentity(keyId, keyLabel);
        }
        catch (TokenException e) {
            throw new ObjectCreationException("error finding identity with " + str2 + ": " + e.getMessage());
        }
        if (identity == null) {
            throw new ObjectCreationException("unknown identity with " + str2);
        }
        try {
            SignAlgo algo = null;
            String algoName = conf.getConfValue("algo");
            if (algoName != null) {
                algo = SignAlgo.getInstance(algoName);
            }
            if (algo != null && algo.isMac()) {
                P11MacContentSignerBuilder signerBuilder = new P11MacContentSignerBuilder(identity);
                return signerBuilder.createSigner(algo, parallelism);
            }
            if (algo == null) {
                algo = SignAlgo.getInstance(identity, conf);
            }
            P11ContentSignerBuilder signerBuilder = new P11ContentSignerBuilder(this.securityFactory, identity, certificateChain);
            return signerBuilder.createSigner(algo, parallelism);
        }
        catch (NoSuchAlgorithmException | TokenException | XiSecurityException ex) {
            throw new ObjectCreationException(ex.getMessage(), ex);
        }
    }
}

