/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.security.pkcs11.emulator;

import java.math.BigInteger;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.SecureRandom;
import java.security.Signature;
import java.security.SignatureException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.gm.GMObjectIdentifiers;
import org.bouncycastle.asn1.x9.X9ECParameters;
import org.bouncycastle.crypto.BlockCipher;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.CryptoException;
import org.bouncycastle.crypto.Digest;
import org.bouncycastle.crypto.engines.AESEngine;
import org.bouncycastle.crypto.macs.GMac;
import org.bouncycastle.crypto.macs.HMac;
import org.bouncycastle.crypto.modes.GCMBlockCipher;
import org.bouncycastle.crypto.params.KeyParameter;
import org.bouncycastle.crypto.params.ParametersWithIV;
import org.bouncycastle.jcajce.interfaces.EdDSAKey;
import org.bouncycastle.jcajce.provider.asymmetric.util.ECUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xipki.pkcs11.wrapper.PKCS11Constants;
import org.xipki.pkcs11.wrapper.TokenException;
import org.xipki.security.EdECConstants;
import org.xipki.security.HashAlgo;
import org.xipki.security.XiSecurityException;
import org.xipki.security.pkcs11.P11Identity;
import org.xipki.security.pkcs11.P11IdentityId;
import org.xipki.security.pkcs11.P11Params;
import org.xipki.security.pkcs11.P11Slot;
import org.xipki.security.pkcs11.emulator.EmulatorSM2Signer;
import org.xipki.security.util.PKCS1Util;
import org.xipki.security.util.SignerUtil;
import org.xipki.util.Args;
import org.xipki.util.concurrent.ConcurrentBag;
import org.xipki.util.concurrent.ConcurrentBagEntry;

class EmulatorP11Identity
extends P11Identity {
    private static final Logger LOG = LoggerFactory.getLogger(EmulatorP11Identity.class);
    private static final Map<Long, HashAlgo> mgfMechHashMap = new HashMap<Long, HashAlgo>();
    private static final Map<Long, HashAlgo> mechHashMap = new HashMap<Long, HashAlgo>();
    private final Key signingKey;
    private final ConcurrentBag<ConcurrentBagEntry<Cipher>> rsaCiphers = new ConcurrentBag();
    private final ConcurrentBag<ConcurrentBagEntry<Signature>> dsaSignatures = new ConcurrentBag();
    private final ConcurrentBag<ConcurrentBagEntry<Signature>> eddsaSignatures = new ConcurrentBag();
    private final ConcurrentBag<ConcurrentBagEntry<EmulatorSM2Signer>> sm2Signers = new ConcurrentBag();
    private final SecureRandom random;
    private final int maxSessions;
    private boolean initialized;
    private int dsaOrderBitLen;

    public EmulatorP11Identity(P11Slot slot, P11IdentityId identityId, Key signingKey, int maxSessions, SecureRandom random) {
        super(slot, identityId);
        this.signingKey = (Key)Args.notNull((Object)signingKey, (String)"signingKey");
        this.random = (SecureRandom)Args.notNull((Object)random, (String)"random");
        this.maxSessions = maxSessions;
    }

    @Override
    public void setEcParams(ASN1ObjectIdentifier ecParams) {
        super.setEcParams(ecParams);
        X9ECParameters x9params = ECUtil.getNamedCurveByOid((ASN1ObjectIdentifier)ecParams);
        if (x9params != null) {
            this.dsaOrderBitLen = x9params.getCurve().getOrder().bitLength();
        }
    }

    @Override
    public void setDsaQ(BigInteger q) {
        super.setDsaQ(q);
        this.dsaOrderBitLen = q.bitLength();
    }

    private synchronized void init() throws TokenException {
        block30: {
            if (this.initialized) {
                return;
            }
            long keyType = this.getKeyType();
            try {
                int i;
                String algorithm;
                if (keyType == 0L) {
                    String providerName = "BC";
                    LOG.info("use provider {}", (Object)providerName);
                    for (int i2 = 0; i2 < this.maxSessions; ++i2) {
                        Cipher rsaCipher;
                        try {
                            String algo = "RSA/ECB/NoPadding";
                            rsaCipher = Cipher.getInstance("RSA/ECB/NoPadding", providerName);
                            LOG.info("use cipher algorithm {}", (Object)"RSA/ECB/NoPadding");
                        }
                        catch (NoSuchPaddingException ex) {
                            throw new TokenException("NoSuchPadding", (Exception)ex);
                        }
                        catch (NoSuchAlgorithmException ex) {
                            String algo = "RSA/NONE/NoPadding";
                            try {
                                rsaCipher = Cipher.getInstance("RSA/NONE/NoPadding", providerName);
                                LOG.info("use cipher algorithm {}", (Object)"RSA/NONE/NoPadding");
                            }
                            catch (NoSuchPaddingException e1) {
                                throw new TokenException("NoSuchPadding", (Exception)ex);
                            }
                        }
                        rsaCipher.init(1, this.signingKey);
                        this.rsaCiphers.add(new ConcurrentBagEntry((Object)rsaCipher));
                    }
                    break block30;
                }
                if (keyType == 3L || keyType == 0xFFFFF001L) {
                    boolean sm2curve = GMObjectIdentifiers.sm2p256v1.equals((ASN1Primitive)this.getEcParams());
                    algorithm = sm2curve ? null : "NONEwithECDSA";
                } else if (keyType == 1L) {
                    algorithm = "NONEwithDSA";
                } else if (keyType == 64L) {
                    algorithm = null;
                } else if (keyType == 65L) {
                    algorithm = null;
                } else {
                    throw new TokenException("Currently only RSA, DSA, EC, EC Edwards and EC Montgomery public key are supported, but not " + PKCS11Constants.ckkCodeToName((long)keyType));
                }
                if (algorithm != null) {
                    for (i = 0; i < this.maxSessions; ++i) {
                        Signature dsaSignature = Signature.getInstance(algorithm, "BC");
                        dsaSignature.initSign((PrivateKey)this.signingKey, this.random);
                        this.dsaSignatures.add(new ConcurrentBagEntry((Object)dsaSignature));
                    }
                } else if (keyType == 64L) {
                    algorithm = EdECConstants.getName(this.getEcParams());
                    for (i = 0; i < this.maxSessions; ++i) {
                        Signature signature = Signature.getInstance(algorithm, "BC");
                        signature.initSign((PrivateKey)this.signingKey);
                        this.eddsaSignatures.add(new ConcurrentBagEntry((Object)signature));
                    }
                } else if (keyType == 65L) {
                } else {
                    for (i = 0; i < this.maxSessions; ++i) {
                        EmulatorSM2Signer sm2signer = new EmulatorSM2Signer((CipherParameters)ECUtil.generatePrivateKeyParameter((PrivateKey)((PrivateKey)this.signingKey)));
                        this.sm2Signers.add(new ConcurrentBagEntry((Object)sm2signer));
                    }
                }
            }
            catch (GeneralSecurityException ex) {
                throw new TokenException((Exception)ex);
            }
            finally {
                this.initialized = true;
            }
        }
    }

    @Override
    protected byte[] digestSecretKey0(long mechanism) throws TokenException {
        if (!(this.signingKey instanceof SecretKey)) {
            throw new TokenException("digestSecretKey could not be applied to non-SecretKey");
        }
        HashAlgo hashAlgo = mechHashMap.get(mechanism);
        if (hashAlgo == null) {
            throw new TokenException("unknown mechanism " + PKCS11Constants.ckmCodeToName((long)mechanism));
        }
        return hashAlgo.hash(new byte[][]{this.signingKey.getEncoded()});
    }

    @Override
    public void destroy() throws TokenException {
        this.slot.destroyObjectsById(this.id.getKeyId().getId());
    }

    @Override
    protected byte[] sign0(long mechanism, P11Params parameters, byte[] content) throws TokenException {
        this.init();
        if (mechanism == 4161L) {
            return this.dsaAndEcdsaSign(content, null);
        }
        if (mechanism == 0xFFFFF002L) {
            return this.sm2SignHash(content);
        }
        if (mechanism == 17L) {
            return this.dsaAndEcdsaSign(content, null);
        }
        if (mechanism == 4183L) {
            return this.eddsaSign(content);
        }
        if (mechanism == 3L) {
            return this.rsaX509Sign(content);
        }
        if (mechanism == 1L) {
            return this.rsaPkcsSign(content, null);
        }
        if (13L == mechanism) {
            return this.rsaPkcsPssSign(parameters, content, null);
        }
        if (4238L == mechanism) {
            return this.aesGmac(parameters, content);
        }
        HashAlgo hashAlgo = mechHashMap.get(mechanism);
        if (mechanism == 4162L || mechanism == 4163L || mechanism == 4164L || mechanism == 4165L || mechanism == 4166L || mechanism == 4167L || mechanism == 4168L || mechanism == 4169L || mechanism == 4170L) {
            return this.dsaAndEcdsaSign(content, hashAlgo);
        }
        if (mechanism == 0xFFFFF003L) {
            return this.sm2Sign(parameters, content);
        }
        if (mechanism == 18L || mechanism == 19L || mechanism == 20L || mechanism == 21L || mechanism == 22L || mechanism == 24L || mechanism == 25L || mechanism == 26L || mechanism == 27L) {
            return this.dsaAndEcdsaSign(content, hashAlgo);
        }
        if (mechanism == 6L || mechanism == 70L || mechanism == 64L || mechanism == 65L || mechanism == 66L || mechanism == 102L || mechanism == 96L || mechanism == 97L || mechanism == 98L) {
            return this.rsaPkcsSign(content, hashAlgo);
        }
        if (mechanism == 14L || mechanism == 71L || mechanism == 67L || mechanism == 68L || mechanism == 69L || mechanism == 103L || mechanism == 99L || mechanism == 100L || mechanism == 101L) {
            return this.rsaPkcsPssSign(parameters, content, hashAlgo);
        }
        if (mechanism == 545L || mechanism == 598L || mechanism == 593L || mechanism == 609L || mechanism == 625L || mechanism == 694L || mechanism == 689L || mechanism == 705L || mechanism == 721L) {
            return this.hmac(content, hashAlgo);
        }
        throw new TokenException("unsupported mechanism " + mechanism);
    }

    private byte[] hmac(byte[] contentToSign, HashAlgo hashAlgo) {
        HMac hmac = new HMac((Digest)hashAlgo.createDigest());
        hmac.init((CipherParameters)new KeyParameter(this.signingKey.getEncoded()));
        hmac.update(contentToSign, 0, contentToSign.length);
        byte[] signature = new byte[hmac.getMacSize()];
        hmac.doFinal(signature, 0);
        return signature;
    }

    private byte[] aesGmac(P11Params params, byte[] contentToSign) throws TokenException {
        if (params == null) {
            throw new TokenException("iv may not be null");
        }
        if (!(params instanceof P11Params.P11ByteArrayParams)) {
            throw new TokenException("params must be instanceof P11ByteArrayParams");
        }
        byte[] iv = ((P11Params.P11ByteArrayParams)params).getBytes();
        GMac gmac = new GMac(new GCMBlockCipher((BlockCipher)new AESEngine()));
        gmac.init((CipherParameters)new ParametersWithIV((CipherParameters)new KeyParameter(this.signingKey.getEncoded()), iv));
        gmac.update(contentToSign, 0, contentToSign.length);
        byte[] signature = new byte[gmac.getMacSize()];
        gmac.doFinal(signature, 0);
        return signature;
    }

    private byte[] rsaPkcsPssSign(P11Params parameters, byte[] contentToSign, HashAlgo hashAlgo) throws TokenException {
        byte[] encodedHashValue;
        if (!(parameters instanceof P11Params.P11RSAPkcsPssParams)) {
            throw new TokenException("the parameters is not of " + P11Params.P11RSAPkcsPssParams.class.getName());
        }
        P11Params.P11RSAPkcsPssParams pssParam = (P11Params.P11RSAPkcsPssParams)parameters;
        HashAlgo contentHash = mechHashMap.get(pssParam.getHashAlgorithm());
        if (contentHash == null) {
            throw new TokenException("unsupported HashAlgorithm " + pssParam.getHashAlgorithm());
        }
        if (hashAlgo != null && contentHash != hashAlgo) {
            throw new TokenException("Invalid parameters: invalid hash algorithm");
        }
        HashAlgo mgfHash = mgfMechHashMap.get(pssParam.getMaskGenerationFunction());
        if (mgfHash == null) {
            throw new TokenException("unsupported MaskGenerationFunction " + pssParam.getHashAlgorithm());
        }
        byte[] hashValue = hashAlgo == null ? contentToSign : hashAlgo.hash(new byte[][]{contentToSign});
        try {
            encodedHashValue = PKCS1Util.EMSA_PSS_ENCODE(contentHash, hashValue, mgfHash, pssParam.getSaltLength(), this.getRsaModulus().bitLength(), this.random);
        }
        catch (XiSecurityException ex) {
            throw new TokenException("XiSecurityException: " + ex.getMessage(), (Exception)ex);
        }
        return this.rsaX509Sign(encodedHashValue);
    }

    private byte[] rsaPkcsSign(byte[] contentToSign, HashAlgo hashAlgo) throws TokenException {
        byte[] paddedHash;
        int modulusBitLen = this.getRsaModulus().bitLength();
        try {
            paddedHash = hashAlgo == null ? PKCS1Util.EMSA_PKCS1_v1_5_encoding(contentToSign, modulusBitLen) : PKCS1Util.EMSA_PKCS1_v1_5_encoding(hashAlgo.hash(new byte[][]{contentToSign}), modulusBitLen, hashAlgo);
        }
        catch (XiSecurityException ex) {
            throw new TokenException("XiSecurityException: " + ex.getMessage(), (Exception)ex);
        }
        return this.rsaX509Sign(paddedHash);
    }

    private byte[] rsaX509Sign(byte[] dataToSign) throws TokenException {
        ConcurrentBagEntry cipher;
        try {
            cipher = this.rsaCiphers.borrow(5000L, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException ex) {
            throw new TokenException("could not take any idle signer");
        }
        if (cipher == null) {
            throw new TokenException("no idle RSA cipher available");
        }
        try {
            byte[] ex = ((Cipher)cipher.value()).doFinal(dataToSign);
            return ex;
        }
        catch (BadPaddingException ex) {
            throw new TokenException("BadPaddingException: " + ex.getMessage(), (Exception)ex);
        }
        catch (IllegalBlockSizeException ex) {
            throw new TokenException("IllegalBlockSizeException: " + ex.getMessage(), (Exception)ex);
        }
        finally {
            this.rsaCiphers.requite(cipher);
        }
    }

    private byte[] dsaAndEcdsaSign(byte[] dataToSign, HashAlgo hashAlgo) throws TokenException {
        ConcurrentBagEntry sig0;
        byte[] hash = hashAlgo == null ? dataToSign : hashAlgo.hash(new byte[][]{dataToSign});
        try {
            sig0 = this.dsaSignatures.borrow(5000L, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException ex) {
            throw new TokenException("InterruptedException occurs while retrieving idle signature");
        }
        if (sig0 == null) {
            throw new TokenException("no idle DSA Signature available");
        }
        try {
            Signature sig = (Signature)sig0.value();
            sig.update(hash);
            byte[] x962Signature = sig.sign();
            byte[] byArray = SignerUtil.dsaSigX962ToPlain(x962Signature, this.dsaOrderBitLen);
            return byArray;
        }
        catch (SignatureException ex) {
            throw new TokenException("SignatureException: " + ex.getMessage(), (Exception)ex);
        }
        catch (XiSecurityException ex) {
            throw new TokenException("XiSecurityException: " + ex.getMessage(), (Exception)ex);
        }
        finally {
            this.dsaSignatures.requite(sig0);
        }
    }

    private byte[] eddsaSign(byte[] dataToSign) throws TokenException {
        ConcurrentBagEntry sig0;
        if (!(this.signingKey instanceof EdDSAKey)) {
            throw new TokenException("given signing key is not suitable for EdDSA sign");
        }
        try {
            sig0 = this.eddsaSignatures.borrow(5000L, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException ex) {
            throw new TokenException("InterruptedException occurs while retrieving idle signature");
        }
        if (sig0 == null) {
            throw new TokenException("no idle DSA Signature available");
        }
        try {
            Signature sig = (Signature)sig0.value();
            sig.update(dataToSign);
            byte[] byArray = sig.sign();
            return byArray;
        }
        catch (SignatureException ex) {
            throw new TokenException("SignatureException: " + ex.getMessage(), (Exception)ex);
        }
        finally {
            this.eddsaSignatures.requite(sig0);
        }
    }

    private byte[] sm2SignHash(byte[] hash) throws TokenException {
        ConcurrentBagEntry sig0;
        try {
            sig0 = this.sm2Signers.borrow(5000L, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException ex) {
            throw new TokenException("InterruptedException occurs while retrieving idle signature");
        }
        if (sig0 == null) {
            throw new TokenException("no idle SM2 Signer available");
        }
        try {
            EmulatorSM2Signer sig = (EmulatorSM2Signer)sig0.value();
            byte[] x962Signature = sig.generateSignatureForHash(hash);
            byte[] byArray = SignerUtil.dsaSigX962ToPlain(x962Signature, this.dsaOrderBitLen);
            return byArray;
        }
        catch (CryptoException ex) {
            throw new TokenException("CryptoException: " + ex.getMessage(), (Exception)((Object)ex));
        }
        catch (XiSecurityException ex) {
            throw new TokenException("XiSecurityException: " + ex.getMessage(), (Exception)ex);
        }
        finally {
            this.sm2Signers.requite(sig0);
        }
    }

    private byte[] sm2Sign(P11Params params, byte[] dataToSign) throws TokenException {
        ConcurrentBagEntry sig0;
        if (params == null) {
            throw new TokenException("userId may not be null");
        }
        if (!(params instanceof P11Params.P11ByteArrayParams)) {
            throw new TokenException("params must be instanceof P11ByteArrayParams");
        }
        byte[] userId = ((P11Params.P11ByteArrayParams)params).getBytes();
        try {
            sig0 = this.sm2Signers.borrow(5000L, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException ex) {
            throw new TokenException("InterruptedException occurs while retrieving idle signature");
        }
        if (sig0 == null) {
            throw new TokenException("no idle SM2 Signer available");
        }
        try {
            EmulatorSM2Signer sig = (EmulatorSM2Signer)sig0.value();
            byte[] x962Signature = sig.generateSignatureForMessage(userId, dataToSign);
            byte[] byArray = SignerUtil.dsaSigX962ToPlain(x962Signature, this.dsaOrderBitLen);
            return byArray;
        }
        catch (CryptoException ex) {
            throw new TokenException("CryptoException: " + ex.getMessage(), (Exception)((Object)ex));
        }
        catch (XiSecurityException ex) {
            throw new TokenException("XiSecurityException: " + ex.getMessage(), (Exception)ex);
        }
        finally {
            this.sm2Signers.requite(sig0);
        }
    }

    static {
        mgfMechHashMap.put(1L, HashAlgo.SHA1);
        mgfMechHashMap.put(5L, HashAlgo.SHA224);
        mgfMechHashMap.put(2L, HashAlgo.SHA256);
        mgfMechHashMap.put(3L, HashAlgo.SHA384);
        mgfMechHashMap.put(4L, HashAlgo.SHA512);
        mgfMechHashMap.put(6L, HashAlgo.SHA3_224);
        mgfMechHashMap.put(7L, HashAlgo.SHA3_256);
        mgfMechHashMap.put(8L, HashAlgo.SHA3_384);
        mgfMechHashMap.put(9L, HashAlgo.SHA3_512);
        mechHashMap.put(544L, HashAlgo.SHA1);
        mechHashMap.put(597L, HashAlgo.SHA224);
        mechHashMap.put(592L, HashAlgo.SHA256);
        mechHashMap.put(608L, HashAlgo.SHA384);
        mechHashMap.put(624L, HashAlgo.SHA512);
        mechHashMap.put(693L, HashAlgo.SHA3_224);
        mechHashMap.put(688L, HashAlgo.SHA3_256);
        mechHashMap.put(704L, HashAlgo.SHA3_384);
        mechHashMap.put(720L, HashAlgo.SHA3_512);
        mechHashMap.put(0xFFFFF005L, HashAlgo.SM3);
        mechHashMap.put(4162L, HashAlgo.SHA1);
        mechHashMap.put(4163L, HashAlgo.SHA224);
        mechHashMap.put(4164L, HashAlgo.SHA256);
        mechHashMap.put(4165L, HashAlgo.SHA384);
        mechHashMap.put(4166L, HashAlgo.SHA512);
        mechHashMap.put(4167L, HashAlgo.SHA3_224);
        mechHashMap.put(4168L, HashAlgo.SHA3_256);
        mechHashMap.put(4169L, HashAlgo.SHA3_384);
        mechHashMap.put(4170L, HashAlgo.SHA3_512);
        mechHashMap.put(0xFFFFF003L, HashAlgo.SM3);
        mechHashMap.put(18L, HashAlgo.SHA1);
        mechHashMap.put(19L, HashAlgo.SHA224);
        mechHashMap.put(20L, HashAlgo.SHA256);
        mechHashMap.put(21L, HashAlgo.SHA384);
        mechHashMap.put(22L, HashAlgo.SHA512);
        mechHashMap.put(24L, HashAlgo.SHA3_224);
        mechHashMap.put(25L, HashAlgo.SHA3_256);
        mechHashMap.put(26L, HashAlgo.SHA3_384);
        mechHashMap.put(27L, HashAlgo.SHA3_512);
        mechHashMap.put(6L, HashAlgo.SHA1);
        mechHashMap.put(70L, HashAlgo.SHA224);
        mechHashMap.put(64L, HashAlgo.SHA256);
        mechHashMap.put(65L, HashAlgo.SHA384);
        mechHashMap.put(66L, HashAlgo.SHA512);
        mechHashMap.put(102L, HashAlgo.SHA3_224);
        mechHashMap.put(96L, HashAlgo.SHA3_256);
        mechHashMap.put(97L, HashAlgo.SHA3_384);
        mechHashMap.put(98L, HashAlgo.SHA3_512);
        mechHashMap.put(14L, HashAlgo.SHA1);
        mechHashMap.put(71L, HashAlgo.SHA224);
        mechHashMap.put(67L, HashAlgo.SHA256);
        mechHashMap.put(68L, HashAlgo.SHA384);
        mechHashMap.put(69L, HashAlgo.SHA512);
        mechHashMap.put(103L, HashAlgo.SHA3_224);
        mechHashMap.put(99L, HashAlgo.SHA3_256);
        mechHashMap.put(100L, HashAlgo.SHA3_384);
        mechHashMap.put(101L, HashAlgo.SHA3_512);
        mechHashMap.put(545L, HashAlgo.SHA1);
        mechHashMap.put(598L, HashAlgo.SHA224);
        mechHashMap.put(593L, HashAlgo.SHA256);
        mechHashMap.put(609L, HashAlgo.SHA384);
        mechHashMap.put(625L, HashAlgo.SHA512);
        mechHashMap.put(694L, HashAlgo.SHA224);
        mechHashMap.put(689L, HashAlgo.SHA256);
        mechHashMap.put(705L, HashAlgo.SHA384);
        mechHashMap.put(721L, HashAlgo.SHA512);
    }
}

