/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.security.util;

import java.security.SecureRandom;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.bouncycastle.crypto.Xof;
import org.xipki.security.HashAlgo;
import org.xipki.security.XiSecurityException;
import org.xipki.util.Args;
import org.xipki.util.Hex;

public class PKCS1Util {
    private static final Map<HashAlgo, byte[]> digestPkcsPrefix = new HashMap<HashAlgo, byte[]>();

    private static void addDigestPkcsPrefix(HashAlgo algo, String prefix) {
        digestPkcsPrefix.put(algo, Hex.decode((String)prefix));
    }

    public static byte[] EMSA_PKCS1_v1_5_encoding(byte[] hashValue, int modulusBigLength, HashAlgo hashAlgo) throws XiSecurityException {
        Args.notNull((Object)hashValue, (String)"hashValue");
        Args.notNull((Object)((Object)hashAlgo), (String)"hashAlgo");
        int hashLen = hashAlgo.getLength();
        Args.range((int)hashValue.length, (String)"hashValue.length", (int)hashLen, (int)hashLen);
        int blockSize = (modulusBigLength + 7) / 8;
        byte[] prefix = digestPkcsPrefix.get((Object)hashAlgo);
        if (prefix.length + hashLen + 3 > blockSize) {
            throw new XiSecurityException("data too long (maximal " + (blockSize - 3) + " allowed): " + (prefix.length + hashLen));
        }
        byte[] block = new byte[blockSize];
        block[0] = 0;
        block[1] = 1;
        int offset = 2;
        while (offset < block.length - prefix.length - hashLen - 1) {
            block[offset++] = -1;
        }
        block[offset++] = 0;
        System.arraycopy(prefix, 0, block, offset, prefix.length);
        System.arraycopy(hashValue, 0, block, offset += prefix.length, hashValue.length);
        return block;
    }

    public static byte[] EMSA_PKCS1_v1_5_encoding(byte[] encodedDigestInfo, int modulusBigLength) throws XiSecurityException {
        Args.notNull((Object)encodedDigestInfo, (String)"encodedDigestInfo");
        int msgLen = encodedDigestInfo.length;
        int blockSize = (modulusBigLength + 7) / 8;
        if (msgLen + 3 > blockSize) {
            throw new XiSecurityException("data too long (maximal " + (blockSize - 3) + " allowed): " + msgLen);
        }
        byte[] block = new byte[blockSize];
        block[0] = 0;
        block[1] = 1;
        int offset = 2;
        while (offset < block.length - msgLen - 1) {
            block[offset++] = -1;
        }
        block[offset++] = 0;
        System.arraycopy(encodedDigestInfo, 0, block, offset, encodedDigestInfo.length);
        return block;
    }

    public static byte[] EMSA_PSS_ENCODE(HashAlgo contentDigest, byte[] hashValue, HashAlgo mgfDigest, int saltLen, int modulusBitLength, SecureRandom random) throws XiSecurityException {
        byte[] dbMask;
        if (contentDigest.isShake()) {
            if (mgfDigest != contentDigest) {
                throw new XiSecurityException("contentDigest != mgfDigest");
            }
            if (saltLen != contentDigest.getLength()) {
                throw new XiSecurityException("saltLen != " + contentDigest.getLength() + ": " + saltLen);
            }
        }
        int hLen = contentDigest.getLength();
        byte[] salt = new byte[saltLen];
        byte[] mDash = new byte[8 + saltLen + hLen];
        int trailer = -68;
        if (hashValue.length != hLen) {
            throw new XiSecurityException("hashValue.length is incorrect: " + hashValue.length + " != " + hLen);
        }
        int emBits = modulusBitLength - 1;
        if (emBits < 8 * hLen + 8 * saltLen + 9) {
            throw new IllegalArgumentException("key too small for specified hash and salt lengths");
        }
        System.arraycopy(hashValue, 0, mDash, mDash.length - hLen - saltLen, hLen);
        random.nextBytes(salt);
        System.arraycopy(salt, 0, mDash, mDash.length - saltLen, saltLen);
        byte[] hv = contentDigest.hash(new byte[][]{mDash});
        byte[] block = new byte[(emBits + 7) / 8];
        block[block.length - saltLen - 1 - hLen - 1] = 1;
        System.arraycopy(salt, 0, block, block.length - saltLen - hLen - 1, saltLen);
        int dbMaskLen = block.length - hLen - 1;
        if (contentDigest.isShake()) {
            Xof xof = (Xof)contentDigest.createDigest();
            xof.update(hv, 0, hv.length);
            dbMask = new byte[dbMaskLen];
            xof.doFinal(dbMask, 0, dbMaskLen);
        } else {
            dbMask = PKCS1Util.mgf1(mgfDigest, hv, dbMaskLen);
        }
        for (int i = 0; i != dbMask.length; ++i) {
            int n = i;
            block[n] = (byte)(block[n] ^ dbMask[i]);
        }
        block[0] = (byte)(block[0] & 255 >> block.length * 8 - emBits);
        System.arraycopy(hv, 0, block, block.length - hLen - 1, hLen);
        block[block.length - 1] = -68;
        return block;
    }

    public static byte[] getDigestPkcsPrefix(HashAlgo hashAlgo) {
        byte[] bytes = digestPkcsPrefix.get((Object)hashAlgo);
        return bytes == null ? null : Arrays.copyOf(bytes, bytes.length);
    }

    public static byte[] RSAES_OAEP_ENCODE(byte[] M, int modulusBigLength, HashAlgo hashAlgo, SecureRandom random) {
        int mLen = M.length;
        int k = (modulusBigLength + 7) / 8;
        int hLen = hashAlgo.getLength();
        if (mLen > k - 2 * hLen - 2) {
            throw new IllegalArgumentException("message too long");
        }
        byte[] lHash = hashAlgo.hash(new byte[][]{new byte[0]});
        byte[] PS = new byte[k - mLen - 2 * hLen - 2];
        byte[] DB = PKCS1Util.concat(lHash, PS, {1}, M);
        byte[] seed = new byte[hLen];
        random.nextBytes(seed);
        byte[] dbMask = PKCS1Util.mgf1(hashAlgo, seed, k - hLen - 1);
        byte[] maskedDB = PKCS1Util.xor(DB, dbMask);
        byte[] seedMask = PKCS1Util.mgf1(hashAlgo, maskedDB, hLen);
        byte[] maskedSeed = PKCS1Util.xor(seed, seedMask);
        return PKCS1Util.concat({0}, maskedSeed, maskedDB);
    }

    public static byte[] RSAES_OAEP_DECODE(byte[] EM, int modulusBigLength, HashAlgo hashAlgo) {
        int mOffset;
        int k = (modulusBigLength + 7) / 8;
        if (EM.length != k) {
            throw new IllegalArgumentException("EM.length != k");
        }
        int hLen = hashAlgo.getLength();
        if (EM[0] != 0) {
            throw new IllegalArgumentException("decryption error");
        }
        byte[] maskedSeed = Arrays.copyOfRange(EM, 1, 1 + hLen);
        byte[] maskedDB = Arrays.copyOfRange(EM, 1 + hLen, k);
        byte[] seedMask = PKCS1Util.mgf1(hashAlgo, maskedDB, hLen);
        byte[] seed = PKCS1Util.xor(maskedSeed, seedMask);
        byte[] dbMask = PKCS1Util.mgf1(hashAlgo, seed, k - hLen - 1);
        byte[] DB = PKCS1Util.xor(maskedDB, dbMask);
        byte[] lHash = hashAlgo.hash(new byte[][]{new byte[0]});
        for (int i = 0; i < hLen; ++i) {
            if (lHash[i] == DB[i]) continue;
            throw new IllegalArgumentException("decryption error");
        }
        for (mOffset = hLen; mOffset < DB.length && DB[mOffset] != 1; ++mOffset) {
            if (DB[mOffset] == 0) continue;
            throw new IllegalArgumentException("decryption error");
        }
        if (++mOffset >= DB.length) {
            throw new IllegalArgumentException("decryption error");
        }
        return Arrays.copyOfRange(DB, mOffset, DB.length);
    }

    private static byte[] mgf1(HashAlgo mgfDigest, byte[] Z, int length) {
        byte[] hashBuf;
        int counter;
        int mgfhLen = mgfDigest.getLength();
        byte[] mask = new byte[length];
        byte[] all = new byte[Z.length + 4];
        System.arraycopy(Z, 0, all, 0, Z.length);
        for (counter = 0; counter < length / mgfhLen; ++counter) {
            PKCS1Util.ItoOSP(counter, all, Z.length);
            hashBuf = mgfDigest.hash(new byte[][]{all});
            System.arraycopy(hashBuf, 0, mask, counter * mgfhLen, mgfhLen);
        }
        if (counter * mgfhLen < length) {
            PKCS1Util.ItoOSP(counter, all, Z.length);
            hashBuf = mgfDigest.hash(new byte[][]{all});
            int offset = counter * mgfhLen;
            System.arraycopy(hashBuf, 0, mask, offset, mask.length - offset);
        }
        return mask;
    }

    private static void ItoOSP(int i, byte[] sp, int spOffset) {
        sp[spOffset] = (byte)(i >>> 24);
        sp[spOffset + 1] = (byte)(i >>> 16);
        sp[spOffset + 2] = (byte)(i >>> 8);
        sp[spOffset + 3] = (byte)i;
    }

    private static byte[] xor(byte[] a, byte[] b) {
        if (a.length != b.length) {
            throw new IllegalArgumentException("a.length != b.length");
        }
        byte[] rv = new byte[a.length];
        for (int i = 0; i < a.length; ++i) {
            rv[i] = (byte)(a[i] ^ b[i]);
        }
        return rv;
    }

    private static byte[] concat(byte[] ... byteArrays) {
        int len = 0;
        for (byte[] ba : byteArrays) {
            len += ba.length;
        }
        byte[] rv = new byte[len];
        int offset = 0;
        for (byte[] ba : byteArrays) {
            System.arraycopy(ba, 0, rv, offset, ba.length);
            offset += ba.length;
        }
        return rv;
    }

    static {
        PKCS1Util.addDigestPkcsPrefix(HashAlgo.SHA1, "3021300906052b0e03021a05000414");
        PKCS1Util.addDigestPkcsPrefix(HashAlgo.SHA224, "302d300d06096086480165030402040500041c");
        PKCS1Util.addDigestPkcsPrefix(HashAlgo.SHA256, "3031300d060960864801650304020105000420");
        PKCS1Util.addDigestPkcsPrefix(HashAlgo.SHA384, "3041300d060960864801650304020205000430");
        PKCS1Util.addDigestPkcsPrefix(HashAlgo.SHA512, "3051300d060960864801650304020305000440");
        PKCS1Util.addDigestPkcsPrefix(HashAlgo.SHA3_224, "302d300d06096086480165030402070500041c");
        PKCS1Util.addDigestPkcsPrefix(HashAlgo.SHA3_256, "3031300d060960864801650304020805000420");
        PKCS1Util.addDigestPkcsPrefix(HashAlgo.SHA3_384, "3041300d060960864801650304020905000430");
        PKCS1Util.addDigestPkcsPrefix(HashAlgo.SHA3_512, "3051300d060960864801650304020a05000440");
    }
}

