/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.security;

import java.time.Instant;
import org.xipki.security.CrlReason;
import org.xipki.util.Args;
import org.xipki.util.CompareUtil;
import org.xipki.util.ConfPairs;
import org.xipki.util.StringUtil;

public class CertRevocationInfo {
    private CrlReason reason;
    private Instant revocationTime;
    private Instant invalidityTime;

    private CertRevocationInfo() {
    }

    public CertRevocationInfo(CrlReason reason) {
        this(reason, Instant.now(), null);
    }

    public CertRevocationInfo(CrlReason reason, Instant revocationTime) {
        this(reason, revocationTime, null);
    }

    public CertRevocationInfo(CrlReason reason, Instant revocationTime, Instant invalidityTime) {
        this.reason = (CrlReason)((Object)Args.notNull((Object)((Object)reason), (String)"reason"));
        this.revocationTime = (Instant)Args.notNull((Object)revocationTime, (String)"revocationTime");
        this.invalidityTime = invalidityTime;
    }

    public CertRevocationInfo(int reasonCode) {
        this(reasonCode, Instant.now(), null);
    }

    public CertRevocationInfo(int reasonCode, Instant revocationTime) {
        this(reasonCode, revocationTime, null);
    }

    public CertRevocationInfo(int reasonCode, Instant revocationTime, Instant invalidityTime) {
        this.revocationTime = (Instant)Args.notNull((Object)revocationTime, (String)"revocationTime");
        this.reason = CrlReason.forReasonCode(reasonCode);
        this.invalidityTime = invalidityTime;
    }

    public void setReason(CrlReason reason) {
        this.reason = (CrlReason)((Object)Args.notNull((Object)((Object)reason), (String)"reason"));
    }

    public CrlReason getReason() {
        return this.reason;
    }

    public void setRevocationTime(Instant revocationTime) {
        this.revocationTime = (Instant)Args.notNull((Object)revocationTime, (String)"revocationTime");
    }

    public Instant getRevocationTime() {
        if (this.revocationTime == null) {
            this.revocationTime = Instant.now();
        }
        return this.revocationTime;
    }

    public Instant getInvalidityTime() {
        return this.invalidityTime;
    }

    public void setInvalidityTime(Instant invalidityTime) {
        this.invalidityTime = invalidityTime;
    }

    public String toString() {
        return StringUtil.concatObjects((Object)"reason: ", (Object[])new Object[]{this.reason, "\nrevocationTime: ", this.revocationTime, "\ninvalidityTime: ", this.invalidityTime});
    }

    public static CertRevocationInfo fromEncoded(String encoded) {
        ConfPairs pairs = new ConfPairs(encoded);
        CrlReason reason = CrlReason.forNameOrText(pairs.value("reason"));
        Instant revocationTime = Instant.ofEpochSecond(Long.parseLong(pairs.value("revocationTime")));
        String str = pairs.value("invalidityTime");
        Instant invalidityTime = null;
        if (str != null) {
            invalidityTime = Instant.ofEpochSecond(Long.parseLong(pairs.value("invalidityTime")));
        }
        return new CertRevocationInfo(reason, revocationTime, invalidityTime);
    }

    public String getEncoded() {
        ConfPairs pairs = new ConfPairs().putPair("reason", this.reason.getDescription()).putPair("revocationTime", Long.toString(this.revocationTime.getEpochSecond()));
        if (this.invalidityTime != null) {
            pairs.putPair("invalidityTime", Long.toString(this.invalidityTime.getEpochSecond()));
        }
        return pairs.getEncoded();
    }

    public int hashCode() {
        return this.reason.hashCode() + 31 * this.revocationTime.hashCode() + (this.invalidityTime == null ? 0 : 961 * this.invalidityTime.hashCode());
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof CertRevocationInfo)) {
            return false;
        }
        CertRevocationInfo other = (CertRevocationInfo)obj;
        return this.reason == other.reason && CompareUtil.equalsObject((Object)this.revocationTime, (Object)other.revocationTime) && CompareUtil.equalsObject((Object)this.invalidityTime, (Object)other.invalidityTime);
    }
}

