/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.security;

import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xipki.security.AlgorithmValidator;
import org.xipki.security.HashAlgo;
import org.xipki.security.SignAlgo;
import org.xipki.util.Args;

public class CollectionAlgorithmValidator
implements AlgorithmValidator {
    private static final Logger LOG = LoggerFactory.getLogger(CollectionAlgorithmValidator.class);
    public static final CollectionAlgorithmValidator INSTANCE;
    private final Set<SignAlgo> algos;
    private final Set<String> algoNames;

    public static CollectionAlgorithmValidator buildAlgorithmValidator(Collection<String> algoNames) throws NoSuchAlgorithmException {
        HashSet<SignAlgo> algos = new HashSet<SignAlgo>();
        for (String algoName : algoNames) {
            SignAlgo sa;
            try {
                sa = SignAlgo.getInstance(algoName);
            }
            catch (NoSuchAlgorithmException ex) {
                LOG.warn("algorithm is not supported {}, ignore it", (Object)algoName);
                continue;
            }
            algos.add(sa);
        }
        if (algos.isEmpty()) {
            throw new NoSuchAlgorithmException("none of the signature algorithms " + algoNames + " are supported");
        }
        return new CollectionAlgorithmValidator(algos);
    }

    public CollectionAlgorithmValidator(Collection<SignAlgo> algos) {
        this.algos = Collections.unmodifiableSet(new HashSet<SignAlgo>(algos));
        HashSet<String> names = new HashSet<String>();
        for (SignAlgo m : algos) {
            names.add(m.getJceName());
        }
        this.algoNames = Collections.unmodifiableSet(names);
    }

    public Set<SignAlgo> getAlgos() {
        return this.algos;
    }

    public Set<String> getAlgoNames() {
        return this.algoNames;
    }

    @Override
    public boolean isAlgorithmPermitted(AlgorithmIdentifier algId) {
        SignAlgo algo;
        Args.notNull((Object)algId, (String)"algId");
        if (this.algos.isEmpty()) {
            return true;
        }
        try {
            algo = SignAlgo.getInstance(algId);
        }
        catch (NoSuchAlgorithmException ex) {
            return false;
        }
        return this.algos.contains((Object)algo);
    }

    @Override
    public boolean isAlgorithmPermitted(SignAlgo algo) {
        return this.algos.contains(Args.notNull((Object)((Object)algo), (String)"algo"));
    }

    static {
        ArrayList<SignAlgo> secureAlgos = new ArrayList<SignAlgo>(SignAlgo.values().length);
        for (SignAlgo m : SignAlgo.values()) {
            if (m.getHashAlgo() == HashAlgo.SHA1) continue;
            secureAlgos.add(m);
        }
        INSTANCE = new CollectionAlgorithmValidator(secureAlgos);
    }
}

