/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.security;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.security.spec.InvalidKeySpecException;
import java.time.Instant;
import java.util.Arrays;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x509.AuthorityKeyIdentifier;
import org.bouncycastle.asn1.x509.BasicConstraints;
import org.bouncycastle.asn1.x509.Certificate;
import org.bouncycastle.asn1.x509.Extension;
import org.bouncycastle.asn1.x509.Extensions;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.cert.X509CertificateHolder;
import org.xipki.security.KeyUsage;
import org.xipki.security.SignAlgo;
import org.xipki.security.util.KeyUtil;
import org.xipki.security.util.X509Util;
import org.xipki.util.Args;
import org.xipki.util.Hex;

public class X509Cert {
    private final Object sync = new Object();
    private X509CertificateHolder bcInstance;
    private X509Certificate jceInstance;
    private final boolean selfSigned;
    private final X500Name issuer;
    private final BigInteger serialNumber;
    private final X500Name subject;
    private final Instant notBefore;
    private final Instant notAfter;
    private String issuerText;
    private String subjectText;
    private byte[] subjectKeyId;
    private byte[] authorityKeyId;
    private int basicConstraints = -2;
    private boolean keyUsageProcessed;
    private boolean[] keyUsage;
    private boolean sanProcessed;
    private byte[] san;
    private SubjectPublicKeyInfo subjectPublicKeyInfo;
    private PublicKey publicKey;
    private byte[] encoded;

    public X509Cert(Certificate cert) {
        this(new X509CertificateHolder(cert), null);
    }

    public X509Cert(Certificate cert, byte[] encoded) {
        this(new X509CertificateHolder(cert), encoded);
    }

    public X509Cert(X509Certificate cert) {
        this(cert, null);
    }

    public X509Cert(X509Certificate cert, byte[] encoded) {
        this.bcInstance = null;
        this.jceInstance = (X509Certificate)Args.notNull((Object)cert, (String)"cert");
        this.encoded = encoded;
        this.notBefore = cert.getNotBefore().toInstant();
        this.notAfter = cert.getNotAfter().toInstant();
        this.serialNumber = cert.getSerialNumber();
        this.issuer = X500Name.getInstance((Object)cert.getIssuerX500Principal().getEncoded());
        this.subject = X500Name.getInstance((Object)cert.getSubjectX500Principal().getEncoded());
        this.selfSigned = this.subject.equals((Object)this.issuer);
        byte[] bytes = cert.getExtensionValue(Extension.subjectAlternativeName.getId());
        this.san = bytes == null ? null : ASN1OctetString.getInstance((Object)bytes).getOctets();
    }

    public X509Cert(X509CertificateHolder cert) {
        this(cert, null);
    }

    public X509Cert(X509CertificateHolder cert, byte[] encoded) {
        this.bcInstance = (X509CertificateHolder)Args.notNull((Object)cert, (String)"cert");
        this.jceInstance = null;
        this.encoded = encoded;
        this.notBefore = cert.getNotBefore().toInstant();
        this.notAfter = cert.getNotAfter().toInstant();
        this.serialNumber = cert.getSerialNumber();
        this.issuer = cert.getIssuer();
        this.subject = cert.getSubject();
        this.selfSigned = this.subject.equals((Object)this.issuer);
        this.san = X509Util.getCoreExtValue(cert.getExtensions(), Extension.subjectAlternativeName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getBasicConstraints() {
        if (this.basicConstraints == -2) {
            Object object = this.sync;
            synchronized (object) {
                BigInteger bn;
                BasicConstraints bc;
                byte[] extnValue;
                this.basicConstraints = this.bcInstance != null ? ((extnValue = this.getCoreExtValue(Extension.basicConstraints)) == null ? -1 : ((bc = BasicConstraints.getInstance((Object)extnValue)).isCA() ? ((bn = bc.getPathLenConstraint()) == null ? Integer.MAX_VALUE : bn.intValueExact()) : -1)) : this.jceInstance.getBasicConstraints();
            }
        }
        return this.basicConstraints;
    }

    public BigInteger getSerialNumber() {
        return this.serialNumber;
    }

    public String getSerialNumberHex() {
        return "0x" + Hex.encode((byte[])this.serialNumber.toByteArray());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PublicKey getPublicKey() {
        if (this.publicKey == null) {
            Object object = this.sync;
            synchronized (object) {
                if (this.bcInstance != null) {
                    try {
                        this.publicKey = KeyUtil.generatePublicKey(this.bcInstance.getSubjectPublicKeyInfo());
                    }
                    catch (InvalidKeySpecException ex) {
                        throw new IllegalStateException(ex.getMessage(), ex);
                    }
                } else {
                    this.publicKey = this.jceInstance.getPublicKey();
                }
            }
        }
        return this.publicKey;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean[] getKeyUsage() {
        if (!this.keyUsageProcessed) {
            Object object = this.sync;
            synchronized (object) {
                if (this.bcInstance != null) {
                    byte[] extnValue = this.getCoreExtValue(Extension.keyUsage);
                    if (extnValue == null) {
                        this.keyUsage = null;
                    } else {
                        org.bouncycastle.asn1.x509.KeyUsage bc = org.bouncycastle.asn1.x509.KeyUsage.getInstance((Object)extnValue);
                        this.keyUsage = new boolean[9];
                        for (KeyUsage ku : KeyUsage.values()) {
                            this.keyUsage[ku.getBit()] = bc.hasUsages(ku.getBcUsage());
                        }
                    }
                } else {
                    this.keyUsage = this.jceInstance.getKeyUsage();
                }
            }
            this.keyUsageProcessed = true;
        }
        return this.keyUsage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getSubjectAltNames() {
        if (!this.sanProcessed) {
            Object object = this.sync;
            synchronized (object) {
                this.san = this.getCoreExtValue(Extension.subjectAlternativeName);
                this.sanProcessed = true;
            }
        }
        return this.san == null ? null : (byte[])this.san.clone();
    }

    public X500Name getIssuer() {
        return this.issuer;
    }

    public X500Name getSubject() {
        return this.subject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getSubjectKeyId() {
        if (this.subjectKeyId == null) {
            Object object = this.sync;
            synchronized (object) {
                byte[] extnValue = this.getCoreExtValue(Extension.subjectKeyIdentifier);
                if (extnValue != null) {
                    this.subjectKeyId = ASN1OctetString.getInstance((Object)extnValue).getOctets();
                }
            }
        }
        return this.subjectKeyId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getAuthorityKeyId() {
        if (this.authorityKeyId == null) {
            Object object = this.sync;
            synchronized (object) {
                byte[] extnValue = this.getCoreExtValue(Extension.authorityKeyIdentifier);
                if (extnValue != null) {
                    this.authorityKeyId = AuthorityKeyIdentifier.getInstance((Object)extnValue).getKeyIdentifier();
                }
            }
        }
        return this.authorityKeyId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getSubjectText() {
        if (this.subjectText == null) {
            Object object = this.sync;
            synchronized (object) {
                this.subjectText = X509Util.x500NameText(this.subject);
            }
        }
        return this.subjectText;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getIssuerText() {
        if (this.issuerText == null) {
            Object object = this.sync;
            synchronized (object) {
                this.issuerText = X509Util.x500NameText(this.subject);
            }
        }
        return this.issuerText;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SubjectPublicKeyInfo getSubjectPublicKeyInfo() {
        if (this.subjectPublicKeyInfo == null) {
            Object object = this.sync;
            synchronized (object) {
                if (this.bcInstance != null) {
                    this.subjectPublicKeyInfo = this.bcInstance.getSubjectPublicKeyInfo();
                } else {
                    try {
                        this.subjectPublicKeyInfo = KeyUtil.createSubjectPublicKeyInfo(this.jceInstance.getPublicKey());
                    }
                    catch (InvalidKeyException ex) {
                        throw new IllegalStateException("error creating SubjectPublicKeyInfo from PublicKey", ex);
                    }
                }
            }
        }
        return this.subjectPublicKeyInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public X509Certificate toJceCert() {
        if (this.jceInstance == null) {
            Object object = this.sync;
            synchronized (object) {
                this.encoded = this.getEncoded();
                try {
                    this.jceInstance = X509Util.parseX509Certificate(new ByteArrayInputStream(this.encoded));
                }
                catch (CertificateException ex) {
                    throw new IllegalStateException("error converting to X509Certificate", ex);
                }
            }
        }
        return this.jceInstance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public X509CertificateHolder toBcCert() {
        if (this.bcInstance == null) {
            Object object = this.sync;
            synchronized (object) {
                try {
                    this.encoded = this.jceInstance.getEncoded();
                    this.bcInstance = new X509CertificateHolder(this.encoded);
                }
                catch (IOException | CertificateEncodingException ex) {
                    throw new IllegalStateException("error encoding certificate", ex);
                }
            }
        }
        return this.bcInstance;
    }

    public boolean isSelfSigned() {
        return this.selfSigned;
    }

    public Instant getNotBefore() {
        return this.notBefore;
    }

    public Instant getNotAfter() {
        return this.notAfter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getEncoded() {
        if (this.encoded == null) {
            Object object = this.sync;
            synchronized (object) {
                try {
                    this.encoded = this.bcInstance != null ? this.bcInstance.getEncoded() : this.jceInstance.getEncoded();
                }
                catch (IOException | CertificateEncodingException ex) {
                    throw new IllegalStateException("error encoding certificate", ex);
                }
            }
        }
        return this.encoded;
    }

    public String getCommonName() {
        return X509Util.getCommonName(this.subject);
    }

    public void verify(PublicKey key) throws SignatureException, InvalidKeyException, CertificateException, NoSuchAlgorithmException, NoSuchProviderException {
        if (this.jceInstance != null) {
            this.jceInstance.verify(key, "BC");
        } else {
            SignAlgo signAlgo = SignAlgo.getInstance(this.bcInstance.getSignatureAlgorithm());
            if (signAlgo == null) {
                throw new NoSuchAlgorithmException("could not detect SignAlgo");
            }
            Signature signature = signAlgo.newSignature("BC");
            this.checkBcSignature(key, signature);
        }
    }

    public void verify(PublicKey key, String sigProvider) throws CertificateException, NoSuchAlgorithmException, InvalidKeyException, SignatureException, NoSuchProviderException {
        if (sigProvider == null) {
            this.verify(key);
        } else if (this.jceInstance != null) {
            this.jceInstance.verify(key, sigProvider);
        } else {
            SignAlgo signAlgo = SignAlgo.getInstance(this.bcInstance.getSignatureAlgorithm());
            if (signAlgo == null) {
                throw new NoSuchAlgorithmException("could not detect SignAlgo");
            }
            Signature signature = signAlgo.newSignature(sigProvider);
            this.checkBcSignature(key, signature);
        }
    }

    private void checkBcSignature(PublicKey key, Signature signature) throws CertificateException, SignatureException, InvalidKeyException {
        Certificate c = this.bcInstance.toASN1Structure();
        if (!c.getSignatureAlgorithm().equals((Object)c.getTBSCertificate().getSignature())) {
            throw new CertificateException("signature algorithm in TBS cert not same as outer cert");
        }
        signature.initVerify(key);
        try {
            signature.update(c.getTBSCertificate().getEncoded());
        }
        catch (IOException ex) {
            throw new CertificateException("error encoding TBSCertificate");
        }
        if (!signature.verify(c.getSignature().getBytes())) {
            throw new SignatureException("certificate does not verify with supplied key");
        }
    }

    public byte[] getExtensionCoreValue(ASN1ObjectIdentifier extnType) {
        if (this.bcInstance != null) {
            Extension extn = this.bcInstance.getExtensions().getExtension(extnType);
            return extn == null ? null : extn.getExtnValue().getOctets();
        }
        byte[] rawValue = this.jceInstance.getExtensionValue(extnType.getId());
        return rawValue == null ? null : ASN1OctetString.getInstance((Object)rawValue).getOctets();
    }

    public boolean hasKeyusage(KeyUsage usage) {
        boolean[] usages = this.getKeyUsage();
        return usages == null || usages[usage.getBit()];
    }

    public int hashCode() {
        return Arrays.hashCode(this.getEncoded());
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof X509Cert)) {
            return false;
        }
        return Arrays.equals(this.getEncoded(), ((X509Cert)obj).getEncoded());
    }

    private byte[] getCoreExtValue(ASN1ObjectIdentifier extnType) {
        if (this.bcInstance != null) {
            Extensions extns = this.bcInstance.getExtensions();
            if (extns == null) {
                return null;
            }
            Extension extn = extns.getExtension(extnType);
            return extn == null ? null : extn.getExtnValue().getOctets();
        }
        byte[] rawValue = this.jceInstance.getExtensionValue(extnType.getId());
        return rawValue == null ? null : ASN1OctetString.getInstance((Object)rawValue).getOctets();
    }
}

