/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.security.pkcs11;

import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xipki.password.PasswordResolverException;
import org.xipki.pkcs11.wrapper.ModuleInfo;
import org.xipki.pkcs11.wrapper.PKCS11Exception;
import org.xipki.pkcs11.wrapper.PKCS11Module;
import org.xipki.pkcs11.wrapper.PKCS11Token;
import org.xipki.pkcs11.wrapper.Slot;
import org.xipki.pkcs11.wrapper.SlotInfo;
import org.xipki.pkcs11.wrapper.TokenException;
import org.xipki.pkcs11.wrapper.TokenInfo;
import org.xipki.security.pkcs11.NativeP11Slot;
import org.xipki.security.pkcs11.P11Module;
import org.xipki.security.pkcs11.P11ModuleConf;
import org.xipki.security.pkcs11.P11Slot;
import org.xipki.security.pkcs11.P11SlotId;
import org.xipki.util.Args;
import org.xipki.util.IoUtil;
import org.xipki.util.LogUtil;
import org.xipki.util.StringUtil;

public class NativeP11Module
extends P11Module {
    public static final String TYPE = "native";
    private static final Logger LOG = LoggerFactory.getLogger(NativeP11Module.class);
    private final PKCS11Module module;
    private String description;

    private NativeP11Module(PKCS11Module module, P11ModuleConf moduleConf) throws TokenException {
        super(moduleConf);
        int size;
        Slot[] slotList;
        this.module = (PKCS11Module)Args.notNull((Object)module, (String)"module");
        try {
            ModuleInfo info = module.getInfo();
            this.description = StringUtil.concatObjects((Object)"PKCS#11 wrapper", (Object[])new Object[]{"\n\tPath: ", moduleConf.getNativeLibrary(), "\n\tCryptoki Version: ", info.getCryptokiVersion(), "\n\tManufacturerID: ", info.getManufacturerID(), "\n\tLibrary Description: ", info.getLibraryDescription(), "\n\tLibrary Version: ", info.getLibraryVersion()});
        }
        catch (TokenException ex) {
            this.description = StringUtil.concatObjects((Object)"PKCS#11 wrapper", (Object[])new Object[]{"\n\tPath ", moduleConf.getNativeLibrary()});
        }
        LOG.info("PKCS#11 module\n{}", (Object)this.description);
        try {
            slotList = module.getSlotList(false);
        }
        catch (Throwable th) {
            String msg = "could not getSlotList of module " + moduleConf.getName();
            LogUtil.error((Logger)LOG, (Throwable)th, (String)msg);
            throw new TokenException(msg);
        }
        int n = size = slotList == null ? 0 : slotList.length;
        if (size == 0) {
            throw new TokenException("no slot could be found");
        }
        for (int i = 0; i < size; ++i) {
            SlotInfo slotInfo;
            Slot slot = slotList[i];
            try {
                slotInfo = slot.getSlotInfo();
            }
            catch (TokenException ex) {
                LOG.error("ignore slot[{}] (id={} with error", (Object)i, (Object)slot.getSlotID());
                slotList[i] = null;
                continue;
            }
            if (slotInfo.isTokenPresent()) continue;
            slotList[i] = null;
            LOG.info("ignore slot[{}] (id={} without token", (Object)i, (Object)slot.getSlotID());
        }
        StringBuilder msg = new StringBuilder();
        HashSet<P11Slot> slots = new HashSet<P11Slot>();
        for (int i = 0; i < slotList.length; ++i) {
            List<char[]> pwd;
            Slot slot = slotList[i];
            if (slot == null) continue;
            P11SlotId slotId = new P11SlotId(i, slot.getSlotID());
            if (!moduleConf.isSlotIncluded(slotId)) {
                LOG.info("skipped slot {}", (Object)slotId);
                continue;
            }
            TokenInfo ti = slot.getToken().getTokenInfo();
            if (!ti.isTokenInitialized()) {
                LOG.info("slot {} not initialized, skipped it.", (Object)slotId);
                continue;
            }
            if (LOG.isDebugEnabled()) {
                msg.append("--------------------Slot ").append(i).append("--------------------\n");
                msg.append("id: ").append(slot.getSlotID()).append("\n");
                try {
                    msg.append(slot.getSlotInfo()).append("\n");
                }
                catch (TokenException ex) {
                    msg.append("error: ").append(ex.getMessage());
                }
            }
            try {
                pwd = moduleConf.getPasswordRetriever().getPassword(slotId);
            }
            catch (PasswordResolverException ex) {
                throw new TokenException("PasswordResolverException: " + ex.getMessage(), (Exception)((Object)ex));
            }
            PKCS11Token token = new PKCS11Token(slot.getToken(), moduleConf.isReadOnly(), moduleConf.getUserType(), moduleConf.getUserName(), pwd, moduleConf.getNumSessions());
            token.setMaxMessageSize(moduleConf.getMaxMessageSize());
            NativeP11Slot p11Slot = new NativeP11Slot(moduleConf.getName(), slotId, token, moduleConf.getP11MechanismFilter(), moduleConf.getP11NewObjectConf(), moduleConf.getSecretKeyTypes(), moduleConf.getKeyPairTypes());
            slots.add(p11Slot);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("{}", (Object)msg);
        }
        this.setSlots(slots);
    }

    public static P11Module getInstance(P11ModuleConf moduleConf) throws TokenException {
        PKCS11Module module;
        Args.notNull((Object)moduleConf, (String)"moduleConf");
        long userType = moduleConf.getUserType();
        if (userType == 0L) {
            throw new TokenException("CKU_SO is not allowed in P11Module, too dangerous.");
        }
        String path = moduleConf.getNativeLibrary();
        path = IoUtil.expandFilepath((String)path, (boolean)false);
        try {
            module = PKCS11Module.getInstance((String)path);
        }
        catch (IOException ex) {
            String msg = "could not load the PKCS#11 module " + moduleConf.getName() + ": " + path;
            LogUtil.error((Logger)LOG, (Throwable)ex, (String)msg);
            throw new TokenException(msg, (Exception)ex);
        }
        try {
            module.initialize();
        }
        catch (PKCS11Exception ex) {
            if (ex.getErrorCode() != 401L) {
                LogUtil.error((Logger)LOG, (Throwable)ex);
                NativeP11Module.close(moduleConf.getName(), module);
                throw ex;
            }
            LOG.info("PKCS#11 module already initialized");
            try {
                LOG.info("pkcs11.getInfo():\n{}", (Object)module.getInfo());
            }
            catch (TokenException e2) {
                LOG.debug("module.getInfo()", (Throwable)e2);
            }
        }
        catch (Throwable th) {
            LOG.error("unexpected Exception", th);
            NativeP11Module.close(moduleConf.getName(), module);
            throw new TokenException(th.getMessage());
        }
        return new NativeP11Module(module, moduleConf);
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public void close() {
        for (P11SlotId slotId : this.getSlotIds()) {
            try {
                this.getSlot(slotId).close();
            }
            catch (Throwable th) {
                LogUtil.error((Logger)LOG, (Throwable)th, (String)("could not close PKCS#11 slot " + slotId));
            }
        }
        NativeP11Module.close(this.conf.getNativeLibrary(), this.module);
    }

    private static void close(String modulePath, PKCS11Module module) {
        if (module == null) {
            return;
        }
        LOG.info("close PKCS#11 module: {}", (Object)modulePath);
        try {
            module.finalize(null);
        }
        catch (Throwable th) {
            LogUtil.error((Logger)LOG, (Throwable)th, (String)("could not close module " + modulePath));
        }
    }
}

