/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.security.pkcs11;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentLinkedDeque;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xipki.pkcs11.wrapper.TokenException;
import org.xipki.security.pkcs11.P11Module;
import org.xipki.security.pkcs11.P11ModuleConf;
import org.xipki.security.pkcs11.P11ModuleFactory;
import org.xipki.security.pkcs11.P11ModuleFactoryRegister;
import org.xipki.util.LogUtil;

public class P11ModuleFactoryRegisterImpl
implements P11ModuleFactoryRegister {
    private static final Logger LOG = LoggerFactory.getLogger(P11ModuleFactoryRegisterImpl.class);
    private static final Map<String, P11Module> modules = new HashMap<String, P11Module>();
    private final ConcurrentLinkedDeque<P11ModuleFactory> factories = new ConcurrentLinkedDeque();

    public void registFactory(P11ModuleFactory factory) {
        if (factory == null) {
            LOG.info("registFactory invoked with null.");
            return;
        }
        boolean replaced = this.factories.remove(factory);
        this.factories.add(factory);
        String action = replaced ? "replaced" : "added";
        LOG.info("{} P11ModuleFactory binding for {}", (Object)action, (Object)factory);
    }

    public void unregistFactory(P11ModuleFactory factory) {
        if (factory == null) {
            LOG.info("unregistFactory invoked with null.");
            return;
        }
        if (this.factories.remove(factory)) {
            LOG.info("removed P11ModuleFactory binding for {}", (Object)factory);
        } else {
            LOG.info("no P11ModuleFactory binding found to remove for '{}'", (Object)factory);
        }
    }

    @Override
    public P11Module getP11Module(P11ModuleConf conf) throws TokenException {
        String type = conf.getType().toLowerCase();
        String nativeLib = conf.getNativeLibrary();
        String key = type + ":" + nativeLib;
        P11Module p11Module = modules.get(key);
        if (p11Module == null) {
            for (P11ModuleFactory service : this.factories) {
                if (!service.canCreateModule(type)) continue;
                p11Module = service.newModule(conf);
                break;
            }
            if (p11Module == null) {
                throw new TokenException("could not find Factory to create PKCS#11 module of type '" + type + "'");
            }
            modules.put(key, p11Module);
        }
        return p11Module;
    }

    @Override
    public void close() {
        for (Map.Entry<String, P11Module> entry : modules.entrySet()) {
            try {
                entry.getValue().close();
            }
            catch (Throwable th) {
                LogUtil.error((Logger)LOG, (Throwable)th, (String)("could not close PKCS11 Module " + entry.getKey()));
            }
        }
        modules.clear();
        this.factories.clear();
    }
}

