/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.security.pkcs11;

import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.spec.DSAParameterSpec;
import java.security.spec.RSAKeyGenParameterSpec;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xipki.pkcs11.wrapper.MechanismInfo;
import org.xipki.pkcs11.wrapper.PKCS11Constants;
import org.xipki.pkcs11.wrapper.PKCS11KeyId;
import org.xipki.pkcs11.wrapper.TokenException;
import org.xipki.security.EdECConstants;
import org.xipki.security.pkcs11.P11Key;
import org.xipki.security.pkcs11.P11ModuleConf;
import org.xipki.security.pkcs11.P11SlotId;
import org.xipki.security.util.DSAParameterCache;
import org.xipki.util.Args;
import org.xipki.util.Hex;
import org.xipki.util.StringUtil;

public abstract class P11Slot
implements Closeable {
    private static final Logger LOG = LoggerFactory.getLogger(P11Slot.class);
    protected final String moduleName;
    protected final P11SlotId slotId;
    private final boolean readOnly;
    private final SecureRandom random = new SecureRandom();
    private final Map<Long, MechanismInfo> mechanisms = new HashMap<Long, MechanismInfo>();
    protected final List<Long> secretKeyTypes;
    protected final List<Long> keyPairTypes;
    protected final P11ModuleConf.P11NewObjectConf newObjectConf;

    protected P11Slot(String moduleName, P11SlotId slotId, boolean readOnly, List<Long> secretKeyTypes, List<Long> keyPairTypes, P11ModuleConf.P11NewObjectConf newObjectConf) throws TokenException {
        this.newObjectConf = (P11ModuleConf.P11NewObjectConf)Args.notNull((Object)newObjectConf, (String)"newObjectConf");
        this.moduleName = Args.notBlank((String)moduleName, (String)"moduleName");
        this.slotId = (P11SlotId)Args.notNull((Object)slotId, (String)"slotId");
        this.readOnly = readOnly;
        this.secretKeyTypes = secretKeyTypes;
        this.keyPairTypes = keyPairTypes;
    }

    protected static String hex(byte[] bytes) {
        return Hex.encode((byte[])bytes);
    }

    protected static byte[] decodeHex(String hex) {
        return Hex.decode((String)hex);
    }

    protected static String getDescription(byte[] keyId, String keyLabel) {
        return StringUtil.concat((String)"id ", (String[])new String[]{keyId == null ? "null" : P11Slot.hex(keyId), " and label ", keyLabel});
    }

    public abstract PKCS11KeyId getKeyId(byte[] var1, String var2) throws TokenException;

    public abstract P11Key getKey(PKCS11KeyId var1) throws TokenException;

    public abstract P11Key getKey(byte[] var1, String var2) throws TokenException;

    protected abstract PublicKey getPublicKey(P11Key var1) throws TokenException;

    public abstract long[] destroyObjectsByHandle(long ... var1);

    public abstract int destroyAllObjects();

    public abstract int destroyObjectsByIdLabel(byte[] var1, String var2) throws TokenException;

    public abstract boolean objectExistsByIdLabel(byte[] var1, String var2) throws TokenException;

    protected abstract PKCS11KeyId doGenerateSecretKey(long var1, Integer var3, P11NewKeyControl var4) throws TokenException;

    protected abstract PKCS11KeyId doImportSecretKey(long var1, byte[] var3, P11NewKeyControl var4) throws TokenException;

    protected abstract PKCS11KeyId doGenerateDSAKeypair(BigInteger var1, BigInteger var2, BigInteger var3, P11NewKeyControl var4) throws TokenException;

    protected abstract PKCS11KeyId doGenerateECEdwardsKeypair(ASN1ObjectIdentifier var1, P11NewKeyControl var2) throws TokenException;

    protected abstract PrivateKeyInfo doGenerateECEdwardsKeypairOtf(ASN1ObjectIdentifier var1) throws TokenException;

    protected abstract PKCS11KeyId doGenerateECMontgomeryKeypair(ASN1ObjectIdentifier var1, P11NewKeyControl var2) throws TokenException;

    protected abstract PrivateKeyInfo doGenerateECMontgomeryKeypairOtf(ASN1ObjectIdentifier var1) throws TokenException;

    protected abstract PKCS11KeyId doGenerateECKeypair(ASN1ObjectIdentifier var1, P11NewKeyControl var2) throws TokenException;

    protected abstract PrivateKeyInfo doGenerateECKeypairOtf(ASN1ObjectIdentifier var1) throws TokenException;

    protected abstract PKCS11KeyId doGenerateSM2Keypair(P11NewKeyControl var1) throws TokenException;

    protected abstract PrivateKeyInfo doGenerateSM2KeypairOtf() throws TokenException;

    protected abstract PKCS11KeyId doGenerateRSAKeypair(int var1, BigInteger var2, P11NewKeyControl var3) throws TokenException;

    public abstract void showDetails(OutputStream var1, Long var2, boolean var3) throws IOException;

    @Override
    public abstract void close();

    protected void initMechanisms(Map<Long, MechanismInfo> supportedMechanisms, P11ModuleConf.P11MechanismFilter mechanismFilter) {
        this.mechanisms.clear();
        ArrayList<Long> ignoreMechs = new ArrayList<Long>();
        for (Map.Entry<Long, MechanismInfo> entry : supportedMechanisms.entrySet()) {
            long mech = entry.getKey();
            if (mechanismFilter.isMechanismPermitted(this.slotId, mech)) {
                this.mechanisms.put(mech, entry.getValue());
                continue;
            }
            ignoreMechs.add(mech);
        }
        Collections.sort(ignoreMechs);
        if (LOG.isInfoEnabled()) {
            StringBuilder sb = new StringBuilder();
            sb.append("initialized module ").append(this.moduleName).append(", slot ").append(this.slotId);
            sb.append("\nsupported mechanisms:\n");
            if (this.mechanisms.isEmpty()) {
                sb.append("  NONE\n");
            } else {
                P11Slot.printMechanisms(sb, this.mechanisms);
            }
            sb.append("\nsupported by device but ignored mechanisms:\n");
            if (ignoreMechs.isEmpty()) {
                sb.append("  NONE\n");
            } else {
                for (Long mech : ignoreMechs) {
                    sb.append("\n  ").append(PKCS11Constants.ckmCodeToName((long)mech));
                }
            }
            LOG.info(sb.toString());
        }
    }

    private static void printMechanisms(StringBuilder sb, Map<Long, MechanismInfo> mechanisms) {
        ArrayList<Long> sortedMechs = new ArrayList<Long>(mechanisms.keySet());
        Collections.sort(sortedMechs);
        ArrayList mechNames = new ArrayList(mechanisms.size());
        boolean maxNameLen = false;
        for (Long mech : sortedMechs) {
            sb.append("  ").append(PKCS11Constants.ckmCodeToName((long)mech)).append("\n").append(mechanisms.get(mech).toString("  ")).append("\n");
        }
    }

    public Map<Long, MechanismInfo> getMechanisms() {
        return Collections.unmodifiableMap(this.mechanisms);
    }

    public boolean supportsMechanism(long mechanism, long flagBit) {
        MechanismInfo info = this.mechanisms.get(mechanism);
        return info != null && info.hasFlagBit(flagBit);
    }

    public void assertMechanismSupported(long mechanism, long flagBit) throws TokenException {
        if (!this.supportsMechanism(mechanism, flagBit)) {
            throw new TokenException("mechanism " + PKCS11Constants.ckmCodeToName((long)mechanism) + " for " + PKCS11Constants.codeToName((PKCS11Constants.Category)PKCS11Constants.Category.CKF_MECHANISM, (long)flagBit) + " is not supported by PKCS11 slot " + this.slotId);
        }
    }

    public String getModuleName() {
        return this.moduleName;
    }

    public P11SlotId getSlotId() {
        return this.slotId;
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    protected void assertNoObjects(byte[] id, String label) throws TokenException {
        if (id == null && label == null) {
            return;
        }
        if (this.objectExistsByIdLabel(id, label)) {
            throw new TokenException("Objects with " + P11Slot.getDescription(id, label) + " already exists");
        }
    }

    public int destroyObjectsById(byte[] id) throws TokenException {
        return this.destroyObjectsByIdLabel(id, null);
    }

    public int destroyObjectsByLabel(String label) throws TokenException {
        return this.destroyObjectsByIdLabel(null, label);
    }

    public PKCS11KeyId generateSecretKey(long keyType, Integer keysize, P11NewKeyControl control) throws TokenException {
        this.assertWritable("generateSecretKey");
        Args.notNull((Object)control, (String)"control");
        this.assertNoObjects(control.getId(), control.getLabel());
        this.assertSecretKeyAllowed(keyType);
        if (keysize == null && keyType != 21L) {
            throw new IllegalArgumentException("keysize is required for key " + PKCS11Constants.ckkCodeToName((long)keyType) + " but is not specified");
        }
        PKCS11KeyId keyId = this.doGenerateSecretKey(keyType, keysize, control);
        LOG.info("generated secret key {}", (Object)keyId);
        return keyId;
    }

    public PKCS11KeyId importSecretKey(long keyType, byte[] keyValue, P11NewKeyControl control) throws TokenException {
        Args.notNull((Object)control, (String)"control");
        this.assertWritable("createSecretKey");
        this.assertNoObjects(control.getId(), control.getLabel());
        this.assertSecretKeyAllowed(keyType);
        PKCS11KeyId keyId = this.doImportSecretKey(keyType, keyValue, control);
        LOG.info("created secret key {}", (Object)keyId);
        return keyId;
    }

    private void assertSecretKeyAllowed(long keyType) throws TokenException {
        if (this.secretKeyTypes == null) {
            return;
        }
        if (!this.secretKeyTypes.contains(keyType)) {
            throw new TokenException("secret key type 0x" + Long.toHexString(keyType) + "unsupported");
        }
    }

    public PrivateKeyInfo generateRSAKeypairOtf(int keysize, BigInteger publicExponent) throws TokenException {
        Args.min((int)keysize, (String)"keysize", (int)1024);
        if (keysize % 1024 != 0) {
            throw new IllegalArgumentException("key size is not multiple of 1024: " + keysize);
        }
        if (!this.supportsMechanism(10L, 65536L) && !this.supportsMechanism(0L, 65536L)) {
            throw new TokenException(this.buildOrMechanismsUnsupportedMessage(10L, 0L));
        }
        return this.doGenerateRSAKeypairOtf(keysize, publicExponent == null ? RSAKeyGenParameterSpec.F4 : publicExponent);
    }

    protected abstract PrivateKeyInfo doGenerateRSAKeypairOtf(int var1, BigInteger var2) throws TokenException;

    public PKCS11KeyId generateRSAKeypair(int keysize, BigInteger publicExponent, P11NewKeyControl control) throws TokenException {
        Args.min((int)keysize, (String)"keysize", (int)1024);
        if (keysize % 1024 != 0) {
            throw new IllegalArgumentException("key size is not multiple of 1024: " + keysize);
        }
        this.assertCanGenKeypair("generateRSAKeypair", control, 0L, 10L, 0L);
        PKCS11KeyId keyId = this.doGenerateRSAKeypair(keysize, publicExponent == null ? RSAKeyGenParameterSpec.F4 : publicExponent, control);
        LOG.info("generated RSA keypair {}", (Object)keyId);
        return keyId;
    }

    public PrivateKeyInfo generateDSAKeypairOtf(BigInteger p, BigInteger q, BigInteger g) throws TokenException {
        Args.notNull((Object)p, (String)"p");
        Args.notNull((Object)q, (String)"q");
        Args.notNull((Object)g, (String)"g");
        this.assertMechanismSupported(16L, 65536L);
        return this.generateDSAKeypairOtf0(p, q, g);
    }

    protected abstract PrivateKeyInfo generateDSAKeypairOtf0(BigInteger var1, BigInteger var2, BigInteger var3) throws TokenException;

    public PKCS11KeyId generateDSAKeypair(int plength, int qlength, P11NewKeyControl control) throws TokenException {
        Args.min((int)plength, (String)"plength", (int)1024);
        if (plength % 1024 != 0) {
            throw new IllegalArgumentException("key size is not multiple of 1024: " + plength);
        }
        DSAParameterSpec dsaParams = DSAParameterCache.getDSAParameterSpec(plength, qlength, this.random);
        return this.generateDSAKeypair(dsaParams.getP(), dsaParams.getQ(), dsaParams.getG(), control);
    }

    public PKCS11KeyId generateDSAKeypair(BigInteger p, BigInteger q, BigInteger g, P11NewKeyControl control) throws TokenException {
        this.assertCanGenKeypair("generateDSAKeypair", control, 1L, 16L);
        PKCS11KeyId keyId = this.doGenerateDSAKeypair((BigInteger)Args.notNull((Object)p, (String)"p"), (BigInteger)Args.notNull((Object)q, (String)"q"), (BigInteger)Args.notNull((Object)g, (String)"g"), control);
        LOG.info("generated DSA keypair {}", (Object)keyId);
        return keyId;
    }

    public PrivateKeyInfo generateECKeypairOtf(ASN1ObjectIdentifier curveOid) throws TokenException {
        Args.notNull((Object)curveOid, (String)"curveOid");
        if (EdECConstants.isEdwardsCurve(curveOid)) {
            this.assertMechanismSupported(4181L, 65536L);
            return this.doGenerateECEdwardsKeypairOtf(curveOid);
        }
        if (EdECConstants.isMontgomeryCurve(curveOid)) {
            this.assertMechanismSupported(4182L, 65536L);
            return this.doGenerateECMontgomeryKeypairOtf(curveOid);
        }
        this.assertMechanismSupported(4160L, 65536L);
        return this.doGenerateECKeypairOtf(curveOid);
    }

    public PKCS11KeyId generateECKeypair(ASN1ObjectIdentifier curveOid, P11NewKeyControl control) throws TokenException {
        PKCS11KeyId keyId;
        Args.notNull((Object)curveOid, (String)"curveOid");
        if (EdECConstants.isEdwardsCurve(curveOid)) {
            this.assertCanGenKeypair("generateECKeypair", control, 64L, 4181L);
            keyId = this.doGenerateECEdwardsKeypair(curveOid, control);
        } else if (EdECConstants.isMontgomeryCurve(curveOid)) {
            this.assertCanGenKeypair("generateECKeypair", control, 65L, 4182L);
            keyId = this.doGenerateECMontgomeryKeypair(curveOid, control);
        } else {
            this.assertCanGenKeypair("generateECKeypair", control, 3L, 4160L);
            keyId = this.doGenerateECKeypair(curveOid, control);
        }
        LOG.info("generated EC keypair {}", (Object)keyId);
        return keyId;
    }

    public PrivateKeyInfo generateSM2KeypairOtf() throws TokenException {
        this.assertMechanismSupported(0xFFFFF001L, 65536L);
        return this.doGenerateSM2KeypairOtf();
    }

    public PKCS11KeyId generateSM2Keypair(P11NewKeyControl control) throws TokenException {
        this.assertCanGenKeypair("generateSM2Keypair", control, 0xFFFFF001L, 0xFFFFF001L);
        PKCS11KeyId keyId = this.doGenerateSM2Keypair(control);
        LOG.info("generated SM2 keypair {}", (Object)keyId);
        return keyId;
    }

    private void assertCanGenKeypair(String methodName, P11NewKeyControl control, long keyType, long ... orMechanisms) throws TokenException {
        Args.notNull((Object)control, (String)"control");
        this.assertWritable(methodName);
        if (orMechanisms.length < 2) {
            this.assertMechanismSupported(orMechanisms[0], 65536L);
        } else {
            boolean mechSupported = false;
            for (long mechanism : orMechanisms) {
                if (!this.supportsMechanism(mechanism, 65536L)) continue;
                mechSupported = true;
                break;
            }
            if (!mechSupported) {
                throw new TokenException(this.buildOrMechanismsUnsupportedMessage(orMechanisms));
            }
        }
        this.assertNoObjects(control.getId(), control.getLabel());
        if (this.keyPairTypes == null) {
            return;
        }
        if (!this.keyPairTypes.contains(keyType)) {
            LOG.error("Keypair of key type 0x{} unsupported", (Object)Long.toHexString(keyType));
            throw new TokenException(this.buildOrMechanismsUnsupportedMessage(orMechanisms));
        }
    }

    private String buildOrMechanismsUnsupportedMessage(long ... mechanisms) {
        StringBuilder sb = new StringBuilder("none of mechanisms [");
        for (long mechanism : mechanisms) {
            sb.append(PKCS11Constants.ckmCodeToName((long)mechanism)).append(", ");
        }
        sb.deleteCharAt(sb.length() - 1);
        sb.append("] is supported by PKCS11 slot ").append(this.slotId);
        return sb.toString();
    }

    protected void printSupportedMechanism(OutputStream stream) throws IOException {
        Args.notNull((Object)stream, (String)"stream");
        StringBuilder sb = new StringBuilder();
        sb.append("\nSupported mechanisms:\n");
        P11Slot.printMechanisms(sb, this.mechanisms);
        stream.write(sb.toString().getBytes(StandardCharsets.UTF_8));
    }

    protected void assertWritable(String operationName) throws TokenException {
        if (this.readOnly) {
            throw new TokenException("Writable operation " + operationName + " is not permitted");
        }
    }

    protected static String formatNumber(int value, int numChars) {
        return P11Slot.formatString(Integer.toString(value), numChars, true);
    }

    private static String formatString(String str, int numChars, boolean prepend) {
        if (str.length() >= numChars) {
            return str;
        }
        char[] chars = str.toCharArray();
        char[] ret = new char[numChars];
        if (prepend) {
            System.arraycopy(chars, 0, ret, numChars - chars.length, chars.length);
            Arrays.fill(ret, 0, numChars - chars.length, ' ');
        } else {
            System.arraycopy(chars, 0, ret, 0, chars.length);
            Arrays.fill(ret, chars.length, numChars, ' ');
        }
        return new String(ret);
    }

    public static class P11NewKeyControl
    extends P11NewObjectControl {
        private Boolean extractable;
        private Boolean sensitive;
        private Set<P11KeyUsage> usages;

        public P11NewKeyControl(byte[] id, String label) {
            super(id, label);
        }

        public Boolean getExtractable() {
            return this.extractable;
        }

        public void setExtractable(Boolean extractable) {
            this.extractable = extractable;
        }

        public Boolean getSensitive() {
            return this.sensitive;
        }

        public void setSensitive(Boolean sensitive) {
            this.sensitive = sensitive;
        }

        public Set<P11KeyUsage> getUsages() {
            if (this.usages == null) {
                this.usages = new HashSet<P11KeyUsage>();
            }
            return this.usages;
        }

        public void setUsages(Set<P11KeyUsage> usages) {
            this.usages = usages;
        }
    }

    public static enum P11KeyUsage {
        DECRYPT,
        DERIVE,
        SIGN,
        SIGN_RECOVER,
        UNWRAP;

    }

    public static class P11NewObjectControl {
        private final byte[] id;
        private final String label;

        public P11NewObjectControl(byte[] id, String label) {
            this.id = id;
            this.label = Args.notBlank((String)label, (String)"label");
        }

        public byte[] getId() {
            return this.id;
        }

        public String getLabel() {
            return this.label;
        }
    }
}

