/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.security.pkcs11;

import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.xipki.util.ValidatableConf;
import org.xipki.util.exception.InvalidConfException;

public class Pkcs11conf
extends ValidatableConf {
    private List<Module> modules;
    private List<MechanismSet> mechanismSets;

    public List<Module> getModules() {
        return this.modules;
    }

    public void setModules(List<Module> modules) {
        if (modules == null) {
            modules = new LinkedList<Module>();
        }
        this.modules = modules;
    }

    public List<MechanismSet> getMechanismSets() {
        if (this.mechanismSets == null) {
            this.mechanismSets = new LinkedList<MechanismSet>();
        }
        return this.mechanismSets;
    }

    public void setMechanismSets(List<MechanismSet> mechanismSets) {
        this.mechanismSets = mechanismSets;
    }

    public void addModule(Module module) {
        this.getModules().add(module);
    }

    public void addMechanismSet(MechanismSet mechanismSet) {
        this.getMechanismSets().add(mechanismSet);
    }

    public void validate() throws InvalidConfException {
        Pkcs11conf.notEmpty(this.modules, (String)"modules");
        Pkcs11conf.notEmpty(this.mechanismSets, (String)"mechanismSets");
        Pkcs11conf.validate((Collection[])new Collection[]{this.modules, this.mechanismSets});
    }

    public static class Slot
    extends ValidatableConf {
        private Integer index;
        private String id;

        public Integer getIndex() {
            return this.index;
        }

        public void setIndex(Integer index) {
            this.index = index;
        }

        public String getId() {
            return this.id;
        }

        public void setId(String id) {
            this.id = id;
        }

        public void validate() throws InvalidConfException {
            this.exactOne(this.index, "index", this.id, "id");
        }
    }

    public static class PasswordSet
    extends ValidatableConf {
        private List<Slot> slots;
        private List<String> passwords;

        public List<Slot> getSlots() {
            if (this.slots == null) {
                this.slots = new LinkedList<Slot>();
            }
            return this.slots;
        }

        public void setSlots(List<Slot> slots) {
            this.slots = slots;
        }

        public List<String> getPasswords() {
            if (this.passwords == null) {
                this.passwords = new LinkedList<String>();
            }
            return this.passwords;
        }

        public void setPasswords(List<String> passwords) {
            this.passwords = passwords;
        }

        public void validate() throws InvalidConfException {
            PasswordSet.notEmpty(this.passwords, (String)"passwords");
        }
    }

    public static class NewObjectConf
    extends ValidatableConf {
        private Boolean ignoreLabel;
        private Integer idLength;

        public Boolean getIgnoreLabel() {
            return this.ignoreLabel;
        }

        public void setIgnoreLabel(Boolean ignoreLabel) {
            this.ignoreLabel = ignoreLabel;
        }

        public Integer getIdLength() {
            return this.idLength;
        }

        public void setIdLength(Integer idLength) {
            this.idLength = idLength;
        }

        public void validate() throws InvalidConfException {
        }
    }

    public static class NativeLibrary
    extends ValidatableConf {
        private String path;
        private List<String> operationSystems = new LinkedList<String>();

        public String getPath() {
            return this.path;
        }

        public void setPath(String path) {
            this.path = path;
        }

        public List<String> getOperationSystems() {
            if (this.operationSystems == null) {
                this.operationSystems = new LinkedList<String>();
            }
            return this.operationSystems;
        }

        public void setOperationSystems(List<String> operationSystems) {
            this.operationSystems = operationSystems;
        }

        public void validate() throws InvalidConfException {
            NativeLibrary.notNull((Object)this.path, (String)"path");
        }
    }

    public static class Module
    extends ValidatableConf {
        private String name;
        private String type;
        private List<NativeLibrary> nativeLibraries;
        private NewObjectConf newObjectConf;
        private List<Slot> includeSlots;
        private List<Slot> excludeSlots;
        private boolean readonly;
        private List<String> secretKeyTypes;
        private List<String> keyPairTypes;
        private Integer numSessions;
        private String user;
        private String userName;
        private Integer maxMessageSize;
        private List<PasswordSet> passwordSets;
        private List<MechanismFilter> mechanismFilters;

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getType() {
            return this.type;
        }

        public void setType(String type) {
            this.type = type;
        }

        public List<NativeLibrary> getNativeLibraries() {
            if (this.nativeLibraries == null) {
                this.nativeLibraries = new LinkedList<NativeLibrary>();
            }
            return this.nativeLibraries;
        }

        public void setNativeLibraries(List<NativeLibrary> nativeLibraries) {
            this.nativeLibraries = nativeLibraries;
        }

        public NewObjectConf getNewObjectConf() {
            return this.newObjectConf;
        }

        public void setNewObjectConf(NewObjectConf newObjectConf) {
            this.newObjectConf = newObjectConf;
        }

        public List<Slot> getIncludeSlots() {
            if (this.includeSlots == null) {
                this.includeSlots = new LinkedList<Slot>();
            }
            return this.includeSlots;
        }

        public void setIncludeSlots(List<Slot> includeSlots) {
            this.includeSlots = includeSlots;
        }

        public List<Slot> getExcludeSlots() {
            if (this.excludeSlots == null) {
                this.excludeSlots = new LinkedList<Slot>();
            }
            return this.excludeSlots;
        }

        public void setExcludeSlots(List<Slot> excludeSlots) {
            this.excludeSlots = excludeSlots;
        }

        public boolean isReadonly() {
            return this.readonly;
        }

        public void setReadonly(boolean readonly) {
            this.readonly = readonly;
        }

        public List<PasswordSet> getPasswordSets() {
            if (this.passwordSets == null) {
                this.passwordSets = new LinkedList<PasswordSet>();
            }
            return this.passwordSets;
        }

        public void setPasswordSets(List<PasswordSet> passwordSets) {
            this.passwordSets = passwordSets;
        }

        public List<MechanismFilter> getMechanismFilters() {
            if (this.mechanismFilters == null) {
                this.mechanismFilters = new LinkedList<MechanismFilter>();
            }
            return this.mechanismFilters;
        }

        public void setMechanismFilters(List<MechanismFilter> mechanismFilters) {
            this.mechanismFilters = mechanismFilters;
        }

        public void setUser(String user) {
            this.user = user;
        }

        public void setUserName(String userName) {
            this.userName = userName;
        }

        public void setMaxMessageSize(Integer maxMessageSize) {
            this.maxMessageSize = maxMessageSize;
        }

        public String getUser() {
            return this.user == null ? "CKU_USER" : this.user;
        }

        public String getUserName() {
            return this.userName;
        }

        public int getMaxMessageSize() {
            return this.maxMessageSize == null ? 16384 : this.maxMessageSize;
        }

        public List<String> getSecretKeyTypes() {
            return this.secretKeyTypes;
        }

        public void setSecretKeyTypes(List<String> secretKeyTypes) {
            this.secretKeyTypes = secretKeyTypes;
        }

        public List<String> getKeyPairTypes() {
            return this.keyPairTypes;
        }

        public void setKeyPairTypes(List<String> keyPairTypes) {
            this.keyPairTypes = keyPairTypes;
        }

        public Integer getNumSessions() {
            return this.numSessions;
        }

        public void setNumSessions(Integer numSessions) {
            this.numSessions = numSessions;
        }

        public void validate() throws InvalidConfException {
            Module.notBlank((String)this.name, (String)"name");
            Module.notBlank((String)this.type, (String)"type");
            Module.notEmpty(this.nativeLibraries, (String)"nativeLibraries");
            Module.notEmpty(this.mechanismFilters, (String)"mechanismFilters");
            Module.validate((Collection[])new Collection[]{this.nativeLibraries, this.includeSlots, this.excludeSlots, this.passwordSets, this.mechanismFilters});
        }
    }

    public static class MechanismSet
    extends ValidatableConf {
        private String name;
        private List<String> mechanisms;

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public List<String> getMechanisms() {
            if (this.mechanisms == null) {
                this.mechanisms = new LinkedList<String>();
            }
            return this.mechanisms;
        }

        public void setMechanisms(List<String> mechanisms) {
            this.mechanisms = mechanisms;
        }

        public void validate() throws InvalidConfException {
            MechanismSet.notBlank((String)this.name, (String)"name");
            MechanismSet.notEmpty(this.mechanisms, (String)"mechanisms");
        }
    }

    public static class MechanismFilter
    extends ValidatableConf {
        private String mechanismSet;
        private List<Slot> slots;

        public String getMechanismSet() {
            return this.mechanismSet;
        }

        public void setMechanismSet(String mechanismSet) {
            this.mechanismSet = mechanismSet;
        }

        public List<Slot> getSlots() {
            if (this.slots == null) {
                this.slots = new LinkedList<Slot>();
            }
            return this.slots;
        }

        public void setSlots(List<Slot> slots) {
            this.slots = slots;
        }

        public void validate() throws InvalidConfException {
            MechanismFilter.notBlank((String)this.mechanismSet, (String)"mechanismSet");
            MechanismFilter.validate((Collection[])new Collection[]{this.slots});
        }
    }
}

