/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.security.pkcs12;

import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Security;
import java.security.Signature;
import java.security.SignatureException;
import java.security.interfaces.DSAPrivateKey;
import java.security.interfaces.ECPrivateKey;
import java.security.interfaces.RSAPrivateKey;
import java.security.spec.EllipticCurve;
import java.util.ArrayList;
import javax.crypto.NoSuchPaddingException;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.crypto.DSA;
import org.bouncycastle.crypto.Digest;
import org.bouncycastle.crypto.ExtendedDigest;
import org.bouncycastle.crypto.Signer;
import org.bouncycastle.crypto.params.AsymmetricKeyParameter;
import org.bouncycastle.crypto.params.RSAKeyParameters;
import org.bouncycastle.crypto.signers.DSADigestSigner;
import org.bouncycastle.crypto.signers.DSASigner;
import org.bouncycastle.crypto.signers.ECDSASigner;
import org.bouncycastle.crypto.signers.RSADigestSigner;
import org.bouncycastle.crypto.signers.SM2Signer;
import org.bouncycastle.jcajce.provider.asymmetric.dsa.DSAUtil;
import org.bouncycastle.jcajce.provider.asymmetric.util.ECUtil;
import org.bouncycastle.operator.ContentSigner;
import org.bouncycastle.operator.OperatorCreationException;
import org.bouncycastle.operator.bc.BcContentSignerBuilder;
import org.xipki.security.ConcurrentContentSigner;
import org.xipki.security.DSAPlainDigestSigner;
import org.xipki.security.DfltConcurrentContentSigner;
import org.xipki.security.SignAlgo;
import org.xipki.security.SignatureSigner;
import org.xipki.security.X509Cert;
import org.xipki.security.XiContentSigner;
import org.xipki.security.XiSecurityException;
import org.xipki.security.XiWrappedContentSigner;
import org.xipki.security.pkcs12.KeypairWithCert;
import org.xipki.security.util.GMUtil;
import org.xipki.security.util.SignerUtil;
import org.xipki.util.Args;
import org.xipki.util.CollectionUtil;

public class P12ContentSignerBuilder {
    private final PrivateKey key;
    private final PublicKey publicKey;
    private final X509Cert[] certificateChain;

    public P12ContentSignerBuilder(PrivateKey privateKey, PublicKey publicKey) {
        this.key = (PrivateKey)Args.notNull((Object)privateKey, (String)"privateKey");
        this.publicKey = (PublicKey)Args.notNull((Object)publicKey, (String)"publicKey");
        this.certificateChain = null;
    }

    public P12ContentSignerBuilder(KeypairWithCert keypairWithCert) throws XiSecurityException {
        Args.notNull((Object)keypairWithCert, (String)"keypairWithCert");
        this.key = keypairWithCert.getKey();
        this.publicKey = keypairWithCert.getPublicKey();
        this.certificateChain = keypairWithCert.getCertificateChain();
    }

    public X509Cert getCertificate() {
        return this.certificateChain != null && this.certificateChain.length > 0 ? this.certificateChain[0] : null;
    }

    public X509Cert[] getCertificateChain() {
        return this.certificateChain;
    }

    public PrivateKey getKey() {
        return this.key;
    }

    public ContentSigner createContentSigner(SignAlgo signAlgo, SecureRandom random) throws XiSecurityException {
        Args.notNull((Object)((Object)signAlgo), (String)"signAlgo");
        String provName = this.getProviderName(signAlgo);
        if (provName != null && Security.getProvider(provName) != null) {
            try {
                Signature signature = this.createSignature(signAlgo, provName, true);
                return new SignatureSigner(signAlgo, signature, this.key);
            }
            catch (Exception signature) {
                // empty catch block
            }
        }
        Object[] rv = this.ff(signAlgo, random);
        BcContentSignerBuilder signerBuilder = (BcContentSignerBuilder)rv[0];
        AsymmetricKeyParameter keyparam = (AsymmetricKeyParameter)rv[1];
        try {
            return signerBuilder.build(keyparam);
        }
        catch (OperatorCreationException ex) {
            throw new XiSecurityException("operator creation error", ex);
        }
    }

    public ConcurrentContentSigner createSigner(SignAlgo signAlgo, int parallelism, SecureRandom random) throws XiSecurityException, NoSuchPaddingException {
        DfltConcurrentContentSigner concurrentSigner;
        Args.notNull((Object)((Object)signAlgo), (String)"signAlgo");
        Args.positive((int)parallelism, (String)"parallelism");
        ArrayList<XiContentSigner> signers = new ArrayList<XiContentSigner>(parallelism);
        String provName = this.getProviderName(signAlgo);
        if (provName != null && Security.getProvider(provName) != null) {
            try {
                for (int i = 0; i < parallelism; ++i) {
                    Signature signature = this.createSignature(signAlgo, provName, i == 0);
                    SignatureSigner signer = new SignatureSigner(signAlgo, signature, this.key);
                    signers.add(signer);
                }
            }
            catch (Exception ex) {
                signers.clear();
            }
        }
        if (CollectionUtil.isEmpty(signers)) {
            Object[] rv = this.ff(signAlgo, random);
            BcContentSignerBuilder signerBuilder = (BcContentSignerBuilder)rv[0];
            AsymmetricKeyParameter keyparam = (AsymmetricKeyParameter)rv[1];
            for (int i = 0; i < parallelism; ++i) {
                ContentSigner signer;
                try {
                    signer = signerBuilder.build(keyparam);
                }
                catch (OperatorCreationException ex) {
                    throw new XiSecurityException("operator creation error", ex);
                }
                signers.add(new XiWrappedContentSigner(signer, true));
            }
        }
        boolean mac = false;
        try {
            concurrentSigner = new DfltConcurrentContentSigner(false, signers, this.key);
        }
        catch (NoSuchAlgorithmException ex) {
            throw new XiSecurityException(ex.getMessage(), ex);
        }
        if (this.certificateChain != null) {
            concurrentSigner.setCertificateChain(this.certificateChain);
        } else {
            concurrentSigner.setPublicKey(this.publicKey);
        }
        return concurrentSigner;
    }

    private String getProviderName(SignAlgo signAlgo) {
        if (signAlgo.isRSAPkcs1SigAlgo()) {
            return "SunRsaSign";
        }
        if (signAlgo.isECDSASigAlgo()) {
            return null;
        }
        if (signAlgo.isDSASigAlgo()) {
            return "SUN";
        }
        if (signAlgo.isEDDSASigAlgo()) {
            return "BC";
        }
        return null;
    }

    private Signature createSignature(SignAlgo signAlgo, String provName, boolean test) throws NoSuchAlgorithmException, NoSuchProviderException, InvalidKeyException, SignatureException {
        Signature signature = Signature.getInstance(signAlgo.getJceName(), provName);
        signature.initSign(this.key);
        if (test) {
            signature.update(new byte[]{1, 2, 3, 4});
            signature.sign();
        }
        return signature;
    }

    private Object[] ff(SignAlgo signAlgo, SecureRandom random) throws XiSecurityException {
        BcContentSignerBuilder signerBuilder;
        RSAKeyParameters keyparam;
        block13: {
            try {
                if (this.key instanceof RSAPrivateKey) {
                    if (!signAlgo.isRSAPSSSigAlgo() && !signAlgo.isRSAPkcs1SigAlgo()) {
                        throw new NoSuchAlgorithmException("the given algorithm is not a valid RSA signature algorithm '" + (Object)((Object)signAlgo) + "'");
                    }
                    keyparam = SignerUtil.generateRSAPrivateKeyParameter((RSAPrivateKey)this.key);
                    signerBuilder = new RSAContentSignerBuilder(signAlgo);
                    break block13;
                }
                if (this.key instanceof DSAPrivateKey) {
                    if (!signAlgo.isDSASigAlgo()) {
                        throw new NoSuchAlgorithmException("the given algorithm is not a valid DSA signature algirthm " + (Object)((Object)signAlgo));
                    }
                    keyparam = DSAUtil.generatePrivateKeyParameter((PrivateKey)this.key);
                    signerBuilder = new DSAContentSignerBuilder(signAlgo);
                    break block13;
                }
                if (this.key instanceof ECPrivateKey) {
                    keyparam = ECUtil.generatePrivateKeyParameter((PrivateKey)this.key);
                    EllipticCurve curve = ((ECPrivateKey)this.key).getParams().getCurve();
                    if (GMUtil.isSm2primev2Curve(curve)) {
                        if (!signAlgo.isSM2SigAlgo()) {
                            throw new NoSuchAlgorithmException("the given algorithm is not a valid SM2 signature algirthm " + (Object)((Object)signAlgo));
                        }
                        signerBuilder = new SM2ContentSignerBuilder(signAlgo);
                    } else {
                        if (!signAlgo.isECDSASigAlgo()) {
                            throw new NoSuchAlgorithmException("the given algorithm is not a valid ECDSA signature algirthm " + (Object)((Object)signAlgo));
                        }
                        signerBuilder = new ECDSAContentSignerBuilder(signAlgo);
                    }
                    break block13;
                }
                throw new XiSecurityException("unsupported key " + this.key.getClass().getName());
            }
            catch (InvalidKeyException ex) {
                throw new XiSecurityException("invalid key: " + ex.getMessage(), ex);
            }
            catch (NoSuchAlgorithmException ex) {
                throw new XiSecurityException("no such algorithm: " + ex.getMessage(), ex);
            }
        }
        if (random != null) {
            signerBuilder.setSecureRandom(random);
        }
        return new Object[]{signerBuilder, keyparam};
    }

    private static class SM2ContentSignerBuilder
    extends BcContentSignerBuilder {
        private final SignAlgo signAlgo;

        private SM2ContentSignerBuilder(SignAlgo signAlgo) throws NoSuchAlgorithmException {
            super(signAlgo.getAlgorithmIdentifier(), signAlgo.getHashAlgo().getAlgorithmIdentifier());
            this.signAlgo = signAlgo;
        }

        protected Signer createSigner(AlgorithmIdentifier sigAlgId, AlgorithmIdentifier digAlgId) throws OperatorCreationException {
            this.signAlgo.assertSameAlgorithm(sigAlgId, digAlgId);
            return new SM2Signer((Digest)this.signAlgo.getHashAlgo().createDigest());
        }
    }

    private static class ECDSAContentSignerBuilder
    extends BcContentSignerBuilder {
        private final SignAlgo signAlgo;

        private ECDSAContentSignerBuilder(SignAlgo signAlgo) throws NoSuchAlgorithmException {
            super(signAlgo.getAlgorithmIdentifier(), signAlgo.getHashAlgo().getAlgorithmIdentifier());
            this.signAlgo = signAlgo;
        }

        protected Signer createSigner(AlgorithmIdentifier sigAlgId, AlgorithmIdentifier digAlgId) throws OperatorCreationException {
            this.signAlgo.assertSameAlgorithm(sigAlgId, digAlgId);
            ExtendedDigest dig = this.signAlgo.getHashAlgo().createDigest();
            ECDSASigner dsaSigner = new ECDSASigner();
            return this.signAlgo.isPlainECDSASigAlgo() ? new DSAPlainDigestSigner((DSA)dsaSigner, (Digest)dig) : new DSADigestSigner((DSA)dsaSigner, (Digest)dig);
        }
    }

    private static class DSAContentSignerBuilder
    extends BcContentSignerBuilder {
        private final SignAlgo signAlgo;

        private DSAContentSignerBuilder(SignAlgo signAlgo) throws NoSuchAlgorithmException {
            super(signAlgo.getAlgorithmIdentifier(), signAlgo.getHashAlgo().getAlgorithmIdentifier());
            this.signAlgo = signAlgo;
        }

        protected Signer createSigner(AlgorithmIdentifier sigAlgId, AlgorithmIdentifier digAlgId) throws OperatorCreationException {
            this.signAlgo.assertSameAlgorithm(sigAlgId, digAlgId);
            ExtendedDigest dig = this.signAlgo.getHashAlgo().createDigest();
            return new DSADigestSigner((DSA)new DSASigner(), (Digest)dig);
        }
    }

    private static class RSAContentSignerBuilder
    extends BcContentSignerBuilder {
        private final SignAlgo signAlgo;

        private RSAContentSignerBuilder(SignAlgo signAlgo) throws NoSuchAlgorithmException {
            super(signAlgo.getAlgorithmIdentifier(), signAlgo.getHashAlgo().getAlgorithmIdentifier());
            this.signAlgo = signAlgo;
        }

        protected Signer createSigner(AlgorithmIdentifier sigAlgId, AlgorithmIdentifier digAlgId) throws OperatorCreationException {
            this.signAlgo.assertSameAlgorithm(sigAlgId, digAlgId);
            if (this.signAlgo.isRSAPSSSigAlgo()) {
                try {
                    return SignerUtil.createPSSRSASigner(this.signAlgo);
                }
                catch (XiSecurityException ex) {
                    throw new OperatorCreationException(ex.getMessage(), (Throwable)ex);
                }
            }
            ExtendedDigest dig = this.digestProvider.get(digAlgId);
            return new RSADigestSigner((Digest)dig);
        }
    }
}

