/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.security.qa;

import java.math.BigInteger;
import java.security.spec.DSAParameterSpec;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xipki.security.pkcs11.P11Slot;
import org.xipki.security.util.AlgorithmUtil;
import org.xipki.security.util.DSAParameterCache;
import org.xipki.util.Args;
import org.xipki.util.BenchmarkExecutor;

public abstract class P11KeyGenSpeed
extends BenchmarkExecutor {
    protected final P11Slot slot;
    private static final Logger LOG = LoggerFactory.getLogger(P11KeyGenSpeed.class);

    public P11KeyGenSpeed(P11Slot slot, String description) {
        super(description);
        this.slot = (P11Slot)Args.notNull((Object)slot, (String)"slot");
    }

    protected abstract void genKeypair() throws Exception;

    protected Runnable getTester() throws Exception {
        return new Tester();
    }

    class Tester
    implements Runnable {
        Tester() {
        }

        @Override
        public void run() {
            while (!P11KeyGenSpeed.this.stop() && P11KeyGenSpeed.this.getErrorAccout() < 1L) {
                try {
                    P11KeyGenSpeed.this.genKeypair();
                    P11KeyGenSpeed.this.account(1L, 0L);
                }
                catch (Exception ex) {
                    LOG.error("P11KeyGenSpeed.Tester.run()", (Throwable)ex);
                    P11KeyGenSpeed.this.account(1L, 1L);
                }
            }
        }
    }

    public static class SM2
    extends P11KeyGenSpeed {
        public SM2(P11Slot slot) {
            super(slot, "PKCS#11 SM2 key generation");
        }

        @Override
        protected void genKeypair() throws Exception {
            this.slot.generateSM2KeypairOtf();
        }
    }

    public static class RSA
    extends P11KeyGenSpeed {
        private final int keysize;
        private final BigInteger publicExponent;

        public RSA(P11Slot slot, int keysize, BigInteger publicExponent) {
            super(slot, "PKCS#11 RSA key generation\nkeysize: " + keysize + "\npublic exponent: " + publicExponent);
            this.keysize = keysize;
            this.publicExponent = publicExponent;
        }

        @Override
        protected void genKeypair() throws Exception {
            this.slot.generateRSAKeypairOtf(this.keysize, this.publicExponent);
        }
    }

    public static class EC
    extends P11KeyGenSpeed {
        private final ASN1ObjectIdentifier curveOid;

        public EC(P11Slot slot, ASN1ObjectIdentifier curveOid) throws Exception {
            super(slot, "PKCS#11 EC key generation\ncurve: " + AlgorithmUtil.getCurveName(curveOid));
            this.curveOid = (ASN1ObjectIdentifier)Args.notNull((Object)curveOid, (String)"curveOid");
        }

        @Override
        protected void genKeypair() throws Exception {
            this.slot.generateECKeypairOtf(this.curveOid);
        }
    }

    public static class DSA
    extends P11KeyGenSpeed {
        private final int plength;
        private final int qlength;

        public DSA(P11Slot slot, int plength, int qlength) {
            super(slot, "PKCS#11 DSA key generation\nplength: " + plength + "\nqlength: " + qlength);
            this.plength = plength;
            this.qlength = qlength;
        }

        @Override
        protected void genKeypair() throws Exception {
            DSAParameterSpec spec = DSAParameterCache.getDSAParameterSpec(this.plength, this.qlength, null);
            this.slot.generateDSAKeypairOtf(spec.getP(), spec.getQ(), spec.getG());
        }
    }
}

