/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.security.util;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonIOException;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.google.gson.JsonSyntaxException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;
import org.xipki.util.Base64;

public class JSON {
    private static final Gson gson = new GsonBuilder().registerTypeHierarchyAdapter(byte[].class, (Object)new ByteArrayToBase64TypeAdapter()).registerTypeHierarchyAdapter(Double.class, (Object)new DoubleTypeAdapter()).registerTypeHierarchyAdapter(Double.TYPE, (Object)new DoubleTypeAdapter()).disableHtmlEscaping().create();
    private static final Gson prettyGson = new GsonBuilder().registerTypeHierarchyAdapter(byte[].class, (Object)new ByteArrayToBase64TypeAdapter()).registerTypeHierarchyAdapter(Double.class, (Object)new DoubleTypeAdapter()).registerTypeHierarchyAdapter(Double.TYPE, (Object)new DoubleTypeAdapter()).disableHtmlEscaping().setPrettyPrinting().create();

    public static <T> T parseObject(String json, Class<T> classOfT) throws JsonSyntaxException {
        return (T)gson.fromJson(json, classOfT);
    }

    public static <T> T parseObject(byte[] json, Class<T> classOfT) throws JsonSyntaxException, JsonIOException {
        return JSON.parseObject(new ByteArrayInputStream(json), classOfT);
    }

    public static <T> T parseObject(File jsonFile, Class<T> classOfT) throws JsonSyntaxException, JsonIOException {
        try {
            return JSON.parseObject(new FileInputStream(jsonFile), classOfT);
        }
        catch (FileNotFoundException e) {
            throw new JsonIOException((Throwable)e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static <T> T parseObject(InputStream json, Class<T> classOfT) throws JsonSyntaxException, JsonIOException {
        try (InputStreamReader reader = new InputStreamReader(json);){
            Object object = gson.fromJson((Reader)reader, classOfT);
            return (T)object;
        }
        catch (IOException e) {
            throw new JsonIOException((Throwable)e);
        }
    }

    public static String toJson(Object obj) {
        return gson.toJson(obj);
    }

    public static byte[] toJSONBytes(Object obj) {
        ByteArray ba = new ByteArray();
        gson.toJson(obj, (Appendable)ba);
        return ba.toByteArray();
    }

    public static String toPrettyJson(Object obj) {
        return prettyGson.toJson(obj);
    }

    public static void writeJSON(Object object, OutputStream outputStream) {
        gson.toJson(object, (Appendable)new StreamAppendable(outputStream));
    }

    public static void writePrettyJSON(Object object, OutputStream outputStream) {
        prettyGson.toJson(object, (Appendable)new StreamAppendable(outputStream));
    }

    private static class ByteArray
    extends StreamAppendable {
        private ByteArray() {
            super(new ByteArrayOutputStream(1024));
        }

        public byte[] toByteArray() {
            return ((ByteArrayOutputStream)this.out).toByteArray();
        }
    }

    private static class StreamAppendable
    implements Appendable {
        protected final OutputStream out;

        private StreamAppendable(OutputStream out) {
            this.out = out;
        }

        @Override
        public Appendable append(CharSequence csq) throws IOException {
            this.out.write(csq.toString().getBytes(StandardCharsets.UTF_8));
            return this;
        }

        @Override
        public Appendable append(CharSequence csq, int start, int end) throws IOException {
            this.out.write(csq.subSequence(start, end).toString().getBytes(StandardCharsets.UTF_8));
            return this;
        }

        @Override
        public Appendable append(char c) throws IOException {
            this.out.write(new String(new char[]{c}).getBytes(StandardCharsets.UTF_8));
            return this;
        }
    }

    private static class DoubleTypeAdapter
    implements JsonSerializer<Double>,
    JsonDeserializer<Double> {
        private DoubleTypeAdapter() {
        }

        public Double deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            return json.getAsDouble();
        }

        public JsonElement serialize(Double aDouble, Type type, JsonSerializationContext jsonSerializationContext) {
            if (aDouble == null) {
                return null;
            }
            double d = aDouble;
            if (d == (double)((long)d)) {
                return new JsonPrimitive((Number)((long)d));
            }
            return new JsonPrimitive((Number)aDouble);
        }
    }

    private static class ByteArrayToBase64TypeAdapter
    implements JsonSerializer<byte[]>,
    JsonDeserializer<byte[]> {
        private ByteArrayToBase64TypeAdapter() {
        }

        public byte[] deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            return Base64.decodeFast((String)json.getAsString());
        }

        public JsonElement serialize(byte[] src, Type typeOfSrc, JsonSerializationContext context) {
            return new JsonPrimitive(Base64.encodeToString((byte[])src));
        }
    }
}

