/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.security.util;

import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.PublicKey;
import java.security.interfaces.RSAPrivateCrtKey;
import java.security.interfaces.RSAPrivateKey;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.bouncycastle.crypto.AsymmetricBlockCipher;
import org.bouncycastle.crypto.Digest;
import org.bouncycastle.crypto.Signer;
import org.bouncycastle.crypto.engines.RSABlindedEngine;
import org.bouncycastle.crypto.params.AsymmetricKeyParameter;
import org.bouncycastle.crypto.params.RSAKeyParameters;
import org.bouncycastle.crypto.params.RSAPrivateCrtKeyParameters;
import org.bouncycastle.crypto.signers.PSSSigner;
import org.bouncycastle.operator.ContentVerifierProvider;
import org.bouncycastle.operator.DefaultDigestAlgorithmIdentifierFinder;
import org.bouncycastle.operator.DigestAlgorithmIdentifierFinder;
import org.bouncycastle.operator.OperatorCreationException;
import org.bouncycastle.operator.bc.BcContentVerifierProviderBuilder;
import org.bouncycastle.operator.bc.BcDSAContentVerifierProviderBuilder;
import org.xipki.pkcs11.wrapper.Functions;
import org.xipki.security.DHSigStaticKeyCertPair;
import org.xipki.security.HashAlgo;
import org.xipki.security.SignAlgo;
import org.xipki.security.XiSecurityException;
import org.xipki.security.bc.XiECContentVerifierProviderBuilder;
import org.xipki.security.bc.XiEdDSAContentVerifierProvider;
import org.xipki.security.bc.XiRSAContentVerifierProviderBuilder;
import org.xipki.security.bc.XiXDHContentVerifierProvider;
import org.xipki.security.util.KeyUtil;
import org.xipki.util.Args;

public class SignerUtil {
    private static final DigestAlgorithmIdentifierFinder DIGESTALG_IDENTIFIER_FINDER = new DefaultDigestAlgorithmIdentifierFinder();
    private static final Map<String, BcContentVerifierProviderBuilder> VERIFIER_PROVIDER_BUILDER = new HashMap<String, BcContentVerifierProviderBuilder>();

    private SignerUtil() {
    }

    public static RSAKeyParameters generateRSAPrivateKeyParameter(RSAPrivateKey key) {
        Args.notNull((Object)key, (String)"key");
        if (key instanceof RSAPrivateCrtKey) {
            RSAPrivateCrtKey rsaKey = (RSAPrivateCrtKey)key;
            return new RSAPrivateCrtKeyParameters(rsaKey.getModulus(), rsaKey.getPublicExponent(), rsaKey.getPrivateExponent(), rsaKey.getPrimeP(), rsaKey.getPrimeQ(), rsaKey.getPrimeExponentP(), rsaKey.getPrimeExponentQ(), rsaKey.getCrtCoefficient());
        }
        return new RSAKeyParameters(true, key.getModulus(), key.getPrivateExponent());
    }

    public static Signer createPSSRSASigner(SignAlgo sigAlgo) throws XiSecurityException {
        Args.notNull((Object)((Object)sigAlgo), (String)"sigAlgo");
        if (!sigAlgo.isRSAPSSSigAlgo()) {
            throw new XiSecurityException((Object)((Object)sigAlgo) + " is not an RSAPSS algorithm");
        }
        HashAlgo hashAlgo = sigAlgo.getHashAlgo();
        return new PSSSigner((AsymmetricBlockCipher)new RSABlindedEngine(), (Digest)hashAlgo.createDigest(), (Digest)hashAlgo.createDigest(), hashAlgo.getLength(), -68);
    }

    public static byte[] dsaSigPlainToX962(byte[] signature) throws XiSecurityException {
        Args.notNull((Object)signature, (String)"signature");
        byte[] x962Sig = Functions.dsaSigPlainToX962((byte[])signature);
        if (Arrays.equals(x962Sig, signature)) {
            throw new XiSecurityException("signature is not correctly encoded.");
        }
        return x962Sig;
    }

    public static byte[] dsaSigX962ToPlain(byte[] x962Signature, int orderBitLen) throws XiSecurityException {
        Args.notNull((Object)x962Signature, (String)"x962Signature");
        byte[] plainSig = Functions.dsaSigX962ToPlain((byte[])x962Signature, (int)((orderBitLen + 7) / 8));
        if (Arrays.equals(x962Signature, plainSig)) {
            throw new XiSecurityException("x962Signature is not correctly encoded.");
        }
        return plainSig;
    }

    public static byte[] dsaSigToPlain(BigInteger sigR, BigInteger sigS, int orderBitLen) throws XiSecurityException {
        int bitLenOfS;
        int blockSize = (orderBitLen + 7) / 8;
        int bitLenOfR = ((BigInteger)Args.notNull((Object)sigR, (String)"sigR")).bitLength();
        int bitLen = Math.max(bitLenOfR, bitLenOfS = ((BigInteger)Args.notNull((Object)sigS, (String)"sigS")).bitLength());
        if ((bitLen + 7) / 8 > blockSize) {
            throw new XiSecurityException("signature is too large");
        }
        byte[] plainSignature = new byte[2 * blockSize];
        SignerUtil.bigIntToBytes(sigR, plainSignature, 0, blockSize);
        SignerUtil.bigIntToBytes(sigS, plainSignature, blockSize, blockSize);
        return plainSignature;
    }

    private static void bigIntToBytes(BigInteger num, byte[] dest, int destPos, int length) {
        byte[] bytes = num.toByteArray();
        if (bytes.length == length) {
            System.arraycopy(bytes, 0, dest, destPos, length);
        } else if (bytes.length < length) {
            System.arraycopy(bytes, 0, dest, destPos + length - bytes.length, bytes.length);
        } else {
            System.arraycopy(bytes, bytes.length - length, dest, destPos, length);
        }
    }

    public static ContentVerifierProvider getContentVerifierProvider(PublicKey publicKey, DHSigStaticKeyCertPair ownerKeyAndCert) throws InvalidKeyException {
        Args.notNull((Object)publicKey, (String)"publicKey");
        String keyAlg = publicKey.getAlgorithm().toUpperCase();
        if ("ED25519".equals(keyAlg) || "ED448".equals(keyAlg)) {
            return new XiEdDSAContentVerifierProvider(publicKey);
        }
        if ("X25519".equals(keyAlg) || "X448".equals(keyAlg)) {
            if (ownerKeyAndCert == null) {
                throw new InvalidKeyException("ownerKeyAndCert is required but absent");
            }
            return new XiXDHContentVerifierProvider(publicKey, ownerKeyAndCert);
        }
        Object builder = VERIFIER_PROVIDER_BUILDER.get(keyAlg);
        if (builder == null) {
            if ("RSA".equals(keyAlg)) {
                builder = new XiRSAContentVerifierProviderBuilder();
            } else if ("DSA".equals(keyAlg)) {
                builder = new BcDSAContentVerifierProviderBuilder(DIGESTALG_IDENTIFIER_FINDER);
            } else if ("EC".equals(keyAlg) || "ECDSA".equals(keyAlg)) {
                builder = new XiECContentVerifierProviderBuilder();
            } else {
                throw new InvalidKeyException("unknown key algorithm of the public key " + keyAlg);
            }
            VERIFIER_PROVIDER_BUILDER.put(keyAlg, (BcContentVerifierProviderBuilder)builder);
        }
        AsymmetricKeyParameter keyParam = KeyUtil.generatePublicKeyParameter(publicKey);
        try {
            return builder.build(keyParam);
        }
        catch (OperatorCreationException ex) {
            throw new InvalidKeyException("could not build ContentVerifierProvider: " + ex.getMessage(), ex);
        }
    }
}

