/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.ca.mgmt.shell;

import java.io.File;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.List;
import java.util.Map;
import org.apache.karaf.shell.api.action.Argument;
import org.apache.karaf.shell.api.action.Command;
import org.apache.karaf.shell.api.action.Completion;
import org.apache.karaf.shell.api.action.Option;
import org.apache.karaf.shell.api.action.lifecycle.Service;
import org.apache.karaf.shell.support.completers.FileCompleter;
import org.xipki.ca.api.mgmt.CaConfs;
import org.xipki.ca.api.mgmt.CaMgmtException;
import org.xipki.ca.api.mgmt.CaSystemStatus;
import org.xipki.ca.mgmt.shell.CaActions;
import org.xipki.ca.mgmt.shell.CaCompleters;
import org.xipki.security.X509Cert;
import org.xipki.shell.CmdFailure;
import org.xipki.shell.Completers;
import org.xipki.util.CollectionUtil;
import org.xipki.util.IoUtil;

public class MiscCaActions {

    @Command(scope="ca", name="unlock", description="unlock CA system")
    @Service
    public static class Unlock
    extends CaActions.CaAction {
        protected Object execute0() throws Exception {
            try {
                this.caManager.unlockCa();
                this.println("unlocked CA system, calling ca:restart to restart CA system");
                return null;
            }
            catch (CaMgmtException ex) {
                throw new CmdFailure("could not unlock CA system, error: " + ex.getMessage(), (Throwable)ex);
            }
        }
    }

    @Command(scope="ca", name="system-status", description="show CA system status")
    @Service
    public static class SystemStatus
    extends CaActions.CaAction {
        protected Object execute0() throws Exception {
            CaSystemStatus status = this.caManager.getCaSystemStatus();
            if (status == null) {
                throw new CmdFailure("status is null");
            }
            this.println(status.toString());
            return null;
        }
    }

    @Command(scope="ca", name="restart", description="restart CA system")
    @Service
    public static class Restart
    extends CaActions.CaAction {
        protected Object execute0() throws Exception {
            try {
                this.caManager.restartCaSystem();
            }
            catch (CaMgmtException ex) {
                throw new CmdFailure("could not restart CA system, error: " + ex.getMessage(), (Throwable)ex);
            }
            StringBuilder sb = new StringBuilder("restarted CA system\n");
            sb.append("  successful CAs:\n");
            String prefix = "    ";
            this.printCaNames(sb, this.caManager.getSuccessfulCaNames(), prefix);
            sb.append("  failed CAs:\n");
            this.printCaNames(sb, this.caManager.getFailedCaNames(), prefix);
            sb.append("  inactive CAs:\n");
            this.printCaNames(sb, this.caManager.getInactiveCaNames(), prefix);
            this.print(sb.toString());
            return null;
        }
    }

    @Command(scope="ca", name="restart-ca", description="restart CA")
    @Service
    public static class RestartCa
    extends CaActions.CaAction {
        @Argument(index=0, name="name", required=true, description="CA name")
        @Completion(value=CaCompleters.CaNameCompleter.class)
        private String name;

        protected Object execute0() throws Exception {
            try {
                this.caManager.restartCa(this.name);
                System.out.println("restarted CA " + this.name);
            }
            catch (CaMgmtException ex) {
                throw new CmdFailure("could not restart CA " + this.name + ", error: " + ex.getMessage(), (Throwable)ex);
            }
            return null;
        }
    }

    @Command(scope="ca", name="republish", description="republish certificates")
    @Service
    public static class Republish
    extends CaActions.CaAction {
        @Option(name="--thread", description="number of threads")
        private Integer numThreads = 5;
        @Option(name="--ca", required=true, description="CA name")
        @Completion(value=CaCompleters.CaNameCompleter.class)
        private String caName;
        @Option(name="--publisher", required=true, multiValued=true, description="publisher name or 'all' for all publishers")
        @Completion(value=CaCompleters.PublisherNamePlusAllCompleter.class)
        private List<String> publisherNames;

        protected Object execute0() throws Exception {
            if (this.publisherNames == null) {
                throw new IllegalStateException("should not reach here");
            }
            boolean allPublishers = false;
            for (String publisherName : this.publisherNames) {
                if (!"all".equalsIgnoreCase(publisherName)) continue;
                allPublishers = true;
                break;
            }
            if (allPublishers) {
                this.publisherNames = null;
            }
            if ("all".equalsIgnoreCase(this.caName)) {
                this.caName = null;
            }
            String msg = "certificates";
            try {
                this.caManager.republishCertificates(this.caName, this.publisherNames, this.numThreads.intValue());
                this.println("republished " + msg);
                return null;
            }
            catch (CaMgmtException ex) {
                throw new CmdFailure("could not republish " + msg + ", error: " + ex.getMessage(), (Throwable)ex);
            }
        }
    }

    @Command(scope="ca", name="refresh-token", description="refresh token for signers")
    @Service
    public static class RefreshToken
    extends CaActions.CaAction {
        @Option(name="--type", required=true, description="type of the signer")
        @Completion(value=CaCompleters.SignerTypeCompleter.class)
        protected String type;

        protected Object execute0() throws Exception {
            this.caManager.refreshTokenForSignerType(this.type);
            this.println("refreshed token for signer type " + this.type);
            return null;
        }
    }

    @Command(scope="ca", name="notify-change", description="notify the change of CA system")
    @Service
    public static class NotifyChange
    extends CaActions.CaAction {
        protected Object execute0() throws Exception {
            String msg = "the change of CA system";
            try {
                this.caManager.notifyCaChange();
                this.println("notified " + msg);
                return null;
            }
            catch (CaMgmtException ex) {
                throw new CmdFailure("could not notify " + msg + ", error: " + ex.getMessage(), (Throwable)ex);
            }
        }
    }

    @Command(scope="ca", name="load-conf", description="load configuration")
    @Service
    public static class LoadConf
    extends CaActions.CaAction {
        @Option(name="--conf-file", description="CA system configuration file (XML or zip file")
        @Completion(value=FileCompleter.class)
        private String confFile;
        @Option(name="--outform", description="output format of the root certificates")
        @Completion(value=Completers.DerPemCompleter.class)
        protected String outform = "der";
        @Option(name="--out-dir", description="directory to save the root certificates")
        @Completion(value=FileCompleter.class)
        private String outDir = ".";

        protected Object execute0() throws Exception {
            String msg = "configuration " + this.confFile;
            try {
                InputStream confStream = this.confFile.endsWith(".json") ? CaConfs.convertFileConfToZip((String)this.confFile) : Files.newInputStream(Paths.get(this.confFile, new String[0]), new OpenOption[0]);
                Map rootCerts = this.caManager.loadConf(confStream);
                if (CollectionUtil.isEmpty((Map)rootCerts)) {
                    this.println("loaded " + msg);
                } else {
                    this.println("loaded " + msg);
                    for (String caname : rootCerts.keySet()) {
                        String filename = "ca-" + caname + ".crt";
                        this.saveVerbose("saved certificate of root CA " + caname + " to", new File(this.outDir, filename), LoadConf.encodeCert((byte[])((X509Cert)rootCerts.get(caname)).getEncoded(), (String)this.outform));
                    }
                }
                return null;
            }
            catch (CaMgmtException ex) {
                throw new CmdFailure("could not load " + msg + ", error: " + ex.getMessage(), (Throwable)ex);
            }
        }
    }

    @Command(scope="ca", name="export-conf", description="export configuration to zip file")
    @Service
    public static class ExportConf
    extends CaActions.CaAction {
        @Option(name="--conf-file", required=true, description="zip file that saves the exported configuration")
        @Completion(value=FileCompleter.class)
        private String confFile;
        @Option(name="--ca", multiValued=true, description="CAs whose configuration should be exported. Empty list means all CAs")
        @Completion(value=CaCompleters.CaNameCompleter.class)
        private List<String> caNames;

        protected Object execute0() throws Exception {
            String msg = "configuration to file " + this.confFile;
            try {
                InputStream is = this.caManager.exportConf(this.caNames);
                this.save(new File(this.confFile), IoUtil.read((InputStream)is));
                this.println("exported " + msg);
                return null;
            }
            catch (CaMgmtException ex) {
                throw new CmdFailure("could not export " + msg + ", error: " + ex.getMessage(), (Throwable)ex);
            }
        }
    }

    @Command(scope="ca", name="clear-publishqueue", description="clear publish queue")
    @Service
    public static class ClearPublishqueue
    extends CaActions.CaAction {
        @Option(name="--ca", required=true, description="CA name or 'all' for all CAs")
        @Completion(value=CaCompleters.CaNamePlusAllCompleter.class)
        private String caName;
        @Option(name="--publisher", required=true, multiValued=true, description="publisher name or 'all' for all publishers")
        @Completion(value=CaCompleters.PublisherNamePlusAllCompleter.class)
        private List<String> publisherNames;

        protected Object execute0() throws Exception {
            if (this.publisherNames == null) {
                throw new IllegalStateException("should not reach here");
            }
            boolean allPublishers = false;
            for (String publisherName : this.publisherNames) {
                if (!"all".equalsIgnoreCase(publisherName)) continue;
                allPublishers = true;
                break;
            }
            if (allPublishers) {
                this.publisherNames = null;
            }
            if ("all".equalsIgnoreCase(this.caName)) {
                this.caName = null;
            }
            String msg = "publish queue of CA " + this.caName + " for publishers " + ClearPublishqueue.toString(this.publisherNames);
            try {
                this.caManager.clearPublishQueue(this.caName, this.publisherNames);
                this.println("cleared " + msg);
                return null;
            }
            catch (CaMgmtException ex) {
                throw new CmdFailure("could not clear " + msg + ", error: " + ex.getMessage(), (Throwable)ex);
            }
        }
    }
}

