/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.ca.mgmt.shell;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.apache.karaf.shell.api.action.Argument;
import org.apache.karaf.shell.api.action.Command;
import org.apache.karaf.shell.api.action.Completion;
import org.apache.karaf.shell.api.action.Option;
import org.apache.karaf.shell.api.action.lifecycle.Service;
import org.apache.karaf.shell.support.completers.FileCompleter;
import org.xipki.ca.api.NameId;
import org.xipki.ca.api.mgmt.CaMgmtException;
import org.xipki.ca.api.mgmt.entry.CertprofileEntry;
import org.xipki.ca.mgmt.shell.CaActions;
import org.xipki.ca.mgmt.shell.CaCompleters;
import org.xipki.shell.CmdFailure;
import org.xipki.shell.IllegalCmdParamException;
import org.xipki.util.CollectionUtil;
import org.xipki.util.IoUtil;
import org.xipki.util.StringUtil;

public class ProfileCaActions {

    @Command(scope="ca", name="profile-up", description="update certificate profile")
    @Service
    public static class ProfileUp
    extends CaActions.CaAction {
        @Option(name="--name", aliases={"-n"}, required=true, description="profile name")
        @Completion(value=CaCompleters.ProfileNameCompleter.class)
        protected String name;
        @Option(name="--type", description="profile type")
        @Completion(value=CaCompleters.ProfileTypeCompleter.class)
        protected String type;
        @Option(name="--conf", description="certificate profile configuration or 'null'")
        protected String conf;
        @Option(name="--conf-file", description="certificate profile configuration file")
        @Completion(value=FileCompleter.class)
        protected String confFile;

        protected Object execute0() throws Exception {
            if (this.type == null && this.conf == null && this.confFile == null) {
                throw new IllegalCmdParamException("nothing to update");
            }
            if (this.conf == null && this.confFile != null) {
                this.conf = new String(IoUtil.read((String)this.confFile));
            }
            String msg = "certificate profile " + this.name;
            try {
                this.caManager.changeCertprofile(this.name, this.type, this.conf);
                this.println("updated " + msg);
                return null;
            }
            catch (CaMgmtException ex) {
                throw new CmdFailure("could not update " + msg + ", error: " + ex.getMessage(), (Throwable)ex);
            }
        }
    }

    @Command(scope="ca", name="profile-rm", description="remove certificate profile")
    @Service
    public static class ProfileRm
    extends CaActions.CaAction {
        @Argument(index=0, name="name", required=true, description="certificate profile name")
        @Completion(value=CaCompleters.ProfileNameCompleter.class)
        private String name;
        @Option(name="--force", aliases={"-f"}, description="without prompt")
        private Boolean force = Boolean.FALSE;

        protected Object execute0() throws Exception {
            String msg = "certificate profile " + this.name;
            if (this.force.booleanValue() || this.confirm("Do you want to remove " + msg, 3)) {
                try {
                    this.caManager.removeCertprofile(this.name);
                    this.println("removed " + msg);
                }
                catch (CaMgmtException ex) {
                    throw new CmdFailure("could not remove " + msg + ", error: " + ex.getMessage(), (Throwable)ex);
                }
            }
            return null;
        }
    }

    @Command(scope="ca", name="profile-info", description="show information of certificate profile")
    @Service
    public static class ProfileInfo
    extends CaActions.CaAction {
        @Argument(index=0, name="name", description="certificate profile name")
        @Completion(value=CaCompleters.ProfileNameCompleter.class)
        private String name;
        @Option(name="--verbose", aliases={"-v"}, description="show certificate profile information verbosely")
        private Boolean verbose = Boolean.FALSE;

        protected Object execute0() throws Exception {
            StringBuilder sb = new StringBuilder();
            if (this.name == null) {
                Set names = this.caManager.getCertprofileNames();
                int size = names.size();
                if (size == 0 || size == 1) {
                    sb.append(size == 0 ? "no" : "1");
                    sb.append(" profile is configured\n");
                } else {
                    sb.append(size).append(" profiles are configured:\n");
                }
                ArrayList sorted = new ArrayList(names);
                Collections.sort(sorted);
                for (String entry : sorted) {
                    sb.append("\t").append(entry).append("\n");
                }
            } else {
                CertprofileEntry entry = this.caManager.getCertprofile(this.name);
                if (entry == null) {
                    throw new CmdFailure("\tno certificate profile named '" + this.name + "' is configured");
                }
                sb.append(entry.toString(this.verbose.booleanValue()));
            }
            this.println(sb.toString());
            return null;
        }
    }

    @Command(scope="ca", name="profile-export", description="export certificate profile configuration")
    @Service
    public static class ProfileExport
    extends CaActions.CaAction {
        @Option(name="--name", aliases={"-n"}, required=true, description="profile name")
        @Completion(value=CaCompleters.ProfileNameCompleter.class)
        private String name;
        @Option(name="--out", aliases={"-o"}, required=true, description="where to save the profile configuration")
        @Completion(value=FileCompleter.class)
        private String confFile;

        protected Object execute0() throws Exception {
            CertprofileEntry entry = this.caManager.getCertprofile(this.name);
            if (entry == null) {
                throw new IllegalCmdParamException("no certificate profile named " + this.name + " is defined");
            }
            if (StringUtil.isBlank((String)entry.getConf())) {
                this.println("cert profile does not have conf");
            } else {
                this.saveVerbose("saved cert profile configuration to", this.confFile, StringUtil.toUtf8Bytes((String)entry.getConf()));
            }
            return null;
        }
    }

    @Command(scope="ca", name="profile-add", description="add certificate profile")
    @Service
    public static class ProfileAdd
    extends CaActions.CaAction {
        @Option(name="--name", aliases={"-n"}, required=true, description="profile name")
        private String name;
        @Option(name="--type", description="profile type")
        @Completion(value=CaCompleters.ProfileTypeCompleter.class)
        private String type = "xijson";
        @Option(name="--conf", description="certificate profile configuration")
        private String conf;
        @Option(name="--conf-file", description="certificate profile configuration file")
        @Completion(value=FileCompleter.class)
        private String confFile;

        protected Object execute0() throws Exception {
            if (this.conf == null && this.confFile != null) {
                this.conf = new String(IoUtil.read((String)this.confFile));
            }
            CertprofileEntry entry = new CertprofileEntry(new NameId(null, this.name), this.type, this.conf);
            String msg = "certificate profile " + this.name;
            try {
                this.caManager.addCertprofile(entry);
                this.println("added " + msg);
                return null;
            }
            catch (CaMgmtException ex) {
                throw new CmdFailure("could not add " + msg + ", error: " + ex.getMessage(), (Throwable)ex);
            }
        }
    }

    @Command(scope="ca", name="caprofile-rm", description="remove certificate profile from CA")
    @Service
    public static class CaprofileRm
    extends CaActions.CaAction {
        @Option(name="--ca", required=true, description="CA name")
        @Completion(value=CaCompleters.CaNameCompleter.class)
        private String caName;
        @Option(name="--profile", required=true, multiValued=true, description="certificate profile name")
        @Completion(value=CaCompleters.ProfileNameCompleter.class)
        private List<String> profileNames;
        @Option(name="--force", aliases={"-f"}, description="without prompt")
        private Boolean force = Boolean.FALSE;

        protected Object execute0() throws Exception {
            for (String profileName : this.profileNames) {
                String msg = StringUtil.concat((String)"certificate profile ", (String[])new String[]{profileName, " from CA ", this.caName});
                if (!this.force.booleanValue() && !this.confirm("Do you want to remove " + msg, 3)) continue;
                try {
                    this.caManager.removeCertprofileFromCa(profileName, this.caName);
                    this.println("removed " + msg);
                }
                catch (CaMgmtException ex) {
                    throw new CmdFailure("could not remove " + msg + ", error: " + ex.getMessage(), (Throwable)ex);
                }
            }
            return null;
        }
    }

    @Command(scope="ca", name="caprofile-info", description="show information of certificate profile in given CA")
    @Service
    public static class CaprofileInfo
    extends CaActions.CaAction {
        @Option(name="--ca", required=true, description="CA name")
        @Completion(value=CaCompleters.CaNameCompleter.class)
        private String caName;

        protected Object execute0() throws Exception {
            if (this.caManager.getCa(this.caName) == null) {
                throw new CmdFailure("could not find CA '" + this.caName + "'");
            }
            StringBuilder sb = new StringBuilder();
            Set entries = this.caManager.getCertprofilesForCa(this.caName);
            if (CollectionUtil.isNotEmpty((Collection)entries)) {
                sb.append("certificate Profiles supported by CA " + this.caName).append("\n");
                for (String name : entries) {
                    sb.append("\t").append(name).append("\n");
                }
            } else {
                sb.append("\tno profile for CA " + this.caName + " is configured");
            }
            this.println(sb.toString());
            return null;
        }
    }

    @Command(scope="ca", name="caprofile-add", description="add certificate profile to CA")
    @Service
    public static class CaprofileAdd
    extends CaActions.CaAction {
        @Option(name="--ca", required=true, description="CA name")
        @Completion(value=CaCompleters.CaNameCompleter.class)
        private String caName;
        @Option(name="--profile", required=true, multiValued=true, description="profile name")
        @Completion(value=CaCompleters.ProfileNameCompleter.class)
        private List<String> profileNames;

        protected Object execute0() throws Exception {
            for (String profileName : this.profileNames) {
                String msg = StringUtil.concat((String)"certificate profile ", (String[])new String[]{profileName, " to CA ", this.caName});
                try {
                    this.caManager.addCertprofileToCa(profileName, this.caName);
                    this.println("associated " + msg);
                }
                catch (CaMgmtException ex) {
                    throw new CmdFailure("could not associate " + msg + ", error: " + ex.getMessage(), (Throwable)ex);
                }
            }
            return null;
        }
    }
}

