/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.ca.mgmt.shell;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.apache.karaf.shell.api.action.Argument;
import org.apache.karaf.shell.api.action.Command;
import org.apache.karaf.shell.api.action.Completion;
import org.apache.karaf.shell.api.action.Option;
import org.apache.karaf.shell.api.action.lifecycle.Service;
import org.apache.karaf.shell.support.completers.FileCompleter;
import org.xipki.ca.api.NameId;
import org.xipki.ca.api.mgmt.CaMgmtException;
import org.xipki.ca.api.mgmt.entry.PublisherEntry;
import org.xipki.ca.mgmt.shell.CaActions;
import org.xipki.ca.mgmt.shell.CaCompleters;
import org.xipki.shell.CmdFailure;
import org.xipki.shell.IllegalCmdParamException;
import org.xipki.util.IoUtil;
import org.xipki.util.StringUtil;

public class PublisherCaActions {

    @Command(scope="ca", name="publisher-up", description="update publisher")
    @Service
    public static class PublisherUp
    extends CaActions.CaAction {
        @Option(name="--name", aliases={"-n"}, required=true, description="publisher name")
        @Completion(value=CaCompleters.PublisherNameCompleter.class)
        protected String name;
        @Option(name="--type", description="publisher type")
        @Completion(value=CaCompleters.PublisherTypeCompleter.class)
        protected String type;
        @Option(name="--conf", description="publisher configuration or 'null'")
        protected String conf;
        @Option(name="--conf-file", description="profile configuration file")
        @Completion(value=FileCompleter.class)
        protected String confFile;

        protected Object execute0() throws Exception {
            if (this.type == null && this.conf == null && this.confFile == null) {
                throw new IllegalCmdParamException("nothing to update");
            }
            if (this.conf == null && this.confFile != null) {
                this.conf = new String(IoUtil.read((String)this.confFile));
            }
            String msg = "publisher " + this.name;
            try {
                this.caManager.changePublisher(this.name, this.type, this.conf);
                this.println("updated " + msg);
                return null;
            }
            catch (CaMgmtException ex) {
                throw new CmdFailure("could not update " + msg + ", error: " + ex.getMessage(), (Throwable)ex);
            }
        }
    }

    @Command(scope="ca", name="publisher-rm", description="remove publisher")
    @Service
    public static class PublisherRm
    extends CaActions.CaAction {
        @Argument(index=0, name="name", required=true, description="publisher name")
        @Completion(value=CaCompleters.PublisherNameCompleter.class)
        private String name;
        @Option(name="--force", aliases={"-f"}, description="without prompt")
        private Boolean force = Boolean.FALSE;

        protected Object execute0() throws Exception {
            String msg = "publisher " + this.name;
            if (this.force.booleanValue() || this.confirm("Do you want to remove " + msg, 3)) {
                try {
                    this.caManager.removePublisher(this.name);
                    this.println("removed " + msg);
                }
                catch (CaMgmtException ex) {
                    throw new CmdFailure("could not remove " + msg + ", error: " + ex.getMessage(), (Throwable)ex);
                }
            }
            return null;
        }
    }

    @Command(scope="ca", name="publisher-info", description="show information of publisher")
    @Service
    public static class PublisherInfo
    extends CaActions.CaAction {
        @Argument(index=0, name="name", description="publisher name")
        @Completion(value=CaCompleters.PublisherNameCompleter.class)
        private String name;

        protected Object execute0() throws Exception {
            if (this.name == null) {
                Set names = this.caManager.getPublisherNames();
                int size = names.size();
                StringBuilder sb = new StringBuilder();
                if (size == 0 || size == 1) {
                    sb.append(size == 0 ? "no" : "1");
                    sb.append(" publisher is configured\n");
                } else {
                    sb.append(size).append(" publishers are configured:\n");
                }
                ArrayList sorted = new ArrayList(names);
                Collections.sort(sorted);
                for (String entry : sorted) {
                    sb.append("\t").append(entry).append("\n");
                }
                this.println(sb.toString());
            } else {
                PublisherEntry entry = this.caManager.getPublisher(this.name);
                if (entry == null) {
                    throw new CmdFailure("\tno publisher named '" + this.name + "' is configured");
                }
                this.println(entry.toString());
            }
            return null;
        }
    }

    @Command(scope="ca", name="publisher-export", description="export publisher configuration")
    @Service
    public static class PublisherExport
    extends CaActions.CaAction {
        @Option(name="--name", aliases={"-n"}, required=true, description="publisher name")
        @Completion(value=CaCompleters.PublisherNameCompleter.class)
        private String name;
        @Option(name="--out", aliases={"-o"}, required=true, description="where to save the publisher configuration")
        @Completion(value=FileCompleter.class)
        private String confFile;

        protected Object execute0() throws Exception {
            PublisherEntry entry = this.caManager.getPublisher(this.name);
            if (entry == null) {
                throw new IllegalCmdParamException("no publisher named " + this.name + " is defined");
            }
            if (StringUtil.isBlank((String)entry.getConf())) {
                this.println("publisher does not have conf");
            } else {
                this.saveVerbose("saved publisher configuration to", this.confFile, StringUtil.toUtf8Bytes((String)entry.getConf()));
            }
            return null;
        }
    }

    @Command(scope="ca", name="publisher-add", description="add publisher")
    @Service
    public static class PublisherAdd
    extends CaActions.CaAction {
        @Option(name="--name", aliases={"-n"}, required=true, description="publisher Name")
        private String name;
        @Option(name="--type", required=true, description="publisher type")
        @Completion(value=CaCompleters.PublisherTypeCompleter.class)
        private String type;
        @Option(name="--conf", description="publisher configuration")
        private String conf;
        @Option(name="--conf-file", description="publisher configuration file")
        @Completion(value=FileCompleter.class)
        private String confFile;

        protected Object execute0() throws Exception {
            if (this.conf == null && this.confFile != null) {
                this.conf = new String(IoUtil.read((String)this.confFile));
            }
            PublisherEntry entry = new PublisherEntry(new NameId(null, this.name), this.type, this.conf);
            String msg = "publisher " + this.name;
            try {
                this.caManager.addPublisher(entry);
                this.println("added " + msg);
                return null;
            }
            catch (CaMgmtException ex) {
                throw new CmdFailure("could not add " + msg + ", error: " + ex.getMessage(), (Throwable)ex);
            }
        }
    }

    @Command(scope="ca", name="capub-rm", description="remove publisher from CA")
    @Service
    public static class CapubRm
    extends CaActions.CaAction {
        @Option(name="--ca", required=true, description="CA name")
        @Completion(value=CaCompleters.CaNameCompleter.class)
        private String caName;
        @Option(name="--publisher", required=true, multiValued=true, description="publisher name")
        @Completion(value=CaCompleters.PublisherNameCompleter.class)
        private List<String> publisherNames;
        @Option(name="--force", aliases={"-f"}, description="without prompt")
        private Boolean force = Boolean.FALSE;

        protected Object execute0() throws Exception {
            for (String publisherName : this.publisherNames) {
                String msg = "publisher " + publisherName + " from CA " + this.caName;
                if (!this.force.booleanValue() && !this.confirm("Do you want to remove " + msg, 3)) continue;
                try {
                    this.caManager.removePublisherFromCa(publisherName, this.caName);
                    this.println("removed " + msg);
                }
                catch (CaMgmtException ex) {
                    throw new CmdFailure("could not remove " + msg + ", error: " + ex.getMessage(), (Throwable)ex);
                }
            }
            return null;
        }
    }

    @Command(scope="ca", name="capub-info", description="show information of publisher in given CA")
    @Service
    public static class CapubInfo
    extends CaActions.CaAction {
        @Option(name="--ca", required=true, description="CA name")
        @Completion(value=CaCompleters.CaNameCompleter.class)
        private String caName;

        protected Object execute0() throws Exception {
            if (this.caManager.getCa(this.caName) == null) {
                throw new CmdFailure("could not find CA '" + this.caName + "'");
            }
            List entries = this.caManager.getPublishersForCa(this.caName);
            if (CapubInfo.isNotEmpty((Collection)entries)) {
                StringBuilder sb = new StringBuilder();
                sb.append("publishers for CA ").append(this.caName).append("\n");
                for (PublisherEntry entry : entries) {
                    sb.append("\t").append(entry.getIdent().getName()).append("\n");
                }
                this.println(sb.toString());
            } else {
                this.println(StringUtil.concat((String)"no publisher for CA ", (String[])new String[]{this.caName, " is configured"}));
            }
            return null;
        }
    }

    @Command(scope="ca", name="capub-add", description="add publisher to CA")
    @Service
    public static class CapubAdd
    extends CaActions.CaAction {
        @Option(name="--ca", required=true, description="CA name")
        @Completion(value=CaCompleters.CaNameCompleter.class)
        private String caName;
        @Option(name="--publisher", required=true, multiValued=true, description="publisher name")
        @Completion(value=CaCompleters.PublisherNameCompleter.class)
        private List<String> publisherNames;

        protected Object execute0() throws Exception {
            for (String publisherName : this.publisherNames) {
                String msg = "publisher " + publisherName + " to CA " + this.caName;
                try {
                    this.caManager.addPublisherToCa(publisherName, this.caName);
                    this.println("added " + msg);
                }
                catch (CaMgmtException ex) {
                    throw new CmdFailure("could not add " + msg + ", error: " + ex.getMessage(), (Throwable)ex);
                }
            }
            return null;
        }
    }
}

