/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.ca.mgmt.shell;

import java.util.Map;
import java.util.Set;
import org.apache.karaf.shell.api.action.Argument;
import org.apache.karaf.shell.api.action.Command;
import org.apache.karaf.shell.api.action.Completion;
import org.apache.karaf.shell.api.action.Option;
import org.apache.karaf.shell.api.action.lifecycle.Service;
import org.xipki.ca.api.NameId;
import org.xipki.ca.api.mgmt.CaMgmtException;
import org.xipki.ca.api.mgmt.PermissionConstants;
import org.xipki.ca.api.mgmt.entry.AddUserEntry;
import org.xipki.ca.api.mgmt.entry.CaHasUserEntry;
import org.xipki.ca.api.mgmt.entry.ChangeUserEntry;
import org.xipki.ca.api.mgmt.entry.UserEntry;
import org.xipki.ca.mgmt.shell.CaActions;
import org.xipki.ca.mgmt.shell.CaCompleters;
import org.xipki.ca.mgmt.shell.ShellUtil;
import org.xipki.shell.CmdFailure;
import org.xipki.shell.IllegalCmdParamException;

public class UserCaActions {

    @Command(scope="ca", name="user-up", description="update user")
    @Service
    public static class UserUp
    extends CaActions.CaAction {
        @Option(name="--name", aliases={"-n"}, required=true, description="user Name")
        private String name;
        @Option(name="--active", description="activate this user")
        private Boolean active;
        @Option(name="--inactive", description="deactivate this user")
        private Boolean inactive;
        @Option(name="--password", description="user password, 'CONSOLE' to read from console")
        private String password;

        protected Object execute0() throws Exception {
            Boolean realActive;
            if (this.active != null) {
                if (this.inactive != null) {
                    throw new IllegalCmdParamException("maximal one of --active and --inactive can be set");
                }
                realActive = Boolean.TRUE;
            } else {
                realActive = this.inactive != null ? Boolean.FALSE : null;
            }
            ChangeUserEntry entry = new ChangeUserEntry(new NameId(null, this.name));
            if (realActive != null) {
                entry.setActive(realActive);
            }
            if ("CONSOLE".equalsIgnoreCase(this.password)) {
                this.password = new String(this.readPassword());
            }
            if (this.password != null) {
                entry.setPassword(this.password);
            }
            String msg = "user " + this.name;
            try {
                this.caManager.changeUser(entry);
                this.println("changed " + msg);
                return null;
            }
            catch (CaMgmtException ex) {
                throw new CmdFailure("could not change " + msg + ", error: " + ex.getMessage(), (Throwable)ex);
            }
        }
    }

    @Command(scope="ca", name="user-rm", description="remove user")
    @Service
    public static class UserRm
    extends CaActions.CaAction {
        @Option(name="--name", aliases={"-n"}, required=true, description="user Name")
        private String name;
        @Option(name="--force", aliases={"-f"}, description="without prompt")
        private Boolean force = Boolean.FALSE;

        protected Object execute0() throws Exception {
            String msg = "user " + this.name;
            if (this.force.booleanValue() || this.confirm("Do you want to remove " + msg, 3)) {
                try {
                    this.caManager.removeUser(this.name);
                    this.println("removed " + msg);
                }
                catch (CaMgmtException ex) {
                    throw new CmdFailure("could not remove " + msg + ", error: " + ex.getMessage(), (Throwable)ex);
                }
            }
            return null;
        }
    }

    @Command(scope="ca", name="user-info", description="show information of user")
    @Service
    public static class UserInfo
    extends CaActions.CaAction {
        @Argument(index=0, name="name", required=true, description="user name")
        private String name;

        protected Object execute0() throws Exception {
            UserEntry userEntry = this.caManager.getUser(this.name);
            if (userEntry == null) {
                throw new CmdFailure("no user named '" + this.name + "' is configured");
            }
            StringBuilder sb = new StringBuilder();
            sb.append(userEntry);
            Map caHasUsers = this.caManager.getCaHasUsersForUser(this.name);
            for (String ca : caHasUsers.keySet()) {
                CaHasUserEntry entry = (CaHasUserEntry)caHasUsers.get(ca);
                sb.append("\n----- CA ").append(ca).append("-----");
                sb.append("\nprofiles: ").append(entry.getProfiles());
                sb.append("\npermission: ").append(PermissionConstants.permissionToString((int)entry.getPermission()));
            }
            this.println(sb.toString());
            return null;
        }
    }

    @Command(scope="ca", name="user-add", description="add user")
    @Service
    public static class UserAdd
    extends CaActions.CaAction {
        @Option(name="--name", aliases={"-n"}, required=true, description="user Name")
        private String name;
        @Option(name="--password", description="user password")
        private String password;
        @Option(name="--inactive", description="do not activate this user")
        private Boolean inactive = Boolean.FALSE;

        protected Object execute0() throws Exception {
            if (this.password == null) {
                this.password = new String(this.readPassword());
            }
            AddUserEntry userEntry = new AddUserEntry(new NameId(null, this.name), this.inactive == false, this.password);
            String msg = "user " + this.name;
            try {
                this.caManager.addUser(userEntry);
                this.println("added " + msg);
                return null;
            }
            catch (CaMgmtException ex) {
                throw new CmdFailure("could not add " + msg + ", error: " + ex.getMessage(), (Throwable)ex);
            }
        }
    }

    @Command(scope="ca", name="causer-rm", description="remove user from CA")
    @Service
    public static class CauserRm
    extends CaActions.CaAction {
        @Option(name="--ca", required=true, description="CA name")
        @Completion(value=CaCompleters.CaNameCompleter.class)
        private String caName;
        @Option(name="--user", required=true, description="user name")
        private String userName;
        @Option(name="--force", aliases={"-f"}, description="without prompt")
        private Boolean force = Boolean.FALSE;

        protected Object execute0() throws Exception {
            String msg = "user " + this.userName + " from CA " + this.caName;
            if (this.force.booleanValue() || this.confirm("Do you want to remove " + msg, 3)) {
                try {
                    this.caManager.removeUserFromCa(this.userName, this.caName);
                    this.println("removed " + msg);
                }
                catch (CaMgmtException ex) {
                    throw new CmdFailure("could not remove " + msg + ", error: " + ex.getMessage(), (Throwable)ex);
                }
            }
            return null;
        }
    }

    @Command(scope="ca", name="causer-add", description="add user to CA")
    @Service
    public static class CauserAdd
    extends CaActions.CaAction {
        @Option(name="--ca", required=true, description="CA name")
        @Completion(value=CaCompleters.CaNameCompleter.class)
        private String caName;
        @Option(name="--user", required=true, description="user name")
        private String userName;
        @Option(name="--permission", required=true, multiValued=true, description="permission")
        @Completion(value=CaCompleters.PermissionCompleter.class)
        private Set<String> permissions;
        @Option(name="--profile", required=true, multiValued=true, description="profile name or 'all' for all profiles")
        @Completion(value=CaCompleters.ProfileNameAndAllCompleter.class)
        private Set<String> profiles;

        protected Object execute0() throws Exception {
            CaHasUserEntry entry = new CaHasUserEntry(new NameId(null, this.userName));
            entry.setProfiles(this.profiles);
            int intPermission = ShellUtil.getPermission(this.permissions);
            entry.setPermission(intPermission);
            String msg = "user " + this.userName + " to CA " + this.caName;
            try {
                this.caManager.addUserToCa(entry, this.caName);
                this.println("added " + msg);
                return null;
            }
            catch (CaMgmtException ex) {
                throw new CmdFailure("could not add " + msg + ", error: " + ex.getMessage(), (Throwable)ex);
            }
        }
    }
}

