/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.ca.mgmt.shell;

import java.io.File;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Set;
import org.apache.karaf.shell.api.action.Argument;
import org.apache.karaf.shell.api.action.Command;
import org.apache.karaf.shell.api.action.Completion;
import org.apache.karaf.shell.api.action.Option;
import org.apache.karaf.shell.api.action.lifecycle.Reference;
import org.apache.karaf.shell.api.action.lifecycle.Service;
import org.apache.karaf.shell.support.completers.FileCompleter;
import org.xipki.ca.api.CaUris;
import org.xipki.ca.api.NameId;
import org.xipki.ca.api.mgmt.CaManager;
import org.xipki.ca.api.mgmt.CaMgmtException;
import org.xipki.ca.api.mgmt.CaStatus;
import org.xipki.ca.api.mgmt.CmpControl;
import org.xipki.ca.api.mgmt.CrlControl;
import org.xipki.ca.api.mgmt.CtlogControl;
import org.xipki.ca.api.mgmt.ProtocolSupport;
import org.xipki.ca.api.mgmt.RevokeSuspendedControl;
import org.xipki.ca.api.mgmt.ScepControl;
import org.xipki.ca.api.mgmt.ValidityMode;
import org.xipki.ca.api.mgmt.entry.CaEntry;
import org.xipki.ca.api.mgmt.entry.ChangeCaEntry;
import org.xipki.ca.mgmt.shell.CaCompleters;
import org.xipki.ca.mgmt.shell.ShellUtil;
import org.xipki.password.PasswordResolver;
import org.xipki.security.CertRevocationInfo;
import org.xipki.security.CrlReason;
import org.xipki.security.SecurityFactory;
import org.xipki.security.X509Cert;
import org.xipki.security.util.X509Util;
import org.xipki.shell.CmdFailure;
import org.xipki.shell.Completers;
import org.xipki.shell.IllegalCmdParamException;
import org.xipki.shell.XiAction;
import org.xipki.util.Args;
import org.xipki.util.CollectionUtil;
import org.xipki.util.ConfPairs;
import org.xipki.util.DateUtil;
import org.xipki.util.IoUtil;
import org.xipki.util.StringUtil;
import org.xipki.util.Validity;

public class CaActions {

    @Command(scope="ca", name="ca-up", description="update CA")
    @Service
    public static class CaUp
    extends CaAction {
        @Option(name="--name", aliases={"-n"}, required=true, description="CA name")
        @Completion(value=CaCompleters.CaNameCompleter.class)
        private String caName;
        @Option(name="--sn-len", description="number of octets of the serial number, between 1 and 20")
        private Integer snLen;
        @Option(name="--status", description="CA status")
        @Completion(value=CaCompleters.CaStatusCompleter.class)
        private String caStatus;
        @Option(name="--ca-cert-uri", multiValued=true, description="CA certificate URI")
        private List<String> caCertUris;
        @Option(name="--ocsp-uri", multiValued=true, description="OCSP URI or 'null'")
        private List<String> ocspUris;
        @Option(name="--crl-uri", multiValued=true, description="CRL distribution point URI or 'null'")
        private List<String> crlUris;
        @Option(name="--deltacrl-uri", multiValued=true, description="delta CRL distribution point URI or 'null'")
        private List<String> deltaCrlUris;
        @Option(name="--permission", multiValued=true, description="permission")
        @Completion(value=CaCompleters.PermissionCompleter.class)
        private Set<String> permissions;
        @Option(name="--max-validity", description="maximal validity")
        private String maxValidity;
        @Option(name="--expiration-period", description="days before expiration time of CA to issue certificates")
        private Integer expirationPeriod;
        @Option(name="--keep-expired-certs", description="days to keep expired certificates")
        private Integer keepExpiredCertInDays;
        @Option(name="--crl-signer", description="CRL signer name or 'null'")
        @Completion(value=CaCompleters.SignerNamePlusNullCompleter.class)
        private String crlSignerName;
        @Option(name="--cmp-responder", description="CMP responder name or 'null'")
        @Completion(value=CaCompleters.SignerNamePlusNullCompleter.class)
        private String cmpResponderName;
        @Option(name="--scep-responder", description="SCEP responder name or 'null'")
        @Completion(value=CaCompleters.SignerNamePlusNullCompleter.class)
        private String scepResponderName;
        @Option(name="--cmp-control", description="CMP control or 'null'")
        private String cmpControl;
        @Option(name="--crl-control", description="CRL control or 'null'")
        private String crlControl;
        @Option(name="--scep-control", description="SCEP control or 'null'")
        private String scepControl;
        @Option(name="--ctlog-control", description="CT log control")
        private String ctlogControl;
        @Option(name="--dhpoc-control", description="DHPoc control")
        private String dhpocControl;
        @Option(name="--revoke-suspended-control", description="Revoke suspended certificates control")
        private String revokeSuspendedControl;
        @Option(name="--num-crls", description="number of CRLs to be kept in database")
        private Integer numCrls;
        @Option(name="--cert", description="CA certificate file")
        @Completion(value=FileCompleter.class)
        private String certFile;
        @Option(name="--certchain", multiValued=true, description="certificate chain of CA certificate")
        @Completion(value=FileCompleter.class)
        private List<String> issuerCertFiles;
        @Option(name="--signer-type", description="CA signer type")
        @Completion(value=CaCompleters.SignerTypeCompleter.class)
        private String signerType;
        @Option(name="--signer-conf", description="CA signer configuration or 'null'")
        private String signerConf;
        @Option(name="--support-cmp", description="whether the CMP protocol is supported")
        @Completion(value=Completers.YesNoCompleter.class)
        private String supportCmpS;
        @Option(name="--support-rest", description="whether the REST protocol is supported")
        @Completion(value=Completers.YesNoCompleter.class)
        private String supportRestS;
        @Option(name="--support-scep", description="whether the SCEP protocol is supported")
        @Completion(value=Completers.YesNoCompleter.class)
        private String supportScepS;
        @Option(name="--save-req", description="whether the request is saved")
        @Completion(value=Completers.YesNoCompleter.class)
        private String saveReqS;
        @Option(name="--validity-mode", description="mode of valditity")
        @Completion(value=CaCompleters.ValidityModeCompleter.class)
        private String validityModeS;
        @Option(name="--extra-control", description="extra control")
        private String extraControl;
        @Reference
        private PasswordResolver passwordResolver;

        protected ChangeCaEntry getChangeCaEntry() throws Exception {
            ChangeCaEntry entry = new ChangeCaEntry(new NameId(null, this.caName));
            if (this.snLen != null) {
                Args.range((int)this.snLen, (String)"sn-len", (int)1, (int)20);
                entry.setSerialNoLen(this.snLen);
            }
            if (this.caStatus != null) {
                entry.setStatus(CaStatus.forName((String)this.caStatus));
            }
            if (this.expirationPeriod != null && this.expirationPeriod < 0) {
                throw new IllegalCmdParamException("invalid expirationPeriod: " + this.expirationPeriod);
            }
            entry.setExpirationPeriod(this.expirationPeriod);
            if (this.keepExpiredCertInDays != null) {
                entry.setKeepExpiredCertInDays(this.keepExpiredCertInDays);
            }
            if (this.certFile != null) {
                entry.setEncodedCert(IoUtil.read((String)this.certFile));
            }
            if (CollectionUtil.isNotEmpty(this.issuerCertFiles)) {
                ArrayList<byte[]> list = new ArrayList<byte[]>(this.issuerCertFiles.size());
                for (String m : this.issuerCertFiles) {
                    if ("null".equalsIgnoreCase(m)) {
                        list.clear();
                        break;
                    }
                    list.add(X509Util.parseCert((File)Paths.get(m, new String[0]).toFile()).getEncoded());
                }
                entry.setEncodedCertchain(list);
            }
            if (this.signerConf != null) {
                String tmpSignerType = this.signerType;
                if (tmpSignerType == null) {
                    CaEntry caEntry = this.caManager.getCa(this.caName);
                    if (caEntry == null) {
                        throw new IllegalCmdParamException("please specify the signerType");
                    }
                    tmpSignerType = caEntry.getSignerType();
                }
                this.signerConf = ShellUtil.canonicalizeSignerConf(tmpSignerType, this.signerConf, this.passwordResolver, this.securityFactory);
                entry.setSignerConf(this.signerConf);
            }
            if (this.supportCmpS != null) {
                entry.setSupportCmp(Boolean.valueOf(CaUp.isEnabled((String)this.supportCmpS, (boolean)false, (String)"support-cmp")));
            }
            if (this.supportRestS != null) {
                entry.setSupportRest(Boolean.valueOf(CaUp.isEnabled((String)this.supportRestS, (boolean)false, (String)"support-rest")));
            }
            if (this.supportScepS != null) {
                entry.setSupportScep(Boolean.valueOf(CaUp.isEnabled((String)this.supportScepS, (boolean)false, (String)"support-scep")));
            }
            if (this.saveReqS != null) {
                entry.setSaveRequest(Boolean.valueOf(CaUp.isEnabled((String)this.saveReqS, (boolean)true, (String)"save-req")));
            }
            if (CollectionUtil.isNotEmpty(this.permissions)) {
                int intPermission = ShellUtil.getPermission(this.permissions);
                entry.setPermission(Integer.valueOf(intPermission));
            }
            CaUris caUris = new CaUris(CaUp.getUris(this.caCertUris), CaUp.getUris(this.ocspUris), CaUp.getUris(this.crlUris), CaUp.getUris(this.deltaCrlUris));
            entry.setCaUris(caUris);
            if (this.validityModeS != null) {
                ValidityMode validityMode = ValidityMode.forName((String)this.validityModeS);
                entry.setValidityMode(validityMode);
            }
            if (this.maxValidity != null) {
                entry.setMaxValidity(Validity.getInstance((String)this.maxValidity));
            }
            if (this.cmpControl != null) {
                entry.setCmpControl(this.cmpControl);
            }
            if (this.crlControl != null) {
                entry.setCrlControl(this.crlControl);
            }
            if (this.scepControl != null) {
                entry.setScepControl(this.scepControl);
            }
            if (this.ctlogControl != null) {
                entry.setCtlogControl(this.ctlogControl);
            }
            if (this.dhpocControl != null) {
                String tmp = ShellUtil.canonicalizeSignerConf("PKCS12", this.dhpocControl, this.passwordResolver, this.securityFactory);
                entry.setDhpocControl(tmp);
            }
            if (this.revokeSuspendedControl != null) {
                entry.setRevokeSuspendedControl(this.revokeSuspendedControl);
            }
            if (this.cmpResponderName != null) {
                entry.setCmpResponderName(this.cmpResponderName);
            }
            if (this.scepResponderName != null) {
                entry.setScepResponderName(this.scepResponderName);
            }
            if (this.crlSignerName != null) {
                entry.setCrlSignerName(this.crlSignerName);
            }
            if (this.extraControl != null) {
                entry.setExtraControl(new ConfPairs(this.extraControl).getEncoded());
            }
            if (this.numCrls != null) {
                entry.setNumCrls(this.numCrls);
            }
            return entry;
        }

        protected Object execute0() throws Exception {
            String msg = "CA " + this.caName;
            try {
                this.caManager.changeCa(this.getChangeCaEntry());
                this.println("updated " + msg);
                return null;
            }
            catch (CaMgmtException ex) {
                throw new CmdFailure("could not update " + msg + ", error: " + ex.getMessage(), (Throwable)ex);
            }
        }

        private static List<String> getUris(List<String> uris) {
            if (uris == null) {
                return null;
            }
            boolean clearUris = false;
            for (String uri : uris) {
                if (!"null".equalsIgnoreCase(uri)) continue;
                clearUris = true;
                break;
            }
            return clearUris ? Collections.emptyList() : new ArrayList<String>(uris);
        }
    }

    @Command(scope="ca", name="ca-unrevoke", description="unrevoke CA")
    @Service
    public static class CaUnrevoke
    extends CaAction {
        @Argument(index=0, name="name", required=true, description="CA name")
        @Completion(value=CaCompleters.CaNameCompleter.class)
        private String caName;

        protected Object execute0() throws Exception {
            if (!this.caManager.getCaNames().contains(this.caName)) {
                throw new IllegalCmdParamException("invalid CA name " + this.caName);
            }
            String msg = "CA " + this.caName;
            try {
                this.caManager.unrevokeCa(this.caName);
                this.println("unrevoked " + msg);
                return null;
            }
            catch (CaMgmtException ex) {
                throw new CmdFailure("could not unrevoke " + msg + ", error: " + ex.getMessage(), (Throwable)ex);
            }
        }
    }

    @Command(scope="ca", name="ca-revoke", description="revoke CA")
    @Service
    public static class CaRevoke
    extends CaAction {
        public static final List<CrlReason> PERMITTED_REASONS = Collections.unmodifiableList(Arrays.asList(CrlReason.UNSPECIFIED, CrlReason.KEY_COMPROMISE, CrlReason.CA_COMPROMISE, CrlReason.AFFILIATION_CHANGED, CrlReason.SUPERSEDED, CrlReason.CESSATION_OF_OPERATION, CrlReason.CERTIFICATE_HOLD, CrlReason.PRIVILEGE_WITHDRAWN));
        @Argument(index=0, name="name", description="CA name", required=true)
        @Completion(value=CaCompleters.CaNameCompleter.class)
        private String caName;
        @Option(name="--reason", required=true, description="CRL reason")
        @Completion(value=CaCompleters.CaCrlReasonCompleter.class)
        private String reason;
        @Option(name="--rev-date", valueToShowInHelp="current time", description="revocation date, UTC time of format yyyyMMddHHmmss")
        private String revocationDateS;
        @Option(name="--inv-date", description="invalidity date, UTC time of format yyyyMMddHHmmss")
        private String invalidityDateS;

        protected Object execute0() throws Exception {
            CrlReason crlReason = CrlReason.forNameOrText((String)this.reason);
            if (!PERMITTED_REASONS.contains(crlReason)) {
                throw new IllegalCmdParamException("reason " + this.reason + " is not permitted");
            }
            if (!this.caManager.getCaNames().contains(this.caName)) {
                throw new IllegalCmdParamException("invalid CA name " + this.caName);
            }
            Date revocationDate = CaRevoke.isNotBlank((String)this.revocationDateS) ? DateUtil.parseUtcTimeyyyyMMddhhmmss((String)this.revocationDateS) : new Date();
            Date invalidityDate = null;
            if (CaRevoke.isNotBlank((String)this.invalidityDateS)) {
                invalidityDate = DateUtil.parseUtcTimeyyyyMMddhhmmss((String)this.invalidityDateS);
            }
            CertRevocationInfo revInfo = new CertRevocationInfo(crlReason, revocationDate, invalidityDate);
            String msg = "CA " + this.caName;
            try {
                this.caManager.revokeCa(this.caName, revInfo);
                this.println("revoked " + msg);
                return null;
            }
            catch (CaMgmtException ex) {
                throw new CmdFailure("could not revoke " + msg + ", error: " + ex.getMessage(), (Throwable)ex);
            }
        }
    }

    @Command(scope="ca", name="ca-rm", description="remove CA")
    @Service
    public static class CaRm
    extends CaAction {
        @Argument(index=0, name="name", required=true, description="CA name")
        @Completion(value=CaCompleters.CaNameCompleter.class)
        private String name;
        @Option(name="--force", aliases={"-f"}, description="without prompt")
        private Boolean force = Boolean.FALSE;

        protected Object execute0() throws Exception {
            String msg = "CA " + this.name;
            if (this.force.booleanValue() || this.confirm("Do you want to remove " + msg, 3)) {
                try {
                    this.caManager.removeCa(this.name);
                    this.println("removed " + msg);
                }
                catch (CaMgmtException ex) {
                    throw new CmdFailure("could not remove " + msg + ", error: " + ex.getMessage(), (Throwable)ex);
                }
            }
            return null;
        }
    }

    @Command(scope="ca", name="ca-info", description="show information of CA")
    @Service
    public static class CaInfo
    extends CaAction {
        @Argument(index=0, name="name", description="CA name")
        @Completion(value=CaCompleters.CaNameCompleter.class)
        private String name;
        @Option(name="--verbose", aliases={"-v"}, description="show CA information verbosely")
        private Boolean verbose = Boolean.FALSE;

        protected Object execute0() throws Exception {
            StringBuilder sb = new StringBuilder();
            if (this.name == null) {
                sb.append("successful CAs:\n");
                String prefix = "  ";
                this.printCaNames(sb, this.caManager.getSuccessfulCaNames(), prefix);
                sb.append("failed CAs:\n");
                this.printCaNames(sb, this.caManager.getFailedCaNames(), prefix);
                sb.append("inactive CAs:\n");
                this.printCaNames(sb, this.caManager.getInactiveCaNames(), prefix);
            } else {
                CaEntry entry = this.caManager.getCa(this.name);
                if (entry == null) {
                    throw new CmdFailure("could not find CA '" + this.name + "'");
                }
                if (CaStatus.ACTIVE == entry.getStatus()) {
                    boolean started = this.caManager.getSuccessfulCaNames().contains(entry.getIdent().getName());
                    sb.append("started: ").append(started).append("\n");
                }
                Set aliases = this.caManager.getAliasesForCa(this.name);
                sb.append("aliases: ").append(CaInfo.toString(aliases)).append("\n");
                sb.append(entry.toString(this.verbose.booleanValue()));
            }
            this.println(sb.toString());
            return null;
        }
    }

    @Command(scope="ca", name="gen-rootca", description="generate selfsigned CA")
    @Service
    public static class GenRootca
    extends CaAddOrGenAction {
        @Option(name="--subject", required=true, description="subject of the Root CA")
        private String subject;
        @Option(name="--profile", required=true, description="profile of the Root CA")
        private String rootcaProfile;
        @Option(name="--serial", description="serial number of the Root CA")
        private String serialS;
        @Option(name="--outform", description="output format of the certificate")
        @Completion(value=Completers.DerPemCompleter.class)
        protected String outform = "der";
        @Option(name="--out", aliases={"-o"}, description="where to save the generated CA certificate")
        @Completion(value=FileCompleter.class)
        private String rootcaCertOutFile;

        protected Object execute0() throws Exception {
            CaEntry caEntry = this.getCaEntry();
            X509Cert rootcaCert = this.caManager.generateRootCa(caEntry, this.rootcaProfile, this.subject, this.serialS);
            if (this.rootcaCertOutFile != null) {
                this.saveVerbose("saved root certificate to file", this.rootcaCertOutFile, GenRootca.encodeCert((byte[])rootcaCert.getEncoded(), (String)this.outform));
            }
            this.println("generated root CA " + caEntry.getIdent().getName());
            return null;
        }
    }

    @Command(scope="ca", name="caalias-rm", description="remove CA alias")
    @Service
    public static class CaaliasRm
    extends CaAction {
        @Argument(index=0, name="alias", description="CA alias", required=true)
        @Completion(value=CaCompleters.CaAliasCompleter.class)
        private String caAlias;
        @Option(name="--force", aliases={"-f"}, description="without prompt")
        private Boolean force = Boolean.FALSE;

        protected Object execute0() throws Exception {
            String msg = "CA alias " + this.caAlias;
            if (this.force.booleanValue() || this.confirm("Do you want to remove " + msg, 3)) {
                try {
                    this.caManager.removeCaAlias(this.caAlias);
                    this.println("removed " + msg);
                }
                catch (CaMgmtException ex) {
                    throw new CmdFailure("could not remove " + msg + ", error: " + ex.getMessage(), (Throwable)ex);
                }
            }
            return null;
        }
    }

    @Command(scope="ca", name="caalias-info", description="show information of CA alias")
    @Service
    public static class CaaliasInfo
    extends CaAction {
        @Argument(index=0, name="alias", description="CA alias")
        @Completion(value=CaCompleters.CaAliasCompleter.class)
        private String caAlias;

        protected Object execute0() throws Exception {
            Set aliasNames = this.caManager.getCaAliasNames();
            StringBuilder sb = new StringBuilder();
            if (this.caAlias == null) {
                int size = aliasNames.size();
                if (size == 0 || size == 1) {
                    sb.append(size == 0 ? "no" : "1");
                    sb.append(" CA alias is configured\n");
                } else {
                    sb.append(size).append(" CA aliases are configured:\n");
                }
                ArrayList sorted = new ArrayList(aliasNames);
                Collections.sort(sorted);
                for (String aliasName : sorted) {
                    sb.append("\t").append(aliasName).append("\n");
                }
            } else if (aliasNames.contains(this.caAlias)) {
                String paramValue = this.caManager.getCaNameForAlias(this.caAlias);
                sb.append(this.caAlias).append("\n\t").append(paramValue);
            } else {
                throw new CmdFailure("could not find CA alias '" + this.caAlias + "'");
            }
            this.println(sb.toString());
            return null;
        }
    }

    @Command(scope="ca", name="caalias-add", description="add CA alias")
    @Service
    public static class CaaliasAdd
    extends CaAction {
        @Option(name="--ca", required=true, description="CA name")
        @Completion(value=CaCompleters.CaNameCompleter.class)
        private String caName;
        @Option(name="--alias", required=true, description="CA alias")
        private String caAlias;

        protected Object execute0() throws Exception {
            String msg = "CA alias " + this.caAlias + " associated with CA " + this.caName;
            try {
                this.caManager.addCaAlias(this.caAlias, this.caName);
                this.println("added " + msg);
                return null;
            }
            catch (CaMgmtException ex) {
                throw new CmdFailure("could not add " + msg + ", error: " + ex.getMessage(), (Throwable)ex);
            }
        }
    }

    public static abstract class CaAddOrGenAction
    extends CaAction {
        @Option(name="--name", aliases={"-n"}, required=true, description="CA name")
        private String caName;
        @Option(name="--status", description="CA status")
        @Completion(value=CaCompleters.CaStatusCompleter.class)
        private String caStatus = "active";
        @Option(name="--ca-cert-uri", multiValued=true, description="CA certificate URI")
        private List<String> caCertUris;
        @Option(name="--ocsp-uri", multiValued=true, description="OCSP URI")
        private List<String> ocspUris;
        @Option(name="--crl-uri", multiValued=true, description="CRL distribution point")
        private List<String> crlUris;
        @Option(name="--deltacrl-uri", multiValued=true, description="Delta CRL distribution point")
        private List<String> deltaCrlUris;
        @Option(name="--permission", required=true, multiValued=true, description="permission")
        @Completion(value=CaCompleters.PermissionCompleter.class)
        private Set<String> permissions;
        @Option(name="--sn-len", description="number of bytes of the serial number, between 1 and 20")
        private int snLen = 20;
        @Option(name="--next-crl-no", required=true, description="CRL number for the next CRL")
        private Long nextCrlNumber;
        @Option(name="--max-validity", required=true, description="maximal validity")
        private String maxValidity;
        @Option(name="--keep-expired-certs", description="days to keep expired certificates")
        private Integer keepExpiredCertInDays = -1;
        @Option(name="--crl-signer", description="CRL signer name")
        @Completion(value=CaCompleters.SignerNameCompleter.class)
        private String crlSignerName;
        @Option(name="--cmp-responder", description="CMP responder name")
        @Completion(value=CaCompleters.SignerNameCompleter.class)
        private String cmpResponderName;
        @Option(name="--scep-responder", description="SCEP responder name")
        @Completion(value=CaCompleters.SignerNameCompleter.class)
        private String scepResponderName;
        @Option(name="--cmp-control", description="CMP control")
        private String cmpControl;
        @Option(name="--crl-control", description="CRL control")
        private String crlControl;
        @Option(name="--scep-control", description="SCEP control")
        private String scepControl;
        @Option(name="--ctlog-control", description="CT log control")
        private String ctlogControl;
        @Option(name="--dhpoc-control", description="DHPoc control")
        private String dhpocControl;
        @Option(name="--revoke-suspended-control", description="Revoke suspended certificates control")
        private String revokeSuspendedControl;
        @Option(name="--num-crls", description="number of CRLs to be kept in database")
        private Integer numCrls = 30;
        @Option(name="--expiration-period", description="days before expiration time of CA to issue certificates")
        private Integer expirationPeriod = 365;
        @Option(name="--signer-type", required=true, description="CA signer type")
        @Completion(value=CaCompleters.SignerTypeCompleter.class)
        private String signerType;
        @Option(name="--signer-conf", required=true, description="CA signer configuration")
        private String signerConf;
        @Option(name="--support-cmp", description="whether the CMP protocol is supported")
        @Completion(value=Completers.YesNoCompleter.class)
        private String supportCmpS = "no";
        @Option(name="--support-rest", description="whether the REST protocol is supported")
        @Completion(value=Completers.YesNoCompleter.class)
        private String supportRestS = "no";
        @Option(name="--support-scep", description="whether the SCEP protocol is supported")
        @Completion(value=Completers.YesNoCompleter.class)
        private String supportScepS = "no";
        @Option(name="--save-req", description="whether the request is saved")
        @Completion(value=Completers.YesNoCompleter.class)
        private String saveReqS = "no";
        @Option(name="--validity-mode", description="mode of valditity")
        @Completion(value=CaCompleters.ValidityModeCompleter.class)
        private String validityModeS = "STRICT";
        @Option(name="--extra-control", description="extra control")
        private String extraControl;
        @Reference
        private PasswordResolver passwordResolver;

        protected CaEntry getCaEntry() throws Exception {
            Args.range((int)this.snLen, (String)"snLen", (int)1, (int)20);
            if (this.nextCrlNumber < 1L) {
                throw new IllegalCmdParamException("invalid CRL number: " + this.nextCrlNumber);
            }
            if (this.numCrls < 0) {
                throw new IllegalCmdParamException("invalid numCrls: " + this.numCrls);
            }
            if (this.expirationPeriod < 0) {
                throw new IllegalCmdParamException("invalid expirationPeriod: " + this.expirationPeriod);
            }
            if ("PKCS12".equalsIgnoreCase(this.signerType) || "JCEKS".equalsIgnoreCase(this.signerType)) {
                this.signerConf = ShellUtil.canonicalizeSignerConf(this.signerType, this.signerConf, this.passwordResolver, this.securityFactory);
            }
            CaUris caUris = new CaUris(this.caCertUris, this.ocspUris, this.crlUris, this.deltaCrlUris);
            CaEntry entry = new CaEntry(new NameId(null, this.caName), this.snLen, this.nextCrlNumber.longValue(), this.signerType, this.signerConf, caUris, this.numCrls.intValue(), this.expirationPeriod.intValue());
            entry.setKeepExpiredCertInDays(this.keepExpiredCertInDays.intValue());
            ProtocolSupport protocolSupport = new ProtocolSupport(CaAddOrGenAction.isEnabled((String)this.supportCmpS, (boolean)false, (String)"support-cmp"), CaAddOrGenAction.isEnabled((String)this.supportRestS, (boolean)false, (String)"support-rest"), CaAddOrGenAction.isEnabled((String)this.supportScepS, (boolean)false, (String)"support-scep"));
            entry.setProtocolSupport(protocolSupport);
            entry.setSaveRequest(CaAddOrGenAction.isEnabled((String)this.saveReqS, (boolean)false, (String)"save-req"));
            ValidityMode validityMode = ValidityMode.forName((String)this.validityModeS);
            entry.setValidityMode(validityMode);
            entry.setStatus(CaStatus.forName((String)this.caStatus));
            if (this.cmpControl != null) {
                entry.setCmpControl(new CmpControl(this.cmpControl));
            }
            if (this.crlControl != null) {
                entry.setCrlControl(new CrlControl(this.crlControl));
            }
            if (this.scepControl != null) {
                entry.setScepControl(new ScepControl(this.scepControl));
            }
            if (this.ctlogControl != null) {
                entry.setCtlogControl(new CtlogControl(this.ctlogControl));
            }
            if (this.dhpocControl != null) {
                String conf = this.dhpocControl;
                if (conf.contains("file:")) {
                    ConfPairs confPairs = new ConfPairs(conf);
                    entry.setDhpocControl(this.embedFileContent(confPairs).getEncoded());
                } else {
                    entry.setDhpocControl(this.dhpocControl);
                }
            }
            if (this.revokeSuspendedControl != null) {
                entry.setRevokeSuspendedControl(new RevokeSuspendedControl(new ConfPairs(this.revokeSuspendedControl)));
            }
            if (this.cmpResponderName != null) {
                entry.setCmpResponderName(this.cmpResponderName);
            }
            if (this.scepResponderName != null) {
                entry.setCmpResponderName(this.scepResponderName);
            }
            if (this.crlSignerName != null) {
                entry.setCrlSignerName(this.crlSignerName);
            }
            Validity tmpMaxValidity = Validity.getInstance((String)this.maxValidity);
            entry.setMaxValidity(tmpMaxValidity);
            entry.setKeepExpiredCertInDays(this.keepExpiredCertInDays.intValue());
            int intPermission = ShellUtil.getPermission(this.permissions);
            entry.setPermission(intPermission);
            if (this.extraControl != null) {
                this.extraControl = this.extraControl.trim();
            }
            if (StringUtil.isNotBlank((String)this.extraControl)) {
                entry.setExtraControl(new ConfPairs(this.extraControl).unmodifiable());
            }
            return entry;
        }
    }

    @Command(scope="ca", name="ca-add", description="add CA")
    @Service
    public static class CaAdd
    extends CaAddOrGenAction {
        @Option(name="--cert", description="CA certificate file")
        @Completion(value=FileCompleter.class)
        private String certFile;
        @Option(name="--certchain", multiValued=true, description="certificate chain of CA certificate")
        @Completion(value=FileCompleter.class)
        private List<String> issuerCertFiles;

        protected Object execute0() throws Exception {
            CaEntry caEntry = this.getCaEntry();
            if (this.certFile != null) {
                X509Cert caCert = X509Util.parseCert((File)new File(this.certFile));
                caEntry.setCert(caCert);
            }
            if (CollectionUtil.isNotEmpty(this.issuerCertFiles)) {
                ArrayList<X509Cert> list = new ArrayList<X509Cert>(this.issuerCertFiles.size());
                for (String m : this.issuerCertFiles) {
                    list.add(X509Util.parseCert((File)Paths.get(m, new String[0]).toFile()));
                }
                caEntry.setCertchain(list);
            }
            String msg = "CA " + caEntry.getIdent().getName();
            try {
                this.caManager.addCa(caEntry);
                this.println("added " + msg);
                return null;
            }
            catch (CaMgmtException ex) {
                throw new CmdFailure("could not add " + msg + ", error: " + ex.getMessage(), (Throwable)ex);
            }
        }
    }

    public static abstract class CaAction
    extends XiAction {
        @Reference
        protected CaManager caManager;
        @Reference
        protected SecurityFactory securityFactory;

        protected static String toString(Collection<?> col) {
            if (col == null) {
                return "null";
            }
            StringBuilder sb = new StringBuilder();
            sb.append("{");
            int size = col.size();
            int idx = 0;
            for (Object o : col) {
                sb.append(o);
                if (idx < size - 1) {
                    sb.append(", ");
                }
                ++idx;
            }
            sb.append("}");
            return sb.toString();
        }

        protected void printCaNames(StringBuilder sb, Set<String> caNames, String prefix) throws CaMgmtException {
            if (caNames.isEmpty()) {
                sb.append(prefix).append("-\n");
                return;
            }
            for (String caName : caNames) {
                Set aliases = this.caManager.getAliasesForCa(caName);
                if (CollectionUtil.isEmpty((Collection)aliases)) {
                    sb.append(prefix).append(caName);
                } else {
                    sb.append(prefix).append(caName).append(" (aliases ").append(aliases).append(")");
                }
                sb.append("\n");
            }
        }
    }
}

