/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.ca.mgmt.shell;

import java.io.File;
import java.io.InputStream;
import java.math.BigInteger;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.karaf.shell.api.action.Argument;
import org.apache.karaf.shell.api.action.Command;
import org.apache.karaf.shell.api.action.Completion;
import org.apache.karaf.shell.api.action.Option;
import org.apache.karaf.shell.api.action.lifecycle.Reference;
import org.apache.karaf.shell.api.action.lifecycle.Service;
import org.apache.karaf.shell.support.completers.FileCompleter;
import org.bouncycastle.asn1.x509.Certificate;
import org.xipki.ca.api.CaUris;
import org.xipki.ca.api.NameId;
import org.xipki.ca.api.mgmt.CaConfs;
import org.xipki.ca.api.mgmt.CaManager;
import org.xipki.ca.api.mgmt.CaMgmtException;
import org.xipki.ca.api.mgmt.CaStatus;
import org.xipki.ca.api.mgmt.CaSystemStatus;
import org.xipki.ca.api.mgmt.CmpControl;
import org.xipki.ca.api.mgmt.CrlControl;
import org.xipki.ca.api.mgmt.CtlogControl;
import org.xipki.ca.api.mgmt.MgmtEntry;
import org.xipki.ca.api.mgmt.PermissionConstants;
import org.xipki.ca.api.mgmt.ProtocolSupport;
import org.xipki.ca.api.mgmt.RevokeSuspendedControl;
import org.xipki.ca.api.mgmt.ScepControl;
import org.xipki.ca.api.mgmt.ValidityMode;
import org.xipki.ca.mgmt.shell.CaCompleters;
import org.xipki.ca.mgmt.shell.ShellUtil;
import org.xipki.password.PasswordResolver;
import org.xipki.security.CertRevocationInfo;
import org.xipki.security.CrlReason;
import org.xipki.security.HashAlgo;
import org.xipki.security.SecurityFactory;
import org.xipki.security.util.X509Util;
import org.xipki.shell.CmdFailure;
import org.xipki.shell.Completers;
import org.xipki.shell.IllegalCmdParamException;
import org.xipki.shell.XiAction;
import org.xipki.util.Args;
import org.xipki.util.Base64;
import org.xipki.util.CollectionUtil;
import org.xipki.util.ConfPairs;
import org.xipki.util.DateUtil;
import org.xipki.util.IoUtil;
import org.xipki.util.StringUtil;
import org.xipki.util.Validity;

public class CaActions {

    @Command(scope="ca", name="user-up", description="update user")
    @Service
    public static class UserUp
    extends CaAction {
        @Option(name="--name", aliases={"-n"}, required=true, description="user Name")
        private String name;
        @Option(name="--active", description="activate this user")
        private Boolean active;
        @Option(name="--inactive", description="deactivate this user")
        private Boolean inactive;
        @Option(name="--password", description="user password, 'CONSOLE' to read from console")
        private String password;

        protected Object execute0() throws Exception {
            Boolean realActive;
            if (this.active != null) {
                if (this.inactive != null) {
                    throw new IllegalCmdParamException("maximal one of --active and --inactive can be set");
                }
                realActive = Boolean.TRUE;
            } else {
                realActive = this.inactive != null ? Boolean.FALSE : null;
            }
            MgmtEntry.ChangeUser entry = new MgmtEntry.ChangeUser(new NameId(null, this.name));
            if (realActive != null) {
                entry.setActive(realActive);
            }
            if ("CONSOLE".equalsIgnoreCase(this.password)) {
                this.password = new String(this.readPassword());
            }
            if (this.password != null) {
                entry.setPassword(this.password);
            }
            String msg = "user " + this.name;
            try {
                this.caManager.changeUser(entry);
                this.println("changed " + msg);
                return null;
            }
            catch (CaMgmtException ex) {
                throw new CmdFailure("could not change " + msg + ", error: " + ex.getMessage(), (Throwable)ex);
            }
        }
    }

    @Command(scope="ca", name="user-rm", description="remove user")
    @Service
    public static class UserRm
    extends CaAction {
        @Option(name="--name", aliases={"-n"}, required=true, description="user Name")
        private String name;
        @Option(name="--force", aliases={"-f"}, description="without prompt")
        private Boolean force = Boolean.FALSE;

        protected Object execute0() throws Exception {
            String msg = "user " + this.name;
            if (this.force.booleanValue() || this.confirm("Do you want to remove " + msg, 3)) {
                try {
                    this.caManager.removeUser(this.name);
                    this.println("removed " + msg);
                }
                catch (CaMgmtException ex) {
                    throw new CmdFailure("could not remove " + msg + ", error: " + ex.getMessage(), (Throwable)ex);
                }
            }
            return null;
        }
    }

    @Command(scope="ca", name="user-info", description="show information of user")
    @Service
    public static class UserInfo
    extends CaAction {
        @Argument(index=0, name="name", required=true, description="user name")
        private String name;

        protected Object execute0() throws Exception {
            MgmtEntry.User userEntry = this.caManager.getUser(this.name);
            if (userEntry == null) {
                throw new CmdFailure("no user named '" + this.name + "' is configured");
            }
            StringBuilder sb = new StringBuilder();
            sb.append(userEntry);
            Map caHasUsers = this.caManager.getCaHasUsersForUser(this.name);
            for (String ca : caHasUsers.keySet()) {
                MgmtEntry.CaHasUser entry = (MgmtEntry.CaHasUser)caHasUsers.get(ca);
                sb.append("\n----- CA ").append(ca).append("-----");
                sb.append("\nprofiles: ").append(entry.getProfiles());
                sb.append("\npermission: ").append(PermissionConstants.permissionToString((int)entry.getPermission()));
            }
            this.println(sb.toString());
            return null;
        }
    }

    @Command(scope="ca", name="user-add", description="add user")
    @Service
    public static class UserAdd
    extends CaAction {
        @Option(name="--name", aliases={"-n"}, required=true, description="user Name")
        private String name;
        @Option(name="--password", description="user password")
        private String password;
        @Option(name="--inactive", description="do not activate this user")
        private Boolean inactive = Boolean.FALSE;

        protected Object execute0() throws Exception {
            if (this.password == null) {
                this.password = new String(this.readPassword());
            }
            MgmtEntry.AddUser userEntry = new MgmtEntry.AddUser(new NameId(null, this.name), this.inactive == false, this.password);
            String msg = "user " + this.name;
            try {
                this.caManager.addUser(userEntry);
                this.println("added " + msg);
                return null;
            }
            catch (CaMgmtException ex) {
                throw new CmdFailure("could not add " + msg + ", error: " + ex.getMessage(), (Throwable)ex);
            }
        }
    }

    @Command(scope="ca", name="unlock", description="unlock CA system")
    @Service
    public static class Unlock
    extends CaAction {
        protected Object execute0() throws Exception {
            try {
                this.caManager.unlockCa();
                this.println("unlocked CA system, calling ca:restart to restart CA system");
                return null;
            }
            catch (CaMgmtException ex) {
                throw new CmdFailure("could not unlock CA system, error: " + ex.getMessage(), (Throwable)ex);
            }
        }
    }

    @Command(scope="ca", name="system-status", description="show CA system status")
    @Service
    public static class SystemStatus
    extends CaAction {
        protected Object execute0() throws Exception {
            CaSystemStatus status = this.caManager.getCaSystemStatus();
            if (status == null) {
                throw new CmdFailure("status is null");
            }
            this.println(status.toString());
            return null;
        }
    }

    @Command(scope="ca", name="signer-up", description="update signer")
    @Service
    public static class SignerUp
    extends CaAction {
        @Reference
        protected PasswordResolver passwordResolver;
        @Option(name="--name", aliases={"-n"}, required=true, description="signer name")
        @Completion(value=CaCompleters.SignerNameCompleter.class)
        protected String name;
        @Option(name="--type", description="type of the signer")
        @Completion(value=CaCompleters.SignerTypeCompleter.class)
        protected String type;
        @Option(name="--cert", description="certificate file or 'null'")
        @Completion(value=FileCompleter.class)
        protected String certFile;
        @Option(name="--conf", description="conf of the signer or 'null'")
        private String conf;

        protected String getSignerConf() throws Exception {
            if (this.conf == null) {
                return null;
            }
            String tmpType = this.type;
            if (tmpType == null) {
                MgmtEntry.Signer entry = this.caManager.getSigner(this.name);
                if (entry == null) {
                    throw new IllegalCmdParamException("please specify the type");
                }
                tmpType = entry.getType();
            }
            return ShellUtil.canonicalizeSignerConf(tmpType, this.conf, this.passwordResolver, this.securityFactory);
        }

        protected Object execute0() throws Exception {
            String cert = null;
            if ("null".equalsIgnoreCase(this.certFile)) {
                cert = "null";
            } else if (this.certFile != null) {
                Certificate bcCert = X509Util.parseBcCert((File)new File(this.certFile));
                byte[] certBytes = bcCert.getEncoded();
                cert = Base64.encodeToString((byte[])certBytes);
            }
            String msg = "signer " + this.name;
            try {
                this.caManager.changeSigner(this.name, this.type, this.getSignerConf(), cert);
                this.println("updated " + msg);
                return null;
            }
            catch (CaMgmtException ex) {
                throw new CmdFailure("could not update " + msg + ", error: " + ex.getMessage(), (Throwable)ex);
            }
        }
    }

    @Command(scope="ca", name="signer-rm", description="remove signer")
    @Service
    public static class SignerRm
    extends CaAction {
        @Argument(index=0, name="name", required=true, description="signer name")
        @Completion(value=CaCompleters.SignerNameCompleter.class)
        private String name;
        @Option(name="--force", aliases={"-f"}, description="without prompt")
        private Boolean force = Boolean.FALSE;

        protected Object execute0() throws Exception {
            String msg = "signer " + this.name;
            if (this.force.booleanValue() || this.confirm("Do you want to remove " + msg, 3)) {
                try {
                    this.caManager.removeSigner(this.name);
                    this.println("removed " + msg);
                }
                catch (CaMgmtException ex) {
                    throw new CmdFailure("could not remove " + msg + ", error: " + ex.getMessage(), (Throwable)ex);
                }
            }
            return null;
        }
    }

    @Command(scope="ca", name="signer-info", description="show information of signer")
    @Service
    public static class SignerInfo
    extends CaAction {
        @Argument(index=0, name="name", description="signer name")
        @Completion(value=CaCompleters.SignerNameCompleter.class)
        private String name;
        @Option(name="--verbose", aliases={"-v"}, description="show signer information verbosely")
        private Boolean verbose = Boolean.FALSE;

        protected Object execute0() throws Exception {
            StringBuilder sb = new StringBuilder();
            if (this.name == null) {
                Set names = this.caManager.getSignerNames();
                int size = names.size();
                if (size == 0 || size == 1) {
                    sb.append(size == 0 ? "no" : "1").append(" signer is configured\n");
                } else {
                    sb.append(size).append(" signers are configured:\n");
                }
                ArrayList sorted = new ArrayList(names);
                Collections.sort(sorted);
                for (String entry : sorted) {
                    sb.append("\t").append(entry).append("\n");
                }
            } else {
                MgmtEntry.Signer entry = this.caManager.getSigner(this.name);
                if (entry == null) {
                    throw new CmdFailure("could not find signer " + this.name);
                }
                sb.append(entry.toString(this.verbose.booleanValue()));
            }
            this.println(sb.toString());
            return null;
        }
    }

    @Command(scope="ca", name="signer-add", description="add signer")
    @Service
    public static class SignerAdd
    extends CaAction {
        @Option(name="--name", aliases={"-n"}, required=true, description="signer name")
        private String name;
        @Option(name="--type", required=true, description="type of the signer")
        @Completion(value=CaCompleters.SignerTypeCompleter.class)
        private String type;
        @Option(name="--conf", required=true, description="conf of the signer")
        private String conf;
        @Option(name="--cert", description="signer certificate file")
        @Completion(value=FileCompleter.class)
        private String certFile;
        @Reference
        private PasswordResolver passwordResolver;

        protected Object execute0() throws Exception {
            String base64Cert = null;
            X509Certificate signerCert = null;
            if (this.certFile != null) {
                signerCert = X509Util.parseCert((File)new File(this.certFile));
                base64Cert = IoUtil.base64Encode((byte[])signerCert.getEncoded(), (boolean)false);
            }
            if ("PKCS12".equalsIgnoreCase(this.type) || "JKS".equalsIgnoreCase(this.type)) {
                this.conf = ShellUtil.canonicalizeSignerConf(this.type, this.conf, this.passwordResolver, this.securityFactory);
            }
            MgmtEntry.Signer entry = new MgmtEntry.Signer(this.name, this.type, this.conf, base64Cert);
            String msg = "signer " + this.name;
            try {
                this.caManager.addSigner(entry);
                this.println("added " + msg);
                return null;
            }
            catch (CaMgmtException ex) {
                throw new CmdFailure("could not add " + msg + ", error: " + ex.getMessage(), (Throwable)ex);
            }
        }
    }

    @Command(scope="ca", name="restart", description="restart CA system")
    @Service
    public static class Restart
    extends CaAction {
        protected Object execute0() throws Exception {
            try {
                this.caManager.restartCaSystem();
            }
            catch (CaMgmtException ex) {
                throw new CmdFailure("could not restart CA system, error: " + ex.getMessage(), (Throwable)ex);
            }
            StringBuilder sb = new StringBuilder("restarted CA system\n");
            sb.append("  successful CAs:\n");
            String prefix = "    ";
            this.printCaNames(sb, this.caManager.getSuccessfulCaNames(), prefix);
            sb.append("  failed CAs:\n");
            this.printCaNames(sb, this.caManager.getFailedCaNames(), prefix);
            sb.append("  inactive CAs:\n");
            this.printCaNames(sb, this.caManager.getInactiveCaNames(), prefix);
            this.print(sb.toString());
            return null;
        }
    }

    @Command(scope="ca", name="restart-ca", description="restart CA")
    @Service
    public static class RestartCa
    extends CaAction {
        @Argument(index=0, name="name", required=true, description="CA name")
        @Completion(value=CaCompleters.CaNameCompleter.class)
        private String name;

        protected Object execute0() throws Exception {
            try {
                this.caManager.restartCa(this.name);
                System.out.println("restarted CA " + this.name);
            }
            catch (CaMgmtException ex) {
                throw new CmdFailure("could not restart CA " + this.name + ", error: " + ex.getMessage(), (Throwable)ex);
            }
            return null;
        }
    }

    @Command(scope="ca", name="requestor-up", description="update requestor")
    @Service
    public static class RequestorUp
    extends CaAction {
        @Option(name="--name", aliases={"-n"}, required=true, description="requestor name")
        @Completion(value=CaCompleters.RequestorNameCompleter.class)
        protected String name;
        @Option(name="--cert", description="requestor certificate file\n(exactly one of cert and password must be specified).")
        @Completion(value=FileCompleter.class)
        protected String certFile;
        @Option(name="--password", description="Passord for PBM (Password based MAC)")
        protected String password;

        protected Object execute0() throws Exception {
            String conf;
            String type;
            String msg = "CMP requestor " + this.name;
            if (this.certFile != null) {
                type = "cert";
                X509Certificate cert = X509Util.parseCert((byte[])IoUtil.read((String)this.certFile));
                conf = Base64.encodeToString((byte[])cert.getEncoded());
            } else {
                type = "pbm";
                conf = this.password;
            }
            try {
                this.caManager.changeRequestor(this.name, type, conf);
                this.println("updated " + msg);
                return null;
            }
            catch (CaMgmtException ex) {
                throw new CmdFailure("could not update " + msg + ", error: " + ex.getMessage(), (Throwable)ex);
            }
        }
    }

    @Command(scope="ca", name="requestor-rm", description="remove requestor")
    @Service
    public static class RequestorRm
    extends CaAction {
        @Argument(index=0, name="name", required=true, description="requestor name")
        @Completion(value=CaCompleters.RequestorNameCompleter.class)
        private String name;
        @Option(name="--force", aliases={"-f"}, description="without prompt")
        private Boolean force = Boolean.FALSE;

        protected Object execute0() throws Exception {
            String msg = "CMP requestor " + this.name;
            if (this.force.booleanValue() || this.confirm("Do you want to remove " + msg, 3)) {
                try {
                    this.caManager.removeRequestor(this.name);
                    this.println("removed " + msg);
                }
                catch (CaMgmtException ex) {
                    throw new CmdFailure("could not remove " + msg + ", error: " + ex.getMessage(), (Throwable)ex);
                }
            }
            return null;
        }
    }

    @Command(scope="ca", name="requestor-info", description="show information of requestor")
    @Service
    public static class RequestorInfo
    extends CaAction {
        @Argument(index=0, name="name", description="requestor name")
        @Completion(value=CaCompleters.RequestorNameCompleter.class)
        private String name;
        @Option(name="--verbose", aliases={"-v"}, description="show requestor information verbosely")
        private Boolean verbose = Boolean.FALSE;

        protected Object execute0() throws Exception {
            StringBuilder sb = new StringBuilder();
            if (this.name == null) {
                Set names = this.caManager.getRequestorNames();
                int size = names.size();
                if (size == 0 || size == 1) {
                    sb.append(size == 0 ? "no" : "1");
                    sb.append(" CMP requestor is configured\n");
                } else {
                    sb.append(size).append(" CMP requestors are configured:\n");
                }
                ArrayList sorted = new ArrayList(names);
                Collections.sort(sorted);
                for (String entry : sorted) {
                    sb.append("\t").append(entry).append("\n");
                }
            } else {
                MgmtEntry.Requestor entry = this.caManager.getRequestor(this.name);
                if (entry == null) {
                    throw new CmdFailure("could not find CMP requestor '" + this.name + "'");
                }
                sb.append(entry.toString(this.verbose.booleanValue()));
            }
            this.println(sb.toString());
            return null;
        }
    }

    @Command(scope="ca", name="requestor-add", description="add requestor")
    @Service
    public static class RequestorAdd
    extends CaAction {
        @Option(name="--name", aliases={"-n"}, required=true, description="requestor name")
        private String name;
        @Option(name="--cert", description="requestor certificate file(exactly one of cert and password must be specified).")
        @Completion(value=FileCompleter.class)
        private String certFile;
        @Option(name="--password", description="Passord for PBM (Password based MAC)")
        private String password;

        protected Object execute0() throws Exception {
            MgmtEntry.Requestor entry;
            if (!(this.certFile == null ^ this.password == null)) {
                throw new CmdFailure("exactly one of cert and password must be specified");
            }
            if (this.certFile != null) {
                X509Certificate cert = X509Util.parseCert((byte[])IoUtil.read((String)this.certFile));
                entry = new MgmtEntry.Requestor(new NameId(null, this.name), "cert", Base64.encodeToString((byte[])cert.getEncoded()));
            } else {
                entry = new MgmtEntry.Requestor(new NameId(null, this.name), "pbm", this.password);
                String keyId = HashAlgo.SHA1.hexHash((byte[][])new byte[][]{StringUtil.toUtf8Bytes((String)entry.getIdent().getName())});
                this.println("The key ID is " + keyId);
            }
            String msg = "CMP requestor " + this.name;
            try {
                this.caManager.addRequestor(entry);
                this.println("added " + msg);
                return null;
            }
            catch (CaMgmtException ex) {
                throw new CmdFailure("could not add " + msg + ", error: " + ex.getMessage(), (Throwable)ex);
            }
        }
    }

    @Command(scope="ca", name="republish", description="republish certificates")
    @Service
    public static class Republish
    extends CaAction {
        @Option(name="--thread", description="number of threads")
        private Integer numThreads = 5;
        @Option(name="--ca", required=true, description="CA name")
        @Completion(value=CaCompleters.CaNameCompleter.class)
        private String caName;
        @Option(name="--publisher", required=true, multiValued=true, description="publisher name or 'all' for all publishers")
        @Completion(value=CaCompleters.PublisherNamePlusAllCompleter.class)
        private List<String> publisherNames;

        protected Object execute0() throws Exception {
            if (this.publisherNames == null) {
                throw new IllegalStateException("should not reach here");
            }
            boolean allPublishers = false;
            for (String publisherName : this.publisherNames) {
                if (!"all".equalsIgnoreCase(publisherName)) continue;
                allPublishers = true;
                break;
            }
            if (allPublishers) {
                this.publisherNames = null;
            }
            if ("all".equalsIgnoreCase(this.caName)) {
                this.caName = null;
            }
            String msg = "certificates";
            try {
                this.caManager.republishCertificates(this.caName, this.publisherNames, this.numThreads.intValue());
                this.println("republished " + msg);
                return null;
            }
            catch (CaMgmtException ex) {
                throw new CmdFailure("could not republish " + msg + ", error: " + ex.getMessage(), (Throwable)ex);
            }
        }
    }

    @Command(scope="ca", name="refresh-token", description="refresh token for signers")
    @Service
    public static class RefreshToken
    extends CaAction {
        @Option(name="--type", required=true, description="type of the signer")
        @Completion(value=CaCompleters.SignerTypeCompleter.class)
        protected String type;

        protected Object execute0() throws Exception {
            this.caManager.refreshTokenForSignerType(this.type);
            this.println("refreshed token for signer type " + this.type);
            return null;
        }
    }

    @Command(scope="ca", name="publisher-up", description="update publisher")
    @Service
    public static class PublisherUp
    extends CaAction {
        @Option(name="--name", aliases={"-n"}, required=true, description="publisher name")
        @Completion(value=CaCompleters.PublisherNameCompleter.class)
        protected String name;
        @Option(name="--type", description="publisher type")
        @Completion(value=CaCompleters.PublisherTypeCompleter.class)
        protected String type;
        @Option(name="--conf", description="publisher configuration or 'null'")
        protected String conf;
        @Option(name="--conf-file", description="profile configuration file")
        @Completion(value=FileCompleter.class)
        protected String confFile;

        protected Object execute0() throws Exception {
            if (this.type == null && this.conf == null && this.confFile == null) {
                throw new IllegalCmdParamException("nothing to update");
            }
            if (this.conf == null && this.confFile != null) {
                this.conf = new String(IoUtil.read((String)this.confFile));
            }
            String msg = "publisher " + this.name;
            try {
                this.caManager.changePublisher(this.name, this.type, this.conf);
                this.println("updated " + msg);
                return null;
            }
            catch (CaMgmtException ex) {
                throw new CmdFailure("could not update " + msg + ", error: " + ex.getMessage(), (Throwable)ex);
            }
        }
    }

    @Command(scope="ca", name="publisher-rm", description="remove publisher")
    @Service
    public static class PublisherRm
    extends CaAction {
        @Argument(index=0, name="name", required=true, description="publisher name")
        @Completion(value=CaCompleters.PublisherNameCompleter.class)
        private String name;
        @Option(name="--force", aliases={"-f"}, description="without prompt")
        private Boolean force = Boolean.FALSE;

        protected Object execute0() throws Exception {
            String msg = "publisher " + this.name;
            if (this.force.booleanValue() || this.confirm("Do you want to remove " + msg, 3)) {
                try {
                    this.caManager.removePublisher(this.name);
                    this.println("removed " + msg);
                }
                catch (CaMgmtException ex) {
                    throw new CmdFailure("could not remove " + msg + ", error: " + ex.getMessage(), (Throwable)ex);
                }
            }
            return null;
        }
    }

    @Command(scope="ca", name="publisher-info", description="show information of publisher")
    @Service
    public static class PublisherInfo
    extends CaAction {
        @Argument(index=0, name="name", description="publisher name")
        @Completion(value=CaCompleters.PublisherNameCompleter.class)
        private String name;

        protected Object execute0() throws Exception {
            if (this.name == null) {
                Set names = this.caManager.getPublisherNames();
                int size = names.size();
                StringBuilder sb = new StringBuilder();
                if (size == 0 || size == 1) {
                    sb.append(size == 0 ? "no" : "1");
                    sb.append(" publisher is configured\n");
                } else {
                    sb.append(size).append(" publishers are configured:\n");
                }
                ArrayList sorted = new ArrayList(names);
                Collections.sort(sorted);
                for (String entry : sorted) {
                    sb.append("\t").append(entry).append("\n");
                }
                this.println(sb.toString());
            } else {
                MgmtEntry.Publisher entry = this.caManager.getPublisher(this.name);
                if (entry == null) {
                    throw new CmdFailure("\tno publisher named '" + this.name + "' is configured");
                }
                this.println(entry.toString());
            }
            return null;
        }
    }

    @Command(scope="ca", name="publisher-export", description="export publisher configuration")
    @Service
    public static class PublisherExport
    extends CaAction {
        @Option(name="--name", aliases={"-n"}, required=true, description="publisher name")
        @Completion(value=CaCompleters.PublisherNameCompleter.class)
        private String name;
        @Option(name="--out", aliases={"-o"}, required=true, description="where to save the publisher configuration")
        @Completion(value=FileCompleter.class)
        private String confFile;

        protected Object execute0() throws Exception {
            MgmtEntry.Publisher entry = this.caManager.getPublisher(this.name);
            if (entry == null) {
                throw new IllegalCmdParamException("no publisher named " + this.name + " is defined");
            }
            if (StringUtil.isBlank((String)entry.getConf())) {
                this.println("publisher does not have conf");
            } else {
                this.saveVerbose("saved publisher configuration to", this.confFile, StringUtil.toUtf8Bytes((String)entry.getConf()));
            }
            return null;
        }
    }

    @Command(scope="ca", name="publisher-add", description="add publisher")
    @Service
    public static class PublisherAdd
    extends CaAction {
        @Option(name="--name", aliases={"-n"}, required=true, description="publisher Name")
        private String name;
        @Option(name="--type", required=true, description="publisher type")
        @Completion(value=CaCompleters.PublisherTypeCompleter.class)
        private String type;
        @Option(name="--conf", description="publisher configuration")
        private String conf;
        @Option(name="--conf-file", description="publisher configuration file")
        @Completion(value=FileCompleter.class)
        private String confFile;

        protected Object execute0() throws Exception {
            if (this.conf == null && this.confFile != null) {
                this.conf = new String(IoUtil.read((String)this.confFile));
            }
            MgmtEntry.Publisher entry = new MgmtEntry.Publisher(new NameId(null, this.name), this.type, this.conf);
            String msg = "publisher " + this.name;
            try {
                this.caManager.addPublisher(entry);
                this.println("added " + msg);
                return null;
            }
            catch (CaMgmtException ex) {
                throw new CmdFailure("could not add " + msg + ", error: " + ex.getMessage(), (Throwable)ex);
            }
        }
    }

    @Command(scope="ca", name="profile-up", description="update certificate profile")
    @Service
    public static class ProfileUp
    extends CaAction {
        @Option(name="--name", aliases={"-n"}, required=true, description="profile name")
        @Completion(value=CaCompleters.ProfileNameCompleter.class)
        protected String name;
        @Option(name="--type", description="profile type")
        @Completion(value=CaCompleters.ProfileTypeCompleter.class)
        protected String type;
        @Option(name="--conf", description="certificate profile configuration or 'null'")
        protected String conf;
        @Option(name="--conf-file", description="certificate profile configuration file")
        @Completion(value=FileCompleter.class)
        protected String confFile;

        protected Object execute0() throws Exception {
            if (this.type == null && this.conf == null && this.confFile == null) {
                throw new IllegalCmdParamException("nothing to update");
            }
            if (this.conf == null && this.confFile != null) {
                this.conf = new String(IoUtil.read((String)this.confFile));
            }
            String msg = "certificate profile " + this.name;
            try {
                this.caManager.changeCertprofile(this.name, this.type, this.conf);
                this.println("updated " + msg);
                return null;
            }
            catch (CaMgmtException ex) {
                throw new CmdFailure("could not update " + msg + ", error: " + ex.getMessage(), (Throwable)ex);
            }
        }
    }

    @Command(scope="ca", name="profile-rm", description="remove certificate profile")
    @Service
    public static class ProfileRm
    extends CaAction {
        @Argument(index=0, name="name", required=true, description="certificate profile name")
        @Completion(value=CaCompleters.ProfileNameCompleter.class)
        private String name;
        @Option(name="--force", aliases={"-f"}, description="without prompt")
        private Boolean force = Boolean.FALSE;

        protected Object execute0() throws Exception {
            String msg = "certificate profile " + this.name;
            if (this.force.booleanValue() || this.confirm("Do you want to remove " + msg, 3)) {
                try {
                    this.caManager.removeCertprofile(this.name);
                    this.println("removed " + msg);
                }
                catch (CaMgmtException ex) {
                    throw new CmdFailure("could not remove " + msg + ", error: " + ex.getMessage(), (Throwable)ex);
                }
            }
            return null;
        }
    }

    @Command(scope="ca", name="profile-info", description="show information of certificate profile")
    @Service
    public static class ProfileInfo
    extends CaAction {
        @Argument(index=0, name="name", description="certificate profile name")
        @Completion(value=CaCompleters.ProfileNameCompleter.class)
        private String name;
        @Option(name="--verbose", aliases={"-v"}, description="show certificate profile information verbosely")
        private Boolean verbose = Boolean.FALSE;

        protected Object execute0() throws Exception {
            StringBuilder sb = new StringBuilder();
            if (this.name == null) {
                Set names = this.caManager.getCertprofileNames();
                int size = names.size();
                if (size == 0 || size == 1) {
                    sb.append(size == 0 ? "no" : "1");
                    sb.append(" profile is configured\n");
                } else {
                    sb.append(size).append(" profiles are configured:\n");
                }
                ArrayList sorted = new ArrayList(names);
                Collections.sort(sorted);
                for (String entry : sorted) {
                    sb.append("\t").append(entry).append("\n");
                }
            } else {
                MgmtEntry.Certprofile entry = this.caManager.getCertprofile(this.name);
                if (entry == null) {
                    throw new CmdFailure("\tno certificate profile named '" + this.name + "' is configured");
                }
                sb.append(entry.toString(this.verbose.booleanValue()));
            }
            this.println(sb.toString());
            return null;
        }
    }

    @Command(scope="ca", name="profile-export", description="export certificate profile configuration")
    @Service
    public static class ProfileExport
    extends CaAction {
        @Option(name="--name", aliases={"-n"}, required=true, description="profile name")
        @Completion(value=CaCompleters.ProfileNameCompleter.class)
        private String name;
        @Option(name="--out", aliases={"-o"}, required=true, description="where to save the profile configuration")
        @Completion(value=FileCompleter.class)
        private String confFile;

        protected Object execute0() throws Exception {
            MgmtEntry.Certprofile entry = this.caManager.getCertprofile(this.name);
            if (entry == null) {
                throw new IllegalCmdParamException("no certificate profile named " + this.name + " is defined");
            }
            if (StringUtil.isBlank((String)entry.getConf())) {
                this.println("cert profile does not have conf");
            } else {
                this.saveVerbose("saved cert profile configuration to", this.confFile, StringUtil.toUtf8Bytes((String)entry.getConf()));
            }
            return null;
        }
    }

    @Command(scope="ca", name="profile-add", description="add certificate profile")
    @Service
    public static class ProfileAdd
    extends CaAction {
        @Option(name="--name", aliases={"-n"}, required=true, description="profile name")
        private String name;
        @Option(name="--type", required=true, description="profile type")
        @Completion(value=CaCompleters.ProfileTypeCompleter.class)
        private String type;
        @Option(name="--conf", description="certificate profile configuration")
        private String conf;
        @Option(name="--conf-file", description="certificate profile configuration file")
        @Completion(value=FileCompleter.class)
        private String confFile;

        protected Object execute0() throws Exception {
            if (this.conf == null && this.confFile != null) {
                this.conf = new String(IoUtil.read((String)this.confFile));
            }
            MgmtEntry.Certprofile entry = new MgmtEntry.Certprofile(new NameId(null, this.name), this.type, this.conf);
            String msg = "certificate profile " + this.name;
            try {
                this.caManager.addCertprofile(entry);
                this.println("added " + msg);
                return null;
            }
            catch (CaMgmtException ex) {
                throw new CmdFailure("could not add " + msg + ", error: " + ex.getMessage(), (Throwable)ex);
            }
        }
    }

    @Command(scope="ca", name="notify-change", description="notify the change of CA system")
    @Service
    public static class NotifyChange
    extends CaAction {
        protected Object execute0() throws Exception {
            String msg = "the change of CA system";
            try {
                this.caManager.notifyCaChange();
                this.println("notified " + msg);
                return null;
            }
            catch (CaMgmtException ex) {
                throw new CmdFailure("could not notify " + msg + ", error: " + ex.getMessage(), (Throwable)ex);
            }
        }
    }

    @Command(scope="ca", name="load-conf", description="load configuration")
    @Service
    public static class LoadConf
    extends CaAction {
        @Option(name="--conf-file", description="CA system configuration file (XML or zip file")
        @Completion(value=FileCompleter.class)
        private String confFile;
        @Option(name="--outform", description="output format of the root certificates")
        @Completion(value=Completers.DerPemCompleter.class)
        protected String outform = "der";
        @Option(name="--out-dir", description="directory to save the root certificates")
        @Completion(value=FileCompleter.class)
        private String outDir = ".";

        protected Object execute0() throws Exception {
            String msg = "configuration " + this.confFile;
            try {
                InputStream confStream = this.confFile.endsWith(".json") ? CaConfs.convertFileConfToZip((String)this.confFile) : Files.newInputStream(Paths.get(this.confFile, new String[0]), new OpenOption[0]);
                Map rootCerts = this.caManager.loadConf(confStream);
                if (CollectionUtil.isEmpty((Map)rootCerts)) {
                    this.println("loaded " + msg);
                } else {
                    this.println("loaded " + msg);
                    for (String caname : rootCerts.keySet()) {
                        String filename = "ca-" + caname + ".crt";
                        this.saveVerbose("saved certificate of root CA " + caname + " to", new File(this.outDir, filename), LoadConf.encodeCert((byte[])((X509Certificate)rootCerts.get(caname)).getEncoded(), (String)this.outform));
                    }
                }
                return null;
            }
            catch (CaMgmtException ex) {
                throw new CmdFailure("could not load " + msg + ", error: " + ex.getMessage(), (Throwable)ex);
            }
        }
    }

    @Command(scope="ca", name="export-conf", description="export configuration to zip file")
    @Service
    public static class ExportConf
    extends CaAction {
        @Option(name="--conf-file", required=true, description="zip file that saves the exported configuration")
        @Completion(value=FileCompleter.class)
        private String confFile;
        @Option(name="--ca", multiValued=true, description="CAs whose configuration should be exported. Empty list means all CAs")
        @Completion(value=CaCompleters.CaNameCompleter.class)
        private List<String> caNames;

        protected Object execute0() throws Exception {
            String msg = "configuration to file " + this.confFile;
            try {
                InputStream is = this.caManager.exportConf(this.caNames);
                this.save(new File(this.confFile), IoUtil.read((InputStream)is));
                this.println("exported " + msg);
                return null;
            }
            catch (CaMgmtException ex) {
                throw new CmdFailure("could not export " + msg + ", error: " + ex.getMessage(), (Throwable)ex);
            }
        }
    }

    @Command(scope="ca", name="clear-publishqueue", description="clear publish queue")
    @Service
    public static class ClearPublishqueue
    extends CaAction {
        @Option(name="--ca", required=true, description="CA name or 'all' for all CAs")
        @Completion(value=CaCompleters.CaNamePlusAllCompleter.class)
        private String caName;
        @Option(name="--publisher", required=true, multiValued=true, description="publisher name or 'all' for all publishers")
        @Completion(value=CaCompleters.PublisherNamePlusAllCompleter.class)
        private List<String> publisherNames;

        protected Object execute0() throws Exception {
            if (this.publisherNames == null) {
                throw new IllegalStateException("should not reach here");
            }
            boolean allPublishers = false;
            for (String publisherName : this.publisherNames) {
                if (!"all".equalsIgnoreCase(publisherName)) continue;
                allPublishers = true;
                break;
            }
            if (allPublishers) {
                this.publisherNames = null;
            }
            if ("all".equalsIgnoreCase(this.caName)) {
                this.caName = null;
            }
            String msg = "publish queue of CA " + this.caName + " for publishers " + ClearPublishqueue.toString(this.publisherNames);
            try {
                this.caManager.clearPublishQueue(this.caName, this.publisherNames);
                this.println("cleared " + msg);
                return null;
            }
            catch (CaMgmtException ex) {
                throw new CmdFailure("could not clear " + msg + ", error: " + ex.getMessage(), (Throwable)ex);
            }
        }
    }

    @Command(scope="ca", name="causer-rm", description="remove user from CA")
    @Service
    public static class CauserRm
    extends CaAction {
        @Option(name="--ca", required=true, description="CA name")
        @Completion(value=CaCompleters.CaNameCompleter.class)
        private String caName;
        @Option(name="--user", required=true, description="user name")
        private String userName;
        @Option(name="--force", aliases={"-f"}, description="without prompt")
        private Boolean force = Boolean.FALSE;

        protected Object execute0() throws Exception {
            String msg = "user " + this.userName + " from CA " + this.caName;
            if (this.force.booleanValue() || this.confirm("Do you want to remove " + msg, 3)) {
                try {
                    this.caManager.removeUserFromCa(this.userName, this.caName);
                    this.println("removed " + msg);
                }
                catch (CaMgmtException ex) {
                    throw new CmdFailure("could not remove " + msg + ", error: " + ex.getMessage(), (Throwable)ex);
                }
            }
            return null;
        }
    }

    @Command(scope="ca", name="causer-add", description="add user to CA")
    @Service
    public static class CauserAdd
    extends CaAction {
        @Option(name="--ca", required=true, description="CA name")
        @Completion(value=CaCompleters.CaNameCompleter.class)
        private String caName;
        @Option(name="--user", required=true, description="user name")
        private String userName;
        @Option(name="--permission", required=true, multiValued=true, description="permission")
        @Completion(value=CaCompleters.PermissionCompleter.class)
        private Set<String> permissions;
        @Option(name="--profile", required=true, multiValued=true, description="profile name or 'all' for all profiles")
        @Completion(value=CaCompleters.ProfileNameAndAllCompleter.class)
        private Set<String> profiles;

        protected Object execute0() throws Exception {
            MgmtEntry.CaHasUser entry = new MgmtEntry.CaHasUser(new NameId(null, this.userName));
            entry.setProfiles(this.profiles);
            int intPermission = ShellUtil.getPermission(this.permissions);
            entry.setPermission(intPermission);
            String msg = "user " + this.userName + " to CA " + this.caName;
            try {
                this.caManager.addUserToCa(entry, this.caName);
                this.println("added " + msg);
                return null;
            }
            catch (CaMgmtException ex) {
                throw new CmdFailure("could not add " + msg + ", error: " + ex.getMessage(), (Throwable)ex);
            }
        }
    }

    @Command(scope="ca", name="ca-up", description="update CA")
    @Service
    public static class CaUp
    extends CaAction {
        @Option(name="--name", aliases={"-n"}, required=true, description="CA name")
        @Completion(value=CaCompleters.CaNameCompleter.class)
        private String caName;
        @Option(name="--sn-bitlen", description="number of bits of the serial number, between 71 and 159")
        private Integer snBitLen;
        @Option(name="--status", description="CA status")
        @Completion(value=CaCompleters.CaStatusCompleter.class)
        private String caStatus;
        @Option(name="--ca-cert-uri", multiValued=true, description="CA certificate URI")
        private List<String> caCertUris;
        @Option(name="--ocsp-uri", multiValued=true, description="OCSP URI or 'null'")
        private List<String> ocspUris;
        @Option(name="--crl-uri", multiValued=true, description="CRL distribution point URI or 'null'")
        private List<String> crlUris;
        @Option(name="--deltacrl-uri", multiValued=true, description="delta CRL distribution point URI or 'null'")
        private List<String> deltaCrlUris;
        @Option(name="--permission", multiValued=true, description="permission")
        @Completion(value=CaCompleters.PermissionCompleter.class)
        private Set<String> permissions;
        @Option(name="--max-validity", description="maximal validity")
        private String maxValidity;
        @Option(name="--expiration-period", description="days before expiration time of CA to issue certificates")
        private Integer expirationPeriod;
        @Option(name="--keep-expired-certs", description="days to keep expired certificates")
        private Integer keepExpiredCertInDays;
        @Option(name="--crl-signer", description="CRL signer name or 'null'")
        @Completion(value=CaCompleters.SignerNamePlusNullCompleter.class)
        private String crlSignerName;
        @Option(name="--cmp-responder", description="CMP responder name or 'null'")
        @Completion(value=CaCompleters.SignerNamePlusNullCompleter.class)
        private String cmpResponderName;
        @Option(name="--scep-responder", description="SCEP responder name or 'null'")
        @Completion(value=CaCompleters.SignerNamePlusNullCompleter.class)
        private String scepResponderName;
        @Option(name="--cmp-control", description="CMP control or 'null'")
        private String cmpControl;
        @Option(name="--crl-control", description="CRL control or 'null'")
        private String crlControl;
        @Option(name="--scep-control", description="SCEP control or 'null'")
        private String scepControl;
        @Option(name="--ctlog-control", description="CT log control")
        private String ctlogControl;
        @Option(name="--dhpoc-control", description="DHPoc control")
        private String dhpocControl;
        @Option(name="--revoke-suspended-control", description="Revoke suspended certificates control")
        private String revokeSuspendedControl;
        @Option(name="--num-crls", description="number of CRLs to be kept in database")
        private Integer numCrls;
        @Option(name="--cert", description="CA certificate file")
        @Completion(value=FileCompleter.class)
        private String certFile;
        @Option(name="--certchain", multiValued=true, description="certificate chain of CA certificate")
        @Completion(value=FileCompleter.class)
        private List<String> issuerCertFiles;
        @Option(name="--signer-type", description="CA signer type")
        @Completion(value=CaCompleters.SignerTypeCompleter.class)
        private String signerType;
        @Option(name="--signer-conf", description="CA signer configuration or 'null'")
        private String signerConf;
        @Option(name="--duplicate-key", description="whether duplicate key is permitted")
        @Completion(value=Completers.YesNoCompleter.class)
        private String duplicateKeyS;
        @Option(name="--duplicate-subject", description="whether duplicate subject is permitted")
        @Completion(value=Completers.YesNoCompleter.class)
        private String duplicateSubjectS;
        @Option(name="--support-cmp", description="whether the CMP protocol is supported")
        @Completion(value=Completers.YesNoCompleter.class)
        private String supportCmpS;
        @Option(name="--support-rest", description="whether the REST protocol is supported")
        @Completion(value=Completers.YesNoCompleter.class)
        private String supportRestS;
        @Option(name="--support-scep", description="whether the SCEP protocol is supported")
        @Completion(value=Completers.YesNoCompleter.class)
        private String supportScepS;
        @Option(name="--save-req", description="whether the request is saved")
        @Completion(value=Completers.YesNoCompleter.class)
        private String saveReqS;
        @Option(name="--validity-mode", description="mode of valditity")
        @Completion(value=CaCompleters.ValidityModeCompleter.class)
        private String validityModeS;
        @Option(name="--extra-control", description="extra control")
        private String extraControl;
        @Reference
        private PasswordResolver passwordResolver;

        protected MgmtEntry.ChangeCa getChangeCaEntry() throws Exception {
            MgmtEntry.ChangeCa entry = new MgmtEntry.ChangeCa(new NameId(null, this.caName));
            if (this.snBitLen != null) {
                Args.range((int)this.snBitLen, (String)"sn-bitlen", (int)71, (int)159);
                entry.setSerialNoBitLen(this.snBitLen);
            }
            if (this.caStatus != null) {
                entry.setStatus(CaStatus.forName((String)this.caStatus));
            }
            if (this.expirationPeriod != null && this.expirationPeriod < 0) {
                throw new IllegalCmdParamException("invalid expirationPeriod: " + this.expirationPeriod);
            }
            entry.setExpirationPeriod(this.expirationPeriod);
            if (this.keepExpiredCertInDays != null) {
                entry.setKeepExpiredCertInDays(this.keepExpiredCertInDays);
            }
            if (this.certFile != null) {
                entry.setEncodedCert(IoUtil.read((String)this.certFile));
            }
            if (CollectionUtil.isNotEmpty(this.issuerCertFiles)) {
                ArrayList<byte[]> list = new ArrayList<byte[]>(this.issuerCertFiles.size());
                for (String m : this.issuerCertFiles) {
                    if ("null".equalsIgnoreCase(m)) {
                        list.clear();
                        break;
                    }
                    list.add(X509Util.parseCert((File)Paths.get(m, new String[0]).toFile()).getEncoded());
                }
                entry.setEncodedCertchain(list);
            }
            if (this.signerConf != null) {
                String tmpSignerType = this.signerType;
                if (tmpSignerType == null) {
                    MgmtEntry.Ca caEntry = this.caManager.getCa(this.caName);
                    if (caEntry == null) {
                        throw new IllegalCmdParamException("please specify the signerType");
                    }
                    tmpSignerType = caEntry.getSignerType();
                }
                this.signerConf = ShellUtil.canonicalizeSignerConf(tmpSignerType, this.signerConf, this.passwordResolver, this.securityFactory);
                entry.setSignerConf(this.signerConf);
            }
            if (this.duplicateKeyS != null) {
                entry.setDuplicateKeyPermitted(Boolean.valueOf(CaUp.isEnabled((String)this.duplicateKeyS, (boolean)true, (String)"duplicate-key")));
            }
            if (this.duplicateSubjectS != null) {
                entry.setDuplicateSubjectPermitted(Boolean.valueOf(CaUp.isEnabled((String)this.duplicateSubjectS, (boolean)true, (String)"duplicate-subject")));
            }
            if (this.supportCmpS != null) {
                entry.setSupportCmp(Boolean.valueOf(CaUp.isEnabled((String)this.supportCmpS, (boolean)false, (String)"support-cmp")));
            }
            if (this.supportRestS != null) {
                entry.setSupportRest(Boolean.valueOf(CaUp.isEnabled((String)this.supportRestS, (boolean)false, (String)"support-rest")));
            }
            if (this.supportScepS != null) {
                entry.setSupportScep(Boolean.valueOf(CaUp.isEnabled((String)this.supportScepS, (boolean)false, (String)"support-scep")));
            }
            if (this.saveReqS != null) {
                entry.setSaveRequest(Boolean.valueOf(CaUp.isEnabled((String)this.saveReqS, (boolean)true, (String)"save-req")));
            }
            if (CollectionUtil.isNotEmpty(this.permissions)) {
                int intPermission = ShellUtil.getPermission(this.permissions);
                entry.setPermission(Integer.valueOf(intPermission));
            }
            CaUris caUris = new CaUris(CaUp.getUris(this.caCertUris), CaUp.getUris(this.ocspUris), CaUp.getUris(this.crlUris), CaUp.getUris(this.deltaCrlUris));
            entry.setCaUris(caUris);
            if (this.validityModeS != null) {
                ValidityMode validityMode = ValidityMode.forName((String)this.validityModeS);
                entry.setValidityMode(validityMode);
            }
            if (this.maxValidity != null) {
                entry.setMaxValidity(Validity.getInstance((String)this.maxValidity));
            }
            if (this.cmpControl != null) {
                entry.setCmpControl(this.cmpControl);
            }
            if (this.crlControl != null) {
                entry.setCrlControl(this.crlControl);
            }
            if (this.scepControl != null) {
                entry.setScepControl(this.scepControl);
            }
            if (this.ctlogControl != null) {
                entry.setCtlogControl(this.ctlogControl);
            }
            if (this.dhpocControl != null) {
                String tmp = ShellUtil.canonicalizeSignerConf("PKCS12", this.dhpocControl, this.passwordResolver, this.securityFactory);
                entry.setDhpocControl(tmp);
            }
            if (this.revokeSuspendedControl != null) {
                entry.setRevokeSuspendedControl(this.revokeSuspendedControl);
            }
            if (this.cmpResponderName != null) {
                entry.setCmpResponderName(this.cmpResponderName);
            }
            if (this.scepResponderName != null) {
                entry.setScepResponderName(this.scepResponderName);
            }
            if (this.crlSignerName != null) {
                entry.setCrlSignerName(this.crlSignerName);
            }
            if (this.extraControl != null) {
                entry.setExtraControl(new ConfPairs(this.extraControl).unmodifiable());
            }
            if (this.numCrls != null) {
                entry.setNumCrls(this.numCrls);
            }
            return entry;
        }

        protected Object execute0() throws Exception {
            String msg = "CA " + this.caName;
            try {
                this.caManager.changeCa(this.getChangeCaEntry());
                this.println("updated " + msg);
                return null;
            }
            catch (CaMgmtException ex) {
                throw new CmdFailure("could not update " + msg + ", error: " + ex.getMessage(), (Throwable)ex);
            }
        }

        private static List<String> getUris(List<String> uris) {
            if (uris == null) {
                return null;
            }
            boolean clearUris = false;
            for (String uri : uris) {
                if (!"null".equalsIgnoreCase(uri)) continue;
                clearUris = true;
                break;
            }
            return clearUris ? Collections.emptyList() : new ArrayList<String>(uris);
        }
    }

    @Command(scope="ca", name="ca-unrevoke", description="unrevoke CA")
    @Service
    public static class CaUnrevoke
    extends CaAction {
        @Argument(index=0, name="name", required=true, description="CA name")
        @Completion(value=CaCompleters.CaNameCompleter.class)
        private String caName;

        protected Object execute0() throws Exception {
            if (!this.caManager.getCaNames().contains(this.caName)) {
                throw new IllegalCmdParamException("invalid CA name " + this.caName);
            }
            String msg = "CA " + this.caName;
            try {
                this.caManager.unrevokeCa(this.caName);
                this.println("unrevoked " + msg);
                return null;
            }
            catch (CaMgmtException ex) {
                throw new CmdFailure("could not unrevoke " + msg + ", error: " + ex.getMessage(), (Throwable)ex);
            }
        }
    }

    @Command(scope="ca", name="ca-revoke", description="revoke CA")
    @Service
    public static class CaRevoke
    extends CaAction {
        public static final List<CrlReason> PERMITTED_REASONS = Collections.unmodifiableList(Arrays.asList(CrlReason.UNSPECIFIED, CrlReason.KEY_COMPROMISE, CrlReason.CA_COMPROMISE, CrlReason.AFFILIATION_CHANGED, CrlReason.SUPERSEDED, CrlReason.CESSATION_OF_OPERATION, CrlReason.CERTIFICATE_HOLD, CrlReason.PRIVILEGE_WITHDRAWN));
        @Argument(index=0, name="name", description="CA name", required=true)
        @Completion(value=CaCompleters.CaNameCompleter.class)
        private String caName;
        @Option(name="--reason", required=true, description="CRL reason")
        @Completion(value=CaCompleters.CaCrlReasonCompleter.class)
        private String reason;
        @Option(name="--rev-date", valueToShowInHelp="current time", description="revocation date, UTC time of format yyyyMMddHHmmss")
        private String revocationDateS;
        @Option(name="--inv-date", description="invalidity date, UTC time of format yyyyMMddHHmmss")
        private String invalidityDateS;

        protected Object execute0() throws Exception {
            CrlReason crlReason = CrlReason.forNameOrText((String)this.reason);
            if (!PERMITTED_REASONS.contains(crlReason)) {
                throw new IllegalCmdParamException("reason " + this.reason + " is not permitted");
            }
            if (!this.caManager.getCaNames().contains(this.caName)) {
                throw new IllegalCmdParamException("invalid CA name " + this.caName);
            }
            Date revocationDate = null;
            revocationDate = CaRevoke.isNotBlank((String)this.revocationDateS) ? DateUtil.parseUtcTimeyyyyMMddhhmmss((String)this.revocationDateS) : new Date();
            Date invalidityDate = null;
            if (CaRevoke.isNotBlank((String)this.invalidityDateS)) {
                invalidityDate = DateUtil.parseUtcTimeyyyyMMddhhmmss((String)this.invalidityDateS);
            }
            CertRevocationInfo revInfo = new CertRevocationInfo(crlReason, revocationDate, invalidityDate);
            String msg = "CA " + this.caName;
            try {
                this.caManager.revokeCa(this.caName, revInfo);
                this.println("revoked " + msg);
                return null;
            }
            catch (CaMgmtException ex) {
                throw new CmdFailure("could not revoke " + msg + ", error: " + ex.getMessage(), (Throwable)ex);
            }
        }
    }

    @Command(scope="ca", name="careq-rm", description="remove requestor from CA")
    @Service
    public static class CareqRm
    extends CaAction {
        @Option(name="--ca", required=true, description="CA name")
        @Completion(value=CaCompleters.CaNameCompleter.class)
        private String caName;
        @Option(name="--requestor", required=true, multiValued=true, description="requestor name")
        @Completion(value=CaCompleters.RequestorNameCompleter.class)
        private List<String> requestorNames;
        @Option(name="--force", aliases={"-f"}, description="without prompt")
        private Boolean force = Boolean.FALSE;

        protected Object execute0() throws Exception {
            for (String requestorName : this.requestorNames) {
                String msg = "requestor " + requestorName + " from CA " + this.caName;
                if (!this.force.booleanValue() && !this.confirm("Do you want to remove " + msg, 3)) continue;
                try {
                    this.caManager.removeRequestorFromCa(requestorName, this.caName);
                    this.println("removed " + msg);
                }
                catch (CaMgmtException ex) {
                    throw new CmdFailure("could not remove " + msg + ", error: " + ex.getMessage(), (Throwable)ex);
                }
            }
            return null;
        }
    }

    @Command(scope="ca", name="careq-info", description="show information of requestor in CA")
    @Service
    public static class CareqInfo
    extends CaAction {
        @Option(name="--ca", required=true, description="CA name")
        @Completion(value=CaCompleters.CaNameCompleter.class)
        private String caName;

        protected Object execute0() throws Exception {
            if (this.caManager.getCa(this.caName) == null) {
                throw new CmdFailure("could not find CA '" + this.caName + "'");
            }
            StringBuilder sb = new StringBuilder();
            Set entries = this.caManager.getRequestorsForCa(this.caName);
            if (CareqInfo.isNotEmpty((Collection)entries)) {
                sb.append("requestors trusted by CA " + this.caName).append("\n");
                for (MgmtEntry.CaHasRequestor entry : entries) {
                    sb.append("----------\n").append(entry).append("\n");
                }
            } else {
                sb.append("no requestor for CA " + this.caName + " is configured");
            }
            this.println(sb.toString());
            return null;
        }
    }

    @Command(scope="ca", name="careq-add", description="add requestor to CA")
    @Service
    public static class CareqAdd
    extends CaAction {
        @Option(name="--ca", required=true, description="CA name")
        @Completion(value=CaCompleters.CaNameCompleter.class)
        private String caName;
        @Option(name="--requestor", required=true, description="requestor name")
        @Completion(value=CaCompleters.RequestorNameCompleter.class)
        private String requestorName;
        @Option(name="--ra", description="whether as RA")
        @Completion(value=Completers.YesNoCompleter.class)
        private String raS = "no";
        @Option(name="--permission", required=true, multiValued=true, description="permission")
        @Completion(value=CaCompleters.PermissionCompleter.class)
        private Set<String> permissions;
        @Option(name="--profile", multiValued=true, description="profile name or 'all' for all profiles")
        @Completion(value=CaCompleters.ProfileNameAndAllCompleter.class)
        private Set<String> profiles;

        protected Object execute0() throws Exception {
            boolean ra = CareqAdd.isEnabled((String)this.raS, (boolean)false, (String)"ra");
            MgmtEntry.CaHasRequestor entry = new MgmtEntry.CaHasRequestor(new NameId(null, this.requestorName));
            entry.setRa(ra);
            entry.setProfiles(this.profiles);
            int intPermission = ShellUtil.getPermission(this.permissions);
            entry.setPermission(intPermission);
            String msg = "requestor " + this.requestorName + " to CA " + this.caName;
            try {
                this.caManager.addRequestorToCa(entry, this.caName);
                this.println("added " + msg);
                return null;
            }
            catch (CaMgmtException ex) {
                throw new CmdFailure("could not add " + msg + ", error: " + ex.getMessage(), (Throwable)ex);
            }
        }
    }

    @Command(scope="ca", name="ca-rm", description="remove CA")
    @Service
    public static class CaRm
    extends CaAction {
        @Argument(index=0, name="name", required=true, description="CA name")
        @Completion(value=CaCompleters.CaNameCompleter.class)
        private String name;
        @Option(name="--force", aliases={"-f"}, description="without prompt")
        private Boolean force = Boolean.FALSE;

        protected Object execute0() throws Exception {
            String msg = "CA " + this.name;
            if (this.force.booleanValue() || this.confirm("Do you want to remove " + msg, 3)) {
                try {
                    this.caManager.removeCa(this.name);
                    this.println("removed " + msg);
                }
                catch (CaMgmtException ex) {
                    throw new CmdFailure("could not remove " + msg + ", error: " + ex.getMessage(), (Throwable)ex);
                }
            }
            return null;
        }
    }

    @Command(scope="ca", name="capub-rm", description="remove publisher from CA")
    @Service
    public static class CapubRm
    extends CaAction {
        @Option(name="--ca", required=true, description="CA name")
        @Completion(value=CaCompleters.CaNameCompleter.class)
        private String caName;
        @Option(name="--publisher", required=true, multiValued=true, description="publisher name")
        @Completion(value=CaCompleters.PublisherNameCompleter.class)
        private List<String> publisherNames;
        @Option(name="--force", aliases={"-f"}, description="without prompt")
        private Boolean force = Boolean.FALSE;

        protected Object execute0() throws Exception {
            for (String publisherName : this.publisherNames) {
                String msg = "publisher " + publisherName + " from CA " + this.caName;
                if (!this.force.booleanValue() && !this.confirm("Do you want to remove " + msg, 3)) continue;
                try {
                    this.caManager.removePublisherFromCa(publisherName, this.caName);
                    this.println("removed " + msg);
                }
                catch (CaMgmtException ex) {
                    throw new CmdFailure("could not remove " + msg + ", error: " + ex.getMessage(), (Throwable)ex);
                }
            }
            return null;
        }
    }

    @Command(scope="ca", name="capub-info", description="show information of publisher in given CA")
    @Service
    public static class CapubInfo
    extends CaAction {
        @Option(name="--ca", required=true, description="CA name")
        @Completion(value=CaCompleters.CaNameCompleter.class)
        private String caName;

        protected Object execute0() throws Exception {
            if (this.caManager.getCa(this.caName) == null) {
                throw new CmdFailure("could not find CA '" + this.caName + "'");
            }
            List entries = this.caManager.getPublishersForCa(this.caName);
            if (CapubInfo.isNotEmpty((Collection)entries)) {
                StringBuilder sb = new StringBuilder();
                sb.append("publishers for CA ").append(this.caName).append("\n");
                for (MgmtEntry.Publisher entry : entries) {
                    sb.append("\t").append(entry.getIdent().getName()).append("\n");
                }
                this.println(sb.toString());
            } else {
                this.println(StringUtil.concat((String)"no publisher for CA ", (String[])new String[]{this.caName, " is configured"}));
            }
            return null;
        }
    }

    @Command(scope="ca", name="capub-add", description="add publisher to CA")
    @Service
    public static class CapubAdd
    extends CaAction {
        @Option(name="--ca", required=true, description="CA name")
        @Completion(value=CaCompleters.CaNameCompleter.class)
        private String caName;
        @Option(name="--publisher", required=true, multiValued=true, description="publisher name")
        @Completion(value=CaCompleters.PublisherNameCompleter.class)
        private List<String> publisherNames;

        protected Object execute0() throws Exception {
            for (String publisherName : this.publisherNames) {
                String msg = "publisher " + publisherName + " to CA " + this.caName;
                try {
                    this.caManager.addPublisherToCa(publisherName, this.caName);
                    this.println("added " + msg);
                }
                catch (CaMgmtException ex) {
                    throw new CmdFailure("could not add " + msg + ", error: " + ex.getMessage(), (Throwable)ex);
                }
            }
            return null;
        }
    }

    @Command(scope="ca", name="caprofile-rm", description="remove certificate profile from CA")
    @Service
    public static class CaprofileRm
    extends CaAction {
        @Option(name="--ca", required=true, description="CA name")
        @Completion(value=CaCompleters.CaNameCompleter.class)
        private String caName;
        @Option(name="--profile", required=true, multiValued=true, description="certificate profile name")
        @Completion(value=CaCompleters.ProfileNameCompleter.class)
        private List<String> profileNames;
        @Option(name="--force", aliases={"-f"}, description="without prompt")
        private Boolean force = Boolean.FALSE;

        protected Object execute0() throws Exception {
            for (String profileName : this.profileNames) {
                String msg = StringUtil.concat((String)"certificate profile ", (String[])new String[]{profileName, " from CA ", this.caName});
                if (!this.force.booleanValue() && !this.confirm("Do you want to remove " + msg, 3)) continue;
                try {
                    this.caManager.removeCertprofileFromCa(profileName, this.caName);
                    this.println("removed " + msg);
                }
                catch (CaMgmtException ex) {
                    throw new CmdFailure("could not remove " + msg + ", error: " + ex.getMessage(), (Throwable)ex);
                }
            }
            return null;
        }
    }

    @Command(scope="ca", name="caprofile-info", description="show information of certificate profile in given CA")
    @Service
    public static class CaprofileInfo
    extends CaAction {
        @Option(name="--ca", required=true, description="CA name")
        @Completion(value=CaCompleters.CaNameCompleter.class)
        private String caName;

        protected Object execute0() throws Exception {
            if (this.caManager.getCa(this.caName) == null) {
                throw new CmdFailure("could not find CA '" + this.caName + "'");
            }
            StringBuilder sb = new StringBuilder();
            Set entries = this.caManager.getCertprofilesForCa(this.caName);
            if (CollectionUtil.isNotEmpty((Collection)entries)) {
                sb.append("certificate Profiles supported by CA " + this.caName).append("\n");
                for (String name : entries) {
                    sb.append("\t").append(name).append("\n");
                }
            } else {
                sb.append("\tno profile for CA " + this.caName + " is configured");
            }
            this.println(sb.toString());
            return null;
        }
    }

    @Command(scope="ca", name="caprofile-add", description="add certificate profile to CA")
    @Service
    public static class CaprofileAdd
    extends CaAction {
        @Option(name="--ca", required=true, description="CA name")
        @Completion(value=CaCompleters.CaNameCompleter.class)
        private String caName;
        @Option(name="--profile", required=true, multiValued=true, description="profile name")
        @Completion(value=CaCompleters.ProfileNameCompleter.class)
        private List<String> profileNames;

        protected Object execute0() throws Exception {
            for (String profileName : this.profileNames) {
                String msg = StringUtil.concat((String)"certificate profile ", (String[])new String[]{profileName, " to CA ", this.caName});
                try {
                    this.caManager.addCertprofileToCa(profileName, this.caName);
                    this.println("associated " + msg);
                }
                catch (CaMgmtException ex) {
                    throw new CmdFailure("could not associate " + msg + ", error: " + ex.getMessage(), (Throwable)ex);
                }
            }
            return null;
        }
    }

    @Command(scope="ca", name="ca-info", description="show information of CA")
    @Service
    public static class CaInfo
    extends CaAction {
        @Argument(index=0, name="name", description="CA name")
        @Completion(value=CaCompleters.CaNameCompleter.class)
        private String name;
        @Option(name="--verbose", aliases={"-v"}, description="show CA information verbosely")
        private Boolean verbose = Boolean.FALSE;

        protected Object execute0() throws Exception {
            StringBuilder sb = new StringBuilder();
            if (this.name == null) {
                sb.append("successful CAs:\n");
                String prefix = "  ";
                this.printCaNames(sb, this.caManager.getSuccessfulCaNames(), prefix);
                sb.append("failed CAs:\n");
                this.printCaNames(sb, this.caManager.getFailedCaNames(), prefix);
                sb.append("inactive CAs:\n");
                this.printCaNames(sb, this.caManager.getInactiveCaNames(), prefix);
            } else {
                MgmtEntry.Ca entry = this.caManager.getCa(this.name);
                if (entry == null) {
                    throw new CmdFailure("could not find CA '" + this.name + "'");
                }
                if (CaStatus.ACTIVE == entry.getStatus()) {
                    boolean started = this.caManager.getSuccessfulCaNames().contains(entry.getIdent().getName());
                    sb.append("started: ").append(started).append("\n");
                }
                Set aliases = this.caManager.getAliasesForCa(this.name);
                sb.append("aliases: ").append(CaInfo.toString(aliases)).append("\n");
                sb.append(entry.toString(this.verbose.booleanValue()));
            }
            this.println(sb.toString());
            return null;
        }
    }

    @Command(scope="ca", name="gen-rootca", description="generate selfsigned CA")
    @Service
    public static class GenRootca
    extends CaAddOrGenAction {
        @Option(name="--csr", required=true, description="CSR of the Root CA")
        @Completion(value=FileCompleter.class)
        private String csrFile;
        @Option(name="--profile", required=true, description="profile of the Root CA")
        private String rootcaProfile;
        @Option(name="--serial", description="profile of the Root CA")
        private String serialS;
        @Option(name="--outform", description="output format of the certificate")
        @Completion(value=Completers.DerPemCompleter.class)
        protected String outform = "der";
        @Option(name="--out", aliases={"-o"}, description="where to save the generated CA certificate")
        @Completion(value=FileCompleter.class)
        private String rootcaCertOutFile;

        protected Object execute0() throws Exception {
            MgmtEntry.Ca caEntry = this.getCaEntry();
            byte[] csr = IoUtil.read((String)this.csrFile);
            BigInteger serialNumber = null;
            if (this.serialS != null) {
                serialNumber = GenRootca.toBigInt((String)this.serialS);
            }
            X509Certificate rootcaCert = this.caManager.generateRootCa(caEntry, this.rootcaProfile, csr, serialNumber);
            if (this.rootcaCertOutFile != null) {
                this.saveVerbose("saved root certificate to file", this.rootcaCertOutFile, GenRootca.encodeCert((byte[])rootcaCert.getEncoded(), (String)this.outform));
            }
            this.println("generated root CA " + caEntry.getIdent().getName());
            return null;
        }
    }

    @Command(scope="ca", name="caalias-rm", description="remove CA alias")
    @Service
    public static class CaaliasRm
    extends CaAction {
        @Argument(index=0, name="alias", description="CA alias", required=true)
        @Completion(value=CaCompleters.CaAliasCompleter.class)
        private String caAlias;
        @Option(name="--force", aliases={"-f"}, description="without prompt")
        private Boolean force = Boolean.FALSE;

        protected Object execute0() throws Exception {
            String msg = "CA alias " + this.caAlias;
            if (this.force.booleanValue() || this.confirm("Do you want to remove " + msg, 3)) {
                try {
                    this.caManager.removeCaAlias(this.caAlias);
                    this.println("removed " + msg);
                }
                catch (CaMgmtException ex) {
                    throw new CmdFailure("could not remove " + msg + ", error: " + ex.getMessage(), (Throwable)ex);
                }
            }
            return null;
        }
    }

    @Command(scope="ca", name="caalias-info", description="show information of CA alias")
    @Service
    public static class CaaliasInfo
    extends CaAction {
        @Argument(index=0, name="alias", description="CA alias")
        @Completion(value=CaCompleters.CaAliasCompleter.class)
        private String caAlias;

        protected Object execute0() throws Exception {
            Set aliasNames = this.caManager.getCaAliasNames();
            StringBuilder sb = new StringBuilder();
            if (this.caAlias == null) {
                int size = aliasNames.size();
                if (size == 0 || size == 1) {
                    sb.append(size == 0 ? "no" : "1");
                    sb.append(" CA alias is configured\n");
                } else {
                    sb.append(size).append(" CA aliases are configured:\n");
                }
                ArrayList sorted = new ArrayList(aliasNames);
                Collections.sort(sorted);
                for (String aliasName : sorted) {
                    sb.append("\t").append(aliasName).append("\n");
                }
            } else if (aliasNames.contains(this.caAlias)) {
                String paramValue = this.caManager.getCaNameForAlias(this.caAlias);
                sb.append(this.caAlias).append("\n\t").append(paramValue);
            } else {
                throw new CmdFailure("could not find CA alias '" + this.caAlias + "'");
            }
            this.println(sb.toString());
            return null;
        }
    }

    @Command(scope="ca", name="caalias-add", description="add CA alias")
    @Service
    public static class CaaliasAdd
    extends CaAction {
        @Option(name="--ca", required=true, description="CA name")
        @Completion(value=CaCompleters.CaNameCompleter.class)
        private String caName;
        @Option(name="--alias", required=true, description="CA alias")
        private String caAlias;

        protected Object execute0() throws Exception {
            String msg = "CA alias " + this.caAlias + " associated with CA " + this.caName;
            try {
                this.caManager.addCaAlias(this.caAlias, this.caName);
                this.println("added " + msg);
                return null;
            }
            catch (CaMgmtException ex) {
                throw new CmdFailure("could not add " + msg + ", error: " + ex.getMessage(), (Throwable)ex);
            }
        }
    }

    public static abstract class CaAddOrGenAction
    extends CaAction {
        @Option(name="--name", aliases={"-n"}, required=true, description="CA name")
        private String caName;
        @Option(name="--status", description="CA status")
        @Completion(value=CaCompleters.CaStatusCompleter.class)
        private String caStatus = "active";
        @Option(name="--rest-status", description="REST API status")
        @Completion(value=CaCompleters.CaStatusCompleter.class)
        private String restStatus = "inactive";
        @Option(name="--ca-cert-uri", multiValued=true, description="CA certificate URI")
        private List<String> caCertUris;
        @Option(name="--ocsp-uri", multiValued=true, description="OCSP URI")
        private List<String> ocspUris;
        @Option(name="--crl-uri", multiValued=true, description="CRL distribution point")
        private List<String> crlUris;
        @Option(name="--deltacrl-uri", multiValued=true, description="CRL distribution point")
        private List<String> deltaCrlUris;
        @Option(name="--permission", required=true, multiValued=true, description="permission")
        @Completion(value=CaCompleters.PermissionCompleter.class)
        private Set<String> permissions;
        @Option(name="--sn-bitlen", description="number of bits of the serial number, between 71 and 159")
        private int snBitLen = 127;
        @Option(name="--next-crl-no", required=true, description="CRL number for the next CRL")
        private Long nextCrlNumber;
        @Option(name="--max-validity", required=true, description="maximal validity")
        private String maxValidity;
        @Option(name="--keep-expired-certs", description="days to keep expired certificates")
        private Integer keepExpiredCertInDays = -1;
        @Option(name="--crl-signer", description="CRL signer name")
        @Completion(value=CaCompleters.SignerNameCompleter.class)
        private String crlSignerName;
        @Option(name="--cmp-responder", description="CMP responder name")
        @Completion(value=CaCompleters.SignerNameCompleter.class)
        private String cmpResponderName;
        @Option(name="--scep-responder", description="SCEP responder name")
        @Completion(value=CaCompleters.SignerNameCompleter.class)
        private String scepResponderName;
        @Option(name="--cmp-control", description="CMP control")
        private String cmpControl;
        @Option(name="--crl-control", description="CRL control")
        private String crlControl;
        @Option(name="--scep-control", description="SCEP control")
        private String scepControl;
        @Option(name="--ctlog-control", description="CT log control")
        private String ctlogControl;
        @Option(name="--dhpoc-control", description="DHPoc control")
        private String dhpocControl;
        @Option(name="--revoke-suspended-control", description="Revoke suspended certificates control")
        private String revokeSuspendedControl;
        @Option(name="--num-crls", description="number of CRLs to be kept in database")
        private Integer numCrls = 30;
        @Option(name="--expiration-period", description="days before expiration time of CA to issue certificates")
        private Integer expirationPeriod = 365;
        @Option(name="--signer-type", required=true, description="CA signer type")
        @Completion(value=CaCompleters.SignerTypeCompleter.class)
        private String signerType;
        @Option(name="--signer-conf", required=true, description="CA signer configuration")
        private String signerConf;
        @Option(name="--duplicate-key", description="whether duplicate key is permitted")
        @Completion(value=Completers.YesNoCompleter.class)
        private String duplicateKeyS = "yes";
        @Option(name="--duplicate-subject", description="whether duplicate subject is permitted")
        @Completion(value=Completers.YesNoCompleter.class)
        private String duplicateSubjectS = "yes";
        @Option(name="--support-cmp", description="whether the CMP protocol is supported")
        @Completion(value=Completers.YesNoCompleter.class)
        private String supportCmpS = "no";
        @Option(name="--support-rest", description="whether the REST protocol is supported")
        @Completion(value=Completers.YesNoCompleter.class)
        private String supportRestS = "no";
        @Option(name="--support-scep", description="whether the SCEP protocol is supported")
        @Completion(value=Completers.YesNoCompleter.class)
        private String supportScepS = "no";
        @Option(name="--save-req", description="whether the request is saved")
        @Completion(value=Completers.YesNoCompleter.class)
        private String saveReqS = "no";
        @Option(name="--validity-mode", description="mode of valditity")
        @Completion(value=CaCompleters.ValidityModeCompleter.class)
        private String validityModeS = "STRICT";
        @Option(name="--extra-control", description="extra control")
        private String extraControl;
        @Reference
        private PasswordResolver passwordResolver;

        protected MgmtEntry.Ca getCaEntry() throws Exception {
            Args.range((int)this.snBitLen, (String)"sn-bitlen", (int)71, (int)159);
            if (this.nextCrlNumber < 1L) {
                throw new IllegalCmdParamException("invalid CRL number: " + this.nextCrlNumber);
            }
            if (this.numCrls < 0) {
                throw new IllegalCmdParamException("invalid numCrls: " + this.numCrls);
            }
            if (this.expirationPeriod < 0) {
                throw new IllegalCmdParamException("invalid expirationPeriod: " + this.expirationPeriod);
            }
            if ("PKCS12".equalsIgnoreCase(this.signerType) || "JKS".equalsIgnoreCase(this.signerType)) {
                this.signerConf = ShellUtil.canonicalizeSignerConf(this.signerType, this.signerConf, this.passwordResolver, this.securityFactory);
            }
            CaUris caUris = new CaUris(this.caCertUris, this.ocspUris, this.crlUris, this.deltaCrlUris);
            MgmtEntry.Ca entry = new MgmtEntry.Ca(new NameId(null, this.caName), this.snBitLen, this.nextCrlNumber.longValue(), this.signerType, this.signerConf, caUris, this.numCrls.intValue(), this.expirationPeriod.intValue());
            entry.setKeepExpiredCertInDays(this.keepExpiredCertInDays.intValue());
            boolean duplicateKeyPermitted = CaAddOrGenAction.isEnabled((String)this.duplicateKeyS, (boolean)true, (String)"duplicate-key");
            entry.setDuplicateKeyPermitted(duplicateKeyPermitted);
            boolean duplicateSubjectPermitted = CaAddOrGenAction.isEnabled((String)this.duplicateSubjectS, (boolean)true, (String)"duplicate-subject");
            entry.setDuplicateSubjectPermitted(duplicateSubjectPermitted);
            ProtocolSupport protocolSupport = new ProtocolSupport(CaAddOrGenAction.isEnabled((String)this.supportCmpS, (boolean)false, (String)"support-cmp"), CaAddOrGenAction.isEnabled((String)this.supportRestS, (boolean)false, (String)"support-rest"), CaAddOrGenAction.isEnabled((String)this.supportScepS, (boolean)false, (String)"support-scep"));
            entry.setProtocolSupport(protocolSupport);
            entry.setSaveRequest(CaAddOrGenAction.isEnabled((String)this.saveReqS, (boolean)false, (String)"save-req"));
            ValidityMode validityMode = ValidityMode.forName((String)this.validityModeS);
            entry.setValidityMode(validityMode);
            entry.setStatus(CaStatus.forName((String)this.caStatus));
            if (this.cmpControl != null) {
                entry.setCmpControl(new CmpControl(this.cmpControl));
            }
            if (this.crlControl != null) {
                entry.setCrlControl(new CrlControl(this.crlControl));
            }
            if (this.scepControl != null) {
                entry.setScepControl(new ScepControl(this.scepControl));
            }
            if (this.ctlogControl != null) {
                entry.setCtlogControl(new CtlogControl(this.ctlogControl));
            }
            if (this.dhpocControl != null) {
                String conf = this.dhpocControl;
                if (conf.contains("file:")) {
                    ConfPairs confPairs = new ConfPairs(conf);
                    entry.setDhpocControl(this.embedFileContent(confPairs).getEncoded());
                } else {
                    entry.setDhpocControl(this.dhpocControl);
                }
            }
            if (this.revokeSuspendedControl != null) {
                entry.setRevokeSuspendedControl(new RevokeSuspendedControl(new ConfPairs(this.revokeSuspendedControl)));
            }
            if (this.cmpResponderName != null) {
                entry.setCmpResponderName(this.cmpResponderName);
            }
            if (this.scepResponderName != null) {
                entry.setCmpResponderName(this.scepResponderName);
            }
            if (this.crlSignerName != null) {
                entry.setCrlSignerName(this.crlSignerName);
            }
            Validity tmpMaxValidity = Validity.getInstance((String)this.maxValidity);
            entry.setMaxValidity(tmpMaxValidity);
            entry.setKeepExpiredCertInDays(this.keepExpiredCertInDays.intValue());
            int intPermission = ShellUtil.getPermission(this.permissions);
            entry.setPermission(intPermission);
            if (this.extraControl != null) {
                this.extraControl = this.extraControl.trim();
            }
            if (StringUtil.isNotBlank((String)this.extraControl)) {
                entry.setExtraControl(new ConfPairs(this.extraControl).unmodifiable());
            }
            return entry;
        }
    }

    @Command(scope="ca", name="ca-add", description="add CA")
    @Service
    public static class CaAdd
    extends CaAddOrGenAction {
        @Option(name="--cert", description="CA certificate file")
        @Completion(value=FileCompleter.class)
        private String certFile;
        @Option(name="--certchain", multiValued=true, description="certificate chain of CA certificate")
        @Completion(value=FileCompleter.class)
        private List<String> issuerCertFiles;

        protected Object execute0() throws Exception {
            MgmtEntry.Ca caEntry = this.getCaEntry();
            if (this.certFile != null) {
                X509Certificate caCert = X509Util.parseCert((File)new File(this.certFile));
                caEntry.setCert(caCert);
            }
            if (CollectionUtil.isNotEmpty(this.issuerCertFiles)) {
                ArrayList<X509Certificate> list = new ArrayList<X509Certificate>(this.issuerCertFiles.size());
                for (String m : this.issuerCertFiles) {
                    list.add(X509Util.parseCert((File)Paths.get(m, new String[0]).toFile()));
                }
                caEntry.setCertchain(list);
            }
            String msg = "CA " + caEntry.getIdent().getName();
            try {
                this.caManager.addCa(caEntry);
                this.println("added " + msg);
                return null;
            }
            catch (CaMgmtException ex) {
                throw new CmdFailure("could not add " + msg + ", error: " + ex.getMessage(), (Throwable)ex);
            }
        }
    }

    public static abstract class CaAction
    extends XiAction {
        @Reference
        protected CaManager caManager;
        @Reference
        protected SecurityFactory securityFactory;

        protected static String getRealString(String str) {
            return "null".equalsIgnoreCase(str) ? null : str;
        }

        protected static String toString(Collection<? extends Object> col) {
            if (col == null) {
                return "null";
            }
            StringBuilder sb = new StringBuilder();
            sb.append("{");
            int size = col.size();
            int idx = 0;
            for (Object object : col) {
                sb.append(object);
                if (idx < size - 1) {
                    sb.append(", ");
                }
                ++idx;
            }
            sb.append("}");
            return sb.toString();
        }

        protected void printCaNames(StringBuilder sb, Set<String> caNames, String prefix) throws CaMgmtException {
            if (caNames.isEmpty()) {
                sb.append(prefix).append("-\n");
                return;
            }
            for (String caName : caNames) {
                Set aliases = this.caManager.getAliasesForCa(caName);
                if (CollectionUtil.isEmpty((Collection)aliases)) {
                    sb.append(prefix).append(caName);
                } else {
                    sb.append(prefix).append(caName + " (aliases " + aliases + ")");
                }
                sb.append("\n");
            }
        }
    }
}

