/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.ca.mgmt.shell;

import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import org.apache.karaf.shell.api.action.lifecycle.Reference;
import org.apache.karaf.shell.api.action.lifecycle.Service;
import org.xipki.ca.api.mgmt.CaManager;
import org.xipki.ca.api.mgmt.CaMgmtException;
import org.xipki.ca.api.mgmt.CertListOrderBy;
import org.xipki.ca.api.mgmt.MgmtEntry;
import org.xipki.ca.api.mgmt.ValidityMode;
import org.xipki.ca.mgmt.shell.CaActions;
import org.xipki.security.CrlReason;
import org.xipki.security.X509Cert;
import org.xipki.shell.DynamicEnumCompleter;
import org.xipki.shell.EnumCompleter;

public class CaCompleters {

    @Service
    public static class ValidityModeCompleter
    extends EnumCompleter {
        public ValidityModeCompleter() {
            LinkedList<String> enums = new LinkedList<String>();
            for (ValidityMode mode : ValidityMode.values()) {
                enums.add(mode.name());
            }
            this.setTokens(enums);
        }
    }

    @Service
    public static class SignerTypeCompleter
    extends CaMgmtCompleter {
        protected Set<String> getEnums() {
            try {
                return this.caManager.getSupportedSignerTypes();
            }
            catch (CaMgmtException ex) {
                return Collections.emptySet();
            }
        }
    }

    @Service
    public static class SignerNamePlusNullCompleter
    extends CaMgmtCompleter {
        protected Set<String> getEnums() {
            HashSet<String> ret = new HashSet<String>();
            try {
                ret.addAll(this.caManager.getSignerNames());
            }
            catch (CaMgmtException caMgmtException) {
                // empty catch block
            }
            ret.add("null");
            return ret;
        }
    }

    @Service
    public static class SignerNameCompleter
    extends CaMgmtCompleter {
        protected Set<String> getEnums() {
            try {
                return this.caManager.getSignerNames();
            }
            catch (CaMgmtException ex) {
                return Collections.emptySet();
            }
        }
    }

    @Service
    public static class RequestorNameCompleter
    extends CaMgmtCompleter {
        protected Set<String> getEnums() {
            HashSet<String> names = new HashSet<String>();
            try {
                names.addAll(this.caManager.getRequestorNames());
            }
            catch (CaMgmtException caMgmtException) {
                // empty catch block
            }
            names.remove("by-ca");
            names.remove("by-user");
            return names;
        }
    }

    @Service
    public static class RcaNameCompleter
    extends CaMgmtCompleter {
        protected Set<String> getEnums() {
            Set caNames;
            try {
                caNames = this.caManager.getCaNames();
            }
            catch (CaMgmtException ex) {
                return Collections.emptySet();
            }
            HashSet<String> ret = new HashSet<String>();
            for (String name : caNames) {
                MgmtEntry.Ca caEntry;
                try {
                    caEntry = this.caManager.getCa(name);
                }
                catch (CaMgmtException ex) {
                    continue;
                }
                X509Cert cert = caEntry.getCert();
                if (!cert.isSelfSigned()) continue;
                ret.add(name);
            }
            return ret;
        }
    }

    @Service
    public static class PublisherTypeCompleter
    extends CaMgmtCompleter {
        protected Set<String> getEnums() {
            try {
                return this.caManager.getSupportedPublisherTypes();
            }
            catch (CaMgmtException ex) {
                return Collections.emptySet();
            }
        }
    }

    @Service
    public static class PublisherNamePlusAllCompleter
    extends CaMgmtCompleter {
        protected Set<String> getEnums() {
            HashSet<String> ret;
            try {
                ret = new HashSet(this.caManager.getPublisherNames());
            }
            catch (CaMgmtException ex) {
                ret = new HashSet<String>();
            }
            ret.add("all");
            return ret;
        }
    }

    @Service
    public static class PublisherNameCompleter
    extends CaMgmtCompleter {
        protected Set<String> getEnums() {
            try {
                return this.caManager.getPublisherNames();
            }
            catch (CaMgmtException ex) {
                return Collections.emptySet();
            }
        }
    }

    @Service
    public static class ProfileTypeCompleter
    extends CaMgmtCompleter {
        protected Set<String> getEnums() {
            try {
                return this.caManager.getSupportedCertprofileTypes();
            }
            catch (CaMgmtException ex) {
                return Collections.emptySet();
            }
        }
    }

    @Service
    public static class ProfileNameCompleter
    extends CaMgmtCompleter {
        protected Set<String> getEnums() {
            try {
                return this.caManager.getCertprofileNames();
            }
            catch (CaMgmtException ex) {
                return Collections.emptySet();
            }
        }
    }

    @Service
    public static class ProfileNameAndAllCompleter
    extends CaMgmtCompleter {
        protected Set<String> getEnums() {
            HashSet<String> ret;
            try {
                ret = new HashSet(this.caManager.getCertprofileNames());
            }
            catch (CaMgmtException ex) {
                ret = new HashSet<String>();
            }
            ret.add("all");
            return ret;
        }
    }

    @Service
    public static class PermissionCompleter
    extends EnumCompleter {
        public PermissionCompleter() {
            this.setTokens(new String[]{"enroll_cert", "revoke_cert", "unrevoke_cert", "remove_cert", "key_update", "gen_crl", "get_crl", "enroll_cross", "all"});
        }
    }

    @Service
    public static class CertListSortByCompleter
    extends EnumCompleter {
        public CertListSortByCompleter() {
            LinkedList<String> enums = new LinkedList<String>();
            for (CertListOrderBy sort : CertListOrderBy.values()) {
                enums.add(sort.getText());
            }
            this.setTokens(enums);
        }
    }

    @Service
    public static class CaStatusCompleter
    extends EnumCompleter {
        public CaStatusCompleter() {
            this.setTokens(new String[]{"active", "inactive"});
        }
    }

    @Service
    public static class CaNamePlusAllCompleter
    extends CaMgmtCompleter {
        protected Set<String> getEnums() {
            HashSet<String> ret;
            try {
                ret = new HashSet(this.caManager.getCaNames());
            }
            catch (CaMgmtException ex) {
                ret = new HashSet<String>();
            }
            ret.add("all");
            return ret;
        }
    }

    @Service
    public static class CaNameCompleter
    extends CaMgmtCompleter {
        protected Set<String> getEnums() {
            try {
                return this.caManager.getCaNames();
            }
            catch (CaMgmtException ex) {
                return Collections.emptySet();
            }
        }
    }

    @Service
    public static class CaCrlReasonCompleter
    extends EnumCompleter {
        public CaCrlReasonCompleter() {
            LinkedList<String> enums = new LinkedList<String>();
            for (CrlReason reason : CaActions.CaRevoke.PERMITTED_REASONS) {
                enums.add(reason.getDescription());
            }
            this.setTokens(enums);
        }
    }

    @Service
    public static class CaAliasCompleter
    extends CaMgmtCompleter {
        protected Set<String> getEnums() {
            try {
                return this.caManager.getCaAliasNames();
            }
            catch (CaMgmtException ex) {
                return Collections.emptySet();
            }
        }
    }

    public static abstract class CaMgmtCompleter
    extends DynamicEnumCompleter {
        @Reference
        protected CaManager caManager;
    }
}

