/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.ca.mgmt.shell;

import java.io.File;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.apache.karaf.shell.api.action.Command;
import org.apache.karaf.shell.api.action.Completion;
import org.apache.karaf.shell.api.action.Option;
import org.apache.karaf.shell.api.action.lifecycle.Reference;
import org.apache.karaf.shell.api.action.lifecycle.Service;
import org.apache.karaf.shell.support.completers.FileCompleter;
import org.xipki.ca.mgmt.db.diffdb.DigestDiffWorker;
import org.xipki.ca.mgmt.db.port.DbPortWorker;
import org.xipki.datasource.DataSourceFactory;
import org.xipki.password.PasswordResolver;
import org.xipki.security.util.X509Util;
import org.xipki.shell.Completers;
import org.xipki.shell.XiAction;

public class DbActions {

    @Command(scope="ca", name="import-ocspfromca", description="import OCSP database from CA data")
    @Service
    public static class ImportOcspfromca
    extends DbPortAction {
        private static final String DFLT_PUBLISHER = "ocsp-publisher";
        @Option(name="--db-conf", required=true, description="database configuration file")
        @Completion(value=FileCompleter.class)
        private String dbconfFile;
        @Option(name="--in-dir", required=true, description="input directory")
        @Completion(value=Completers.DirCompleter.class)
        private String indir;
        @Option(name="--publisher", description="publisher name")
        private String publisherName = "ocsp-publisher";
        @Option(name="-k", description="number of certificates per commit")
        private Integer numCertsPerCommit = 100;
        @Option(name="--resume", description="resume from the last successful point")
        private Boolean resume = Boolean.FALSE;
        @Option(name="--test", description="just test the import, no real import")
        private Boolean testOnly = Boolean.FALSE;

        @Override
        protected DbPortWorker getDbPortWorker() throws Exception {
            return new DbPortWorker.ImportOcspFromCaDb(this.datasourceFactory, this.passwordResolver, this.dbconfFile, this.publisherName, this.resume.booleanValue(), this.indir, this.numCertsPerCommit.intValue(), this.testOnly.booleanValue());
        }
    }

    @Command(scope="ca", name="import-ocsp", description="import OCSP database")
    @Service
    public static class ImportOcsp
    extends DbPortAction {
        @Option(name="--db-conf", required=true, description="database configuration file")
        @Completion(value=FileCompleter.class)
        private String dbconfFile;
        @Option(name="--in-dir", required=true, description="input directory")
        @Completion(value=Completers.DirCompleter.class)
        private String indir;
        @Option(name="-k", description="number of certificates per commit")
        private Integer numCertsPerCommit = 100;
        @Option(name="--resume", description="resume from the last successful point")
        private Boolean resume = Boolean.FALSE;

        @Override
        protected DbPortWorker getDbPortWorker() throws Exception {
            return new DbPortWorker.ImportOcspDb(this.datasourceFactory, this.passwordResolver, this.dbconfFile, this.resume.booleanValue(), this.indir, this.numCertsPerCommit.intValue());
        }
    }

    @Command(scope="ca", name="import-ca", description="import CA database")
    @Service
    public static class ImportCa
    extends DbPortAction {
        @Option(name="--db-conf", required=true, description="database configuration file")
        @Completion(value=FileCompleter.class)
        private String dbconfFile;
        @Option(name="--in-dir", required=true, description="input directory")
        @Completion(value=Completers.DirCompleter.class)
        private String indir;
        @Option(name="-k", description="number of certificates per commit")
        private Integer numCertsPerCommit = 100;
        @Option(name="--resume", description="resume from the last successful point")
        private Boolean resume = Boolean.FALSE;

        @Override
        protected DbPortWorker getDbPortWorker() throws Exception {
            return new DbPortWorker.ImportCaDb(this.datasourceFactory, this.passwordResolver, this.dbconfFile, this.resume.booleanValue(), this.indir, this.numCertsPerCommit.intValue());
        }
    }

    @Command(scope="ca", name="export-ocsp", description="export OCSP database")
    @Service
    public static class ExportOcsp
    extends DbPortAction {
        @Option(name="--db-conf", required=true, description="database configuration file.")
        @Completion(value=FileCompleter.class)
        private String dbconfFile;
        @Option(name="--out-dir", required=true, description="output directory")
        @Completion(value=Completers.DirCompleter.class)
        private String outdir;
        @Option(name="-n", description="number of certificates in one zip file")
        private Integer numCertsInBundle = 10000;
        @Option(name="-k", description="number of certificates per SELECT")
        private Integer numCertsPerSelect = 100;
        @Option(name="--resume", description="resume from the last successful point")
        private Boolean resume = Boolean.FALSE;

        @Override
        protected DbPortWorker getDbPortWorker() throws Exception {
            return new DbPortWorker.ExportOcspDb(this.datasourceFactory, this.passwordResolver, this.dbconfFile, this.outdir, this.resume.booleanValue(), this.numCertsInBundle.intValue(), this.numCertsPerSelect.intValue());
        }
    }

    @Command(scope="ca", name="export-ca", description="export CA database")
    @Service
    public static class ExportCa
    extends DbPortAction {
        @Option(name="--db-conf", required=true, description="database configuration file")
        @Completion(value=FileCompleter.class)
        private String dbconfFile;
        @Option(name="--out-dir", required=true, description="output directory")
        @Completion(value=Completers.DirCompleter.class)
        private String outdir;
        @Option(name="-n", description="number of certificates in one zip file")
        private Integer numCertsInBundle = 10000;
        @Option(name="-k", description="number of certificates per SELECT")
        private Integer numCertsPerCommit = 100;
        @Option(name="--resume", description="resume from the last successful point")
        private Boolean resume = Boolean.FALSE;

        @Override
        protected DbPortWorker getDbPortWorker() throws Exception {
            return new DbPortWorker.ExportCaDb(this.datasourceFactory, this.passwordResolver, this.dbconfFile, this.outdir, this.resume.booleanValue(), this.numCertsInBundle.intValue(), this.numCertsPerCommit.intValue());
        }
    }

    @Command(scope="ca", name="diff-digest", description="diff digest XiPKI database")
    @Service
    public static class DiffDigest
    extends DbPortAction {
        @Option(name="--ref-db", required=true, description="database configuration file of the reference system")
        @Completion(value=FileCompleter.class)
        private String refDbConf;
        @Option(name="--target", required=true, description="configuration file of the target database to be evaluated")
        @Completion(value=FileCompleter.class)
        private String dbconfFile;
        @Option(name="--report-dir", required=true, description="report directory")
        @Completion(value=Completers.DirCompleter.class)
        private String reportDir;
        @Option(name="--revoked-only", description="considers only the revoked certificates")
        private Boolean revokedOnly = Boolean.FALSE;
        @Option(name="-k", description="number of certificates per SELECT")
        private Integer numCertsPerSelect = 1000;
        @Option(name="--target-threads", description="number of threads to query the target database")
        private Integer numTargetThreads = 40;
        @Option(name="--ca-cert", multiValued=true, description="Certificate of CAs to be considered")
        @Completion(value=FileCompleter.class)
        private List<String> caCertFiles;

        @Override
        protected DbPortWorker getDbPortWorker() throws Exception {
            HashSet<byte[]> caCerts = null;
            if (this.caCertFiles != null && !this.caCertFiles.isEmpty()) {
                caCerts = new HashSet<byte[]>(this.caCertFiles.size());
                for (String fileName : this.caCertFiles) {
                    byte[] derEncodedCert = X509Util.parseCert((File)new File(fileName)).getEncoded();
                    caCerts.add(derEncodedCert);
                }
            }
            return new DigestDiffWorker(this.datasourceFactory, this.passwordResolver, this.revokedOnly.booleanValue(), this.refDbConf, this.dbconfFile, this.reportDir, this.numCertsPerSelect.intValue(), this.numTargetThreads.intValue(), caCerts);
        }
    }

    public static abstract class DbPortAction
    extends XiAction {
        protected DataSourceFactory datasourceFactory = new DataSourceFactory();
        @Reference
        protected PasswordResolver passwordResolver;

        protected abstract DbPortWorker getDbPortWorker() throws Exception;

        protected Object execute0() throws Exception {
            ExecutorService executor = Executors.newFixedThreadPool(1);
            DbPortWorker myRun = this.getDbPortWorker();
            executor.execute((Runnable)myRun);
            executor.shutdown();
            while (true) {
                try {
                    boolean terminated;
                    while (!(terminated = executor.awaitTermination(1L, TimeUnit.SECONDS))) {
                    }
                }
                catch (InterruptedException ex) {
                    myRun.setStopMe(true);
                    continue;
                }
                break;
            }
            Exception ex = myRun.exception();
            if (ex != null) {
                throw ex;
            }
            return null;
        }
    }
}

