/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.ca.mgmt.shell;

import java.util.Set;
import org.xipki.ca.api.mgmt.PermissionConstants;
import org.xipki.password.PasswordResolver;
import org.xipki.security.SecurityFactory;
import org.xipki.shell.IllegalCmdParamException;
import org.xipki.util.Args;
import org.xipki.util.Base64;
import org.xipki.util.ConfPairs;
import org.xipki.util.IoUtil;
import org.xipki.util.StringUtil;

public class ShellUtil {
    private ShellUtil() {
    }

    public static String canonicalizeSignerConf(String keystoreType, String signerConf, PasswordResolver passwordResolver, SecurityFactory securityFactory) throws Exception {
        byte[] keystoreBytes;
        Args.notBlank((String)keystoreType, (String)"keystoreType");
        Args.notBlank((String)signerConf, (String)"signerConf");
        Args.notNull((Object)securityFactory, (String)"securityFactory");
        if (!(signerConf.contains("file:") || signerConf.contains("base64:") || signerConf.contains("FILE:") || signerConf.contains("BASE64:"))) {
            return signerConf;
        }
        ConfPairs pairs = new ConfPairs(signerConf);
        String keystoreConf = pairs.value("keystore");
        String passwordHint = pairs.value("password");
        if (passwordHint == null) {
            throw new IllegalArgumentException("password is not set in " + signerConf);
        }
        if (StringUtil.startsWithIgnoreCase((String)keystoreConf, (String)"file:")) {
            String keystoreFile = keystoreConf.substring("file:".length());
            keystoreBytes = IoUtil.read((String)keystoreFile);
        } else if (StringUtil.startsWithIgnoreCase((String)keystoreConf, (String)"base64:")) {
            keystoreBytes = Base64.decode((String)keystoreConf.substring("base64:".length()));
        } else {
            return signerConf;
        }
        char[] password = passwordResolver == null ? passwordHint.toCharArray() : passwordResolver.resolvePassword(passwordHint);
        String keyLabel = pairs.value("key-label");
        keystoreBytes = securityFactory.extractMinimalKeyStore(keystoreType, keystoreBytes, keyLabel, password, null);
        pairs.putPair("keystore", "base64:" + Base64.encodeToString((byte[])keystoreBytes));
        return pairs.getEncoded();
    }

    public static int getPermission(Set<String> permissions) throws IllegalCmdParamException {
        int ret = 0;
        for (String permission : permissions) {
            Integer code = PermissionConstants.getPermissionForText((String)permission);
            if (code == null) {
                throw new IllegalCmdParamException("invalid permission '" + permission + "'");
            }
            ret |= code.intValue();
        }
        return ret;
    }
}

