/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.ca.mgmt.shell;

import java.io.File;
import java.io.IOException;
import java.math.BigInteger;
import java.security.cert.CertificateException;
import java.util.Date;
import java.util.List;
import org.apache.karaf.shell.api.action.Command;
import org.apache.karaf.shell.api.action.Completion;
import org.apache.karaf.shell.api.action.Option;
import org.apache.karaf.shell.api.action.lifecycle.Service;
import org.apache.karaf.shell.support.completers.FileCompleter;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x509.Extension;
import org.bouncycastle.asn1.x509.Extensions;
import org.bouncycastle.cert.X509CRLHolder;
import org.xipki.ca.api.mgmt.CaMgmtException;
import org.xipki.ca.api.mgmt.CertListInfo;
import org.xipki.ca.api.mgmt.CertListOrderBy;
import org.xipki.ca.api.mgmt.CertWithRevocationInfo;
import org.xipki.ca.api.mgmt.MgmtEntry;
import org.xipki.ca.mgmt.shell.CaActions;
import org.xipki.ca.mgmt.shell.CaCompleters;
import org.xipki.security.CrlReason;
import org.xipki.security.X509Cert;
import org.xipki.security.util.X509Util;
import org.xipki.shell.CmdFailure;
import org.xipki.shell.Completers;
import org.xipki.shell.IllegalCmdParamException;
import org.xipki.util.DateUtil;
import org.xipki.util.InvalidConfException;
import org.xipki.util.IoUtil;
import org.xipki.util.StringUtil;

public class CertActions {

    public static abstract class UnRevRmCertAction
    extends CaActions.CaAction {
        @Option(name="--ca", required=true, description="CA name")
        @Completion(value=CaCompleters.CaNameCompleter.class)
        protected String caName;
        @Option(name="--cert", aliases={"-c"}, description="certificate file\n(either cert or serial must be specified)")
        @Completion(value=FileCompleter.class)
        protected String certFile;
        @Option(name="--serial", aliases={"-s"}, description="serial number\n(either cert or serial must be specified)")
        private String serialNumberS;

        protected BigInteger getSerialNumber() throws CmdFailure, IllegalCmdParamException, CertificateException, IOException, CaMgmtException {
            BigInteger serialNumber;
            MgmtEntry.Ca ca = this.caManager.getCa(this.caName);
            if (ca == null) {
                throw new CmdFailure("CA " + this.caName + " not available");
            }
            if (this.serialNumberS != null) {
                serialNumber = UnRevRmCertAction.toBigInt((String)this.serialNumberS);
            } else if (this.certFile != null) {
                X509Cert cert;
                X509Cert caCert = ca.getCert();
                if (!X509Util.issues((X509Cert)caCert, (X509Cert)(cert = X509Util.parseCert((File)new File(this.certFile))))) {
                    throw new CmdFailure("certificate '" + this.certFile + "' is not issued by CA " + this.caName);
                }
                serialNumber = cert.getSerialNumber();
            } else {
                throw new IllegalCmdParamException("neither serialNumber nor certFile is specified");
            }
            return serialNumber;
        }
    }

    @Command(scope="ca", name="unrevoke-cert", description="unrevoke certificate")
    @Service
    public static class UnrevokeCert
    extends UnRevRmCertAction {
        protected Object execute0() throws Exception {
            BigInteger serialNo = this.getSerialNumber();
            String msg = "certificate (serial number = 0x" + serialNo.toString(16) + ")";
            try {
                this.caManager.unrevokeCertificate(this.caName, serialNo);
                this.println("unrevoked " + msg);
                return null;
            }
            catch (CaMgmtException ex) {
                throw new CmdFailure("could not unrevoke " + msg + ", error: " + ex.getMessage(), (Throwable)ex);
            }
        }
    }

    @Command(scope="ca", name="revoke-cert", description="revoke certificate")
    @Service
    public static class RevokeCert
    extends UnRevRmCertAction {
        @Option(name="--reason", aliases={"-r"}, required=true, description="CRL reason")
        @Completion(value=Completers.ClientCrlReasonCompleter.class)
        private String reason;
        @Option(name="--inv-date", description="invalidity date, UTC time of format yyyyMMddHHmmss")
        private String invalidityDateS;

        protected Object execute0() throws Exception {
            CrlReason crlReason = CrlReason.forNameOrText((String)this.reason);
            if (!CrlReason.PERMITTED_CLIENT_CRLREASONS.contains(crlReason)) {
                throw new InvalidConfException("reason " + this.reason + " is not permitted");
            }
            Date invalidityDate = null;
            if (RevokeCert.isNotBlank((String)this.invalidityDateS)) {
                invalidityDate = DateUtil.parseUtcTimeyyyyMMddhhmmss((String)this.invalidityDateS);
            }
            BigInteger serialNo = this.getSerialNumber();
            String msg = "certificate (serial number = 0x" + serialNo.toString(16) + ")";
            try {
                this.caManager.revokeCertificate(this.caName, serialNo, crlReason, invalidityDate);
                this.println("revoked " + msg);
                return null;
            }
            catch (CaMgmtException ex) {
                throw new CmdFailure("could not revoke " + msg + ", error: " + ex.getMessage(), (Throwable)ex);
            }
        }
    }

    @Command(scope="ca", name="rm-cert", description="remove certificate")
    @Service
    public static class RmCert
    extends UnRevRmCertAction {
        @Option(name="--force", aliases={"-f"}, description="without prompt")
        private Boolean force = Boolean.FALSE;

        protected Object execute0() throws Exception {
            BigInteger serialNo = this.getSerialNumber();
            String msg = "certificate (serial number = 0x" + serialNo.toString(16) + ")";
            if (this.force.booleanValue() || this.confirm("Do you want to remove " + msg, 3)) {
                try {
                    this.caManager.removeCertificate(this.caName, serialNo);
                    this.println("removed " + msg);
                }
                catch (CaMgmtException ex) {
                    throw new CmdFailure("could not remove " + msg + ", error: " + ex.getMessage(), (Throwable)ex);
                }
            }
            return null;
        }
    }

    @Command(scope="ca", name="list-cert", description="show a list of certificates")
    @Service
    public static class ListCert
    extends CaActions.CaAction {
        @Option(name="--ca", required=true, description="CA name")
        @Completion(value=CaCompleters.CaNameCompleter.class)
        protected String caName;
        @Option(name="--subject", description="the subject pattern, * is allowed.")
        protected String subjectPatternS;
        @Option(name="--valid-from", description="start UTC time when the certificate is still valid, in form ofyyyyMMdd or yyyyMMddHHmmss")
        private String validFromS;
        @Option(name="--valid-to", description="end UTC time when the certificate is still valid, in form ofyyyMMdd or yyyyMMddHHmmss")
        private String validToS;
        @Option(name="-n", description="maximal number of entries (between 1 and 1000)")
        private int num = 1000;
        @Option(name="--order", description="by which the result is ordered")
        @Completion(value=CaCompleters.CertListSortByCompleter.class)
        private String orderByS;

        protected Object execute0() throws Exception {
            Date validFrom = this.getDate(this.validFromS);
            Date validTo = this.getDate(this.validToS);
            X500Name subjectPattern = null;
            if (StringUtil.isNotBlank((String)this.subjectPatternS)) {
                subjectPattern = new X500Name(this.subjectPatternS);
            }
            CertListOrderBy orderBy = null;
            if (this.orderByS != null && (orderBy = CertListOrderBy.forValue((String)this.orderByS)) == null) {
                throw new IllegalCmdParamException("invalid order '" + this.orderByS + "'");
            }
            List certInfos = this.caManager.listCertificates(this.caName, subjectPattern, validFrom, validTo, orderBy, this.num);
            int n = certInfos.size();
            if (n == 0) {
                this.println("found no certificate");
                return null;
            }
            this.println("     | serial               | notBefore      | notAfter       | subject");
            this.println("-----+----------------------+----------------+----------------+-----------------");
            for (int i = 0; i < n; ++i) {
                CertListInfo info = (CertListInfo)certInfos.get(i);
                this.println(this.format(i + 1, info));
            }
            return null;
        }

        private String format(int index, CertListInfo info) {
            return StringUtil.concat((String)StringUtil.formatAccount((long)index, (int)4), (String[])new String[]{" | ", StringUtil.formatText((String)info.getSerialNumber().toString(16), (int)20), " | ", DateUtil.toUtcTimeyyyyMMddhhmmss((Date)info.getNotBefore()), " | ", DateUtil.toUtcTimeyyyyMMddhhmmss((Date)info.getNotAfter()), " | ", info.getSubject()});
        }

        private Date getDate(String str) throws IllegalCmdParamException {
            if (str == null) {
                return null;
            }
            int len = str.length();
            try {
                if (len == 8) {
                    return DateUtil.parseUtcTimeyyyyMMdd((String)str);
                }
                if (len == 14) {
                    return DateUtil.parseUtcTimeyyyyMMddhhmmss((String)str);
                }
                throw new IllegalCmdParamException("invalid time " + str);
            }
            catch (IllegalArgumentException ex) {
                throw new IllegalCmdParamException("invalid time " + str + ": " + ex.getMessage(), (Throwable)ex);
            }
        }
    }

    @Command(scope="ca", name="get-request", description="get the request to enroll certificate")
    @Service
    public static class GetRequest
    extends UnRevRmCertAction {
        @Option(name="--out", aliases={"-o"}, required=true, description="where to save the request")
        @Completion(value=FileCompleter.class)
        private String outputFile;

        protected Object execute0() throws Exception {
            byte[] request = this.caManager.getCertRequest(this.caName, this.getSerialNumber());
            if (request == null) {
                System.out.println("unknown request unknown");
                return null;
            }
            this.saveVerbose("request saved to file", this.outputFile, request);
            return null;
        }
    }

    @Command(scope="ca", name="get-crl", description="download CRL")
    @Service
    public static class GetCrl
    extends CrlAction {
        @Option(name="--with-basecrl", description="whether to retrieve the baseCRL if the current CRL is a delta CRL")
        private Boolean withBaseCrl = Boolean.FALSE;
        @Option(name="--basecrl-out", description="where to save the baseCRL\n(defaults to <out>-baseCRL)")
        @Completion(value=FileCompleter.class)
        private String baseCrlOut;
        @Option(name="--out", aliases={"-o"}, required=true, description="where to save the CRL")
        @Completion(value=FileCompleter.class)
        protected String outFile;

        @Override
        protected X509CRLHolder retrieveCrl() throws Exception {
            return this.caManager.getCurrentCrl(this.caName);
        }

        @Override
        protected Object execute0() throws Exception {
            Extensions extns;
            byte[] extnValue;
            MgmtEntry.Ca ca = this.caManager.getCa(this.caName);
            if (ca == null) {
                throw new CmdFailure("CA " + this.caName + " not available");
            }
            X509CRLHolder crl = null;
            try {
                crl = this.retrieveCrl();
            }
            catch (Exception ex) {
                throw new CmdFailure("received no CRL from server: " + ex.getMessage());
            }
            if (crl == null) {
                throw new CmdFailure("received no CRL from server");
            }
            this.saveVerbose("saved CRL to file", this.outFile, GetCrl.encodeCrl((byte[])crl.getEncoded(), (String)this.outform));
            if (this.withBaseCrl.booleanValue() && (extnValue = X509Util.getCoreExtValue((Extensions)(extns = crl.getExtensions()), (ASN1ObjectIdentifier)Extension.deltaCRLIndicator)) != null) {
                if (this.baseCrlOut == null) {
                    this.baseCrlOut = this.outFile + "-baseCRL";
                }
                BigInteger baseCrlNumber = ASN1Integer.getInstance((Object)extnValue).getPositiveValue();
                try {
                    crl = this.caManager.getCrl(this.caName, baseCrlNumber);
                }
                catch (Exception ex) {
                    throw new CmdFailure("received no baseCRL from server: " + ex.getMessage());
                }
                if (crl == null) {
                    throw new CmdFailure("received no baseCRL from server");
                }
                this.saveVerbose("saved baseCRL to file", this.baseCrlOut, GetCrl.encodeCrl((byte[])crl.getEncoded(), (String)this.outform));
            }
            return null;
        }

        @Override
        protected String getOutFile() {
            return this.outFile;
        }
    }

    @Command(scope="ca", name="get-cert", description="get certificate")
    @Service
    public static class GetCert
    extends CaActions.CaAction {
        @Option(name="--ca", required=true, description="CA name")
        @Completion(value=CaCompleters.CaNameCompleter.class)
        protected String caName;
        @Option(name="--serial", aliases={"-s"}, required=true, description="serial number")
        private String serialNumberS;
        @Option(name="--outform", description="output format of the certificate")
        @Completion(value=Completers.DerPemCompleter.class)
        protected String outform = "der";
        @Option(name="--out", aliases={"-o"}, required=true, description="where to save the certificate")
        @Completion(value=FileCompleter.class)
        private String outputFile;

        protected Object execute0() throws Exception {
            CertWithRevocationInfo certInfo = this.caManager.getCert(this.caName, GetCert.toBigInt((String)this.serialNumberS));
            if (certInfo == null) {
                System.out.println("certificate unknown");
                return null;
            }
            this.saveVerbose("certificate saved to file", this.outputFile, GetCert.encodeCert((byte[])certInfo.getCert().getCert().getEncoded(), (String)this.outform));
            return null;
        }
    }

    @Command(scope="ca", name="gen-crl", description="generate CRL")
    @Service
    public static class GenCrl
    extends CrlAction {
        @Option(name="--out", aliases={"-o"}, description="where to save the CRL")
        @Completion(value=FileCompleter.class)
        protected String outFile;

        @Override
        protected X509CRLHolder retrieveCrl() throws Exception {
            return this.caManager.generateCrlOnDemand(this.caName);
        }

        @Override
        protected String getOutFile() {
            return this.outFile;
        }
    }

    @Command(scope="ca", name="enroll-cert", description="enroll certificate")
    @Service
    public static class EnrollCert
    extends CaActions.CaAction {
        @Option(name="--ca", required=true, description="CA name")
        @Completion(value=CaCompleters.CaNameCompleter.class)
        private String caName;
        @Option(name="--csr", required=true, description="CSR file")
        @Completion(value=FileCompleter.class)
        private String csrFile;
        @Option(name="--outform", description="output format of the certificate")
        @Completion(value=Completers.DerPemCompleter.class)
        protected String outform = "der";
        @Option(name="--out", aliases={"-o"}, required=true, description="where to save the certificate")
        @Completion(value=FileCompleter.class)
        private String outFile;
        @Option(name="--profile", aliases={"-p"}, required=true, description="profile name")
        @Completion(value=CaCompleters.ProfileNameCompleter.class)
        private String profileName;
        @Option(name="--not-before", description="notBefore, UTC time of format yyyyMMddHHmmss")
        private String notBeforeS;
        @Option(name="--not-after", description="notAfter, UTC time of format yyyyMMddHHmmss")
        private String notAfterS;

        protected Object execute0() throws Exception {
            MgmtEntry.Ca ca = this.caManager.getCa(this.caName);
            if (ca == null) {
                throw new CmdFailure("CA " + this.caName + " not available");
            }
            Date notBefore = StringUtil.isNotBlank((String)this.notBeforeS) ? DateUtil.parseUtcTimeyyyyMMddhhmmss((String)this.notBeforeS) : null;
            Date notAfter = StringUtil.isNotBlank((String)this.notAfterS) ? DateUtil.parseUtcTimeyyyyMMddhhmmss((String)this.notAfterS) : null;
            byte[] encodedCsr = IoUtil.read((String)this.csrFile);
            X509Cert cert = this.caManager.generateCertificate(this.caName, this.profileName, encodedCsr, notBefore, notAfter);
            this.saveVerbose("saved certificate to file", this.outFile, EnrollCert.encodeCert((byte[])cert.getEncoded(), (String)this.outform));
            return null;
        }
    }

    public static abstract class CrlAction
    extends CaActions.CaAction {
        @Option(name="--ca", required=true, description="CA name")
        @Completion(value=CaCompleters.CaNameCompleter.class)
        protected String caName;
        @Option(name="--outform", description="output format of the CRL")
        @Completion(value=Completers.DerPemCompleter.class)
        protected String outform = "der";

        protected abstract X509CRLHolder retrieveCrl() throws Exception;

        protected Object execute0() throws Exception {
            MgmtEntry.Ca ca = this.caManager.getCa(this.caName);
            if (ca == null) {
                throw new CmdFailure("CA " + this.caName + " not available");
            }
            X509CRLHolder crl = null;
            try {
                crl = this.retrieveCrl();
            }
            catch (Exception ex) {
                throw new CmdFailure("received no CRL from server: " + ex.getMessage());
            }
            if (crl == null) {
                throw new CmdFailure("received no CRL from server");
            }
            String outFile = this.getOutFile();
            if (outFile != null) {
                this.saveVerbose("saved CRL to file", outFile, CrlAction.encodeCrl((byte[])crl.getEncoded(), (String)this.outform));
            }
            return null;
        }

        protected abstract String getOutFile();
    }

    @Command(scope="ca", name="cert-status", description="show certificate status and save the certificate")
    @Service
    public static class CertStatus
    extends UnRevRmCertAction {
        @Option(name="--outform", description="output format of the certificate")
        @Completion(value=Completers.DerPemCompleter.class)
        protected String outform = "der";
        @Option(name="--out", aliases={"-o"}, description="where to save the certificate")
        @Completion(value=FileCompleter.class)
        private String outputFile;

        protected Object execute0() throws Exception {
            CertWithRevocationInfo certInfo = this.caManager.getCert(this.caName, this.getSerialNumber());
            if (certInfo == null) {
                System.out.println("certificate unknown");
                return null;
            }
            String msg = StringUtil.concat((String)"certificate profile: ", (String[])new String[]{certInfo.getCertprofile(), "\nstatus: ", certInfo.getRevInfo() == null ? "good" : "revoked with " + certInfo.getRevInfo()});
            this.println(msg);
            if (this.outputFile != null) {
                this.saveVerbose("saved certificate to file", this.outputFile, CertStatus.encodeCert((byte[])certInfo.getCert().getCert().getEncoded(), (String)this.outform));
            }
            return null;
        }
    }
}

