/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.ca.mgmt.shell;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.apache.karaf.shell.api.action.Argument;
import org.apache.karaf.shell.api.action.Command;
import org.apache.karaf.shell.api.action.Completion;
import org.apache.karaf.shell.api.action.Option;
import org.apache.karaf.shell.api.action.lifecycle.Service;
import org.apache.karaf.shell.support.completers.FileCompleter;
import org.xipki.ca.api.NameId;
import org.xipki.ca.api.mgmt.CaMgmtException;
import org.xipki.ca.api.mgmt.entry.CaHasRequestorEntry;
import org.xipki.ca.api.mgmt.entry.RequestorEntry;
import org.xipki.ca.mgmt.shell.CaActions;
import org.xipki.ca.mgmt.shell.CaCompleters;
import org.xipki.ca.mgmt.shell.ShellUtil;
import org.xipki.security.X509Cert;
import org.xipki.security.util.X509Util;
import org.xipki.shell.CmdFailure;
import org.xipki.util.Base64;
import org.xipki.util.IoUtil;

public class RequestorCaActions {

    @Command(scope="ca", name="requestor-up", description="update requestor")
    @Service
    public static class RequestorUp
    extends CaActions.CaAction {
        @Option(name="--name", aliases={"-n"}, required=true, description="requestor name")
        @Completion(value=CaCompleters.RequestorNameCompleter.class)
        protected String name;
        @Option(name="--cert", required=true, description="requestor certificate file")
        @Completion(value=FileCompleter.class)
        protected String certFile;

        protected Object execute0() throws Exception {
            String msg = "requestor " + this.name;
            String conf = Base64.encodeToString((byte[])X509Util.parseCert((byte[])IoUtil.read((String)this.certFile)).getEncoded());
            try {
                this.caManager.changeRequestor(this.name, "cert", conf);
                this.println("updated " + msg);
                return null;
            }
            catch (CaMgmtException ex) {
                throw new CmdFailure("could not update " + msg + ", error: " + ex.getMessage(), (Throwable)ex);
            }
        }
    }

    @Command(scope="ca", name="requestor-rm", description="remove requestor")
    @Service
    public static class RequestorRm
    extends CaActions.CaAction {
        @Argument(index=0, name="name", required=true, description="requestor name")
        @Completion(value=CaCompleters.RequestorNameCompleter.class)
        private String name;
        @Option(name="--force", aliases={"-f"}, description="without prompt")
        private Boolean force = Boolean.FALSE;

        protected Object execute0() throws Exception {
            String msg = "CMP requestor " + this.name;
            if (this.force.booleanValue() || this.confirm("Do you want to remove " + msg, 3)) {
                try {
                    this.caManager.removeRequestor(this.name);
                    this.println("removed " + msg);
                }
                catch (CaMgmtException ex) {
                    throw new CmdFailure("could not remove " + msg + ", error: " + ex.getMessage(), (Throwable)ex);
                }
            }
            return null;
        }
    }

    @Command(scope="ca", name="requestor-info", description="show information of requestor")
    @Service
    public static class RequestorInfo
    extends CaActions.CaAction {
        @Argument(index=0, name="name", description="requestor name")
        @Completion(value=CaCompleters.RequestorNameCompleter.class)
        private String name;
        @Option(name="--verbose", aliases={"-v"}, description="show requestor information verbosely")
        private Boolean verbose = Boolean.FALSE;

        protected Object execute0() throws Exception {
            StringBuilder sb = new StringBuilder();
            if (this.name == null) {
                Set names = this.caManager.getRequestorNames();
                int size = names.size();
                if (size == 0 || size == 1) {
                    sb.append(size == 0 ? "no" : "1").append(" requestor is configured\n");
                } else {
                    sb.append(size).append(" requestors are configured:\n");
                }
                ArrayList sorted = new ArrayList(names);
                Collections.sort(sorted);
                for (String entry : sorted) {
                    sb.append("\t").append(entry).append("\n");
                }
            } else {
                RequestorEntry entry = this.caManager.getRequestor(this.name);
                if (entry == null) {
                    throw new CmdFailure("could not find requestor '" + this.name + "'");
                }
                sb.append(entry.toString(this.verbose.booleanValue()));
            }
            this.println(sb.toString());
            return null;
        }
    }

    @Command(scope="ca", name="requestor-add", description="add requestor")
    @Service
    public static class RequestorAdd
    extends CaActions.CaAction {
        @Option(name="--name", aliases={"-n"}, required=true, description="requestor name")
        private String name;
        @Option(name="--cert", required=true, description="requestor certificate file(exactly one of cert and password must be specified).")
        @Completion(value=FileCompleter.class)
        private String certFile;

        protected Object execute0() throws Exception {
            X509Cert cert = X509Util.parseCert((byte[])IoUtil.read((String)this.certFile));
            RequestorEntry entry = new RequestorEntry(new NameId(null, this.name), "cert", Base64.encodeToString((byte[])cert.getEncoded()));
            String msg = "CMP requestor " + this.name;
            try {
                this.caManager.addRequestor(entry);
                this.println("added " + msg);
                return null;
            }
            catch (CaMgmtException ex) {
                throw new CmdFailure("could not add " + msg + ", error: " + ex.getMessage(), (Throwable)ex);
            }
        }
    }

    @Command(scope="ca", name="careq-rm", description="remove requestor from CA")
    @Service
    public static class CareqRm
    extends CaActions.CaAction {
        @Option(name="--ca", required=true, description="CA name")
        @Completion(value=CaCompleters.CaNameCompleter.class)
        private String caName;
        @Option(name="--requestor", required=true, multiValued=true, description="requestor name")
        @Completion(value=CaCompleters.RequestorNameCompleter.class)
        private List<String> requestorNames;
        @Option(name="--force", aliases={"-f"}, description="without prompt")
        private Boolean force = Boolean.FALSE;

        protected Object execute0() throws Exception {
            for (String requestorName : this.requestorNames) {
                String msg = "requestor " + requestorName + " from CA " + this.caName;
                if (!this.force.booleanValue() && !this.confirm("Do you want to remove " + msg, 3)) continue;
                try {
                    this.caManager.removeRequestorFromCa(requestorName, this.caName);
                    this.println("removed " + msg);
                }
                catch (CaMgmtException ex) {
                    throw new CmdFailure("could not remove " + msg + ", error: " + ex.getMessage(), (Throwable)ex);
                }
            }
            return null;
        }
    }

    @Command(scope="ca", name="careq-info", description="show information of requestor in CA")
    @Service
    public static class CareqInfo
    extends CaActions.CaAction {
        @Option(name="--ca", required=true, description="CA name")
        @Completion(value=CaCompleters.CaNameCompleter.class)
        private String caName;

        protected Object execute0() throws Exception {
            if (this.caManager.getCa(this.caName) == null) {
                throw new CmdFailure("could not find CA '" + this.caName + "'");
            }
            StringBuilder sb = new StringBuilder();
            Set entries = this.caManager.getRequestorsForCa(this.caName);
            if (CareqInfo.isNotEmpty((Collection)entries)) {
                sb.append("requestors trusted by CA ").append(this.caName).append("\n");
                for (CaHasRequestorEntry entry : entries) {
                    sb.append("----------\n").append(entry).append("\n");
                }
            } else {
                sb.append("no requestor for CA ").append(this.caName).append(" is configured");
            }
            this.println(sb.toString());
            return null;
        }
    }

    @Command(scope="ca", name="careq-add", description="add requestor to CA")
    @Service
    public static class CareqAdd
    extends CaActions.CaAction {
        @Option(name="--ca", required=true, description="CA name")
        @Completion(value=CaCompleters.CaNameCompleter.class)
        private String caName;
        @Option(name="--requestor", required=true, description="requestor name")
        @Completion(value=CaCompleters.RequestorNameCompleter.class)
        private String requestorName;
        @Option(name="--permission", required=true, multiValued=true, description="permission")
        @Completion(value=CaCompleters.PermissionCompleter.class)
        private Set<String> permissions;
        @Option(name="--profile", multiValued=true, description="profile name or 'all' for all profiles")
        @Completion(value=CaCompleters.ProfileNameAndAllCompleter.class)
        private Set<String> profiles;

        protected Object execute0() throws Exception {
            CaHasRequestorEntry entry = new CaHasRequestorEntry(new NameId(null, this.requestorName));
            entry.setProfiles(this.profiles);
            entry.setPermission(ShellUtil.getPermission(this.permissions));
            String msg = "requestor " + this.requestorName + " to CA " + this.caName;
            try {
                this.caManager.addRequestorToCa(entry, this.caName);
                this.println("added " + msg);
                return null;
            }
            catch (CaMgmtException ex) {
                throw new CmdFailure("could not add " + msg + ", error: " + ex.getMessage(), (Throwable)ex);
            }
        }
    }
}

