/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.ca.mgmt.shell;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.apache.karaf.shell.api.action.Argument;
import org.apache.karaf.shell.api.action.Command;
import org.apache.karaf.shell.api.action.Completion;
import org.apache.karaf.shell.api.action.Option;
import org.apache.karaf.shell.api.action.lifecycle.Service;
import org.apache.karaf.shell.support.completers.FileCompleter;
import org.xipki.ca.mgmt.db.DbWorker;
import org.xipki.ca.mgmt.db.diffdb.DigestDiffWorker;
import org.xipki.ca.mgmt.db.port.DbPortWorker;
import org.xipki.datasource.DataSourceFactory;
import org.xipki.datasource.DataSourceWrapper;
import org.xipki.datasource.DatabaseType;
import org.xipki.datasource.ScriptRunner;
import org.xipki.password.PasswordResolverException;
import org.xipki.security.util.X509Util;
import org.xipki.shell.Completers;
import org.xipki.shell.IllegalCmdParamException;
import org.xipki.shell.XiAction;
import org.xipki.util.ConfigurableProperties;
import org.xipki.util.IoUtil;

public class DbActions {

    @Command(scope="ca", name="import-ocspfromca", description="import OCSP database from CA data")
    @Service
    public static class ImportOcspfromca
    extends DbPortAction {
        private static final String DFLT_PUBLISHER = "ocsp-publisher";
        @Option(name="--db-conf", required=true, description="database configuration file")
        @Completion(value=FileCompleter.class)
        private String dbconfFile;
        @Option(name="--in-dir", required=true, description="input directory")
        @Completion(value=Completers.DirCompleter.class)
        private String indir;
        @Option(name="--publisher", description="publisher name")
        private String publisherName = "ocsp-publisher";
        @Option(name="-k", description="number of certificates per commit")
        private Integer numCertsPerCommit = 100;
        @Option(name="--resume", description="resume from the last successful point")
        private Boolean resume = Boolean.FALSE;

        protected DbPortWorker getDbWorker() throws Exception {
            return new DbPortWorker.ImportOcspFromCaDb(this.datasourceFactory, this.passwordResolver, this.dbconfFile, this.publisherName, this.resume.booleanValue(), this.indir, this.numCertsPerCommit.intValue(), this.readPassword());
        }
    }

    @Command(scope="ca", name="import-ocsp", description="import OCSP database")
    @Service
    public static class ImportOcsp
    extends DbPortAction {
        @Option(name="--db-conf", required=true, description="database configuration file")
        @Completion(value=FileCompleter.class)
        private String dbconfFile;
        @Option(name="--in-dir", required=true, description="input directory")
        @Completion(value=Completers.DirCompleter.class)
        private String indir;
        @Option(name="-k", description="number of certificates per commit")
        private Integer numCertsPerCommit = 100;
        @Option(name="--resume", description="resume from the last successful point")
        private Boolean resume = Boolean.FALSE;

        protected DbPortWorker getDbWorker() throws Exception {
            return new DbPortWorker.ImportOcspDb(this.datasourceFactory, this.passwordResolver, this.dbconfFile, this.resume.booleanValue(), this.indir, this.numCertsPerCommit.intValue(), this.readPassword());
        }
    }

    @Command(scope="ca", name="import-ca", description="import CA database")
    @Service
    public static class ImportCa
    extends DbPortAction {
        @Option(name="--caconf-db-conf", description="CA configuration database file")
        @Completion(value=FileCompleter.class)
        private String caconfDbFile;
        @Option(name="--db-conf", required=true, description="CA database file")
        @Completion(value=FileCompleter.class)
        private String dbConfFile;
        @Option(name="--in-dir", required=true, description="input directory")
        @Completion(value=Completers.DirCompleter.class)
        private String indir;
        @Option(name="-k", description="number of certificates per commit")
        private Integer numCertsPerCommit = 100;
        @Option(name="--resume", description="resume from the last successful point")
        private Boolean resume = Boolean.FALSE;

        protected DbPortWorker getDbWorker() throws Exception {
            return new DbPortWorker.ImportCaDb(this.datasourceFactory, this.passwordResolver, this.caconfDbFile, this.dbConfFile, this.resume.booleanValue(), this.indir, this.numCertsPerCommit.intValue(), this.readPassword());
        }
    }

    @Command(scope="ca", name="export-ocsp", description="export OCSP database")
    @Service
    public static class ExportOcsp
    extends DbPortAction {
        @Option(name="--db-conf", required=true, description="database configuration file.")
        @Completion(value=FileCompleter.class)
        private String dbconfFile;
        @Option(name="--out-dir", required=true, description="output directory")
        @Completion(value=Completers.DirCompleter.class)
        private String outdir;
        @Option(name="-n", description="number of certificates in one zip file")
        private Integer numCertsInBundle = 10000;
        @Option(name="-k", description="number of certificates per SELECT")
        private Integer numCertsPerSelect = 100;
        @Option(name="--resume", description="resume from the last successful point")
        private Boolean resume = Boolean.FALSE;

        protected DbPortWorker getDbWorker() throws Exception {
            return new DbPortWorker.ExportOcspDb(this.datasourceFactory, this.passwordResolver, this.dbconfFile, this.outdir, this.resume.booleanValue(), this.numCertsInBundle.intValue(), this.numCertsPerSelect.intValue(), this.readPassword());
        }
    }

    @Command(scope="ca", name="sql", description="Run SQL script")
    @Service
    public static class Sql
    extends XiAction {
        @Option(name="--db-conf", required=true, description="database configuration file")
        @Completion(value=FileCompleter.class)
        private String dbConfFile;
        @Argument(name="script", required=true, description="SQL script file")
        @Completion(value=FileCompleter.class)
        private String scriptFile;
        @Option(name="--force", aliases={"-f"}, description="without prompt")
        private Boolean force = Boolean.FALSE;

        protected Object execute0() throws Exception {
            ConfigurableProperties props = new ConfigurableProperties();
            try (InputStream is = Files.newInputStream(Paths.get(IoUtil.expandFilepath((String)this.dbConfFile), new String[0]), new OpenOption[0]);){
                props.load(is);
            }
            props.setProperty("minimumIdle", "1");
            try (DataSourceWrapper dataSource = new DataSourceFactory().createDataSource("default", props, this.passwordResolver);){
                String type;
                DatabaseType dbType = dataSource.getDatabaseType();
                switch (dbType) {
                    case H2: {
                        type = "h2";
                        break;
                    }
                    case POSTGRES: {
                        type = "postgresql";
                        break;
                    }
                    case DB2: {
                        type = "db2";
                        break;
                    }
                    case ORACLE: {
                        type = "oracle";
                        break;
                    }
                    case MYSQL: 
                    case MARIADB: {
                        type = "mysql";
                        break;
                    }
                    case HSQL: {
                        type = "hsqldb";
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("unknown database type " + dbType);
                    }
                }
                this.scriptFile = Sql.expandFilepath((String)this.scriptFile);
                Path p = Paths.get(this.scriptFile, new String[0]);
                String derivedScriptFile = null;
                if (!Files.exists(p, new LinkOption[0]) && !this.scriptFile.contains("." + type + ".")) {
                    Object fn = p.getFileName().toString();
                    int idx = ((String)fn).lastIndexOf(46);
                    fn = ((String)fn).substring(0, idx) + "." + type + ((String)fn).substring(idx);
                    p = Paths.get(p.getParent().toString(), new String[]{fn});
                    derivedScriptFile = p.toString();
                }
                if (!Files.exists(p, new LinkOption[0])) {
                    if (derivedScriptFile != null) {
                        throw new IllegalCmdParamException("Could not find script files " + this.scriptFile + " and " + derivedScriptFile);
                    }
                    throw new IllegalCmdParamException("Could not find script file " + this.scriptFile);
                }
                if (this.force.booleanValue() || this.confirm("Do you want to execute the SQL script?", 3)) {
                    System.out.println("Start executing script " + p);
                    ScriptRunner.runScript((DataSourceWrapper)dataSource, (String)p.toString());
                    System.out.println("  End executing script " + p);
                }
                Object var7_11 = null;
                return var7_11;
            }
        }
    }

    @Command(scope="ca", name="diff-digest", description="diff digest XiPKI database")
    @Service
    public static class DiffDigest
    extends DbAction {
        @Option(name="--ref-db", required=true, description="database configuration file of the reference system")
        @Completion(value=FileCompleter.class)
        private String refDbConf;
        @Option(name="--target", required=true, description="configuration file of the target database to be evaluated")
        @Completion(value=FileCompleter.class)
        private String dbconfFile;
        @Option(name="--report-dir", required=true, description="report directory")
        @Completion(value=Completers.DirCompleter.class)
        private String reportDir;
        @Option(name="--revoked-only", description="considers only the revoked certificates")
        private Boolean revokedOnly = Boolean.FALSE;
        @Option(name="-k", description="number of certificates per SELECT")
        private Integer numCertsPerSelect = 1000;
        @Option(name="--target-threads", description="number of threads to query the target database")
        private Integer numTargetThreads = 40;
        @Option(name="--ca-cert", multiValued=true, description="Certificate of CAs to be considered")
        @Completion(value=FileCompleter.class)
        private List<String> caCertFiles;

        @Override
        protected DbWorker getDbWorker() throws Exception {
            HashSet<byte[]> caCerts = null;
            if (this.caCertFiles != null && !this.caCertFiles.isEmpty()) {
                caCerts = new HashSet<byte[]>(this.caCertFiles.size());
                for (String fileName : this.caCertFiles) {
                    caCerts.add(X509Util.parseCert((File)new File(fileName)).getEncoded());
                }
            }
            return new DigestDiffWorker(this.datasourceFactory, this.passwordResolver, this.revokedOnly.booleanValue(), this.refDbConf, this.dbconfFile, this.reportDir, this.numCertsPerSelect.intValue(), this.numTargetThreads.intValue(), caCerts);
        }
    }

    public static abstract class DbPortAction
    extends DbAction {
        @Option(name="--password", description="password, as plaintext or PBE-encrypted.")
        private String passwordHint;

        protected char[] readPassword() throws IOException, PasswordResolverException {
            return this.readPasswordIfNotSet("Please enter password of the ZIP file", this.passwordHint);
        }
    }

    @Command(scope="ca", name="export-ca", description="export CA database")
    @Service
    public static class ExportCa
    extends DbPortAction {
        @Option(name="--caconf-db-conf", description="CA configuration database file")
        @Completion(value=FileCompleter.class)
        private String caConfDbConfFile;
        @Option(name="--db-conf", required=true, description="CA database file")
        @Completion(value=FileCompleter.class)
        private String dbConfFile;
        @Option(name="--out-dir", required=true, description="output directory")
        @Completion(value=Completers.DirCompleter.class)
        private String outdir;
        @Option(name="-n", description="number of certificates in one zip file")
        private Integer numCertsInBundle = 10000;
        @Option(name="-k", description="number of certificates per SELECT")
        private Integer numCertsPerCommit = 100;
        @Option(name="--resume", description="resume from the last successful point")
        private Boolean resume = Boolean.FALSE;

        protected DbPortWorker getDbWorker() throws Exception {
            return new DbPortWorker.ExportCaDb(this.datasourceFactory, this.passwordResolver, this.caConfDbConfFile, this.dbConfFile, this.outdir, this.resume.booleanValue(), this.numCertsInBundle.intValue(), this.numCertsPerCommit.intValue(), this.readPassword());
        }
    }

    public static abstract class DbAction
    extends XiAction {
        protected DataSourceFactory datasourceFactory = new DataSourceFactory();

        protected abstract DbWorker getDbWorker() throws Exception;

        protected Object execute0() throws Exception {
            ExecutorService executor = Executors.newFixedThreadPool(1);
            DbWorker myRun = this.getDbWorker();
            executor.execute((Runnable)myRun);
            executor.shutdown();
            while (true) {
                try {
                    while (!executor.awaitTermination(1L, TimeUnit.SECONDS)) {
                    }
                }
                catch (InterruptedException ex) {
                    myRun.setStopMe(true);
                    continue;
                }
                break;
            }
            Exception ex = myRun.exception();
            if (ex != null) {
                throw ex;
            }
            return null;
        }
    }
}

