/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.ca.mgmt.shell;

import java.util.Map;
import org.apache.karaf.shell.api.action.Command;
import org.apache.karaf.shell.api.action.Option;
import org.apache.karaf.shell.api.action.lifecycle.Service;
import org.xipki.ca.mgmt.shell.CaActions;
import org.xipki.util.CollectionUtil;

public class DbSchemaActions {

    @Command(scope="ca", name="dbschema-info", description="list DBSchema entries")
    @Service
    public static class ListDbSchemas
    extends CaActions.CaAction {
        protected Object execute0() throws Exception {
            Map result = this.caManager.getDbSchemas();
            if (CollectionUtil.isEmpty((Map)result)) {
                this.println("found no DBSchema entries");
                return null;
            }
            StringBuilder sb = new StringBuilder();
            for (Map.Entry entry : result.entrySet()) {
                sb.append((String)entry.getKey()).append(": ").append((String)entry.getValue()).append("\n");
            }
            this.print(sb.toString());
            return null;
        }
    }

    @Command(scope="ca", name="dbschema-rm", description="remove DBSchema entry")
    @Service
    public static class RemoveDbSchema
    extends CaActions.CaAction {
        @Option(name="--name", aliases={"-n"}, required=true, description="DBSchema entry name")
        private String name;

        protected Object execute0() throws Exception {
            this.caManager.removeDbSchema(this.name);
            return null;
        }
    }

    @Command(scope="ca", name="dbschema-up", description="change DBSchema entry")
    @Service
    public static class ChangeDbSchema
    extends CaActions.CaAction {
        @Option(name="--name", aliases={"-n"}, required=true, description="DBSchema entry name")
        private String name;
        @Option(name="--value", aliases={"-v"}, required=true, description="DBSchema entry value")
        private String value;

        protected Object execute0() throws Exception {
            this.caManager.changeDbSchema(this.name, this.value);
            return null;
        }
    }

    @Command(scope="ca", name="dbschema-add", description="add DBSchema entry")
    @Service
    public static class AddDbSchema
    extends CaActions.CaAction {
        @Option(name="--name", aliases={"-n"}, required=true, description="DBSchema entry name")
        private String name;
        @Option(name="--value", aliases={"-v"}, required=true, description="DBSchema entry value")
        private String value;

        protected Object execute0() throws Exception {
            this.caManager.addDbSchema(this.name, this.value);
            return null;
        }
    }
}

