/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.cmp.client.shell;

import java.io.File;
import java.io.IOException;
import java.math.BigInteger;
import java.security.cert.CertificateException;
import java.util.Date;
import org.apache.karaf.shell.api.action.Command;
import org.apache.karaf.shell.api.action.Completion;
import org.apache.karaf.shell.api.action.Option;
import org.apache.karaf.shell.api.action.lifecycle.Service;
import org.apache.karaf.shell.support.completers.FileCompleter;
import org.xipki.cmp.PkiStatusInfo;
import org.xipki.cmp.client.CertIdOrError;
import org.xipki.cmp.client.Requestor;
import org.xipki.cmp.client.shell.Actions;
import org.xipki.security.CrlReason;
import org.xipki.security.X509Cert;
import org.xipki.security.util.X509Util;
import org.xipki.shell.CmdFailure;
import org.xipki.shell.Completers;
import org.xipki.shell.IllegalCmdParamException;
import org.xipki.util.DateUtil;
import org.xipki.util.ReqRespDebug;

public class UnRevokeCertActions {

    public static abstract class UnRevokeCertAction
    extends Actions.AuthClientAction {
        @Option(name="--ca-cert", required=true, description="certificate file")
        @Completion(value=FileCompleter.class)
        private String caCertFile;
        @Option(name="--cert", aliases={"-c"}, description="certificate file (either cert or serial must be specified)")
        @Completion(value=FileCompleter.class)
        protected String certFile;
        @Option(name="--serial", aliases={"-s"}, description="serial number (either cert or serial must be specified)")
        private String serialNumberS;
        private BigInteger serialNumber;

        protected X509Cert getCaCert() throws CertificateException, IOException {
            return X509Util.parseCert((File)new File(this.caCertFile));
        }

        protected BigInteger getSerialNumber() {
            if (this.serialNumber == null && UnRevokeCertAction.isNotBlank((String)this.serialNumberS)) {
                this.serialNumber = UnRevokeCertAction.toBigInt((String)this.serialNumberS);
            }
            return this.serialNumber;
        }
    }

    @Command(scope="xi", name="cmp-unsuspend", description="unsuspend certificate")
    @Service
    public static class CmpUnsuspend
    extends UnRevokeCertAction {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected Object execute0() throws Exception {
            CertIdOrError certIdOrError;
            if (this.certFile == null == (this.getSerialNumber() == null)) {
                throw new IllegalCmdParamException("exactly one of cert and serial must be specified");
            }
            ReqRespDebug debug = this.getReqRespDebug();
            try {
                Requestor requestor = this.getRequestor();
                X509Cert caCert = this.getCaCert();
                if (this.certFile != null) {
                    X509Cert cert = X509Util.parseCert((File)new File(this.certFile));
                    certIdOrError = this.client.unsuspendCert(this.caName, requestor, caCert, cert, debug);
                } else {
                    certIdOrError = this.client.unsuspendCert(this.caName, requestor, caCert, this.getSerialNumber(), debug);
                }
            }
            finally {
                this.saveRequestResponse(debug);
            }
            if (certIdOrError.getError() != null) {
                PkiStatusInfo error = certIdOrError.getError();
                throw new CmdFailure("releasing revocation failed: " + error);
            }
            this.println("unsuspended certificate");
            return null;
        }
    }

    @Command(scope="xi", name="cmp-revoke", description="revoke certificate")
    @Service
    public static class CmpRevoke
    extends UnRevokeCertAction {
        @Option(name="--reason", aliases={"-r"}, required=true, description="CRL reason")
        @Completion(value=Completers.ClientCrlReasonCompleter.class)
        private String reason;
        @Option(name="--inv-date", description="invalidity date, UTC time of format yyyyMMddHHmmss")
        private String invalidityDateS;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected Object execute0() throws Exception {
            CertIdOrError certIdOrError;
            if (this.certFile == null == (this.getSerialNumber() == null)) {
                throw new IllegalCmdParamException("exactly one of cert and serial must be specified");
            }
            CrlReason crlReason = CrlReason.forNameOrText((String)this.reason);
            if (!CrlReason.PERMITTED_CLIENT_CRLREASONS.contains(crlReason)) {
                throw new IllegalCmdParamException("reason " + this.reason + " is not permitted");
            }
            Date invalidityDate = null;
            if (CmpRevoke.isNotBlank((String)this.invalidityDateS)) {
                invalidityDate = DateUtil.parseUtcTimeyyyyMMddhhmmss((String)this.invalidityDateS);
            }
            ReqRespDebug debug = this.getReqRespDebug();
            try {
                Requestor requestor = this.getRequestor();
                X509Cert caCert = this.getCaCert();
                if (this.certFile != null) {
                    X509Cert cert = X509Util.parseCert((File)new File(this.certFile));
                    certIdOrError = this.client.revokeCert(this.caName, requestor, caCert, cert, crlReason.getCode(), invalidityDate, debug);
                } else {
                    certIdOrError = this.client.revokeCert(this.caName, requestor, caCert, this.getSerialNumber(), crlReason.getCode(), invalidityDate, debug);
                }
            }
            finally {
                this.saveRequestResponse(debug);
            }
            if (certIdOrError.getError() != null) {
                PkiStatusInfo error = certIdOrError.getError();
                throw new CmdFailure("revocation failed: " + error);
            }
            this.println("revoked certificate");
            return null;
        }
    }
}

