/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.cmp.client.shell;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.security.NoSuchAlgorithmException;
import java.util.Collection;
import java.util.List;
import org.apache.karaf.shell.api.action.Command;
import org.apache.karaf.shell.api.action.Completion;
import org.apache.karaf.shell.api.action.Option;
import org.apache.karaf.shell.api.action.lifecycle.Reference;
import org.apache.karaf.shell.api.action.lifecycle.Service;
import org.apache.karaf.shell.support.completers.FileCompleter;
import org.xipki.cmp.client.CmpClient;
import org.xipki.cmp.client.Requestor;
import org.xipki.password.PasswordResolverException;
import org.xipki.security.ConcurrentContentSigner;
import org.xipki.security.HashAlgo;
import org.xipki.security.SecurityFactory;
import org.xipki.security.SignAlgo;
import org.xipki.security.SignatureAlgoControl;
import org.xipki.security.SignerConf;
import org.xipki.security.X509Cert;
import org.xipki.security.util.X509Util;
import org.xipki.shell.CmdFailure;
import org.xipki.shell.Completers;
import org.xipki.shell.IllegalCmdParamException;
import org.xipki.shell.XiAction;
import org.xipki.util.CollectionUtil;
import org.xipki.util.ConfPairs;
import org.xipki.util.Hex;
import org.xipki.util.IoUtil;
import org.xipki.util.ReqRespDebug;
import org.xipki.util.StringUtil;
import org.xipki.util.exception.ObjectCreationException;

public class Actions {

    @Command(scope="xi", name="cmp-cacerts", description="get CA certificate chain")
    @Service
    public static class CmpCacertchain
    extends ClientAction {
        @Option(name="--out", aliases={"-o"}, required=true, description="where to save the CA certificate chain")
        @Completion(value=FileCompleter.class)
        private String outFile;

        protected Object execute0() throws Exception {
            List caCertChain;
            try {
                caCertChain = this.client.caCerts(this.caName, this.getReqRespDebug());
            }
            catch (Exception ex) {
                throw new CmdFailure("Error while retrieving CA certificate chain: " + ex.getMessage(), (Throwable)ex);
            }
            if (CollectionUtil.isEmpty((Collection)caCertChain)) {
                throw new CmdFailure("received no CA certificate chain");
            }
            String encoded = X509Util.encodeCertificates((X509Cert[])caCertChain.toArray(new X509Cert[0]));
            this.saveVerbose("saved CA certificate to file", this.outFile, StringUtil.toUtf8Bytes((String)encoded));
            return null;
        }
    }

    @Command(scope="xi", name="cmp-cacert", description="get CA certificate")
    @Service
    public static class CmpCacert
    extends ClientAction {
        @Option(name="--outform", description="output format of the certificate")
        @Completion(value=Completers.DerPemCompleter.class)
        private String outform = "der";
        @Option(name="--out", aliases={"-o"}, required=true, description="where to save the CA certificate")
        @Completion(value=FileCompleter.class)
        private String outFile;

        protected Object execute0() throws Exception {
            X509Cert caCert;
            try {
                caCert = this.client.caCert(this.caName, this.getReqRespDebug());
            }
            catch (Exception ex) {
                throw new CmdFailure("Error while retrieving CA certificate: " + ex.getMessage());
            }
            if (caCert == null) {
                throw new CmdFailure("received no CA certificate");
            }
            this.saveVerbose("saved CA certificate to file", this.outFile, CmpCacert.encodeCert((byte[])caCert.getEncoded(), (String)this.outform));
            return null;
        }
    }

    public static abstract class ClientAction
    extends XiAction {
        @Reference
        protected SecurityFactory securityFactory;
        @Reference
        protected CmpClient client;
        @Option(name="--ca", required=true, description="CA name")
        protected String caName;
        @Option(name="--req-out", description="where to save the request")
        @Completion(value=FileCompleter.class)
        private String reqout;
        @Option(name="--resp-out", description="where to save the response")
        @Completion(value=FileCompleter.class)
        private String respout;

        protected static HashAlgo getHashAlgo(String algoStr) throws ObjectCreationException {
            try {
                return HashAlgo.getInstance((String)algoStr);
            }
            catch (NoSuchAlgorithmException ex) {
                throw new ObjectCreationException(ex.getMessage(), (Throwable)ex);
            }
        }

        protected ReqRespDebug getReqRespDebug() {
            boolean saveReq = ClientAction.isNotBlank((String)this.reqout);
            boolean saveResp = ClientAction.isNotBlank((String)this.respout);
            if (saveReq || saveResp) {
                return new ReqRespDebug(saveReq, saveResp);
            }
            return null;
        }

        protected void saveRequestResponse(ReqRespDebug debug) {
            boolean saveReq = ClientAction.isNotBlank((String)this.reqout);
            boolean saveResp = ClientAction.isNotBlank((String)this.respout);
            if (!saveReq && !saveResp) {
                return;
            }
            if (debug == null || debug.size() == 0) {
                return;
            }
            int n = debug.size();
            for (int i = 0; i < n; ++i) {
                String fn;
                byte[] bytes;
                ReqRespDebug.ReqRespPair reqResp = debug.get(i);
                if (saveReq && (bytes = reqResp.getRequest()) != null) {
                    fn = n == 1 ? this.reqout : ClientAction.appendIndex(this.reqout, i);
                    try {
                        IoUtil.save((String)fn, (byte[])bytes);
                    }
                    catch (IOException ex) {
                        System.err.println("IOException: " + ex.getMessage());
                    }
                }
                if (!saveResp || (bytes = reqResp.getResponse()) == null) continue;
                fn = n == 1 ? this.respout : ClientAction.appendIndex(this.respout, i);
                try {
                    IoUtil.save((String)fn, (byte[])bytes);
                    continue;
                }
                catch (IOException ex) {
                    System.err.println("IOException: " + ex.getMessage());
                }
            }
        }

        private static String appendIndex(String filename, int index) {
            int idx = filename.lastIndexOf(46);
            if (idx == -1 || idx == filename.length() - 1) {
                return filename + "-" + index;
            }
            return new StringBuilder(filename).insert(idx, index).insert(idx, '-').toString();
        }
    }

    public static abstract class AuthClientAction
    extends ClientAction {
        @Reference
        protected SecurityFactory securityFactory;
        @Option(name="--signer-p12", description="Signer PKCS#12 file")
        @Completion(value=FileCompleter.class)
        private String signerP12File;
        @Option(name="--signer-p12-algo", description="Signature algorithm of the PKCS#12 signer")
        @Completion(value=Completers.SigAlgCompleter.class)
        private String signerP12SigAlgo;
        @Option(name="--signer-keyid", multiValued=true, description="User, text key ID, or prefix 0x for hex-encoded key ID")
        private String signerKeyId;
        @Option(name="--signer-password", description="Signer password, as plaintext or PBE-encrypted.")
        private String signerPasswordHint;

        protected Requestor getRequestor() throws IllegalCmdParamException, ObjectCreationException, IOException, PasswordResolverException {
            if (this.signerP12File == null == (this.signerKeyId == null)) {
                throw new IllegalCmdParamException("Exactly one of signer-p12 and signer-keyid must be specified");
            }
            if (this.signerP12File != null) {
                SignerConf sc;
                if (this.signerPasswordHint == null) {
                    char[] pwd = this.readPassword("Enter the password for " + this.signerP12File);
                    this.signerPasswordHint = new String(pwd);
                }
                ConfPairs cp = new ConfPairs().putPair("password", this.signerPasswordHint).putPair("keystore", "file:" + this.signerP12File);
                if (this.signerP12SigAlgo == null) {
                    sc = new SignerConf(cp.getEncoded(), HashAlgo.SHA256, new SignatureAlgoControl());
                } else {
                    cp.putPair("algo", this.signerP12SigAlgo);
                    sc = new SignerConf(cp.getEncoded());
                }
                ConcurrentContentSigner signer = this.securityFactory.createSigner("PKCS12", sc, (X509Cert)null);
                return new Requestor.SignatureCmpRequestor(signer);
            }
            if (this.signerPasswordHint == null) {
                this.signerPasswordHint = new String(this.readPassword("Enter the password for the user/keyID " + this.signerKeyId));
            }
            byte[] senderKID = StringUtil.startsWithIgnoreCase((String)this.signerKeyId, (String)"0x") ? Hex.decode((String)this.signerKeyId) : this.signerKeyId.getBytes(StandardCharsets.UTF_8);
            int iterationCount = 2048;
            return new Requestor.PbmMacCmpRequestor(this.resolvePassword(this.signerPasswordHint), senderKID, HashAlgo.SHA256, iterationCount, SignAlgo.HMAC_SHA256);
        }
    }
}

