/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.cmp.client.shell;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.util.Date;
import java.util.LinkedList;
import org.apache.karaf.shell.api.action.Command;
import org.apache.karaf.shell.api.action.Completion;
import org.apache.karaf.shell.api.action.Option;
import org.apache.karaf.shell.api.action.lifecycle.Reference;
import org.apache.karaf.shell.api.action.lifecycle.Service;
import org.apache.karaf.shell.support.completers.FileCompleter;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.cmp.CMPObjectIdentifiers;
import org.bouncycastle.asn1.crmf.AttributeTypeAndValue;
import org.bouncycastle.asn1.crmf.CertId;
import org.bouncycastle.asn1.crmf.CertRequest;
import org.bouncycastle.asn1.crmf.CertTemplateBuilder;
import org.bouncycastle.asn1.crmf.Controls;
import org.bouncycastle.asn1.crmf.OptionalValidity;
import org.bouncycastle.asn1.crmf.POPOSigningKey;
import org.bouncycastle.asn1.crmf.ProofOfPossession;
import org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x509.Extension;
import org.bouncycastle.asn1.x509.Extensions;
import org.bouncycastle.asn1.x509.GeneralName;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.asn1.x509.Time;
import org.bouncycastle.cert.crmf.ProofOfPossessionSigningKeyBuilder;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.operator.ContentSigner;
import org.xipki.cmp.client.EnrollCertRequest;
import org.xipki.cmp.client.EnrollCertResult;
import org.xipki.cmp.client.shell.Actions;
import org.xipki.password.PasswordResolverException;
import org.xipki.security.ConcurrentBagEntrySigner;
import org.xipki.security.ConcurrentContentSigner;
import org.xipki.security.HashAlgo;
import org.xipki.security.SecurityFactory;
import org.xipki.security.SignatureAlgoControl;
import org.xipki.security.SignerConf;
import org.xipki.security.X509Cert;
import org.xipki.security.util.KeyUtil;
import org.xipki.security.util.X509Util;
import org.xipki.shell.CmdFailure;
import org.xipki.shell.Completers;
import org.xipki.util.Args;
import org.xipki.util.ConfPairs;
import org.xipki.util.DateUtil;
import org.xipki.util.Hex;
import org.xipki.util.ReqRespDebug;
import org.xipki.util.StringUtil;
import org.xipki.util.exception.ObjectCreationException;

public class UpdateCertActions {

    public static abstract class UpdateCertAction
    extends UpdateAction {
        @Option(name="--hash", description="hash algorithm name for the POP computation")
        protected String hashAlgo = "SHA256";
        @Option(name="--outform", description="output format of the certificate")
        @Completion(value=Completers.DerPemCompleter.class)
        private String outform = "der";
        @Option(name="--out", aliases={"-o"}, required=true, description="where to save the certificate")
        @Completion(value=FileCompleter.class)
        private String outputFile;
        @Option(name="--rsa-pss", description="whether to use the RSAPSS for the POP computation\n(only applied to RSA key)")
        private Boolean rsaPss = Boolean.FALSE;
        @Option(name="--dsa-plain", description="whether to use the Plain DSA for the POP computation\n(only applied to DSA and ECDSA key)")
        private Boolean dsaPlain = Boolean.FALSE;
        @Option(name="--gm", description="whether to use the chinese GM algorithm for the POP computation\n(only applied to EC key with GM curves)")
        private Boolean gm = Boolean.FALSE;
        @Option(name="--embeds-publickey", description="whether to embed the public key in the request")
        private Boolean embedsPulibcKey = Boolean.FALSE;

        protected SignatureAlgoControl getSignatureAlgoControl() {
            return new SignatureAlgoControl(this.rsaPss.booleanValue(), this.dsaPlain.booleanValue(), this.gm.booleanValue());
        }

        protected abstract ConcurrentContentSigner getSigner() throws ObjectCreationException;

        @Override
        protected SubjectPublicKeyInfo getPublicKey() throws Exception {
            return this.embedsPulibcKey != false ? this.getSigner().getCertificate().getSubjectPublicKeyInfo() : null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected EnrollCertRequest.Entry buildEnrollCertRequestEntry(String id, String profile, CertRequest certRequest) throws Exception {
            POPOSigningKey popSk;
            ConcurrentContentSigner signer = this.getSigner();
            ProofOfPossessionSigningKeyBuilder popBuilder = new ProofOfPossessionSigningKeyBuilder(certRequest);
            ConcurrentBagEntrySigner signer0 = signer.borrowSigner();
            try {
                popSk = popBuilder.build((ContentSigner)signer0.value());
            }
            finally {
                signer.requiteSigner(signer0);
            }
            ProofOfPossession pop = new ProofOfPossession(popSk);
            return new EnrollCertRequest.Entry(id, profile, certRequest, pop, false, true);
        }

        protected Object execute0() throws Exception {
            EnrollCertResult result = this.enroll();
            X509Cert cert = null;
            if (result != null) {
                String id = (String)result.getAllIds().iterator().next();
                cert = result.getCertOrError(id).getCertificate();
            }
            if (cert == null) {
                throw new CmdFailure("no certificate received from the server");
            }
            this.saveVerbose("saved certificate to file", this.outputFile, UpdateCertAction.encodeCert((byte[])cert.getEncoded(), (String)this.outform));
            return null;
        }
    }

    public static abstract class UpdateAction
    extends Actions.AuthClientAction {
        @Reference
        protected SecurityFactory securityFactory;
        @Option(name="--subject", aliases={"-s"}, description="subject to be requested")
        private String subject;
        @Option(name="--not-before", description="notBefore, UTC time of format yyyyMMddHHmmss")
        private String notBeforeS;
        @Option(name="--not-after", description="notAfter, UTC time of format yyyyMMddHHmmss")
        private String notAfterS;
        @Option(name="--oldcert", required=true, description="certificate file")
        @Completion(value=FileCompleter.class)
        private String oldCertFile;

        protected abstract SubjectPublicKeyInfo getPublicKey() throws Exception;

        protected abstract EnrollCertRequest.Entry buildEnrollCertRequestEntry(String var1, String var2, CertRequest var3) throws Exception;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected EnrollCertResult enroll() throws Exception {
            EnrollCertResult result;
            LinkedList extensions;
            SubjectPublicKeyInfo publicKey;
            CertTemplateBuilder certTemplateBuilder = new CertTemplateBuilder();
            if (this.subject != null && !this.subject.isEmpty()) {
                certTemplateBuilder.setSubject(new X500Name(this.subject));
            }
            if ((publicKey = this.getPublicKey()) != null) {
                certTemplateBuilder.setPublicKey(this.getPublicKey());
            }
            if (StringUtil.isNotBlank((String)this.notBeforeS) || StringUtil.isNotBlank((String)this.notAfterS)) {
                Time notBefore = StringUtil.isNotBlank((String)this.notBeforeS) ? new Time(Date.from(DateUtil.parseUtcTimeyyyyMMddhhmmss((String)this.notBeforeS))) : null;
                Time notAfter = StringUtil.isNotBlank((String)this.notAfterS) ? new Time(Date.from(DateUtil.parseUtcTimeyyyyMMddhhmmss((String)this.notAfterS))) : null;
                OptionalValidity validity = new OptionalValidity(notBefore, notAfter);
                certTemplateBuilder.setValidity(validity);
            }
            if (UpdateAction.isNotEmpty(extensions = new LinkedList())) {
                Extensions asn1Extensions = new Extensions(extensions.toArray(new Extension[0]));
                certTemplateBuilder.setExtensions(asn1Extensions);
            }
            X509Cert oldCert = X509Util.parseCert((File)new File(this.oldCertFile));
            CertId oldCertId = new CertId(new GeneralName(oldCert.getIssuer()), oldCert.getSerialNumber());
            Controls controls = new Controls(new AttributeTypeAndValue(CMPObjectIdentifiers.regCtrl_oldCertID, (ASN1Encodable)oldCertId));
            CertRequest certReq = new CertRequest(1, certTemplateBuilder.build(), controls);
            EnrollCertRequest.Entry reqEntry = this.buildEnrollCertRequestEntry("id-1", null, certReq);
            EnrollCertRequest request = new EnrollCertRequest(EnrollCertRequest.EnrollType.KEY_UPDATE);
            request.addRequestEntry(reqEntry);
            ReqRespDebug debug = this.getReqRespDebug();
            try {
                result = this.client.enrollCerts(this.caName, this.getRequestor(), request, debug);
            }
            finally {
                this.saveRequestResponse(debug);
            }
            return result;
        }
    }

    @Command(scope="xi", name="cmp-update-p12", description="update certificate (PKCS#12 keystore)")
    @Service
    public static class CmpUpdateP12
    extends UpdateCertAction {
        @Option(name="--p12", required=true, description="PKCS#12 keystore file")
        @Completion(value=FileCompleter.class)
        private String p12File;
        @Option(name="--password", description="password of the PKCS#12 keystore file, as plaintext or PBE-encrypted.")
        private String passwordHint;
        private ConcurrentContentSigner signer;

        @Override
        protected ConcurrentContentSigner getSigner() throws ObjectCreationException {
            if (this.signer == null) {
                char[] password;
                try {
                    password = this.readPasswordIfNotSet(this.passwordHint);
                }
                catch (IOException | PasswordResolverException ex) {
                    throw new ObjectCreationException("could not read password: " + ex.getMessage(), ex);
                }
                ConfPairs conf = new ConfPairs("password", new String(password)).putPair("parallelism", Integer.toString(1)).putPair("keystore", "file:" + this.p12File);
                SignerConf signerConf = new SignerConf(conf.getEncoded(), CmpUpdateP12.getHashAlgo(this.hashAlgo), this.getSignatureAlgoControl());
                this.signer = this.securityFactory.createSigner("PKCS12", signerConf, (X509Cert[])null);
            }
            return this.signer;
        }
    }

    @Command(scope="xi", name="cmp-update-p11", description="update certificate (PKCS#11 token)")
    @Service
    public static class CmpUpdateP11
    extends UpdateCertAction {
        @Option(name="--slot", required=true, description="slot index")
        private String slotIndex = "0";
        @Option(name="--key-id", description="id of the private key in the PKCS#11 device\neither keyId or keyLabel must be specified")
        private String keyId;
        @Option(name="--key-label", description="label of the private key in the PKCS#11 device\neither keyId or keyLabel must be specified")
        private String keyLabel;
        @Option(name="--module", description="name of the PKCS#11 module")
        private String moduleName = "default";
        private ConcurrentContentSigner signer;

        @Override
        protected ConcurrentContentSigner getSigner() throws ObjectCreationException {
            if (this.signer == null) {
                byte[] keyIdBytes = null;
                if (this.keyId != null) {
                    keyIdBytes = Hex.decode((String)this.keyId);
                }
                SignerConf signerConf = CmpUpdateP11.getPkcs11SignerConf(this.moduleName, Integer.parseInt(this.slotIndex), this.keyLabel, keyIdBytes, CmpUpdateP11.getHashAlgo(this.hashAlgo), this.getSignatureAlgoControl());
                this.signer = this.securityFactory.createSigner("PKCS11", signerConf, (X509Cert[])null);
            }
            return this.signer;
        }

        public static SignerConf getPkcs11SignerConf(String pkcs11ModuleName, int slotIndex, String keyLabel, byte[] keyId, HashAlgo hashAlgo, SignatureAlgoControl signatureAlgoControl) {
            Args.notNull((Object)hashAlgo, (String)"hashAlgo");
            if (keyId == null && keyLabel == null) {
                throw new IllegalArgumentException("at least one of keyId and keyLabel may not be null");
            }
            ConfPairs conf = new ConfPairs();
            conf.putPair("parallelism", Integer.toString(1));
            if (pkcs11ModuleName != null && pkcs11ModuleName.length() > 0) {
                conf.putPair("module", pkcs11ModuleName);
            }
            conf.putPair("slot", Integer.toString(slotIndex));
            if (keyId != null) {
                conf.putPair("key-id", Hex.encode((byte[])keyId));
            }
            if (keyLabel != null) {
                conf.putPair("key-label", keyLabel);
            }
            return new SignerConf(conf.getEncoded(), hashAlgo, signatureAlgoControl);
        }
    }

    @Command(scope="xi", name="cmp-update-serverkeygen", description="update certificate (keypair will be generated by the CA)")
    @Service
    public static class CmpUpdateCagenkey
    extends UpdateAction {
        @Option(name="--cert-outform", description="output format of the certificate")
        @Completion(value=Completers.DerPemCompleter.class)
        private String certOutform = "der";
        @Option(name="--cert-out", description="where to save the certificate")
        @Completion(value=FileCompleter.class)
        private String certOutputFile;
        @Option(name="--p12-out", required=true, description="where to save the PKCS#12 keystore")
        @Completion(value=FileCompleter.class)
        private String p12OutputFile;
        @Option(name="--password", description="password of the PKCS#12 file, as plaintext or PBE-encrypted.")
        private String passwordHint;

        @Override
        protected SubjectPublicKeyInfo getPublicKey() throws Exception {
            return null;
        }

        @Override
        protected EnrollCertRequest.Entry buildEnrollCertRequestEntry(String id, String profile, CertRequest certRequest) throws Exception {
            return new EnrollCertRequest.Entry("id-1", profile, certRequest, null, true, true);
        }

        protected Object execute0() throws Exception {
            EnrollCertResult result = this.enroll();
            X509Cert cert = null;
            PrivateKeyInfo privateKeyInfo = null;
            if (result != null) {
                String id = (String)result.getAllIds().iterator().next();
                EnrollCertResult.CertifiedKeyPairOrError certOrError = result.getCertOrError(id);
                cert = certOrError.getCertificate();
                privateKeyInfo = certOrError.getPrivateKeyInfo();
            }
            if (cert == null) {
                throw new CmdFailure("no certificate received from the server");
            }
            if (privateKeyInfo == null) {
                throw new CmdFailure("no private key received from the server");
            }
            if (StringUtil.isNotBlank((String)this.certOutputFile)) {
                this.saveVerbose("saved certificate to file", this.certOutputFile, CmpUpdateCagenkey.encodeCert((byte[])cert.getEncoded(), (String)this.certOutform));
            }
            PrivateKey privateKey = BouncyCastleProvider.getPrivateKey(privateKeyInfo);
            KeyStore ks = KeyUtil.getOutKeyStore((String)"PKCS12");
            char[] pwd = this.getPassword();
            ks.load(null, pwd);
            ks.setKeyEntry("main", privateKey, pwd, new Certificate[]{cert.toJceCert()});
            ByteArrayOutputStream bout = new ByteArrayOutputStream();
            ks.store(bout, pwd);
            this.saveVerbose("saved key to file", this.p12OutputFile, bout.toByteArray());
            return null;
        }

        private char[] getPassword() throws IOException, PasswordResolverException {
            char[] pwdInChar = this.readPasswordIfNotSet(this.passwordHint);
            if (pwdInChar != null) {
                this.passwordHint = new String(pwdInChar);
            }
            return pwdInChar;
        }
    }
}

