/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.cmp.client.shell;

import java.io.File;
import java.io.IOException;
import java.math.BigInteger;
import java.security.cert.CertificateException;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.karaf.shell.api.action.Command;
import org.apache.karaf.shell.api.action.Completion;
import org.apache.karaf.shell.api.action.Option;
import org.apache.karaf.shell.api.action.lifecycle.Service;
import org.apache.karaf.shell.support.completers.FileCompleter;
import org.xipki.cmp.PkiStatusInfo;
import org.xipki.cmp.client.CertIdOrError;
import org.xipki.cmp.client.CmpClientException;
import org.xipki.cmp.client.Requestor;
import org.xipki.cmp.client.RevokeCertRequest;
import org.xipki.cmp.client.UnrevokeCertRequest;
import org.xipki.cmp.client.shell.Actions;
import org.xipki.security.CrlReason;
import org.xipki.security.X509Cert;
import org.xipki.security.util.X509Util;
import org.xipki.shell.CmdFailure;
import org.xipki.shell.Completers;
import org.xipki.shell.IllegalCmdParamException;
import org.xipki.util.CollectionUtil;
import org.xipki.util.DateUtil;
import org.xipki.util.ReqRespDebug;

public class UnRevokeCertActions {
    private static void assertIssuedByCa(X509Cert cert, X509Cert ca, String certDesc) throws CmpClientException {
        boolean issued = X509Util.issues((X509Cert)ca, (X509Cert)cert);
        if (!issued) {
            throw new CmpClientException("certificate " + certDesc + "is not issued by the CA");
        }
    }

    public static abstract class UnRevokeCertAction
    extends Actions.AuthClientAction {
        @Option(name="--ca-cert", required=true, description="certificate file")
        @Completion(value=FileCompleter.class)
        private String caCertFile;
        @Option(name="--cert", aliases={"-c"}, multiValued=true, description="certificate files (either cert or serial is allowed)")
        @Completion(value=FileCompleter.class)
        protected List<String> certFiles;
        @Option(name="--serial", aliases={"-s"}, multiValued=true, description="serial numbers (either cert or serial is allowed)")
        private List<String> serialNumbersS;
        private List<BigInteger> serialNumbers;

        protected X509Cert getCaCert() throws CertificateException, IOException {
            return X509Util.parseCert((File)new File(this.caCertFile));
        }

        protected ReqInfo getReqInfo() throws IllegalCmdParamException, CertificateException, IOException, CmpClientException {
            if (CollectionUtil.isEmpty(this.certFiles) && CollectionUtil.isEmpty(this.serialNumbersS)) {
                throw new IllegalCmdParamException("none of cert and serial is specified");
            }
            LinkedList<String> ids = new LinkedList<String>();
            LinkedList<String> sources = new LinkedList<String>();
            LinkedList<BigInteger> serialNumbers = new LinkedList<BigInteger>();
            X509Cert caCert = this.getCaCert();
            int id = 1;
            if (CollectionUtil.isNotEmpty(this.certFiles)) {
                for (String certFile : this.certFiles) {
                    X509Cert cert = X509Util.parseCert((File)new File(certFile));
                    UnRevokeCertActions.assertIssuedByCa(cert, caCert, certFile);
                    ids.add(Integer.toString(id++));
                    sources.add(certFile);
                    serialNumbers.add(cert.getSerialNumber());
                }
            }
            if (CollectionUtil.isNotEmpty(this.serialNumbersS)) {
                for (String serialNumber : this.serialNumbersS) {
                    ids.add(Integer.toString(id++));
                    sources.add(serialNumber);
                    serialNumbers.add(UnRevokeCertAction.toBigInt((String)serialNumber));
                }
            }
            ReqInfo reqInfo = new ReqInfo();
            reqInfo.caCert = caCert;
            reqInfo.ids = ids;
            reqInfo.sources = sources;
            reqInfo.serialNumbers = serialNumbers;
            return reqInfo;
        }

        protected void analyseResult(boolean revoke, Map<String, CertIdOrError> certIdOrErrors, ReqInfo reqInfo) throws CmdFailure {
            boolean failed = false;
            ArrayList<Integer> processedIndex = new ArrayList<Integer>(reqInfo.sources.size());
            for (Map.Entry<String, CertIdOrError> certIdOrError : certIdOrErrors.entrySet()) {
                String id = certIdOrError.getKey();
                int index = reqInfo.ids.indexOf(id);
                if (index == -1) {
                    failed = true;
                    this.println("error in CMP protocol, unknown id " + id);
                    continue;
                }
                processedIndex.add(index);
                String source = reqInfo.sources.get(index);
                if (certIdOrError.getValue().getError() != null) {
                    failed = true;
                    PkiStatusInfo error = certIdOrError.getValue().getError();
                    this.println((revoke ? "revoking" : "unsuspending") + " certificate " + source + " failed: " + error);
                    continue;
                }
                this.println((revoke ? "revoked" : "suspended") + " certificate " + source);
            }
            if (reqInfo.sources.size() != processedIndex.size()) {
                Collections.sort(processedIndex, Collections.reverseOrder());
                for (Integer index : processedIndex) {
                    reqInfo.sources.remove(index);
                }
                failed = true;
                this.println("server did not process request for " + reqInfo.sources);
            }
            if (failed) {
                throw new CmdFailure("failed processing at least one certificate");
            }
        }
    }

    @Command(scope="xi", name="cmp-unsuspend", description="unsuspend certificate")
    @Service
    public static class CmpUnsuspend
    extends UnRevokeCertAction {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected Object execute0() throws Exception {
            Map certIdOrErrors;
            ReqInfo reqInfo = this.getReqInfo();
            ReqRespDebug debug = this.getReqRespDebug();
            try {
                Requestor requestor = this.getRequestor();
                X509Cert caCert = reqInfo.caCert;
                UnrevokeCertRequest req = new UnrevokeCertRequest();
                for (int i = 0; i < reqInfo.ids.size(); ++i) {
                    UnrevokeCertRequest.Entry entry = new UnrevokeCertRequest.Entry(reqInfo.ids.get(i), caCert.getSubject(), reqInfo.serialNumbers.get(i));
                    req.addRequestEntry(entry);
                }
                certIdOrErrors = this.client.unsuspendCerts(this.caName, requestor, req, debug);
            }
            finally {
                this.saveRequestResponse(debug);
            }
            this.analyseResult(false, certIdOrErrors, reqInfo);
            return null;
        }
    }

    @Command(scope="xi", name="cmp-revoke", description="revoke certificate")
    @Service
    public static class CmpRevoke
    extends UnRevokeCertAction {
        @Option(name="--reason", aliases={"-r"}, required=true, description="CRL reason")
        @Completion(value=Completers.ClientCrlReasonCompleter.class)
        private String reason;
        @Option(name="--inv-date", description="invalidity date, UTC time of format yyyyMMddHHmmss")
        private String invalidityDateS;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected Object execute0() throws Exception {
            Map certIdOrErrors;
            CrlReason crlReason = CrlReason.forNameOrText((String)this.reason);
            if (!CrlReason.PERMITTED_CLIENT_CRLREASONS.contains(crlReason)) {
                throw new IllegalCmdParamException("reason " + this.reason + " is not permitted");
            }
            Instant invalidityDate = null;
            if (CmpRevoke.isNotBlank((String)this.invalidityDateS)) {
                invalidityDate = DateUtil.parseUtcTimeyyyyMMddhhmmss((String)this.invalidityDateS);
            }
            ReqInfo reqInfo = this.getReqInfo();
            ReqRespDebug debug = this.getReqRespDebug();
            try {
                Requestor requestor = this.getRequestor();
                X509Cert caCert = this.getCaCert();
                RevokeCertRequest req = new RevokeCertRequest();
                for (int i = 0; i < reqInfo.ids.size(); ++i) {
                    RevokeCertRequest.Entry entry = new RevokeCertRequest.Entry(reqInfo.ids.get(i), caCert.getSubject(), reqInfo.serialNumbers.get(i), crlReason.getCode(), invalidityDate);
                    req.addRequestEntry(entry);
                }
                certIdOrErrors = this.client.revokeCerts(this.caName, requestor, req, debug);
            }
            finally {
                this.saveRequestResponse(debug);
            }
            this.analyseResult(true, certIdOrErrors, reqInfo);
            return null;
        }
    }

    private static class ReqInfo {
        private X509Cert caCert;
        private List<String> ids;
        private List<BigInteger> serialNumbers;
        private List<String> sources;

        private ReqInfo() {
        }
    }
}

