/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.cmp.client.shell;

import java.util.Optional;
import org.apache.karaf.shell.api.action.Command;
import org.apache.karaf.shell.api.action.Completion;
import org.apache.karaf.shell.api.action.Option;
import org.apache.karaf.shell.api.action.lifecycle.Service;
import org.apache.karaf.shell.support.completers.FileCompleter;
import org.bouncycastle.cert.X509CRLHolder;
import org.xipki.cmp.client.CmpClientException;
import org.xipki.cmp.client.PkiErrorException;
import org.xipki.cmp.client.shell.Actions;
import org.xipki.shell.CmdFailure;
import org.xipki.shell.Completers;
import org.xipki.shell.XiAction;
import org.xipki.util.ReqRespDebug;

public class CrlActions {

    public static abstract class CrlAction
    extends Actions.ClientAction {
        @Option(name="--outform", description="output format of the CRL")
        @Completion(value=Completers.DerPemCompleter.class)
        protected String outform = "der";
        @Option(name="--out", aliases={"-o"}, required=true, description="where to save the CRL")
        @Completion(value=FileCompleter.class)
        protected String outFile;

        protected abstract X509CRLHolder retrieveCrl() throws CmpClientException, PkiErrorException;

        protected Object execute0() throws Exception {
            X509CRLHolder crl;
            try {
                crl = Optional.ofNullable(this.retrieveCrl()).orElseThrow(() -> new CmdFailure("received no CRL from server"));
            }
            catch (PkiErrorException ex) {
                throw new CmdFailure("received no CRL from server: " + ex.getMessage());
            }
            this.saveVerbose("saved CRL to file", this.outFile, CrlAction.encodeCrl((byte[])crl.getEncoded(), (String)this.outform));
            return null;
        }
    }

    @Command(scope="xi", name="cmp-get-crl", description="download CRL")
    @Service
    public static class CmpGetCrl
    extends CrlAction {
        @Override
        protected X509CRLHolder retrieveCrl() throws CmpClientException, PkiErrorException {
            ReqRespDebug debug = this.getReqRespDebug();
            try {
                X509CRLHolder x509CRLHolder = this.client.downloadCrl(this.caName, debug);
                return x509CRLHolder;
            }
            finally {
                this.saveRequestResponse(debug);
            }
        }

        @Override
        protected Object execute0() throws Exception {
            X509CRLHolder crl;
            try {
                crl = Optional.ofNullable(this.retrieveCrl()).orElseThrow(() -> new CmdFailure("received no CRL from server"));
            }
            catch (PkiErrorException ex) {
                throw new CmdFailure("received no CRL from server: " + ex.getMessage());
            }
            this.saveVerbose("saved CRL to file", this.outFile, XiAction.encodeCrl((byte[])crl.getEncoded(), (String)this.outform));
            return null;
        }
    }
}

