/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.cmpclient.shell;

import com.alibaba.fastjson.JSON;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.apache.karaf.shell.api.action.Command;
import org.apache.karaf.shell.api.action.Completion;
import org.apache.karaf.shell.api.action.Option;
import org.apache.karaf.shell.api.action.lifecycle.Reference;
import org.apache.karaf.shell.api.action.lifecycle.Service;
import org.apache.karaf.shell.support.completers.FileCompleter;
import org.xipki.cmpclient.CmpClient;
import org.xipki.cmpclient.shell.CmpClientCompleters;
import org.xipki.security.X509Cert;
import org.xipki.security.util.X509Util;
import org.xipki.shell.CmdFailure;
import org.xipki.shell.Completers;
import org.xipki.shell.IllegalCmdParamException;
import org.xipki.shell.XiAction;
import org.xipki.util.CollectionUtil;
import org.xipki.util.HealthCheckResult;
import org.xipki.util.IoUtil;
import org.xipki.util.ReqRespDebug;
import org.xipki.util.StringUtil;

public class Actions {

    @Command(scope="xi", name="cmp-init", description="initialize CMP client")
    @Service
    public static class CmpInit
    extends ClientAction {
        protected Object execute0() throws Exception {
            boolean succ = this.client.init();
            if (succ) {
                this.println("CA client initialized successfully");
            } else {
                this.println("CA client initialization failed");
            }
            return null;
        }
    }

    @Command(scope="xi", name="cmp-health", description="check healty status of CA")
    @Service
    public static class CmpHealth
    extends ClientAction {
        @Option(name="--ca", description="CA name\n(required if multiple CAs are configured)")
        @Completion(value=CmpClientCompleters.CaNameCompleter.class)
        private String caName;
        @Option(name="--verbose", aliases={"-v"}, description="show status verbosely")
        private Boolean verbose = Boolean.FALSE;

        protected Object execute0() throws Exception {
            Set caNames;
            if (this.caName != null) {
                this.caName = this.caName.toLowerCase();
            }
            if (CmpHealth.isEmpty((Collection)(caNames = this.client.getCaNames()))) {
                throw new IllegalCmdParamException("no CA is configured");
            }
            if (this.caName != null && !caNames.contains(this.caName)) {
                throw new IllegalCmdParamException("CA " + this.caName + " is not within the configured CAs " + caNames);
            }
            if (this.caName == null) {
                if (caNames.size() == 1) {
                    this.caName = (String)caNames.iterator().next();
                } else {
                    throw new IllegalCmdParamException("no CA is specified, one of " + caNames + " is required");
                }
            }
            HealthCheckResult healthResult = this.client.getHealthCheckResult(this.caName);
            String str = StringUtil.concat((String)"healthy status for CA ", (String[])new String[]{this.caName, ": ", healthResult.isHealthy() ? "healthy" : "not healthy"});
            if (this.verbose.booleanValue()) {
                str = StringUtil.concat((String)str, (String[])new String[]{"\n", JSON.toJSONString((Object)healthResult, (boolean)true)});
            }
            System.out.println(str);
            return null;
        }
    }

    @Command(scope="xi", name="cmp-cacertchain", description="get CA certificate chain")
    @Service
    public static class CmpCacertchain
    extends ClientAction {
        @Option(name="--ca", description="CA name\n(required if multiple CAs are configured)")
        @Completion(value=CmpClientCompleters.CaNameCompleter.class)
        private String caName;
        @Option(name="--out", aliases={"-o"}, required=true, description="where to save the CA certificate chain")
        @Completion(value=FileCompleter.class)
        private String outFile;

        protected Object execute0() throws Exception {
            List caCertChain;
            Set caNames;
            if (this.caName != null) {
                this.caName = this.caName.toLowerCase();
            }
            if (CmpCacertchain.isEmpty((Collection)(caNames = this.client.getCaNames()))) {
                throw new CmdFailure("no CA is configured");
            }
            if (this.caName != null && !caNames.contains(this.caName)) {
                throw new IllegalCmdParamException("CA " + this.caName + " is not within the configured CAs " + caNames);
            }
            if (this.caName == null) {
                if (caNames.size() == 1) {
                    this.caName = (String)caNames.iterator().next();
                } else {
                    throw new IllegalCmdParamException("no CA is specified, one of " + caNames + " is required");
                }
            }
            try {
                caCertChain = this.client.getCaCertchain(this.caName);
            }
            catch (Exception ex) {
                throw new CmdFailure("Error while retrieving CA certificate chain: " + ex.getMessage());
            }
            if (CollectionUtil.isEmpty((Collection)caCertChain)) {
                throw new CmdFailure("received no CA certificate chain");
            }
            String encoded = X509Util.encodeCertificates((X509Cert[])caCertChain.toArray(new X509Cert[0]));
            this.saveVerbose("saved CA certificate to file", this.outFile, StringUtil.toUtf8Bytes((String)encoded));
            return null;
        }
    }

    @Command(scope="xi", name="cmp-cacert", description="get CA certificate")
    @Service
    public static class CmpCacert
    extends ClientAction {
        @Option(name="--ca", description="CA name\n(required if multiple CAs are configured)")
        @Completion(value=CmpClientCompleters.CaNameCompleter.class)
        private String caName;
        @Option(name="--outform", description="output format of the certificate")
        @Completion(value=Completers.DerPemCompleter.class)
        private String outform = "der";
        @Option(name="--out", aliases={"-o"}, required=true, description="where to save the CA certificate")
        @Completion(value=FileCompleter.class)
        private String outFile;

        protected Object execute0() throws Exception {
            X509Cert caCert;
            Set caNames;
            if (this.caName != null) {
                this.caName = this.caName.toLowerCase();
            }
            if (CmpCacert.isEmpty((Collection)(caNames = this.client.getCaNames()))) {
                throw new CmdFailure("no CA is configured");
            }
            if (this.caName != null && !caNames.contains(this.caName)) {
                throw new IllegalCmdParamException("CA " + this.caName + " is not within the configured CAs " + caNames);
            }
            if (this.caName == null) {
                if (caNames.size() == 1) {
                    this.caName = (String)caNames.iterator().next();
                } else {
                    throw new IllegalCmdParamException("no CA is specified, one of " + caNames + " is required");
                }
            }
            try {
                caCert = this.client.getCaCert(this.caName);
            }
            catch (Exception ex) {
                throw new CmdFailure("Error while retrieving CA certificate: " + ex.getMessage());
            }
            if (caCert == null) {
                throw new CmdFailure("received no CA certificate");
            }
            this.saveVerbose("saved CA certificate to file", this.outFile, CmpCacert.encodeCert((byte[])caCert.getEncoded(), (String)this.outform));
            return null;
        }
    }

    public static abstract class ClientAction
    extends XiAction {
        @Reference
        protected CmpClient client;
        @Option(name="--req-out", description="where to save the request")
        @Completion(value=FileCompleter.class)
        private String reqout;
        @Option(name="--resp-out", description="where to save the response")
        @Completion(value=FileCompleter.class)
        private String respout;

        protected ReqRespDebug getReqRespDebug() {
            boolean saveReq = ClientAction.isNotBlank((String)this.reqout);
            boolean saveResp = ClientAction.isNotBlank((String)this.respout);
            if (saveReq || saveResp) {
                return new ReqRespDebug(saveReq, saveResp);
            }
            return null;
        }

        protected void saveRequestResponse(ReqRespDebug debug) {
            boolean saveReq = ClientAction.isNotBlank((String)this.reqout);
            boolean saveResp = ClientAction.isNotBlank((String)this.respout);
            if (!saveReq && !saveResp) {
                return;
            }
            if (debug == null || debug.size() == 0) {
                return;
            }
            int n = debug.size();
            for (int i = 0; i < n; ++i) {
                String fn;
                byte[] bytes;
                ReqRespDebug.ReqRespPair reqResp = debug.get(i);
                if (saveReq && (bytes = reqResp.getRequest()) != null) {
                    fn = n == 1 ? this.reqout : ClientAction.appendIndex(this.reqout, i);
                    try {
                        IoUtil.save((String)fn, (byte[])bytes);
                    }
                    catch (IOException ex) {
                        System.err.println("IOException: " + ex.getMessage());
                    }
                }
                if (!saveResp || (bytes = reqResp.getResponse()) == null) continue;
                fn = n == 1 ? this.respout : ClientAction.appendIndex(this.respout, i);
                try {
                    IoUtil.save((String)fn, (byte[])bytes);
                    continue;
                }
                catch (IOException ex) {
                    System.err.println("IOException: " + ex.getMessage());
                }
            }
        }

        private static String appendIndex(String filename, int index) {
            int idx = filename.lastIndexOf(46);
            if (idx == -1 || idx == filename.length() - 1) {
                return filename + "-" + index;
            }
            StringBuilder sb = new StringBuilder(filename);
            sb.insert(idx, index);
            sb.insert(idx, '-');
            return sb.toString();
        }
    }
}

