/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.cmpclient.shell;

import com.alibaba.fastjson.JSON;
import java.math.BigInteger;
import java.util.Collection;
import java.util.Set;
import org.apache.karaf.shell.api.action.Command;
import org.apache.karaf.shell.api.action.Completion;
import org.apache.karaf.shell.api.action.Option;
import org.apache.karaf.shell.api.action.lifecycle.Service;
import org.apache.karaf.shell.support.completers.FileCompleter;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.x509.Extension;
import org.bouncycastle.asn1.x509.Extensions;
import org.bouncycastle.cert.X509CRLHolder;
import org.xipki.cmpclient.CmpClientException;
import org.xipki.cmpclient.PkiErrorException;
import org.xipki.cmpclient.shell.Actions;
import org.xipki.cmpclient.shell.CmpClientCompleters;
import org.xipki.security.util.X509Util;
import org.xipki.shell.CmdFailure;
import org.xipki.shell.Completers;
import org.xipki.shell.IllegalCmdParamException;
import org.xipki.util.HealthCheckResult;
import org.xipki.util.ReqRespDebug;
import org.xipki.util.StringUtil;

public class CrlActions {

    public static abstract class CrlAction
    extends Actions.ClientAction {
        @Option(name="--ca", description="CA name\n(required if multiple CAs are configured)")
        @Completion(value=CmpClientCompleters.CaNameCompleter.class)
        protected String caName;
        @Option(name="--outform", description="output format of the CRL")
        @Completion(value=Completers.DerPemCompleter.class)
        protected String outform = "der";
        @Option(name="--out", aliases={"-o"}, required=true, description="where to save the CRL")
        @Completion(value=FileCompleter.class)
        protected String outFile;

        protected abstract X509CRLHolder retrieveCrl() throws CmpClientException, PkiErrorException;

        protected Object execute0() throws Exception {
            Set caNames;
            if (this.caName != null) {
                this.caName = this.caName.toLowerCase();
            }
            if (CrlAction.isEmpty((Collection)(caNames = this.client.getCaNames()))) {
                throw new CmdFailure("no CA is configured");
            }
            if (this.caName != null && !caNames.contains(this.caName)) {
                throw new IllegalCmdParamException("CA " + this.caName + " is not within the configured CAs " + caNames);
            }
            if (this.caName == null) {
                if (caNames.size() == 1) {
                    this.caName = (String)caNames.iterator().next();
                } else {
                    throw new IllegalCmdParamException("no CA is specified, one of " + caNames + " is required");
                }
            }
            X509CRLHolder crl = null;
            try {
                crl = this.retrieveCrl();
            }
            catch (PkiErrorException ex) {
                throw new CmdFailure("received no CRL from server: " + ex.getMessage());
            }
            if (crl == null) {
                throw new CmdFailure("received no CRL from server");
            }
            this.saveVerbose("saved CRL to file", this.outFile, CrlAction.encodeCrl((byte[])crl.getEncoded(), (String)this.outform));
            return null;
        }
    }

    @Command(scope="xi", name="cmp-health", description="check healty status of CA")
    @Service
    public static class CmpHealth
    extends Actions.ClientAction {
        @Option(name="--ca", description="CA name\n(required if multiple CAs are configured)")
        @Completion(value=CmpClientCompleters.CaNameCompleter.class)
        private String caName;
        @Option(name="--verbose", aliases={"-v"}, description="show status verbosely")
        private Boolean verbose = Boolean.FALSE;

        protected Object execute0() throws Exception {
            Set caNames;
            if (this.caName != null) {
                this.caName = this.caName.toLowerCase();
            }
            if (CmpHealth.isEmpty((Collection)(caNames = this.client.getCaNames()))) {
                throw new IllegalCmdParamException("no CA is configured");
            }
            if (this.caName != null && !caNames.contains(this.caName)) {
                throw new IllegalCmdParamException("CA " + this.caName + " is not within the configured CAs " + caNames);
            }
            if (this.caName == null) {
                if (caNames.size() == 1) {
                    this.caName = (String)caNames.iterator().next();
                } else {
                    throw new IllegalCmdParamException("no CA is specified, one of " + caNames + " is required");
                }
            }
            HealthCheckResult healthResult = this.client.getHealthCheckResult(this.caName);
            String str = StringUtil.concat((String)"healthy status for CA ", (String[])new String[]{this.caName, ": ", healthResult.isHealthy() ? "healthy" : "not healthy"});
            if (this.verbose.booleanValue()) {
                str = StringUtil.concat((String)str, (String[])new String[]{"\n", JSON.toJSONString((Object)healthResult, (boolean)true)});
            }
            System.out.println(str);
            return null;
        }
    }

    @Command(scope="xi", name="cmp-get-crl", description="download CRL")
    @Service
    public static class CmpGetCrl
    extends CrlAction {
        @Option(name="--with-basecrl", description="whether to retrieve the baseCRL if the current CRL is a delta CRL")
        private Boolean withBaseCrl = Boolean.FALSE;
        @Option(name="--basecrl-out", description="where to save the baseCRL\n(defaults to <out>-baseCRL)")
        @Completion(value=FileCompleter.class)
        private String baseCrlOut;

        @Override
        protected X509CRLHolder retrieveCrl() throws CmpClientException, PkiErrorException {
            ReqRespDebug debug = this.getReqRespDebug();
            try {
                X509CRLHolder x509CRLHolder = this.client.downloadCrl(this.caName, debug);
                return x509CRLHolder;
            }
            finally {
                this.saveRequestResponse(debug);
            }
        }

        @Override
        protected Object execute0() throws Exception {
            Set caNames;
            if (this.caName != null) {
                this.caName = this.caName.toLowerCase();
            }
            if (CmpGetCrl.isEmpty((Collection)(caNames = this.client.getCaNames()))) {
                throw new IllegalCmdParamException("no CA is configured");
            }
            if (this.caName != null && !caNames.contains(this.caName)) {
                throw new IllegalCmdParamException("CA " + this.caName + " is not within the configured CAs " + caNames);
            }
            if (this.caName == null) {
                if (caNames.size() == 1) {
                    this.caName = (String)caNames.iterator().next();
                } else {
                    throw new IllegalCmdParamException("no CA is specified, one of " + caNames + " is required");
                }
            }
            X509CRLHolder crl = null;
            try {
                crl = this.retrieveCrl();
            }
            catch (PkiErrorException ex) {
                throw new CmdFailure("received no CRL from server: " + ex.getMessage());
            }
            if (crl == null) {
                throw new CmdFailure("received no CRL from server");
            }
            this.saveVerbose("saved CRL to file", this.outFile, CmpGetCrl.encodeCrl((byte[])crl.getEncoded(), (String)this.outform));
            if (!this.withBaseCrl.booleanValue()) {
                return null;
            }
            byte[] extnValue = X509Util.getCoreExtValue((Extensions)crl.getExtensions(), (ASN1ObjectIdentifier)Extension.deltaCRLIndicator);
            if (extnValue == null) {
                return null;
            }
            if (this.baseCrlOut == null) {
                this.baseCrlOut = this.outFile + "-baseCRL";
            }
            BigInteger baseCrlNumber = ASN1Integer.getInstance((Object)extnValue).getPositiveValue();
            ReqRespDebug debug = this.getReqRespDebug();
            try {
                crl = this.client.downloadCrl(this.caName, baseCrlNumber, debug);
            }
            catch (PkiErrorException ex) {
                throw new CmdFailure("received no baseCRL from server: " + ex.getMessage());
            }
            finally {
                this.saveRequestResponse(debug);
            }
            if (crl == null) {
                throw new CmdFailure("received no baseCRL from server");
            }
            this.saveVerbose("saved baseCRL to file", this.baseCrlOut, CmpGetCrl.encodeCrl((byte[])crl.getEncoded(), (String)this.outform));
            return null;
        }
    }

    @Command(scope="xi", name="cmp-gen-crl", description="generate CRL")
    @Service
    public static class CmpGenCrl
    extends CrlAction {
        @Override
        protected X509CRLHolder retrieveCrl() throws CmpClientException, PkiErrorException {
            ReqRespDebug debug = this.getReqRespDebug();
            try {
                X509CRLHolder x509CRLHolder = this.client.generateCrl(this.caName, debug);
                return x509CRLHolder;
            }
            finally {
                this.saveRequestResponse(debug);
            }
        }
    }
}

