/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.cmpclient.shell;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.parser.Feature;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.security.KeyStore;
import java.security.MessageDigest;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.StringTokenizer;
import org.apache.karaf.shell.api.action.Command;
import org.apache.karaf.shell.api.action.Completion;
import org.apache.karaf.shell.api.action.Option;
import org.apache.karaf.shell.api.action.lifecycle.Reference;
import org.apache.karaf.shell.api.action.lifecycle.Service;
import org.apache.karaf.shell.support.completers.FileCompleter;
import org.apache.karaf.shell.support.completers.StringsCompleter;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.DERGeneralizedTime;
import org.bouncycastle.asn1.DERIA5String;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.DERUTF8String;
import org.bouncycastle.asn1.crmf.CertRequest;
import org.bouncycastle.asn1.crmf.CertTemplateBuilder;
import org.bouncycastle.asn1.crmf.OptionalValidity;
import org.bouncycastle.asn1.crmf.POPOSigningKey;
import org.bouncycastle.asn1.crmf.ProofOfPossession;
import org.bouncycastle.asn1.pkcs.CertificationRequest;
import org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import org.bouncycastle.asn1.x500.RDN;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.ExtendedKeyUsage;
import org.bouncycastle.asn1.x509.Extension;
import org.bouncycastle.asn1.x509.Extensions;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.asn1.x509.Time;
import org.bouncycastle.asn1.x509.qualified.BiometricData;
import org.bouncycastle.asn1.x509.qualified.Iso4217CurrencyCode;
import org.bouncycastle.asn1.x509.qualified.MonetaryValue;
import org.bouncycastle.asn1.x509.qualified.QCStatement;
import org.bouncycastle.asn1.x509.qualified.TypeOfBiometricData;
import org.bouncycastle.cert.crmf.ProofOfPossessionSigningKeyBuilder;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.operator.ContentSigner;
import org.xipki.cmpclient.CmpClientException;
import org.xipki.cmpclient.EnrollCertRequest;
import org.xipki.cmpclient.EnrollCertResult;
import org.xipki.cmpclient.shell.Actions;
import org.xipki.cmpclient.shell.CmpClientCompleters;
import org.xipki.security.ConcurrentBagEntrySigner;
import org.xipki.security.ConcurrentContentSigner;
import org.xipki.security.HashAlgo;
import org.xipki.security.KeyUsage;
import org.xipki.security.ObjectIdentifiers;
import org.xipki.security.SecurityFactory;
import org.xipki.security.SignatureAlgoControl;
import org.xipki.security.SignerConf;
import org.xipki.security.X509Cert;
import org.xipki.security.X509ExtensionType;
import org.xipki.security.util.AlgorithmUtil;
import org.xipki.security.util.X509Util;
import org.xipki.shell.CmdFailure;
import org.xipki.shell.Completers;
import org.xipki.shell.IllegalCmdParamException;
import org.xipki.util.Args;
import org.xipki.util.CollectionUtil;
import org.xipki.util.ConfPairs;
import org.xipki.util.DateUtil;
import org.xipki.util.Hex;
import org.xipki.util.IoUtil;
import org.xipki.util.ObjectCreationException;
import org.xipki.util.ReqRespDebug;
import org.xipki.util.StringUtil;

public class EnrollCertActions {

    public static abstract class EnrollCertAction
    extends EnrollAction {
        @Option(name="--cmpreq-type", description="CMP request type (ir for Initialization Request,\ncr for Certification Request, and ccr for Cross-Certification Request)")
        @Completion(value=StringsCompleter.class, values={"ir", "cr", "ccr"})
        private String cmpreqType = "cr";
        @Option(name="--hash", description="hash algorithm name for the POPO computation")
        protected String hashAlgo = "SHA256";
        @Option(name="--outform", description="output format of the certificate")
        @Completion(value=Completers.DerPemCompleter.class)
        private String outform = "der";
        @Option(name="--out", aliases={"-o"}, required=true, description="where to save the certificate")
        @Completion(value=FileCompleter.class)
        private String outputFile;
        @Option(name="--rsa-mgf1", description="whether to use the RSAPSS MGF1 for the POPO computation\n(only applied to RSA key)")
        private Boolean rsaMgf1 = Boolean.FALSE;
        @Option(name="--dsa-plain", description="whether to use the Plain DSA for the POPO computation\n(only applied to DSA and ECDSA key)")
        private Boolean dsaPlain = Boolean.FALSE;
        @Option(name="--gm", description="whether to use the chinese GM algorithm for the POPO computation\n(only applied to EC key with GM curves)")
        private Boolean gm = Boolean.FALSE;

        protected SignatureAlgoControl getSignatureAlgoControl() {
            return new SignatureAlgoControl(this.rsaMgf1.booleanValue(), this.dsaPlain.booleanValue(), this.gm.booleanValue());
        }

        protected abstract ConcurrentContentSigner getSigner() throws ObjectCreationException, CmpClientException;

        @Override
        protected SubjectPublicKeyInfo getPublicKey() throws Exception {
            return this.getSigner().getCertificate().getSubjectPublicKeyInfo();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected EnrollCertRequest.Entry buildEnrollCertRequestEntry(String id, String profile, CertRequest certRequest) throws Exception {
            POPOSigningKey popoSk;
            ConcurrentContentSigner signer = this.getSigner();
            ProofOfPossessionSigningKeyBuilder popoBuilder = new ProofOfPossessionSigningKeyBuilder(certRequest);
            ConcurrentBagEntrySigner signer0 = signer.borrowSigner();
            try {
                popoSk = popoBuilder.build((ContentSigner)signer0.value());
            }
            finally {
                signer.requiteSigner(signer0);
            }
            ProofOfPossession popo = new ProofOfPossession(popoSk);
            return new EnrollCertRequest.Entry(id, profile, certRequest, popo);
        }

        protected Object execute0() throws Exception {
            EnrollCertResult result = this.enroll();
            X509Cert cert = null;
            if (result != null) {
                String id = (String)result.getAllIds().iterator().next();
                cert = result.getCertOrError(id).getCertificate();
            }
            if (cert == null) {
                throw new CmdFailure("no certificate received from the server");
            }
            this.saveVerbose("saved certificate to file", this.outputFile, EnrollCertAction.encodeCert((byte[])cert.getEncoded(), (String)this.outform));
            return null;
        }

        @Override
        protected EnrollCertRequest.EnrollType getCmpReqType() throws Exception {
            if ("cr".equalsIgnoreCase(this.cmpreqType)) {
                return EnrollCertRequest.EnrollType.CERT_REQ;
            }
            if ("ir".equalsIgnoreCase(this.cmpreqType)) {
                return EnrollCertRequest.EnrollType.INIT_REQ;
            }
            if ("ccr".equalsIgnoreCase(this.cmpreqType)) {
                return EnrollCertRequest.EnrollType.CROSS_CERT_REQ;
            }
            throw new IllegalCmdParamException("invalid cmpreq-type " + this.cmpreqType);
        }
    }

    public static abstract class EnrollAction
    extends Actions.ClientAction {
        private static final long _12_HOURS_MS = 43200000L;
        @Reference
        protected SecurityFactory securityFactory;
        @Option(name="--subject", aliases={"-s"}, required=true, description="subject to be requested")
        private String subject;
        @Option(name="--profile", aliases={"-p"}, required=true, description="certificate profile")
        private String profile;
        @Option(name="--not-before", description="notBefore, UTC time of format yyyyMMddHHmmss")
        private String notBeforeS;
        @Option(name="--not-after", description="notAfter, UTC time of format yyyyMMddHHmmss")
        private String notAfterS;
        @Option(name="--ca", description="CA name\n(required if the profile is supported by more than one CA)")
        @Completion(value=CmpClientCompleters.CaNameCompleter.class)
        private String caName;
        @Option(name="--keyusage", multiValued=true, description="keyusage")
        @Completion(value=Completers.KeyusageCompleter.class)
        private List<String> keyusages;
        @Option(name="--ext-keyusage", multiValued=true, description="extended keyusage (name or OID")
        @Completion(value=Completers.ExtKeyusageCompleter.class)
        private List<String> extkeyusages;
        @Option(name="--subject-alt-name", multiValued=true, description="subjectAltName")
        private List<String> subjectAltNames;
        @Option(name="--subject-info-access", multiValued=true, description="subjectInfoAccess")
        private List<String> subjectInfoAccesses;
        @Option(name="--qc-eu-limit", multiValued=true, description="QC EuLimitValue of format <currency>:<amount>:<exponent>.")
        private List<String> qcEuLimits;
        @Option(name="--biometric-type", description="Biometric type")
        private String biometricType;
        @Option(name="--biometric-hash", description="Biometric hash algorithm")
        @Completion(value=Completers.HashAlgCompleter.class)
        private String biometricHashAlgo;
        @Option(name="--biometric-file", description="Biometric hash algorithm")
        @Completion(value=FileCompleter.class)
        private String biometricFile;
        @Option(name="--biometric-uri", description="Biometric source data URI")
        private String biometricUri;
        @Option(name="--dateOfBirth", description="Date of birth YYYYMMdd in subject")
        private String dateOfBirth;
        @Option(name="--postalAddress", multiValued=true, description="postal address in subject")
        private List<String> postalAddress;
        @Option(name="--extra-extensions-file", description="Configuration file for extral extensions")
        @Completion(value=FileCompleter.class)
        private String extraExtensionsFile;

        protected abstract SubjectPublicKeyInfo getPublicKey() throws Exception;

        protected abstract EnrollCertRequest.Entry buildEnrollCertRequestEntry(String var1, String var2, CertRequest var3) throws Exception;

        protected abstract EnrollCertRequest.EnrollType getCmpReqType() throws Exception;

        protected String getCaName() throws CmpClientException {
            if (StringUtil.isBlank((String)this.caName)) {
                this.caName = this.client.getCaNameForProfile(this.profile);
            }
            return this.caName;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected EnrollCertResult enroll() throws Exception {
            EnrollCertResult result;
            Object extType;
            RDN rdn;
            DERSequence atvValue;
            RDN[] id;
            RDN[] rdns;
            EnrollCertRequest.EnrollType type = this.getCmpReqType();
            if (this.extkeyusages != null) {
                ArrayList<String> list = new ArrayList<String>(this.extkeyusages.size());
                for (String m : this.extkeyusages) {
                    String id2 = Completers.ExtKeyusageCompleter.getIdForUsageName((String)m);
                    if (id2 != null) continue;
                    try {
                        id2 = new ASN1ObjectIdentifier(m).getId();
                    }
                    catch (Exception ex) {
                        throw new IllegalCmdParamException("invalid extended key usage " + m);
                    }
                }
                this.extkeyusages = list;
            }
            X500Name subjectDn = new X500Name(this.subject);
            LinkedList<RDN> list = new LinkedList<RDN>();
            if (StringUtil.isNotBlank((String)this.dateOfBirth) && ((rdns = subjectDn.getRDNs((ASN1ObjectIdentifier)(id = ObjectIdentifiers.DN.dateOfBirth))) == null || rdns.length == 0)) {
                Date date = DateUtil.parseUtcTimeyyyyMMdd((String)this.dateOfBirth);
                date = new Date(date.getTime() + 43200000L);
                atvValue = new DERGeneralizedTime(DateUtil.toUtcTimeyyyyMMddhhmmss((Date)date) + "Z");
                rdn = new RDN((ASN1ObjectIdentifier)id, (ASN1Encodable)atvValue);
                list.add(rdn);
            }
            if (CollectionUtil.isNotEmpty(this.postalAddress) && ((rdns = subjectDn.getRDNs((ASN1ObjectIdentifier)(id = ObjectIdentifiers.DN.postalAddress))) == null || rdns.length == 0)) {
                ASN1EncodableVector vec = new ASN1EncodableVector();
                for (String m : this.postalAddress) {
                    vec.add((ASN1Encodable)new DERUTF8String(m));
                }
                if (vec.size() > 0) {
                    atvValue = new DERSequence(vec);
                    rdn = new RDN((ASN1ObjectIdentifier)id, (ASN1Encodable)atvValue);
                    list.add(rdn);
                }
            }
            if (!list.isEmpty()) {
                for (RDN rdn2 : subjectDn.getRDNs()) {
                    list.add(rdn2);
                }
                subjectDn = new X500Name(list.toArray(new RDN[0]));
            }
            CertTemplateBuilder certTemplateBuilder = new CertTemplateBuilder();
            certTemplateBuilder.setSubject(subjectDn);
            SubjectPublicKeyInfo publicKey = this.getPublicKey();
            if (publicKey != null) {
                certTemplateBuilder.setPublicKey(this.getPublicKey());
            }
            if (StringUtil.isNotBlank((String)this.notBeforeS) || StringUtil.isNotBlank((String)this.notAfterS)) {
                Time notBefore = StringUtil.isNotBlank((String)this.notBeforeS) ? new Time(DateUtil.parseUtcTimeyyyyMMddhhmmss((String)this.notBeforeS)) : null;
                Time notAfter = StringUtil.isNotBlank((String)this.notAfterS) ? new Time(DateUtil.parseUtcTimeyyyyMMddhhmmss((String)this.notAfterS)) : null;
                OptionalValidity validity = new OptionalValidity(notBefore, notAfter);
                certTemplateBuilder.setValidity(validity);
            }
            LinkedList<Extension> extensions = new LinkedList<Extension>();
            if (EnrollAction.isNotEmpty(this.subjectAltNames)) {
                extensions.add(X509Util.createExtnSubjectAltName(this.subjectAltNames, (boolean)false));
            }
            if (EnrollAction.isNotEmpty(this.subjectInfoAccesses)) {
                extensions.add(X509Util.createExtnSubjectInfoAccess(this.subjectInfoAccesses, (boolean)false));
            }
            if (EnrollAction.isNotEmpty(this.keyusages)) {
                HashSet<KeyUsage> usages = new HashSet<KeyUsage>();
                for (String usage : this.keyusages) {
                    usages.add(KeyUsage.getKeyUsage((String)usage));
                }
                org.bouncycastle.asn1.x509.KeyUsage extValue = X509Util.createKeyUsage(usages);
                ASN1ObjectIdentifier extType2 = Extension.keyUsage;
                extensions.add(new Extension(extType2, false, extValue.getEncoded()));
            }
            if (EnrollAction.isNotEmpty(this.extkeyusages)) {
                ExtendedKeyUsage extValue = X509Util.createExtendedUsage(EnrollAction.textToAsn1ObjectIdentifers(this.extkeyusages));
                extType = Extension.extendedKeyUsage;
                extensions.add(new Extension((ASN1ObjectIdentifier)extType, false, extValue.getEncoded()));
            }
            if (EnrollAction.isNotEmpty(this.qcEuLimits)) {
                ASN1EncodableVector vec = new ASN1EncodableVector();
                for (String m : this.qcEuLimits) {
                    StringTokenizer st = new StringTokenizer(m, ":");
                    try {
                        Iso4217CurrencyCode currency;
                        String currencyS = st.nextToken();
                        String amountS = st.nextToken();
                        String exponentS = st.nextToken();
                        try {
                            int intValue = Integer.parseInt(currencyS);
                            currency = new Iso4217CurrencyCode(intValue);
                        }
                        catch (NumberFormatException ex) {
                            currency = new Iso4217CurrencyCode(currencyS);
                        }
                        int amount = Integer.parseInt(amountS);
                        int exponent = Integer.parseInt(exponentS);
                        MonetaryValue monterayValue = new MonetaryValue(currency, amount, exponent);
                        QCStatement statment = new QCStatement(ObjectIdentifiers.Extn.id_etsi_qcs_QcLimitValue, (ASN1Encodable)monterayValue);
                        vec.add((ASN1Encodable)statment);
                    }
                    catch (Exception ex) {
                        throw new Exception("invalid qc-eu-limit '" + m + "'");
                    }
                }
                extType = Extension.qCStatements;
                DERSequence extValue = new DERSequence(vec);
                extensions.add(new Extension((ASN1ObjectIdentifier)extType, false, extValue.getEncoded()));
            }
            if (this.biometricType != null && this.biometricHashAlgo != null && this.biometricFile != null) {
                TypeOfBiometricData objBiometricType = StringUtil.isNumber((String)this.biometricType) ? new TypeOfBiometricData(Integer.parseInt(this.biometricType)) : new TypeOfBiometricData(new ASN1ObjectIdentifier(this.biometricType));
                ASN1ObjectIdentifier objBiometricHashAlgo = AlgorithmUtil.getHashAlg((String)this.biometricHashAlgo);
                byte[] biometricBytes = IoUtil.read((String)this.biometricFile);
                MessageDigest md = MessageDigest.getInstance(objBiometricHashAlgo.getId());
                md.reset();
                byte[] biometricDataHash = md.digest(biometricBytes);
                DERIA5String sourceDataUri = null;
                if (this.biometricUri != null) {
                    sourceDataUri = new DERIA5String(this.biometricUri);
                }
                BiometricData biometricData = new BiometricData(objBiometricType, new AlgorithmIdentifier(objBiometricHashAlgo), (ASN1OctetString)new DEROctetString(biometricDataHash), sourceDataUri);
                ASN1EncodableVector vec = new ASN1EncodableVector();
                vec.add((ASN1Encodable)biometricData);
                ASN1ObjectIdentifier extType3 = Extension.biometricInfo;
                DERSequence extValue = new DERSequence(vec);
                extensions.add(new Extension(extType3, false, extValue.getEncoded()));
            } else if (this.biometricType != null || this.biometricHashAlgo != null || this.biometricFile != null) {
                throw new Exception("either all of biometric triples (type, hash algo, file) must be set or none of them should be set");
            }
            if (this.extraExtensionsFile != null) {
                byte[] bytes = IoUtil.read((String)this.extraExtensionsFile);
                X509ExtensionType.ExtensionsType extraExtensions = (X509ExtensionType.ExtensionsType)JSON.parseObject((byte[])bytes, X509ExtensionType.ExtensionsType.class, (Feature[])new Feature[0]);
                extraExtensions.validate();
                List extnConfs = extraExtensions.getExtensions();
                if (CollectionUtil.isNotEmpty((Collection)extnConfs)) {
                    for (X509ExtensionType m : extnConfs) {
                        String id3 = m.getType().getOid();
                        byte[] encodedExtnValue = m.getConstant().toASN1Encodable().toASN1Primitive().getEncoded("DER");
                        extensions.add(new Extension(new ASN1ObjectIdentifier(id3), false, encodedExtnValue));
                    }
                }
            }
            if (EnrollAction.isNotEmpty(extensions)) {
                Extensions asn1Extensions = new Extensions(extensions.toArray(new Extension[0]));
                certTemplateBuilder.setExtensions(asn1Extensions);
            }
            CertRequest certReq = new CertRequest(1, certTemplateBuilder.build(), null);
            EnrollCertRequest.Entry reqEntry = this.buildEnrollCertRequestEntry("id-1", this.profile, certReq);
            EnrollCertRequest request = new EnrollCertRequest(type);
            request.addRequestEntry(reqEntry);
            ReqRespDebug debug = this.getReqRespDebug();
            try {
                result = this.client.enrollCerts(this.getCaName(), request, debug);
            }
            finally {
                this.saveRequestResponse(debug);
            }
            return result;
        }

        static List<ASN1ObjectIdentifier> textToAsn1ObjectIdentifers(List<String> oidTexts) {
            if (oidTexts == null) {
                return null;
            }
            ArrayList<ASN1ObjectIdentifier> ret = new ArrayList<ASN1ObjectIdentifier>(oidTexts.size());
            for (String oidText : oidTexts) {
                ASN1ObjectIdentifier oid;
                if (oidText.isEmpty() || ret.contains(oid = new ASN1ObjectIdentifier(oidText))) continue;
                ret.add(oid);
            }
            return ret;
        }
    }

    @Command(scope="xi", name="cmp-enroll-p12", description="enroll certificate (PKCS#12 keystore)")
    @Service
    public static class CmpEnrollP12
    extends EnrollCertAction {
        @Option(name="--p12", required=true, description="PKCS#12 keystore file")
        @Completion(value=FileCompleter.class)
        private String p12File;
        @Option(name="--password", description="password of the PKCS#12 keystore file")
        private String password;
        private ConcurrentContentSigner signer;

        @Override
        protected ConcurrentContentSigner getSigner() throws ObjectCreationException, CmpClientException {
            if (this.signer == null) {
                if (this.password == null) {
                    try {
                        this.password = new String(this.readPassword());
                    }
                    catch (IOException ex) {
                        throw new ObjectCreationException("could not read password: " + ex.getMessage(), (Throwable)ex);
                    }
                }
                ConfPairs conf = new ConfPairs("password", this.password);
                conf.putPair("parallelism", Integer.toString(1));
                conf.putPair("keystore", "file:" + this.p12File);
                SignerConf signerConf = new SignerConf(conf.getEncoded(), HashAlgo.getNonNullInstance((String)this.hashAlgo), this.getSignatureAlgoControl());
                String caName = this.getCaName().toLowerCase();
                List peerCerts = this.client.getDhPocPeerCertificates(caName);
                if (CollectionUtil.isNotEmpty((Collection)peerCerts)) {
                    signerConf.setPeerCertificates(peerCerts);
                }
                this.signer = this.securityFactory.createSigner("PKCS12", signerConf, (X509Cert[])null);
            }
            return this.signer;
        }
    }

    @Command(scope="xi", name="cmp-enroll-p11", description="enroll certificate (PKCS#11 token)")
    @Service
    public static class CmpEnrollP11
    extends EnrollCertAction {
        @Option(name="--slot", required=true, description="slot index")
        private Integer slotIndex;
        @Option(name="--key-id", description="id of the private key in the PKCS#11 device\neither keyId or keyLabel must be specified")
        private String keyId;
        @Option(name="--key-label", description="label of the private key in the PKCS#11 device\neither keyId or keyLabel must be specified")
        private String keyLabel;
        @Option(name="--module", description="name of the PKCS#11 module")
        private String moduleName = "default";
        private ConcurrentContentSigner signer;

        @Override
        protected ConcurrentContentSigner getSigner() throws ObjectCreationException {
            if (this.signer == null) {
                byte[] keyIdBytes = null;
                if (this.keyId != null) {
                    keyIdBytes = Hex.decode((String)this.keyId);
                }
                SignerConf signerConf = CmpEnrollP11.getPkcs11SignerConf(this.moduleName, this.slotIndex, this.keyLabel, keyIdBytes, HashAlgo.getInstance((String)this.hashAlgo), this.getSignatureAlgoControl());
                this.signer = this.securityFactory.createSigner("PKCS11", signerConf, (X509Cert[])null);
            }
            return this.signer;
        }

        public static SignerConf getPkcs11SignerConf(String pkcs11ModuleName, Integer slotIndex, String keyLabel, byte[] keyId, HashAlgo hashAlgo, SignatureAlgoControl signatureAlgoControl) {
            Args.notNull((Object)hashAlgo, (String)"hashAlgo");
            Args.notNull((Object)slotIndex, (String)"slotIndex");
            if (keyId == null && keyLabel == null) {
                throw new IllegalArgumentException("at least one of keyId and keyLabel may not be null");
            }
            ConfPairs conf = new ConfPairs();
            conf.putPair("parallelism", Integer.toString(1));
            if (pkcs11ModuleName != null && pkcs11ModuleName.length() > 0) {
                conf.putPair("module", pkcs11ModuleName);
            }
            if (slotIndex != null) {
                conf.putPair("slot", slotIndex.toString());
            }
            if (keyId != null) {
                conf.putPair("key-id", Hex.encode((byte[])keyId));
            }
            if (keyLabel != null) {
                conf.putPair("key-label", keyLabel);
            }
            return new SignerConf(conf.getEncoded(), hashAlgo, signatureAlgoControl);
        }
    }

    @Command(scope="xi", name="cmp-enroll-cagenkey", description="enroll certificate (keypair will be generated by the CA)")
    @Service
    public static class CmpEnrollCagenkey
    extends EnrollAction {
        @Option(name="--cmpreq-type", description="CMP request type (ir for Initialization Request,\nand cr for Certification Request)")
        @Completion(value=StringsCompleter.class, values={"ir", "cr"})
        private String cmpreqType = "cr";
        @Option(name="--cert-outform", description="output format of the certificate")
        @Completion(value=Completers.DerPemCompleter.class)
        private String certOutform = "der";
        @Option(name="--cert-out", description="where to save the certificate")
        @Completion(value=FileCompleter.class)
        private String certOutputFile;
        @Option(name="--p12-out", required=true, description="where to save the PKCS#12 keystore")
        @Completion(value=FileCompleter.class)
        private String p12OutputFile;
        @Option(name="--password", description="password of the PKCS#12 file")
        private String password;

        @Override
        protected SubjectPublicKeyInfo getPublicKey() throws Exception {
            return null;
        }

        @Override
        protected EnrollCertRequest.Entry buildEnrollCertRequestEntry(String id, String profile, CertRequest certRequest) throws Exception {
            boolean caGenKeypair = true;
            boolean kup = false;
            return new EnrollCertRequest.Entry("id-1", profile, certRequest, null, true, false);
        }

        protected Object execute0() throws Exception {
            EnrollCertResult result = this.enroll();
            X509Cert cert = null;
            PrivateKeyInfo privateKeyInfo = null;
            if (result != null) {
                String id = (String)result.getAllIds().iterator().next();
                EnrollCertResult.CertifiedKeyPairOrError certOrError = result.getCertOrError(id);
                cert = certOrError.getCertificate();
                privateKeyInfo = certOrError.getPrivateKeyInfo();
            }
            if (cert == null) {
                throw new CmdFailure("no certificate received from the server");
            }
            if (privateKeyInfo == null) {
                throw new CmdFailure("no private key received from the server");
            }
            if (StringUtil.isNotBlank((String)this.certOutputFile)) {
                this.saveVerbose("saved certificate to file", this.certOutputFile, CmpEnrollCagenkey.encodeCert((byte[])cert.getEncoded(), (String)this.certOutform));
            }
            PrivateKey privateKey = BouncyCastleProvider.getPrivateKey(privateKeyInfo);
            KeyStore ks = KeyStore.getInstance("PKCS12");
            char[] pwd = this.getPassword();
            ks.load(null, pwd);
            ks.setKeyEntry("main", privateKey, pwd, new Certificate[]{cert.toJceCert()});
            ByteArrayOutputStream bout = new ByteArrayOutputStream();
            ks.store(bout, pwd);
            this.saveVerbose("saved key to file", this.p12OutputFile, bout.toByteArray());
            return null;
        }

        @Override
        protected EnrollCertRequest.EnrollType getCmpReqType() throws Exception {
            if ("cr".equalsIgnoreCase(this.cmpreqType)) {
                return EnrollCertRequest.EnrollType.CERT_REQ;
            }
            if ("ir".equalsIgnoreCase(this.cmpreqType)) {
                return EnrollCertRequest.EnrollType.INIT_REQ;
            }
            throw new IllegalCmdParamException("invalid cmpreq-type " + this.cmpreqType);
        }

        private char[] getPassword() throws IOException {
            char[] pwdInChar = this.readPasswordIfNotSet(this.password);
            if (pwdInChar != null) {
                this.password = new String(pwdInChar);
            }
            return pwdInChar;
        }
    }

    @Command(scope="xi", name="cmp-csr-enroll", description="enroll certificate via CSR")
    @Service
    public static class CmpCsrEnroll
    extends Actions.ClientAction {
        @Option(name="--csr", required=true, description="CSR file")
        @Completion(value=FileCompleter.class)
        private String csrFile;
        @Option(name="--profile", aliases={"-p"}, required=true, description="certificate profile")
        private String profile;
        @Option(name="--not-before", description="notBefore, UTC time of format yyyyMMddHHmmss")
        private String notBeforeS;
        @Option(name="--not-after", description="notAfter, UTC time of format yyyyMMddHHmmss")
        private String notAfterS;
        @Option(name="--outform", description="output format of the certificate")
        @Completion(value=Completers.DerPemCompleter.class)
        private String outform = "der";
        @Option(name="--out", aliases={"-o"}, required=true, description="where to save the certificate")
        @Completion(value=FileCompleter.class)
        private String outputFile;
        @Option(name="--ca", description="CA name\n(required if the profile is supported by more than one CA)")
        @Completion(value=CmpClientCompleters.CaNameCompleter.class)
        private String caName;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected Object execute0() throws Exception {
            EnrollCertResult result;
            if (this.caName != null) {
                this.caName = this.caName.toLowerCase();
            }
            CertificationRequest csr = X509Util.parseCsr((File)new File(this.csrFile));
            Date notBefore = StringUtil.isNotBlank((String)this.notBeforeS) ? DateUtil.parseUtcTimeyyyyMMddhhmmss((String)this.notBeforeS) : null;
            Date notAfter = StringUtil.isNotBlank((String)this.notAfterS) ? DateUtil.parseUtcTimeyyyyMMddhhmmss((String)this.notAfterS) : null;
            ReqRespDebug debug = this.getReqRespDebug();
            try {
                result = this.client.enrollCert(this.caName, csr, this.profile, notBefore, notAfter, debug);
            }
            finally {
                this.saveRequestResponse(debug);
            }
            X509Cert cert = null;
            if (result != null) {
                String id = (String)result.getAllIds().iterator().next();
                cert = result.getCertOrError(id).getCertificate();
            }
            if (cert == null) {
                throw new CmdFailure("no certificate received from the server");
            }
            this.saveVerbose("certificate saved to file", this.outputFile, CmpCsrEnroll.encodeCert((byte[])cert.getEncoded(), (String)this.outform));
            return null;
        }
    }
}

