/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.cmpclient.shell;

import java.io.File;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.SignatureException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.util.Arrays;
import java.util.Date;
import org.apache.karaf.shell.api.action.Command;
import org.apache.karaf.shell.api.action.Completion;
import org.apache.karaf.shell.api.action.Option;
import org.apache.karaf.shell.api.action.lifecycle.Service;
import org.apache.karaf.shell.support.completers.FileCompleter;
import org.xipki.cmpclient.CertIdOrError;
import org.xipki.cmpclient.shell.Actions;
import org.xipki.cmpclient.shell.CmpClientCompleters;
import org.xipki.security.CrlReason;
import org.xipki.security.X509Cert;
import org.xipki.security.cmp.PkiStatusInfo;
import org.xipki.security.util.X509Util;
import org.xipki.shell.CmdFailure;
import org.xipki.shell.Completers;
import org.xipki.shell.IllegalCmdParamException;
import org.xipki.util.Args;
import org.xipki.util.DateUtil;
import org.xipki.util.ReqRespDebug;

public class UnRevRemoveCertActions {

    public static abstract class UnRevRemoveCertAction
    extends Actions.ClientAction {
        @Option(name="--ca", description="CA name\n(required if more than one CA is configured)")
        @Completion(value=CmpClientCompleters.CaNameCompleter.class)
        protected String caName;
        @Option(name="--cert", aliases={"-c"}, description="certificate file (either cert or serial must be specified)")
        @Completion(value=FileCompleter.class)
        protected String certFile;
        @Option(name="--serial", aliases={"-s"}, description="serial number (either cert or serial must be specified)")
        private String serialNumberS;
        private BigInteger serialNumber;

        protected BigInteger getSerialNumber() {
            if (this.serialNumber == null && UnRevRemoveCertAction.isNotBlank((String)this.serialNumberS)) {
                this.serialNumber = UnRevRemoveCertAction.toBigInt((String)this.serialNumberS);
            }
            return this.serialNumber;
        }

        protected String checkCertificate(X509Cert cert, X509Cert caCert) throws CertificateEncodingException {
            if (this.caName != null) {
                this.caName = this.caName.toLowerCase();
            }
            Args.notNull((Object)cert, (String)"cert");
            Args.notNull((Object)caCert, (String)"caCert");
            if (!cert.getIssuer().equals((Object)caCert.getSubject())) {
                return "the given certificate is not issued by the given issuer";
            }
            byte[] caSki = caCert.getSubjectKeyId();
            byte[] aki = cert.getAuthorityKeyId();
            if (caSki != null && aki != null && !Arrays.equals(aki, caSki)) {
                return "the given certificate is not issued by the given issuer";
            }
            try {
                cert.verify(caCert.getPublicKey(), "BC");
            }
            catch (SignatureException ex) {
                return "could not verify the signature of given certificate by the issuer";
            }
            catch (InvalidKeyException | NoSuchAlgorithmException | NoSuchProviderException | CertificateException ex) {
                return "could not verify the signature of given certificate by the issuer: " + ex.getMessage();
            }
            return null;
        }
    }

    @Command(scope="xi", name="cmp-unrevoke", description="unrevoke certificate")
    @Service
    public static class CmpUnrevoke
    extends UnRevRemoveCertAction {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected Object execute0() throws Exception {
            CertIdOrError certIdOrError;
            if (!(this.certFile == null ^ this.getSerialNumber() == null)) {
                throw new IllegalCmdParamException("exactly one of cert and serial must be specified");
            }
            ReqRespDebug debug = this.getReqRespDebug();
            try {
                if (this.certFile != null) {
                    X509Cert cert = X509Util.parseCert((File)new File(this.certFile));
                    certIdOrError = this.client.unrevokeCert(this.caName, cert, debug);
                } else {
                    certIdOrError = this.client.unrevokeCert(this.caName, this.getSerialNumber(), debug);
                }
            }
            finally {
                this.saveRequestResponse(debug);
            }
            if (certIdOrError.getError() != null) {
                PkiStatusInfo error = certIdOrError.getError();
                throw new CmdFailure("releasing revocation failed: " + error);
            }
            this.println("unrevoked certificate");
            return null;
        }
    }

    @Command(scope="xi", name="cmp-rm-cert", description="remove certificate")
    @Service
    public static class CmpRmCert
    extends UnRevRemoveCertAction {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected Object execute0() throws Exception {
            CertIdOrError certIdOrError;
            if (!(this.certFile == null ^ this.getSerialNumber() == null)) {
                throw new IllegalCmdParamException("exactly one of cert and serial must be specified");
            }
            ReqRespDebug debug = this.getReqRespDebug();
            try {
                if (this.certFile != null) {
                    X509Cert cert = X509Util.parseCert((File)new File(this.certFile));
                    certIdOrError = this.client.removeCert(this.caName, cert, debug);
                } else {
                    certIdOrError = this.client.removeCert(this.caName, this.getSerialNumber(), debug);
                }
            }
            finally {
                this.saveRequestResponse(debug);
            }
            if (certIdOrError.getError() != null) {
                PkiStatusInfo error = certIdOrError.getError();
                throw new CmdFailure("removing certificate failed: " + error);
            }
            this.println("removed certificate");
            return null;
        }
    }

    @Command(scope="xi", name="cmp-revoke", description="revoke certificate")
    @Service
    public static class CmpRevoke
    extends UnRevRemoveCertAction {
        @Option(name="--reason", aliases={"-r"}, required=true, description="CRL reason")
        @Completion(value=Completers.ClientCrlReasonCompleter.class)
        private String reason;
        @Option(name="--inv-date", description="invalidity date, UTC time of format yyyyMMddHHmmss")
        private String invalidityDateS;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected Object execute0() throws Exception {
            CertIdOrError certIdOrError;
            if (!(this.certFile == null ^ this.getSerialNumber() == null)) {
                throw new IllegalCmdParamException("exactly one of cert and serial must be specified");
            }
            CrlReason crlReason = CrlReason.forNameOrText((String)this.reason);
            if (!CrlReason.PERMITTED_CLIENT_CRLREASONS.contains(crlReason)) {
                throw new IllegalCmdParamException("reason " + this.reason + " is not permitted");
            }
            Date invalidityDate = null;
            if (CmpRevoke.isNotBlank((String)this.invalidityDateS)) {
                invalidityDate = DateUtil.parseUtcTimeyyyyMMddhhmmss((String)this.invalidityDateS);
            }
            ReqRespDebug debug = this.getReqRespDebug();
            try {
                if (this.certFile != null) {
                    X509Cert cert = X509Util.parseCert((File)new File(this.certFile));
                    certIdOrError = this.client.revokeCert(this.caName, cert, crlReason.getCode(), invalidityDate, debug);
                } else {
                    certIdOrError = this.client.revokeCert(this.caName, this.getSerialNumber(), crlReason.getCode(), invalidityDate, debug);
                }
            }
            finally {
                this.saveRequestResponse(debug);
            }
            if (certIdOrError.getError() != null) {
                PkiStatusInfo error = certIdOrError.getError();
                throw new CmdFailure("revocation failed: " + error);
            }
            this.println("revoked certificate");
            return null;
        }
    }
}

