/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.dbtool.shell;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import org.apache.karaf.shell.api.action.Command;
import org.apache.karaf.shell.api.action.Completion;
import org.apache.karaf.shell.api.action.Option;
import org.apache.karaf.shell.api.action.lifecycle.Reference;
import org.apache.karaf.shell.api.action.lifecycle.Service;
import org.apache.karaf.shell.support.completers.FileCompleter;
import org.xipki.dbtool.InitDbMain;
import org.xipki.dbtool.LiquibaseMain;
import org.xipki.password.PasswordResolver;
import org.xipki.password.PasswordResolverException;
import org.xipki.shell.XiAction;
import org.xipki.util.IoUtil;
import org.xipki.util.StringUtil;

public class Actions {

    public static abstract class LiquibaseAction
    extends XiAction {
        private static final List<String> YES_NO = Arrays.asList("yes", "no");
        @Reference
        private PasswordResolver passwordResolver;
        @Option(name="--force", aliases={"-f"}, description="never prompt for confirmation")
        protected Boolean force = Boolean.FALSE;
        @Option(name="--db-schema", required=true, description="DB schema file")
        @Completion(value=FileCompleter.class)
        protected String dbSchemaFile;
        @Option(name="--db-conf", required=true, description="DB configuration file")
        @Completion(value=FileCompleter.class)
        private String dbConfFile;

        static void printDatabaseInfo(LiquibaseMain.DatabaseConf dbParams, String schemaFile) {
            String msg = StringUtil.concat((String)"\n--------------------------------------------", (String[])new String[]{"\n     driver: ", dbParams.getDriver(), "\n       user: ", dbParams.getUsername(), "\n        URL: ", dbParams.getUrl(), dbParams.getSchema() != null ? "     schema: " + dbParams.getSchema() : "", "\nschema file: ", schemaFile, "\n"});
            System.out.println(msg);
        }

        protected LiquibaseMain.DatabaseConf getDatabaseConf() throws IOException, PasswordResolverException {
            Properties props = new Properties();
            props.load(Files.newInputStream(Paths.get(IoUtil.expandFilepath((String)this.dbConfFile), new String[0]), new OpenOption[0]));
            return LiquibaseMain.DatabaseConf.getInstance((Properties)props, (PasswordResolver)this.passwordResolver);
        }

        protected static Properties getPropertiesFromFile(String propFile) throws IOException {
            Properties props = new Properties();
            props.load(Files.newInputStream(Paths.get(IoUtil.expandFilepath((String)propFile), new String[0]), new OpenOption[0]));
            return props;
        }

        protected boolean confirm(String command) throws IOException {
            String text = this.read("\nDo you wish to " + command + " the database", YES_NO);
            return "yes".equalsIgnoreCase(text);
        }

        private String read(String prompt, List<String> validValues) throws IOException {
            List<String> tmpValidValues = validValues;
            if (tmpValidValues == null) {
                tmpValidValues = Collections.emptyList();
            }
            if (prompt == null) {
                prompt = "Please enter";
            }
            if (LiquibaseAction.isNotEmpty(tmpValidValues)) {
                StringBuilder promptBuilder = new StringBuilder(prompt);
                promptBuilder.append(" [");
                for (String validValue : tmpValidValues) {
                    promptBuilder.append(validValue).append("/");
                }
                promptBuilder.deleteCharAt(promptBuilder.length() - 1);
                promptBuilder.append("] ?");
                prompt = promptBuilder.toString();
            }
            while (true) {
                String answer = this.readPrompt(prompt);
                if (LiquibaseAction.isEmpty(tmpValidValues) || tmpValidValues.contains(answer)) {
                    return answer;
                }
                StringBuilder retryPromptBuilder = new StringBuilder("Please answer with ");
                for (String validValue : tmpValidValues) {
                    retryPromptBuilder.append(validValue).append("/");
                }
                retryPromptBuilder.deleteCharAt(retryPromptBuilder.length() - 1);
                prompt = retryPromptBuilder.toString();
            }
        }
    }

    @Command(scope="xi", name="initdb", description="reset and initialize single database")
    @Service
    public static class Initdb
    extends LiquibaseAction {
        protected Object execute0() throws Exception {
            LiquibaseMain.DatabaseConf dbConf = this.getDatabaseConf();
            Initdb.printDatabaseInfo(dbConf, this.dbSchemaFile);
            if (!this.force.booleanValue() && !this.confirm("reset and initialize")) {
                this.println("cancelled");
                return null;
            }
            InitDbMain.initDb((LiquibaseMain.DatabaseConf)dbConf, (String)this.dbSchemaFile);
            return null;
        }
    }
}

