/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.ocsp.client.shell;

import java.io.File;
import java.math.BigInteger;
import java.net.URL;
import java.security.MessageDigest;
import java.security.PublicKey;
import java.security.SignatureException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.apache.karaf.shell.api.action.Command;
import org.apache.karaf.shell.api.action.Completion;
import org.apache.karaf.shell.api.action.Option;
import org.apache.karaf.shell.api.action.lifecycle.Reference;
import org.apache.karaf.shell.api.action.lifecycle.Service;
import org.apache.karaf.shell.support.completers.FileCompleter;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1GeneralizedTime;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1String;
import org.bouncycastle.asn1.isismtt.ISISMTTObjectIdentifiers;
import org.bouncycastle.asn1.isismtt.ocsp.CertHash;
import org.bouncycastle.asn1.ocsp.OCSPObjectIdentifiers;
import org.bouncycastle.asn1.ocsp.ResponderID;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x509.AccessDescription;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.AuthorityInformationAccess;
import org.bouncycastle.asn1.x509.Certificate;
import org.bouncycastle.asn1.x509.Extension;
import org.bouncycastle.asn1.x509.GeneralName;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.asn1.x509.X509ObjectIdentifiers;
import org.bouncycastle.cert.AttributeCertificateIssuer;
import org.bouncycastle.cert.X509AttributeCertificateHolder;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cert.ocsp.BasicOCSPResp;
import org.bouncycastle.cert.ocsp.CertificateID;
import org.bouncycastle.cert.ocsp.CertificateStatus;
import org.bouncycastle.cert.ocsp.OCSPException;
import org.bouncycastle.cert.ocsp.OCSPResp;
import org.bouncycastle.cert.ocsp.RevokedStatus;
import org.bouncycastle.cert.ocsp.SingleResp;
import org.bouncycastle.cert.ocsp.UnknownStatus;
import org.bouncycastle.operator.ContentVerifierProvider;
import org.xipki.ocsp.client.OcspRequestor;
import org.xipki.ocsp.client.OcspResponseException;
import org.xipki.ocsp.client.RequestOptions;
import org.xipki.security.CrlReason;
import org.xipki.security.HashAlgo;
import org.xipki.security.IssuerHash;
import org.xipki.security.ObjectIdentifiers;
import org.xipki.security.SecurityFactory;
import org.xipki.security.util.AlgorithmUtil;
import org.xipki.security.util.KeyUtil;
import org.xipki.security.util.X509Util;
import org.xipki.shell.CmdFailure;
import org.xipki.shell.Completers;
import org.xipki.shell.IllegalCmdParamException;
import org.xipki.shell.XiAction;
import org.xipki.util.Args;
import org.xipki.util.CollectionUtil;
import org.xipki.util.Hex;
import org.xipki.util.IoUtil;
import org.xipki.util.LogUtil;
import org.xipki.util.ReqRespDebug;
import org.xipki.util.StringUtil;

public class Actions {

    @Command(scope="xi", name="ocsp-status", description="request certificate status")
    @Service
    public static class OcspStatus
    extends BaseOcspStatusAction {
        @Reference
        private SecurityFactory securityFactory;

        @Override
        protected void checkParameters(X509Certificate respIssuer, List<BigInteger> serialNumbers, Map<BigInteger, byte[]> encodedCerts) throws Exception {
            Args.notEmpty(serialNumbers, (String)"serialNunmbers");
        }

        @Override
        protected Object processResponse(OCSPResp response, X509Certificate respIssuer, IssuerHash issuerHash, List<BigInteger> serialNumbers, Map<BigInteger, byte[]> encodedCerts) throws Exception {
            int i;
            BasicOCSPResp basicResp;
            Args.notNull((Object)response, (String)"response");
            Args.notNull((Object)issuerHash, (String)"issuerHash");
            Args.notNull(serialNumbers, (String)"serialNumbers");
            int statusCode = response.getStatus();
            if (statusCode != 0) {
                throw new OcspResponseException.Unsuccessful(statusCode);
            }
            try {
                basicResp = (BasicOCSPResp)response.getResponseObject();
            }
            catch (OCSPException ex) {
                throw new OcspResponseException.InvalidResponse(ex.getMessage(), (Throwable)ex);
            }
            boolean extendedRevoke = basicResp.getExtension(ObjectIdentifiers.Extn.id_pkix_ocsp_extendedRevoke) != null;
            SingleResp[] singleResponses = basicResp.getResponses();
            if (singleResponses == null || singleResponses.length == 0) {
                throw new CmdFailure("received no status from server");
            }
            int n = singleResponses.length;
            if (n != serialNumbers.size()) {
                throw new CmdFailure("received status with " + n + " single responses from server, but " + serialNumbers.size() + " were requested");
            }
            Date[] thisUpdates = new Date[n];
            for (i = 0; i < n; ++i) {
                thisUpdates[i] = singleResponses[i].getThisUpdate();
            }
            if (null == basicResp.getSignature()) {
                this.println("response is not signed");
            } else {
                X509CertificateHolder[] responderCerts = basicResp.getCerts();
                if (responderCerts == null || responderCerts.length < 1) {
                    throw new CmdFailure("no responder certificate is contained in the response");
                }
                ResponderID respId = basicResp.getResponderId().toASN1Primitive();
                X500Name respIdByName = respId.getName();
                byte[] respIdByKey = respId.getKeyHash();
                X509CertificateHolder respSigner = null;
                for (X509CertificateHolder cert : responderCerts) {
                    if (respIdByName != null) {
                        if (cert.getSubject().equals((Object)respIdByName)) {
                            respSigner = cert;
                        }
                    } else {
                        byte[] spkiSha1 = HashAlgo.SHA1.hash((byte[][])new byte[][]{cert.getSubjectPublicKeyInfo().getPublicKeyData().getBytes()});
                        if (Arrays.equals(respIdByKey, spkiSha1)) {
                            respSigner = cert;
                        }
                    }
                    if (respSigner != null) break;
                }
                if (respSigner == null) {
                    throw new CmdFailure("no responder certificate match the ResponderId");
                }
                boolean validOn = true;
                for (Date thisUpdate : thisUpdates) {
                    validOn = respSigner.isValidOn(thisUpdate);
                    if (validOn) continue;
                    throw new CmdFailure("responder certificate is not valid on " + thisUpdate);
                }
                if (validOn) {
                    PublicKey responderPubKey = KeyUtil.generatePublicKey((SubjectPublicKeyInfo)respSigner.getSubjectPublicKeyInfo());
                    ContentVerifierProvider cvp = this.securityFactory.getContentVerifierProvider(responderPubKey);
                    boolean sigValid = basicResp.isSignatureValid(cvp);
                    if (!sigValid) {
                        throw new CmdFailure("response is equipped with invalid signature");
                    }
                    if (respIssuer != null) {
                        boolean certValid = true;
                        X509Certificate jceRespSigner = X509Util.toX509Cert((Certificate)respSigner.toASN1Structure());
                        if (X509Util.issues((X509Certificate)respIssuer, (X509Certificate)jceRespSigner)) {
                            try {
                                jceRespSigner.verify(respIssuer.getPublicKey());
                            }
                            catch (SignatureException ex) {
                                certValid = false;
                            }
                        }
                        if (!certValid) {
                            throw new CmdFailure("response is equipped with valid signature but the OCSP signer is not trusted");
                        }
                    } else {
                        this.println("response is equipped with valid signature");
                    }
                }
                if (this.verbose.booleanValue()) {
                    this.println("responder is " + X509Util.getRfc4519Name((X500Name)responderCerts[0].getSubject()));
                }
            }
            this.println("produced at " + basicResp.getProducedAt());
            for (i = 0; i < n; ++i) {
                String status;
                SingleResp singleResp;
                CertificateStatus singleCertStatus;
                if (n > 1) {
                    this.println("---------------------------- " + i + "----------------------------");
                }
                if ((singleCertStatus = (singleResp = singleResponses[i]).getCertStatus()) == null) {
                    status = "good";
                } else if (singleCertStatus instanceof RevokedStatus) {
                    RevokedStatus revStatus = (RevokedStatus)singleCertStatus;
                    Date revTime = revStatus.getRevocationTime();
                    Date invTime = null;
                    Extension ext = singleResp.getExtension(Extension.invalidityDate);
                    if (ext != null) {
                        invTime = ASN1GeneralizedTime.getInstance((Object)ext.getParsedValue()).getDate();
                    }
                    if (revStatus.hasRevocationReason()) {
                        int reason = revStatus.getRevocationReason();
                        status = extendedRevoke && reason == CrlReason.CERTIFICATE_HOLD.getCode() && revTime.getTime() == 0L ? "unknown (RFC6960)" : StringUtil.concatObjects((Object)"revoked, reason = ", (Object[])new Object[]{CrlReason.forReasonCode((int)reason).getDescription(), ", revocationTime = ", revTime, invTime == null ? "" : ", invalidityTime = " + invTime});
                    } else {
                        status = "revoked, no reason, revocationTime = " + revTime;
                    }
                } else {
                    status = singleCertStatus instanceof UnknownStatus ? "unknown (RFC2560)" : "ERROR";
                }
                StringBuilder msg = new StringBuilder();
                CertificateID certId = singleResp.getCertID();
                HashAlgo hashAlgo = HashAlgo.getNonNullInstance((ASN1ObjectIdentifier)certId.getHashAlgOID());
                boolean issuerMatch = issuerHash.match(hashAlgo, certId.getIssuerNameHash(), certId.getIssuerKeyHash());
                BigInteger serialNumber = certId.getSerialNumber();
                msg.append("issuer matched: ").append(issuerMatch);
                msg.append("\nserialNumber: ").append(LogUtil.formatCsn((BigInteger)serialNumber));
                msg.append("\nCertificate status: ").append(status);
                if (this.verbose.booleanValue()) {
                    AlgorithmIdentifier sigAlg;
                    ASN1Encodable extensionValue;
                    msg.append("\nthisUpdate: ").append(singleResp.getThisUpdate());
                    msg.append("\nnextUpdate: ").append(singleResp.getNextUpdate());
                    Extension extension = singleResp.getExtension(ISISMTTObjectIdentifiers.id_isismtt_at_certHash);
                    if (extension != null) {
                        msg.append("\nCertHash is provided:\n");
                        extensionValue = extension.getParsedValue();
                        CertHash certHash = CertHash.getInstance((Object)extensionValue);
                        ASN1ObjectIdentifier hashAlgOid = certHash.getHashAlgorithm().getAlgorithm();
                        byte[] hashValue = certHash.getCertificateHash();
                        msg.append("\tHash algo : ").append(hashAlgOid.getId()).append("\n");
                        msg.append("\tHash value: ").append(Hex.encode((byte[])hashValue)).append("\n");
                        if (encodedCerts != null) {
                            byte[] encodedCert = encodedCerts.get(serialNumber);
                            MessageDigest md = MessageDigest.getInstance(hashAlgOid.getId());
                            byte[] expectedHashValue = md.digest(encodedCert);
                            if (Arrays.equals(expectedHashValue, hashValue)) {
                                msg.append("\tThis matches the requested certificate");
                            } else {
                                msg.append("\tThis differs from the requested certificate");
                            }
                        }
                    }
                    if ((extension = singleResp.getExtension(OCSPObjectIdentifiers.id_pkix_ocsp_archive_cutoff)) != null) {
                        extensionValue = extension.getParsedValue();
                        ASN1GeneralizedTime time = ASN1GeneralizedTime.getInstance((Object)extensionValue);
                        msg.append("\nArchive-CutOff: ");
                        msg.append(time.getTimeString());
                    }
                    if ((sigAlg = basicResp.getSignatureAlgorithmID()) == null) {
                        msg.append("\nresponse is not signed");
                    } else {
                        String sigAlgName = AlgorithmUtil.getSignatureAlgoName((AlgorithmIdentifier)sigAlg);
                        if (sigAlgName == null) {
                            sigAlgName = "unknown";
                        }
                        msg.append("\nresponse is signed with ").append(sigAlgName);
                    }
                    msg.append("\nExtensions: ");
                    List extensionOids = basicResp.getExtensionOIDs();
                    if (extensionOids == null || extensionOids.size() == 0) {
                        msg.append("-");
                    } else {
                        int size = extensionOids.size();
                        for (int j = 0; j < size; ++j) {
                            ASN1ObjectIdentifier extensionOid = (ASN1ObjectIdentifier)extensionOids.get(j);
                            String name = (String)EXTENSION_OIDNAME_MAP.get(extensionOid);
                            if (name == null) {
                                msg.append(extensionOid.getId());
                            } else {
                                msg.append(name);
                            }
                            if (j == size - 1) continue;
                            msg.append(", ");
                        }
                    }
                }
                this.println(msg.toString());
            }
            this.println("");
            return null;
        }
    }

    public static abstract class CommonOcspStatusAction
    extends XiAction {
        @Option(name="--issuer", aliases={"-i"}, required=true, description="issuer certificate file")
        @Completion(value=FileCompleter.class)
        protected String issuerCertFile;
        @Option(name="--nonce", description="use nonce")
        protected Boolean usenonce = Boolean.FALSE;
        @Option(name="--nonce-len", description="nonce length in octects")
        protected Integer nonceLen;
        @Option(name="--hash", description="hash algorithm name")
        @Completion(value=Completers.HashAlgCompleter.class)
        protected String hashAlgo = "SHA256";
        @Option(name="--sig-alg", multiValued=true, description="comma-separated preferred signature algorithms")
        @Completion(value=Completers.SigAlgCompleter.class)
        protected List<String> prefSigAlgs;
        @Option(name="--http-get", description="use HTTP GET for small request")
        protected Boolean useHttpGetForSmallRequest = Boolean.FALSE;
        @Option(name="--sign", description="sign request")
        protected Boolean signRequest = Boolean.FALSE;

        protected RequestOptions getRequestOptions() throws Exception {
            ASN1ObjectIdentifier hashAlgOid = AlgorithmUtil.getHashAlg((String)this.hashAlgo);
            RequestOptions options = new RequestOptions();
            options.setUseNonce(this.usenonce.booleanValue());
            if (this.nonceLen != null) {
                options.setNonceLen(this.nonceLen.intValue());
            }
            options.setHashAlgorithmId(hashAlgOid);
            options.setSignRequest(this.signRequest.booleanValue());
            options.setUseHttpGetForRequest(this.useHttpGetForSmallRequest.booleanValue());
            if (CommonOcspStatusAction.isNotEmpty(this.prefSigAlgs)) {
                options.setPreferredSignatureAlgorithms(this.prefSigAlgs.toArray(new String[0]));
            }
            return options;
        }
    }

    public static abstract class BaseOcspStatusAction
    extends CommonOcspStatusAction {
        protected static final Map<ASN1ObjectIdentifier, String> EXTENSION_OIDNAME_MAP = new HashMap<ASN1ObjectIdentifier, String>();
        @Option(name="--verbose", aliases={"-v"}, description="show status verbosely")
        protected Boolean verbose = Boolean.FALSE;
        @Option(name="--resp-issuer", description="certificate file of the responder's issuer")
        @Completion(value=FileCompleter.class)
        private String respIssuerFile;
        @Option(name="--url", description="OCSP responder URL")
        private String serverUrl;
        @Option(name="--req-out", description="where to save the request")
        @Completion(value=FileCompleter.class)
        private String reqout;
        @Option(name="--resp-out", description="where to save the response")
        @Completion(value=FileCompleter.class)
        private String respout;
        @Option(name="--hex", description="serial number without prefix is hex number")
        private Boolean hex = Boolean.FALSE;
        @Option(name="--serial", aliases={"-s"}, description="comma-separated serial numbers or ranges (like 1,3,6-10)\n(at least one of serial and cert must be specified)")
        private String serialNumberList;
        @Option(name="--cert", aliases={"-c"}, multiValued=true, description="certificate files")
        @Completion(value=FileCompleter.class)
        private List<String> certFiles;
        @Option(name="--ac", description="the certificates are attribute certificates")
        @Completion(value=FileCompleter.class)
        private Boolean isAttrCert = Boolean.FALSE;
        @Reference
        private OcspRequestor requestor;

        protected abstract void checkParameters(X509Certificate var1, List<BigInteger> var2, Map<BigInteger, byte[]> var3) throws Exception;

        protected abstract Object processResponse(OCSPResp var1, X509Certificate var2, IssuerHash var3, List<BigInteger> var4, Map<BigInteger, byte[]> var5) throws Exception;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected final Object execute0() throws Exception {
            OCSPResp response;
            if (StringUtil.isBlank((String)this.serialNumberList) && BaseOcspStatusAction.isEmpty(this.certFiles)) {
                throw new IllegalCmdParamException("Neither serialNumbers nor certFiles is set");
            }
            X509Certificate issuerCert = X509Util.parseCert((File)new File(this.issuerCertFile));
            HashMap<BigInteger, byte[]> encodedCerts = null;
            LinkedList<BigInteger> sns = new LinkedList<BigInteger>();
            if (BaseOcspStatusAction.isNotEmpty(this.certFiles)) {
                encodedCerts = new HashMap<BigInteger, byte[]>(this.certFiles.size());
                String ocspUrl = null;
                X500Name issuerX500Name = null;
                for (String certFile : this.certFiles) {
                    BigInteger sn;
                    List<String> ocspUrls;
                    X509Certificate cert;
                    if (this.isAttrCert.booleanValue()) {
                        X500Name reqIssuerName;
                        AttributeCertificateIssuer reqIssuer;
                        if (issuerX500Name == null) {
                            issuerX500Name = X500Name.getInstance((Object)issuerCert.getSubjectX500Principal().getEncoded());
                        }
                        if ((reqIssuer = (cert = new X509AttributeCertificateHolder(IoUtil.read((String)certFile))).getIssuer()) != null && issuerX500Name != null && !issuerX500Name.equals((Object)(reqIssuerName = reqIssuer.getNames()[0]))) {
                            throw new IllegalCmdParamException("certificate " + certFile + " is not issued by the given issuer");
                        }
                        ocspUrls = BaseOcspStatusAction.extractOcspUrls((X509AttributeCertificateHolder)cert);
                        sn = cert.getSerialNumber();
                    } else {
                        cert = X509Util.parseCert((File)new File(certFile));
                        if (!X509Util.issues((X509Certificate)issuerCert, (X509Certificate)cert)) {
                            throw new IllegalCmdParamException("certificate " + certFile + " is not issued by the given issuer");
                        }
                        ocspUrls = BaseOcspStatusAction.extractOcspUrls(cert);
                        sn = cert.getSerialNumber();
                    }
                    if (BaseOcspStatusAction.isBlank((String)this.serverUrl)) {
                        if (CollectionUtil.isEmpty(ocspUrls)) {
                            throw new IllegalCmdParamException("could not extract OCSP responder URL");
                        }
                        String url = ocspUrls.get(0);
                        if (ocspUrl != null && !ocspUrl.equals(url)) {
                            throw new IllegalCmdParamException("given certificates have different OCSP responder URL in certificate");
                        }
                        ocspUrl = url;
                    }
                    sns.add(sn);
                    byte[] encodedCert = IoUtil.read((String)certFile);
                    encodedCerts.put(sn, encodedCert);
                }
                if (BaseOcspStatusAction.isBlank((String)this.serverUrl)) {
                    this.serverUrl = ocspUrl;
                }
            } else {
                StringTokenizer st = new StringTokenizer(this.serialNumberList, ", ");
                while (st.hasMoreTokens()) {
                    BigInteger to;
                    String token = st.nextToken();
                    StringTokenizer st2 = new StringTokenizer(token, "-");
                    BigInteger from = BaseOcspStatusAction.toBigInt((String)st2.nextToken(), (boolean)this.hex);
                    BigInteger bigInteger = to = st2.hasMoreTokens() ? BaseOcspStatusAction.toBigInt((String)st2.nextToken(), (boolean)this.hex) : null;
                    if (to == null) {
                        sns.add(from);
                        continue;
                    }
                    BigIntegerRange range = new BigIntegerRange(from, to);
                    if (range.diff.compareTo(BigInteger.valueOf(10L)) > 0) {
                        throw new IllegalCmdParamException("to many serial numbers");
                    }
                    BigInteger sn = range.from;
                    while (range.isInRange(sn)) {
                        sns.add(sn);
                        sn = sn.add(BigInteger.ONE);
                    }
                }
            }
            if (BaseOcspStatusAction.isBlank((String)this.serverUrl)) {
                throw new IllegalCmdParamException("could not get URL for the OCSP responder");
            }
            X509Certificate respIssuer = null;
            if (this.respIssuerFile != null) {
                respIssuer = X509Util.parseCert((File)new File(this.respIssuerFile));
            }
            URL serverUrlObj = new URL(this.serverUrl);
            RequestOptions options = this.getRequestOptions();
            this.checkParameters(respIssuer, sns, encodedCerts);
            boolean saveReq = BaseOcspStatusAction.isNotBlank((String)this.reqout);
            boolean saveResp = BaseOcspStatusAction.isNotBlank((String)this.respout);
            ReqRespDebug debug = null;
            if (saveReq || saveResp) {
                debug = new ReqRespDebug(saveReq, saveResp);
            }
            IssuerHash issuerHash = new IssuerHash(HashAlgo.getNonNullInstance((ASN1ObjectIdentifier)options.getHashAlgorithmId()), Certificate.getInstance((Object)issuerCert.getEncoded()));
            try {
                response = this.requestor.ask(issuerCert, sns.toArray(new BigInteger[0]), serverUrlObj, options, debug);
            }
            finally {
                if (debug != null && debug.size() > 0) {
                    byte[] bytes;
                    ReqRespDebug.ReqRespPair reqResp = debug.get(0);
                    if (saveReq && (bytes = reqResp.getRequest()) != null) {
                        IoUtil.save((String)this.reqout, (byte[])bytes);
                    }
                    if (saveResp && (bytes = reqResp.getResponse()) != null) {
                        IoUtil.save((String)this.respout, (byte[])bytes);
                    }
                }
            }
            return this.processResponse(response, respIssuer, issuerHash, sns, encodedCerts);
        }

        public static List<String> extractOcspUrls(X509Certificate cert) throws CertificateEncodingException {
            byte[] extnValue = X509Util.getCoreExtValue((X509Certificate)cert, (ASN1ObjectIdentifier)Extension.authorityInfoAccess);
            if (extnValue == null) {
                return Collections.emptyList();
            }
            AuthorityInformationAccess aia = AuthorityInformationAccess.getInstance((Object)extnValue);
            return BaseOcspStatusAction.extractOcspUrls(aia);
        }

        public static List<String> extractOcspUrls(X509AttributeCertificateHolder cert) throws CertificateEncodingException {
            byte[] extValue = X509Util.getCoreExtValue((X509AttributeCertificateHolder)cert, (ASN1ObjectIdentifier)Extension.authorityInfoAccess);
            if (extValue == null) {
                return Collections.emptyList();
            }
            AuthorityInformationAccess aia = AuthorityInformationAccess.getInstance((Object)extValue);
            return BaseOcspStatusAction.extractOcspUrls(aia);
        }

        public static List<String> extractOcspUrls(AuthorityInformationAccess aia) throws CertificateEncodingException {
            AccessDescription[] accessDescriptions = aia.getAccessDescriptions();
            LinkedList<AccessDescription> ocspAccessDescriptions = new LinkedList<AccessDescription>();
            for (AccessDescription accessDescription : accessDescriptions) {
                if (!accessDescription.getAccessMethod().equals((Object)X509ObjectIdentifiers.id_ad_ocsp)) continue;
                ocspAccessDescriptions.add(accessDescription);
            }
            int n = ocspAccessDescriptions.size();
            ArrayList<String> ocspUris = new ArrayList<String>(n);
            for (int i = 0; i < n; ++i) {
                GeneralName accessLocation = ((AccessDescription)ocspAccessDescriptions.get(i)).getAccessLocation();
                if (accessLocation.getTagNo() != 6) continue;
                String ocspUri = ((ASN1String)accessLocation.getName()).getString();
                ocspUris.add(ocspUri);
            }
            return ocspUris;
        }

        static {
            EXTENSION_OIDNAME_MAP.put(OCSPObjectIdentifiers.id_pkix_ocsp_archive_cutoff, "ArchiveCutoff");
            EXTENSION_OIDNAME_MAP.put(OCSPObjectIdentifiers.id_pkix_ocsp_crl, "CrlID");
            EXTENSION_OIDNAME_MAP.put(OCSPObjectIdentifiers.id_pkix_ocsp_nonce, "Nonce");
            EXTENSION_OIDNAME_MAP.put(ObjectIdentifiers.Extn.id_pkix_ocsp_extendedRevoke, "ExtendedRevoke");
        }

        private static class BigIntegerRange {
            private final BigInteger from;
            private final BigInteger to;
            private final BigInteger diff;

            BigIntegerRange(BigInteger from, BigInteger to) {
                if (from.compareTo(to) > 0) {
                    throw new IllegalArgumentException("from (" + from + ") may not be larger than to (" + to + ")");
                }
                this.from = from;
                this.to = to;
                this.diff = to.subtract(from);
            }

            boolean isInRange(BigInteger num) {
                return num.compareTo(this.from) >= 0 && num.compareTo(this.to) <= 0;
            }
        }
    }
}

