/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.ocsp.mgmt.shell;

import org.apache.karaf.shell.api.action.Command;
import org.apache.karaf.shell.api.action.Completion;
import org.apache.karaf.shell.api.action.Option;
import org.apache.karaf.shell.api.action.lifecycle.Reference;
import org.apache.karaf.shell.api.action.lifecycle.Service;
import org.xipki.ocsp.api.mgmt.OcspManager;
import org.xipki.ocsp.api.mgmt.OcspMgmtException;
import org.xipki.shell.CmdFailure;
import org.xipki.shell.Completers;
import org.xipki.shell.XiAction;

public class Actions {

    @Command(scope="ocsp", name="refresh-token", description="refresh token for signers")
    @Service
    public static class RefreshTokenAction
    extends OcspAction {
        @Option(name="--type", required=true, description="type of the signer")
        @Completion(value=Completers.SignerTypeCompleter.class)
        protected String type;

        protected Object execute0() throws Exception {
            this.ocspManager.refreshTokenForSignerType(this.type);
            this.println("refreshed token for signer type " + this.type);
            return null;
        }
    }

    @Command(scope="ocsp", name="restart-server", description="restart OCSP server")
    @Service
    public static class OcspSystemRestartAction
    extends OcspAction {
        protected Object execute0() throws Exception {
            try {
                this.ocspManager.restartOcspServer();
            }
            catch (OcspMgmtException ex) {
                throw new CmdFailure("could not restart OCSP server, error: " + ex.getMessage(), (Throwable)ex);
            }
            StringBuilder sb = new StringBuilder("restarted OCSP server\n");
            this.print(sb.toString());
            return null;
        }
    }

    public static abstract class OcspAction
    extends XiAction {
        @Reference
        protected OcspManager ocspManager;
    }
}

