/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.qa.shell;

import java.io.File;
import java.rmi.UnexpectedException;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.apache.karaf.shell.api.action.Command;
import org.apache.karaf.shell.api.action.Completion;
import org.apache.karaf.shell.api.action.Option;
import org.apache.karaf.shell.api.action.lifecycle.Reference;
import org.apache.karaf.shell.api.action.lifecycle.Service;
import org.apache.karaf.shell.support.completers.FileCompleter;
import org.apache.karaf.shell.support.completers.StringsCompleter;
import org.bouncycastle.asn1.ASN1Set;
import org.bouncycastle.asn1.pkcs.Attribute;
import org.bouncycastle.asn1.pkcs.CertificationRequest;
import org.bouncycastle.asn1.pkcs.CertificationRequestInfo;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.asn1.x509.Extensions;
import org.xipki.ca.api.CaUris;
import org.xipki.ca.api.mgmt.CmpControl;
import org.xipki.ca.api.mgmt.MgmtEntry;
import org.xipki.ca.mgmt.shell.CaActions;
import org.xipki.ca.mgmt.shell.CaCompleters;
import org.xipki.ca.mgmt.shell.CertActions;
import org.xipki.ca.mgmt.shell.ShellUtil;
import org.xipki.qa.ValidationIssue;
import org.xipki.qa.ValidationResult;
import org.xipki.qa.ca.CaEnrollBenchEntry;
import org.xipki.qa.ca.CaEnrollBenchKeyEntry;
import org.xipki.qa.ca.CaEnrollBenchmark;
import org.xipki.qa.ca.CaQaSystemManager;
import org.xipki.qa.ca.CertprofileQa;
import org.xipki.qa.ca.IssuerInfo;
import org.xipki.qa.shell.QaCompleters;
import org.xipki.security.util.X509Util;
import org.xipki.shell.CmdFailure;
import org.xipki.shell.Completers;
import org.xipki.shell.IllegalCmdParamException;
import org.xipki.shell.XiAction;
import org.xipki.util.Base64;
import org.xipki.util.CollectionUtil;
import org.xipki.util.ConfPairs;
import org.xipki.util.IoUtil;
import org.xipki.util.StringUtil;

public class QaCaActions {
    public static void assertTypeEquals(String desc, String ex, String is) throws CmdFailure {
        boolean bo;
        String tmpEx = ex;
        if ("null".equals(tmpEx)) {
            tmpEx = null;
        }
        boolean bl = tmpEx == null ? is == null : (bo = tmpEx.equalsIgnoreCase(is));
        if (!bo) {
            throw new CmdFailure(desc + ": is '" + is + "', but expected '" + tmpEx + "'");
        }
    }

    public static void assertEquals(String desc, String ex, String is) throws CmdFailure {
        boolean bo;
        String tmpEx = ex;
        if ("null".equals(tmpEx)) {
            tmpEx = null;
        }
        boolean bl = tmpEx == null ? is == null : (bo = tmpEx.equals(is));
        if (!bo) {
            throw new CmdFailure(desc + ": is '" + is + "', but expected '" + tmpEx + "'");
        }
    }

    public static void assertEquals(String desc, Collection<?> ex, Collection<?> is) throws CmdFailure {
        boolean bo;
        boolean bl = ex == null ? is == null : (bo = ex.equals(is));
        if (!bo) {
            throw new CmdFailure(desc + ": is '" + is + "', but expected '" + ex + "'");
        }
    }

    public static void assertObjEquals(String desc, Object ex, Object is) throws CmdFailure {
        boolean bo;
        boolean bl = ex == null ? is == null : (bo = ex.equals(is));
        if (!bo) {
            throw new CmdFailure(desc + ": is '" + is + "', but expected '" + ex + "'");
        }
    }

    public static boolean certEquals(byte[] certBytes1, byte[] certBytes2) {
        if (certBytes1 == null && certBytes2 == null) {
            return true;
        }
        if (certBytes1 != null && certBytes2 != null) {
            try {
                byte[] encoded1 = X509Util.parseBcCert((byte[])certBytes1).getEncoded();
                byte[] encoded2 = X509Util.parseBcCert((byte[])certBytes2).getEncoded();
                return Arrays.equals(encoded1, encoded2);
            }
            catch (Exception ex) {
                return false;
            }
        }
        return false;
    }

    @Command(scope="caqa", name="neg-unrevoke-cert", description="unrevoke certificate (negative, QA)")
    @Service
    public static class NegUnrevokeCert
    extends CertActions.UnrevokeCert {
        protected Object execute0() throws Exception {
            this.println("neg-unrevoke-cert");
            try {
                super.execute0();
            }
            catch (Exception ex) {
                return null;
            }
            throw new CmdFailure("Exception expected, but received none");
        }
    }

    @Command(scope="caqa", name="neg-signer-up", description="update signer (negative, QA)")
    @Service
    public static class NegSignerUp
    extends CaActions.SignerUp {
        protected Object execute0() throws Exception {
            this.println("neg-signer-up");
            try {
                super.execute0();
            }
            catch (Exception ex) {
                return null;
            }
            throw new CmdFailure("exception expected, but received none");
        }
    }

    @Command(scope="caqa", name="neg-signer-rm", description="remove signer (negative, QA)")
    @Service
    public static class NegSignerRm
    extends CaActions.SignerRm {
        protected Object execute0() throws Exception {
            this.println("neg-signer-rm");
            try {
                super.execute0();
            }
            catch (Exception ex) {
                return null;
            }
            throw new CmdFailure("exception expected, but received none");
        }
    }

    @Command(scope="caqa", name="signer-check", description="check information of signer (QA)")
    @Service
    public static class SignerCheck
    extends CaActions.SignerUp {
        protected Object execute0() throws Exception {
            String signerConf;
            this.println("checking signer " + this.name);
            MgmtEntry.Signer cr = this.caManager.getSigner(this.name);
            if (cr == null) {
                throw new CmdFailure("signer named '" + this.name + "' is not configured");
            }
            if ("null".equalsIgnoreCase(this.certFile)) {
                if (cr.getBase64Cert() != null) {
                    throw new CmdFailure("CaCert: is configured but expected is none");
                }
            } else if (this.certFile != null) {
                byte[] ex = IoUtil.read((String)this.certFile);
                if (cr.getBase64Cert() == null) {
                    throw new CmdFailure("CaCert: is not configured explicitly as expected");
                }
                if (!QaCaActions.certEquals(ex, Base64.decode((String)cr.getBase64Cert()))) {
                    throw new CmdFailure("CaCert: the expected one and the actual one differ");
                }
            }
            if ((signerConf = this.getSignerConf()) != null) {
                QaCaActions.assertEquals("conf", signerConf, cr.getConf());
            }
            this.println(" checked signer " + this.name);
            return null;
        }
    }

    @Command(scope="caqa", name="neg-signer-add", description="add signer (negative, QA)")
    @Service
    public static class NegSignerAdd
    extends CaActions.SignerAdd {
        protected Object execute0() throws Exception {
            this.println("neg-signer-add");
            try {
                super.execute0();
            }
            catch (Exception ex) {
                return null;
            }
            throw new CmdFailure("exception expected, but received none");
        }
    }

    @Command(scope="caqa", name="neg-revoke-cert", description="revoke certificate (negative, QA)")
    @Service
    public static class NegRevokeCert
    extends CertActions.RevokeCert {
        protected Object execute0() throws Exception {
            this.println("neg-remove-cert");
            try {
                super.execute0();
            }
            catch (Exception ex) {
                return null;
            }
            throw new CmdFailure("Exception expected, but received none");
        }
    }

    @Command(scope="caqa", name="neg-rm-cert", description="remove certificate (negative, QA)")
    @Service
    public static class NegRmCert
    extends CertActions.RmCert {
        protected Object execute0() throws Exception {
            this.println("neg-remove-cert");
            try {
                super.execute0();
            }
            catch (Exception ex) {
                return null;
            }
            throw new CmdFailure("Exception expected, but received none");
        }
    }

    @Command(scope="caqa", name="neg-requestor-up", description="update requestor (negative, QA)")
    @Service
    public static class NegRequestorUp
    extends CaActions.RequestorUp {
        protected Object execute0() throws Exception {
            this.println("neg-requestor-up");
            try {
                super.execute0();
            }
            catch (Exception ex) {
                return null;
            }
            throw new CmdFailure("exception expected, but received none");
        }
    }

    @Command(scope="caqa", name="neg-requestor-rm", description="remove requestor (negative, QA)")
    @Service
    public static class NegRequestorRm
    extends CaActions.RequestorRm {
        protected Object execute0() throws Exception {
            this.println("neg-requestor-rm");
            try {
                super.execute0();
            }
            catch (Exception ex) {
                return null;
            }
            throw new CmdFailure("exception expected, but received none");
        }
    }

    @Command(scope="caqa", name="requestor-check", description="check information of requestors (QA)")
    @Service
    public static class RequestorCheck
    extends CaActions.RequestorUp {
        protected Object execute0() throws Exception {
            this.println("checking requestor " + this.name);
            MgmtEntry.Requestor cr = this.caManager.getRequestor(this.name);
            if (cr == null) {
                throw new CmdFailure("requestor named '" + this.name + "' is not configured");
            }
            if (this.certFile != null) {
                byte[] ex = IoUtil.read((String)this.certFile);
                String expType = "cert";
                if (!cr.getType().equals(expType)) {
                    throw new CmdFailure("IdNameTypeConf type is not " + expType);
                }
                String conf = cr.getConf();
                if (conf == null) {
                    throw new CmdFailure("CaCert: is not configured explicitly as expected");
                }
                if (!QaCaActions.certEquals(ex, Base64.decode((String)conf))) {
                    throw new CmdFailure("CaCert: the expected one and the actual one differ");
                }
            } else {
                char[] is;
                String expType = "pbm";
                if (!cr.getType().equals(expType)) {
                    throw new CmdFailure("IdNameTypeConf type is not " + expType);
                }
                char[] ex = this.password.toCharArray();
                if (Arrays.equals(ex, is = this.securityFactory.getPasswordResolver().resolvePassword(cr.getConf()))) {
                    throw new CmdFailure("PBM: the expected one and the actual one differ");
                }
            }
            this.println(" checked requestor " + this.name);
            return null;
        }
    }

    @Command(scope="caqa", name="neg-requestor-add", description="add requestor (negative, QA)")
    @Service
    public static class NegRequestorAdd
    extends CaActions.RequestorAdd {
        protected Object execute0() throws Exception {
            this.println("neg-requestor-add");
            try {
                super.execute0();
            }
            catch (Exception ex) {
                return null;
            }
            throw new CmdFailure("exception expected, but received none");
        }
    }

    @Command(scope="caqa", name="neg-republish", description="republish certificates (negative, QA)")
    @Service
    public static class NegRepublish
    extends CaActions.Republish {
        protected Object execute0() throws Exception {
            this.println("neg-republish");
            try {
                super.execute0();
            }
            catch (Exception ex) {
                return null;
            }
            throw new CmdFailure("exception expected, but received none");
        }
    }

    @Command(scope="caqa", name="neg-publisher-up", description="update publisher (negative, QA)")
    @Service
    public static class NegPublisherUp
    extends CaActions.PublisherUp {
        protected Object execute0() throws Exception {
            this.println("neg-publisher-up");
            try {
                super.execute0();
            }
            catch (Exception ex) {
                return null;
            }
            throw new CmdFailure("exception expected, but received none");
        }
    }

    @Command(scope="caqa", name="neg-publisher-rm", description="remove publisher (negative, QA)")
    @Service
    public static class NegPublisherRm
    extends CaActions.PublisherRm {
        protected Object execute0() throws Exception {
            this.println("neg-publisher-rm");
            try {
                super.execute0();
            }
            catch (Exception ex) {
                return null;
            }
            throw new CmdFailure("exception expected, but received none");
        }
    }

    @Command(scope="caqa", name="publisher-check", description="check information of publishers (QA)")
    @Service
    public static class PublisherCheck
    extends CaActions.PublisherUp {
        protected Object execute0() throws Exception {
            this.println("checking publisher " + this.name);
            MgmtEntry.Publisher cp = this.caManager.getPublisher(this.name);
            if (cp == null) {
                throw new CmdFailure("publisher named '" + this.name + "' is not configured");
            }
            if (cp.getType() != null) {
                QaCaActions.assertTypeEquals("type", this.type, cp.getType());
            }
            if (cp.getConf() != null) {
                QaCaActions.assertEquals("signer conf", this.conf, cp.getConf());
            }
            this.println(" checked publisher " + this.name);
            return null;
        }
    }

    @Command(scope="caqa", name="neg-publisher-add", description="add publisher (negative, QA)")
    @Service
    public static class NegPublisherAdd
    extends CaActions.PublisherAdd {
        protected Object execute0() throws Exception {
            this.println("neg-publisher-add");
            try {
                super.execute0();
            }
            catch (Exception ex) {
                return null;
            }
            throw new CmdFailure("exception expected, but received none");
        }
    }

    @Command(scope="caqa", name="neg-profile-up", description="update certificate profile (negative, QA)")
    @Service
    public static class NegProfileUp
    extends CaActions.ProfileUp {
        protected Object execute0() throws Exception {
            this.println("neg-profile-up");
            try {
                super.execute0();
            }
            catch (Exception ex) {
                return null;
            }
            throw new CmdFailure("exception expected, but received none");
        }
    }

    @Command(scope="caqa", name="neg-profile-rm", description="remove Profile (negative, QA)")
    @Service
    public static class NegProfileRm
    extends CaActions.ProfileRm {
        protected Object execute0() throws Exception {
            this.println("neg-profile-rm");
            try {
                super.execute0();
            }
            catch (Exception ex) {
                return null;
            }
            throw new CmdFailure("exception expected, but received none");
        }
    }

    @Command(scope="caqa", name="profile-check", description="check information of profiles (QA)")
    @Service
    public static class ProfileCheck
    extends CaActions.ProfileUp {
        protected Object execute0() throws Exception {
            MgmtEntry.Certprofile cp;
            this.println("checking profile " + this.name);
            if (this.type == null && this.conf == null && this.confFile == null) {
                System.out.println("nothing to update");
                return null;
            }
            if (this.conf == null && this.confFile != null) {
                this.conf = new String(IoUtil.read((String)this.confFile));
            }
            if ((cp = this.caManager.getCertprofile(this.name)) == null) {
                throw new CmdFailure("certificate profile named '" + this.name + "' is not configured");
            }
            if (cp.getType() != null) {
                QaCaActions.assertTypeEquals("type", this.type, cp.getType());
            }
            QaCaActions.assertEquals("conf", this.conf, cp.getConf());
            this.println(" checked profile " + this.name);
            return null;
        }
    }

    @Command(scope="caqa", name="neg-profile-add", description="add certificate profile (negative, QA)")
    @Service
    public static class NegProfileAdd
    extends CaActions.ProfileAdd {
        protected Object execute0() throws Exception {
            this.println("neg-profile-add");
            try {
                super.execute0();
            }
            catch (Exception ex) {
                return null;
            }
            throw new CmdFailure("exception expected, but received none");
        }
    }

    @Command(scope="caqa", name="neg-gen-rootca", description="generate selfsigned CA (negative, QA)")
    @Service
    public static class NegGenRootCa
    extends CaActions.GenRootca {
        protected Object execute0() throws Exception {
            this.println("neg-gen-rootca");
            try {
                super.execute0();
            }
            catch (Exception ex) {
                return null;
            }
            throw new CmdFailure("exception expected, but received none");
        }
    }

    @Command(scope="caqa", name="neg-enroll-cert", description="enroll certificate (negative, QA)")
    @Service
    public static class NegEnrollCert
    extends CertActions.EnrollCert {
        protected Object execute0() throws Exception {
            this.println("neg-enroll-cert");
            try {
                super.execute0();
            }
            catch (Exception ex) {
                return null;
            }
            throw new CmdFailure("exception expected, but received none");
        }
    }

    @Command(scope="caqa", name="neg-clear-publishqueue", description="clear publish queue (negative, QA)")
    @Service
    public static class NegClearPublishQueue
    extends CaActions.ClearPublishqueue {
        protected Object execute0() throws Exception {
            this.println("neg-clear-publishqueue");
            try {
                super.execute0();
            }
            catch (Exception ex) {
                return null;
            }
            throw new CmdFailure("exception expected, but received none");
        }
    }

    @Command(scope="caqa", name="neg-ca-up", description="update CA (negative, QA)")
    @Service
    public static class NegCaUp
    extends CaActions.CaUp {
        protected Object execute0() throws Exception {
            this.println("neg-ca-up");
            try {
                super.execute0();
            }
            catch (Exception ex) {
                return null;
            }
            throw new CmdFailure("exception expected, but received none");
        }
    }

    @Command(scope="caqa", name="neg-ca-unrevoke", description="unrevoke CA (negative, QA)")
    @Service
    public static class NegCaUnrevoke
    extends CaActions.CaUnrevoke {
        protected Object execute0() throws Exception {
            this.println("neg-ca-unrevoke");
            try {
                super.execute0();
            }
            catch (Exception ex) {
                return null;
            }
            throw new CmdFailure("exception expected, but received none");
        }
    }

    @Command(scope="caqa", name="neg-ca-revoke", description="revoke CA (negative, QA)")
    @Service
    public static class NegCaRevoke
    extends CaActions.CaRevoke {
        protected Object execute0() throws Exception {
            this.println("neg-ca-revoke");
            try {
                super.execute0();
            }
            catch (Exception ex) {
                return null;
            }
            throw new CmdFailure("exception expected, but received none");
        }
    }

    @Command(scope="caqa", name="neg-careq-rm", description="remove requestor in CA (negative, QA)")
    @Service
    public static class NegCareqRm
    extends CaActions.CareqRm {
        protected Object execute0() throws Exception {
            this.println("neg-careq-rm");
            try {
                super.execute0();
            }
            catch (Exception ex) {
                return null;
            }
            throw new CmdFailure("exception expected, but received none");
        }
    }

    @Command(scope="caqa", name="neg-careq-add", description="add requestor to CA (negative, QA)")
    @Service
    public static class NegCaReqAdd
    extends CaActions.CareqAdd {
        protected Object execute0() throws Exception {
            this.println("neg-careq-add");
            try {
                super.execute0();
            }
            catch (Exception ex) {
                return null;
            }
            throw new CmdFailure("exception expected, but received none");
        }
    }

    @Command(scope="caqa", name="neg-ca-rm", description="remove CA (negative, QA)")
    @Service
    public static class NegCaRm
    extends CaActions.CaRm {
        protected Object execute0() throws Exception {
            this.println("neg-ca-rm");
            try {
                super.execute0();
            }
            catch (Exception ex) {
                return null;
            }
            throw new CmdFailure("exception expected, but received none");
        }
    }

    @Command(scope="caqa", name="neg-capub-rm", description="remove publisher from CA (negative, QA)")
    @Service
    public static class NegCapubRm
    extends CaActions.CapubRm {
        protected Object execute0() throws Exception {
            this.println("neg-capub-rm");
            try {
                super.execute0();
            }
            catch (Exception ex) {
                return null;
            }
            throw new CmdFailure("exception expected, but received none");
        }
    }

    @Command(scope="caqa", name="neg-capub-add", description="add publishers to CA (negative, QA)")
    @Service
    public static class NegCaPubAdd
    extends CaActions.CapubAdd {
        protected Object execute0() throws Exception {
            this.println("neg-capub-add");
            try {
                super.execute0();
            }
            catch (Exception ex) {
                return null;
            }
            throw new CmdFailure("exception expected, but received none");
        }
    }

    @Command(scope="caqa", name="neg-caprofile-rm", description="remove certificate profile from CA (negative, QA)")
    @Service
    public static class NegCaprofileRm
    extends CaActions.CaprofileRm {
        protected Object execute0() throws Exception {
            this.println("neg-caprofile-rm");
            try {
                super.execute0();
            }
            catch (Exception ex) {
                return null;
            }
            throw new CmdFailure("exception expected, but received none");
        }
    }

    @Command(scope="caqa", name="neg-caprofile-add", description="add certificate profiles to CA (negative, QA)")
    @Service
    public static class NegCaprofileAdd
    extends CaActions.CaprofileAdd {
        protected Object execute0() throws Exception {
            this.println("neg-caprofile-add");
            try {
                super.execute0();
            }
            catch (Exception ex) {
                return null;
            }
            throw new CmdFailure("exception expected, but received none");
        }
    }

    @Command(scope="caqa", name="neg-caalias-rm", description="remove CA alias (negative, QA)")
    @Service
    public static class NegCaaliasRm
    extends CaActions.CaaliasRm {
        protected Object execute0() throws Exception {
            this.println("neg-caalias-rm");
            try {
                super.execute0();
            }
            catch (Exception ex) {
                return null;
            }
            throw new CmdFailure("exception expected, but received none");
        }
    }

    @Command(scope="caqa", name="neg-caalias-add", description="add CA alias (negative, QA)")
    @Service
    public static class NegCaaliasAddA
    extends CaActions.CaaliasAdd {
        protected Object execute0() throws Exception {
            this.println("neg-caalias-add");
            try {
                super.execute0();
            }
            catch (Exception ex) {
                return null;
            }
            throw new CmdFailure("exception expected, but received none");
        }
    }

    @Command(scope="caqa", name="neg-ca-add", description="add CA (negative, QA)")
    @Service
    public static class NegCaAdd
    extends CaActions.CaAdd {
        protected Object execute0() throws Exception {
            this.println("neg-ca-add");
            try {
                super.execute0();
            }
            catch (Exception ex) {
                return null;
            }
            throw new CmdFailure("exception expected, but received none");
        }
    }

    @Command(scope="caqa", name="careq-check", description="check information of requestors in CA (QA)")
    @Service
    public static class CaReqCheck
    extends CaActions.CaAction {
        @Option(name="--ca", required=true, description="CA name")
        @Completion(value=CaCompleters.CaNameCompleter.class)
        private String caName;
        @Option(name="--requestor", required=true, description="requestor name")
        @Completion(value=CaCompleters.RequestorNameCompleter.class)
        private String requestorName;
        @Option(name="--ra", description="whether as RA")
        @Completion(value=Completers.YesNoCompleter.class)
        private String raS = "no";
        @Option(name="--permission", multiValued=true, description="permission")
        @Completion(value=CaCompleters.PermissionCompleter.class)
        private Set<String> permissions;
        @Option(name="--profile", multiValued=true, description="profile name or 'all' for all profiles, and 'null' for no profiles")
        @Completion(value=CaCompleters.ProfileNameAndAllCompleter.class)
        private Set<String> profiles;

        protected Object execute0() throws Exception {
            int intPermission;
            boolean bo;
            this.println("checking CA requestor CA='" + this.caName + "', requestor='" + this.requestorName + "'");
            if (this.caManager.getCa(this.caName) == null) {
                throw new UnexpectedException("could not find CA '" + this.caName + "'");
            }
            Set entries = this.caManager.getRequestorsForCa(this.caName);
            MgmtEntry.CaHasRequestor entry = null;
            String upRequestorName = this.requestorName.toLowerCase();
            for (MgmtEntry.CaHasRequestor m : entries) {
                if (!m.getRequestorIdent().getName().equals(upRequestorName)) continue;
                entry = m;
                break;
            }
            if (entry == null) {
                throw new CmdFailure("CA is not associated with requestor '" + this.requestorName + "'");
            }
            boolean ra = CaReqCheck.isEnabled((String)this.raS, (boolean)false, (String)"ra");
            if (ra != (bo = entry.isRa())) {
                throw new CmdFailure("ra: is '" + bo + "', expected '" + ra + "'");
            }
            if (this.permissions != null && (intPermission = ShellUtil.getPermission(this.permissions)) != entry.getPermission()) {
                throw new CmdFailure("permissions: is '" + entry.getPermission() + "', but expected '" + intPermission + "'");
            }
            if (this.profiles != null) {
                if (this.profiles.size() == 1 && "null".equalsIgnoreCase(this.profiles.iterator().next())) {
                    this.profiles = Collections.emptySet();
                }
                if (!this.profiles.equals(entry.getProfiles())) {
                    throw new CmdFailure("profiles: is '" + entry.getProfiles() + "', but expected '" + this.profiles + "'");
                }
            }
            this.println(" checked CA requestor CA='" + this.caName + "', requestor='" + this.requestorName + "'");
            return null;
        }
    }

    @Command(scope="caqa", name="capub-check", description="check information of publishers in given CA (QA)")
    @Service
    public static class CapubCheck
    extends CaActions.CaAction {
        @Option(name="--ca", required=true, description="CA name")
        @Completion(value=CaCompleters.CaNameCompleter.class)
        private String caName;
        @Option(name="--publisher", required=true, description="publisher name")
        @Completion(value=CaCompleters.PublisherNameCompleter.class)
        private String publisherName;

        protected Object execute0() throws Exception {
            this.println("checking CA publisher CA='" + this.caName + "', publisher='" + this.publisherName + "'");
            if (this.caManager.getCa(this.caName) == null) {
                throw new CmdFailure("could not find CA '" + this.caName + "'");
            }
            List entries = this.caManager.getPublishersForCa(this.caName);
            String upPublisherName = this.publisherName.toLowerCase();
            for (MgmtEntry.Publisher m : entries) {
                if (!m.getIdent().getName().equals(upPublisherName)) continue;
                this.println(" checked CA publisher CA='" + this.caName + "', publisher='" + this.publisherName + "'");
                return null;
            }
            throw new CmdFailure("CA is not associated with publisher '" + this.publisherName + "'");
        }
    }

    @Command(scope="caqa", name="caprofile-check", description="check information of certificate profiles in given CA (QA)")
    @Service
    public static class CaprofileCheck
    extends CaActions.CaAction {
        @Option(name="--ca", required=true, description="CA name")
        @Completion(value=CaCompleters.CaNameCompleter.class)
        private String caName;
        @Option(name="--profile", required=true, description="profile name")
        @Completion(value=CaCompleters.ProfileNameCompleter.class)
        private String profileName;

        protected Object execute0() throws Exception {
            this.println("checking CA profile CA='" + this.caName + "', profile='" + this.profileName + "'");
            if (this.caManager.getCa(this.caName) == null) {
                throw new CmdFailure("could not find CA '" + this.caName + "'");
            }
            Set entries = this.caManager.getCertprofilesForCa(this.caName);
            if (!entries.contains(this.profileName.toLowerCase())) {
                throw new CmdFailure("CA is not associated with profile '" + this.profileName + "'");
            }
            this.println(" checked CA profile CA='" + this.caName + "', profile='" + this.profileName + "'");
            return null;
        }
    }

    @Command(scope="caqa", name="ca-check", description="check information of CAs (QA)")
    @Service
    public static class CaCheck
    extends CaActions.CaUp {
        protected Object execute0() throws Exception {
            MgmtEntry.ChangeCa ey = this.getChangeCaEntry();
            String caName = ey.getIdent().getName();
            this.println("checking CA " + caName);
            MgmtEntry.Ca ca = this.caManager.getCa(caName);
            if (ca == null) {
                throw new CmdFailure("could not find CA '" + caName + "'");
            }
            CaUris eyUris = ey.getCaUris();
            if (eyUris != null) {
                QaCaActions.assertObjEquals("CA URIs", ey.getCaUris(), ca.getCaUris());
            }
            if (ey.getEncodedCert() != null && !QaCaActions.certEquals(ey.getEncodedCert(), ca.getCert().getEncoded())) {
                throw new CmdFailure("CA cert is not as expected");
            }
            if (ey.getEncodedCertchain() != null) {
                int isSize;
                List eyList = ey.getEncodedCertchain();
                List isList = ca.getCertchain();
                int eySize = eyList == null ? 0 : eyList.size();
                int n = isSize = isList == null ? 0 : isList.size();
                if (eySize != isSize) {
                    if (CollectionUtil.isNonEmpty((Collection)ca.getCertchain())) {
                        throw new CmdFailure("Length of CA certchain " + isSize + " is not as expected " + eySize);
                    }
                } else if (eySize != 0) {
                    for (int i = 0; i < eySize; ++i) {
                        if (QaCaActions.certEquals((byte[])eyList.get(i), ((X509Certificate)isList.get(i)).getEncoded())) continue;
                        throw new CmdFailure("CA cert chain[" + i + "] is not as expected");
                    }
                }
            }
            if (ey.getSerialNoBitLen() != null) {
                QaCaActions.assertObjEquals("serial number bit length", ey.getSerialNoBitLen(), ca.getSerialNoBitLen());
            }
            if (ey.getCmpControl() != null) {
                QaCaActions.assertObjEquals("CMP control", new CmpControl(ey.getCmpControl()), ca.getCmpControl());
            }
            if (ey.getCrlControl() != null) {
                QaCaActions.assertObjEquals("CRL control", new CmpControl(ey.getCrlControl()), ca.getCrlControl());
            }
            if (ey.getCmpResponderName() != null) {
                QaCaActions.assertEquals("CMP responder name", ey.getCmpResponderName(), ca.getCmpResponderName());
            }
            if (ey.getScepResponderName() != null) {
                QaCaActions.assertEquals("SCEP responder name", ey.getScepResponderName(), ca.getScepResponderName());
            }
            if (ey.getCrlSignerName() != null) {
                QaCaActions.assertEquals("CRL signer name", ey.getCrlSignerName(), ca.getCrlSignerName());
            }
            if (ey.getDuplicateKeyPermitted() != null) {
                QaCaActions.assertObjEquals("Duplicate key permitted", ey.getDuplicateKeyPermitted(), ca.isDuplicateKeyPermitted());
            }
            if (ey.getDuplicateSubjectPermitted() != null) {
                QaCaActions.assertObjEquals("Duplicate subject permitted", ey.getDuplicateSubjectPermitted(), ca.isDuplicateSubjectPermitted());
            }
            if (ey.getExpirationPeriod() != null) {
                QaCaActions.assertObjEquals("Expiration period", ey.getExpirationPeriod(), ca.getExpirationPeriod());
            }
            if (ey.getExtraControl() != null) {
                QaCaActions.assertObjEquals("Extra control", ey.getExtraControl(), ca.getExtraControl());
            }
            if (ey.getMaxValidity() != null) {
                QaCaActions.assertObjEquals("Max validity", ey.getMaxValidity(), ca.getMaxValidity());
            }
            if (ey.getKeepExpiredCertInDays() != null) {
                QaCaActions.assertObjEquals("keepExiredCertInDays", ey.getKeepExpiredCertInDays(), ca.getKeepExpiredCertInDays());
            }
            if (ey.getNumCrls() != null) {
                QaCaActions.assertObjEquals("num CRLs", ey.getNumCrls(), ca.getNumCrls());
            }
            if (ey.getPermission() != null) {
                QaCaActions.assertObjEquals("permission", ey.getPermission(), ca.getPermission());
            }
            if (ey.getSignerType() != null) {
                QaCaActions.assertTypeEquals("signer type", ey.getSignerType(), ca.getSignerType());
            }
            if (ey.getSignerConf() != null) {
                ConfPairs ex = new ConfPairs(ey.getSignerConf());
                ex.removePair("keystore");
                ConfPairs is = new ConfPairs(ca.getSignerConf());
                is.removePair("keystore");
                QaCaActions.assertObjEquals("signer conf", ex, is);
            }
            if (ey.getStatus() != null) {
                QaCaActions.assertObjEquals("status", ey.getStatus(), ca.getStatus());
            }
            if (ey.getValidityMode() != null) {
                QaCaActions.assertObjEquals("validity mode", ey.getValidityMode(), ca.getValidityMode());
            }
            this.println(" checked CA" + caName);
            return null;
        }
    }

    @Command(scope="xiqa", name="cmp-benchmark-enroll", description="CA client enroll (benchmark)")
    @Service
    public static class CmpBenchmarkEnroll
    extends XiAction {
        @Option(name="--profile", aliases={"-p"}, required=true, description="certificate profile that allows duplication of public key")
        private String certprofile;
        @Option(name="--subject", aliases={"-s"}, required=true, description="subject template")
        private String subjectTemplate;
        @Option(name="--random-dn", description="DN name to be incremented")
        @Completion(value=StringsCompleter.class, values={"GIVENNAME", "SURNAME", "STREET", "POSTALCODE", "O", "OU", "CN"})
        private String randomDnStr = "O";
        @Option(name="--duration", description="duration")
        private String duration = "30s";
        @Option(name="--thread", description="number of threads")
        private Integer numThreads = 5;
        @Option(name="--key-type", description="key type to be requested")
        private String keyType = "RSA";
        @Option(name="--key-size", description="modulus length of RSA key or p length of DSA key")
        private Integer keysize = 2048;
        @Option(name="--curve", description="EC curve name or OID of EC key")
        @Completion(value=Completers.ECCurveNameCompleter.class)
        private String curveName;
        @Option(name="-n", description="number of certificates to be requested in one request")
        private Integer num = 1;
        @Option(name="--max-num", description="maximal number of requests\n0 for unlimited")
        private Integer maxRequests = 0;
        @Option(name="--queue-size", description="Number of maximal HTTP requests in the sending queue\n0 for implemention default")
        private Integer queueSize = 0;

        protected Object execute0() throws Exception {
            CaEnrollBenchKeyEntry.ECKeyEntry keyEntry;
            if (this.numThreads < 1) {
                throw new IllegalCmdParamException("invalid number of threads " + this.numThreads);
            }
            if ("EC".equalsIgnoreCase(this.keyType) && StringUtil.isBlank((String)this.curveName)) {
                throw new IllegalCmdParamException("curveName is not specified");
            }
            String description = StringUtil.concatObjectsCap((int)200, (Object)"subjectTemplate: ", (Object[])new Object[]{this.subjectTemplate, "\nprofile: ", this.certprofile, "\nkeyType: ", this.keyType, "\nmaxRequests: ", this.maxRequests});
            CaEnrollBenchEntry.RandomDn randomDn = null;
            if (this.randomDnStr != null && (randomDn = CaEnrollBenchEntry.RandomDn.getInstance((String)this.randomDnStr)) == null) {
                throw new IllegalCmdParamException("invalid randomDn " + this.randomDnStr);
            }
            if ("EC".equalsIgnoreCase(this.keyType)) {
                keyEntry = new CaEnrollBenchKeyEntry.ECKeyEntry(this.curveName);
            } else if ("RSA".equalsIgnoreCase(this.keyType)) {
                keyEntry = new CaEnrollBenchKeyEntry.RSAKeyEntry(this.keysize.intValue());
            } else if ("DSA".equalsIgnoreCase(this.keyType)) {
                keyEntry = new CaEnrollBenchKeyEntry.DSAKeyEntry(this.keysize.intValue());
            } else {
                throw new IllegalCmdParamException("invalid keyType " + this.keyType);
            }
            CaEnrollBenchEntry benchmarkEntry = new CaEnrollBenchEntry(this.certprofile, (CaEnrollBenchKeyEntry)keyEntry, this.subjectTemplate, randomDn);
            CaEnrollBenchmark benchmark = new CaEnrollBenchmark(benchmarkEntry, this.maxRequests.intValue(), this.num.intValue(), this.queueSize.intValue(), description);
            benchmark.setDuration(this.duration);
            benchmark.setThreads(this.numThreads.intValue());
            benchmark.execute();
            return null;
        }
    }

    @Command(scope="caqa", name="caalias-check", description="check CA aliases (QA)")
    @Service
    public static class CaAliasCheck
    extends CaActions.CaAction {
        @Option(name="--ca", required=true, description="CA name")
        @Completion(value=CaCompleters.CaNameCompleter.class)
        private String caName;
        @Option(name="--alias", required=true, description="alias name")
        private String aliasName;

        protected Object execute0() throws Exception {
            this.println("checking CA alias='" + this.aliasName + "', CA='" + this.caName + "'");
            String tmpCaName = this.caManager.getCaNameForAlias(this.aliasName);
            if (tmpCaName == null) {
                throw new CmdFailure("alias '" + this.aliasName + "' is not configured");
            }
            QaCaActions.assertEquals("CA name", this.caName, tmpCaName);
            this.println(" checked CA alias='" + this.aliasName + "', CA='" + this.caName + "'");
            return null;
        }
    }

    @Command(scope="caqa", name="check-cert", description="check the certificate")
    @Service
    public static class CheckCert
    extends XiAction {
        @Option(name="--cert", aliases={"-c"}, required=true, description="certificate file")
        @Completion(value=FileCompleter.class)
        private String certFile;
        @Option(name="--issuer", description="issuer name\n(required if multiple issuers are configured)")
        @Completion(value=QaCompleters.IssuerNameCompleter.class)
        private String issuerName;
        @Option(name="--csr", required=true, description="CSR file")
        @Completion(value=FileCompleter.class)
        private String csrFile;
        @Option(name="--profile", aliases={"-p"}, required=true, description="certificate profile")
        @Completion(value=QaCompleters.CertprofileNameCompleter.class)
        private String profileName;
        @Option(name="--verbose", aliases={"-v"}, description="show status verbosely")
        private Boolean verbose = Boolean.FALSE;
        @Reference
        private CaQaSystemManager qaSystemManager;

        protected Object execute0() throws Exception {
            Set issuerNames = this.qaSystemManager.getIssuerNames();
            if (CheckCert.isEmpty((Collection)issuerNames)) {
                throw new IllegalCmdParamException("no issuer is configured");
            }
            if (this.issuerName == null) {
                if (issuerNames.size() != 1) {
                    throw new IllegalCmdParamException("no issuer is specified");
                }
                this.issuerName = (String)issuerNames.iterator().next();
            }
            if (!issuerNames.contains(this.issuerName)) {
                throw new IllegalCmdParamException("issuer " + this.issuerName + " is not within the configured issuers " + issuerNames);
            }
            IssuerInfo issuerInfo = this.qaSystemManager.getIssuer(this.issuerName);
            CertprofileQa qa = this.qaSystemManager.getCertprofile(this.profileName);
            if (qa == null) {
                throw new IllegalCmdParamException("found no certificate profile named '" + this.profileName + "'");
            }
            CertificationRequest csr = X509Util.parseCsr((File)new File(this.csrFile));
            Extensions extensions = null;
            CertificationRequestInfo reqInfo = csr.getCertificationRequestInfo();
            ASN1Set attrs = reqInfo.getAttributes();
            for (int i = 0; i < attrs.size(); ++i) {
                Attribute attr = Attribute.getInstance((Object)attrs.getObjectAt(i));
                if (!PKCSObjectIdentifiers.pkcs_9_at_extensionRequest.equals((Object)attr.getAttrType())) continue;
                extensions = Extensions.getInstance((Object)attr.getAttributeValues()[0]);
            }
            byte[] certBytes = IoUtil.read((String)this.certFile);
            ValidationResult result = qa.checkCert(certBytes, issuerInfo, reqInfo.getSubject(), reqInfo.getSubjectPublicKeyInfo(), extensions);
            StringBuilder sb = new StringBuilder();
            sb.append(this.certFile).append(" (certprofile ").append(this.profileName).append(")\n");
            sb.append("\tcertificate is ");
            sb.append(result.isAllSuccessful() ? "valid" : "invalid");
            if (this.verbose.booleanValue()) {
                for (ValidationIssue issue : result.getValidationIssues()) {
                    sb.append("\n");
                    CheckCert.format(issue, "    ", sb);
                }
            }
            this.println(sb.toString());
            if (!result.isAllSuccessful()) {
                throw new CmdFailure("certificate is invalid");
            }
            return null;
        }

        private static void format(ValidationIssue issue, String prefix, StringBuilder sb) {
            sb.append(prefix).append(issue.getCode());
            sb.append(", ").append(issue.getDescription());
            sb.append(", ").append(issue.isFailed() ? "failed" : "successful");
            if (issue.getFailureMessage() != null) {
                sb.append(", ").append(issue.getFailureMessage());
            }
        }
    }

    @Command(scope="caqa", name="init", description="initialize the CA QA manager")
    @Service
    public static class Init
    extends XiAction {
        @Reference
        private CaQaSystemManager qaSystemManager;

        protected Object execute0() throws Exception {
            boolean succ = this.qaSystemManager.init();
            if (succ) {
                this.println("CA QA system initialized successfully");
            } else {
                this.println("CA QA system initialization failed");
            }
            return null;
        }
    }
}

