/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.qa.shell;

import java.security.Key;
import java.security.KeyStore;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.cert.Certificate;
import java.security.spec.AlgorithmParameterSpec;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Set;
import org.apache.karaf.shell.api.action.Command;
import org.apache.karaf.shell.api.action.Completion;
import org.apache.karaf.shell.api.action.Option;
import org.apache.karaf.shell.api.action.lifecycle.Reference;
import org.apache.karaf.shell.api.action.lifecycle.Service;
import org.bouncycastle.jcajce.spec.SM2ParameterSpec;
import org.xipki.security.HashAlgo;
import org.xipki.security.SignAlgo;
import org.xipki.security.SignatureAlgoControl;
import org.xipki.security.pkcs11.P11CryptServiceFactory;
import org.xipki.security.pkcs11.provider.XiSM2ParameterSpec;
import org.xipki.shell.Completers;
import org.xipki.shell.DynamicEnumCompleter;
import org.xipki.shell.IllegalCmdParamException;
import org.xipki.shell.XiAction;
import org.xipki.util.CollectionUtil;
import org.xipki.util.StringUtil;

public class QaP11Actions {

    @Service
    public static class P11ModuleNameCompleter
    extends DynamicEnumCompleter {
        @Reference(optional=true)
        private P11CryptServiceFactory p11CryptServiceFactory;

        protected Set<String> getEnums() {
            Set names = this.p11CryptServiceFactory.getModuleNames();
            if (CollectionUtil.isEmpty((Collection)names)) {
                return Collections.emptySet();
            }
            return names;
        }
    }

    protected static abstract class P11SecurityAction
    extends XiAction {
        protected static final String DEFAULT_P11MODULE_NAME = "default";
        @Option(name="--module", description="name of the PKCS#11 module")
        @Completion(value=P11ModuleNameCompleter.class)
        protected String moduleName = "default";
        @Option(name="--slot", description="slot index")
        protected int slotIndex = 0;
        @Option(name="--id", description="id of the private key in the PKCS#11 device\neither keyId or keyLabel must be specified")
        protected String id;
        @Option(name="--label", description="label of the private key in the PKCS#11 device\neither keyId or keyLabel must be specified")
        protected String label;
        @Option(name="--verbose", aliases={"-v"}, description="show object information verbosely")
        protected Boolean verbose = Boolean.FALSE;
        @Reference(optional=true)
        protected P11CryptServiceFactory p11CryptServiceFactory;

        protected P11SecurityAction() {
        }

        protected abstract Object execute1(PrivateKey var1, Certificate var2) throws Exception;

        protected String getAlias() throws IllegalCmdParamException {
            if (this.label != null && this.id == null) {
                return StringUtil.concat((String)this.moduleName, (String[])new String[]{"#slotindex-", Integer.toString(this.slotIndex), "#keylabel-", this.label});
            }
            if (this.label == null && this.id != null) {
                return StringUtil.concat((String)this.moduleName, (String[])new String[]{"#slotindex-", Integer.toString(this.slotIndex), "#keyid-", this.id.toLowerCase()});
            }
            throw new IllegalCmdParamException("exactly one of id or label should be specified");
        }

        protected Object execute0() throws Exception {
            KeyStore ks = KeyStore.getInstance("PKCS11", "XIPKI-P11");
            ks.load(null, null);
            if (this.verbose.booleanValue()) {
                this.println("available aliases:");
                Enumeration<String> aliases = ks.aliases();
                while (aliases.hasMoreElements()) {
                    String alias2 = aliases.nextElement();
                    this.println("    " + alias2);
                }
            }
            String alias = this.getAlias();
            this.println("alias: " + alias);
            PrivateKey key = (PrivateKey)ks.getKey(alias, null);
            if (key == null) {
                this.println("could not find key with alias '" + alias + "'");
                return null;
            }
            Certificate cert = ks.getCertificate(alias);
            if (cert == null) {
                this.println("could not find certificate to verify signature");
                return null;
            }
            return this.execute1(key, cert);
        }
    }

    @Command(scope="qa", name="p11prov-test", description="test the Xipki PKCS#11 JCA/JCE provider")
    @Service
    public static class P11provTest
    extends P11SecurityAction {
        @Option(name="--hash", description="hash algorithm name")
        @Completion(value=Completers.HashAlgCompleter.class)
        protected String hashAlgo = "SHA256";
        @Option(name="--rsa-pss", description="whether to use the RSAPSS for the POPO computation\n(only applied to RSA key)")
        private Boolean rsaPss = Boolean.FALSE;
        @Option(name="--dsa-plain", description="whether to use the Plain DSA for the POPO computation\n(only applied to ECDSA key)")
        private Boolean dsaPlain = Boolean.FALSE;
        @Option(name="--gm", description="whether to use the chinese GM algorithm for the POPO computation\n(only applied to EC key with GM curves)")
        private Boolean gm = Boolean.FALSE;

        @Override
        protected Object execute1(PrivateKey key, Certificate cert) throws Exception {
            PublicKey pubKey = cert.getPublicKey();
            SignAlgo signAlgo = this.getSignatureAlgo(pubKey);
            this.println("signature algorithm: " + signAlgo);
            Signature sig = Signature.getInstance(signAlgo.getJceName());
            sig.initSign(key);
            byte[] data = new byte[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 10};
            sig.update(data);
            byte[] signature = sig.sign();
            this.println("signature created successfully");
            String provName = "BC";
            Signature ver = Signature.getInstance(signAlgo.getJceName(), provName);
            ver.initVerify(pubKey);
            ver.update(data);
            boolean valid = ver.verify(signature);
            this.println("signature valid: " + valid);
            return null;
        }

        private SignAlgo getSignatureAlgo(PublicKey pubKey) throws NoSuchAlgorithmException {
            SignatureAlgoControl algoControl = new SignatureAlgoControl(this.rsaPss.booleanValue(), this.dsaPlain.booleanValue(), this.gm.booleanValue());
            return SignAlgo.getInstance((Key)pubKey, (HashAlgo)HashAlgo.getInstance((String)this.hashAlgo), (SignatureAlgoControl)algoControl);
        }
    }

    @Command(scope="qa", name="p11prov-sm2-test", description="test the SM2 implementation of Xipki PKCS#11 JCA/JCE provider")
    @Service
    public static class P11provSm2Test
    extends P11SecurityAction {
        @Option(name="--ida", description="IDA (ID user A)")
        protected String ida;

        @Override
        protected Object execute1(PrivateKey key, Certificate cert) throws Exception {
            String signAlgo = "SM3withSM2";
            this.println("signature algorithm: " + signAlgo);
            Signature sig = Signature.getInstance(signAlgo);
            if (StringUtil.isNotBlank((String)this.ida)) {
                sig.setParameter((AlgorithmParameterSpec)new XiSM2ParameterSpec(StringUtil.toUtf8Bytes((String)this.ida)));
            }
            sig.initSign(key);
            byte[] data = new byte[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 10};
            sig.update(data);
            byte[] signature = sig.sign();
            this.println("signature created successfully");
            Signature ver = Signature.getInstance(signAlgo, "BC");
            if (StringUtil.isNotBlank((String)this.ida)) {
                ver.setParameter((AlgorithmParameterSpec)new SM2ParameterSpec(StringUtil.toUtf8Bytes((String)this.ida)));
            }
            ver.initVerify(cert.getPublicKey());
            ver.update(data);
            boolean valid = ver.verify(signature);
            this.println("signature valid: " + valid);
            return null;
        }
    }
}

